/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent;

import com.sun.cacao.agent.DomainDispatcher;
import com.sun.cacao.agent.VirtualMBeanInterceptor;
import com.sun.cacao.agent.auth.AccessControlActionEnum;
import com.sun.cacao.agent.auth.AccessControlDispatcher;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class DispatchInterceptor
implements MBeanServerInterceptor {
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent");
    private static final String logTag = "DispatchInterceptor";
    private MBeanServer mbs;
    private static MBeanServerInterceptor defaultInterceptor;
    private static Map domainDispatchers;

    private static MBeanServerInterceptor getInterceptor(ObjectName objectName) {
        Set set = DispatchInterceptor.getInterceptors(objectName);
        if (set.size() == 0) {
            return defaultInterceptor;
        }
        if (set.size() == 1) {
            return (MBeanServerInterceptor)set.iterator().next();
        }
        logger.log(Level.WARNING, "getMBeanInterceptor found multiple interceptors for " + objectName);
        throw new IllegalArgumentException("found multiple interceptors");
    }

    private Collection debugCollection(Collection collection) {
        if (logger.isLoggable(Level.FINEST) && collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof VirtualMBeanInterceptor) {
                    VirtualMBeanInterceptor virtualMBeanInterceptor = (VirtualMBeanInterceptor)e;
                    logger.finest("virtual MBean interceptor for " + virtualMBeanInterceptor.getMBeanClassName());
                    continue;
                }
                logger.finest(e.getClass().getName() + " " + e.toString());
            }
        }
        return collection;
    }

    private static Set getInterceptors(ObjectName objectName) {
        HashSet<MBeanServerInterceptor> hashSet = new HashSet<MBeanServerInterceptor>();
        if (objectName == null || objectName.isDomainPattern()) {
            Iterator iterator = domainDispatchers.values().iterator();
            while (iterator.hasNext()) {
                DomainDispatcher domainDispatcher = (DomainDispatcher)iterator.next();
                hashSet.addAll(domainDispatcher.getInterceptors(objectName));
            }
            hashSet.add(defaultInterceptor);
        } else {
            String string = objectName.getDomain();
            if (domainDispatchers.containsKey(string)) {
                DomainDispatcher domainDispatcher = (DomainDispatcher)domainDispatchers.get(string);
                hashSet.addAll(domainDispatcher.getInterceptors(objectName));
            }
            if (objectName.isPattern() || hashSet.size() == 0) {
                hashSet.add(defaultInterceptor);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainDispatcher addDomainDispatcher(DomainDispatcher domainDispatcher) {
        Map map = domainDispatchers;
        synchronized (map) {
            String string = domainDispatcher.getDomain();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("adding domainDispatcher " + domainDispatcher.getDomain());
            }
            return domainDispatchers.put(domainDispatcher.getDomain(), domainDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainDispatcher removeDomainDispatcher(DomainDispatcher domainDispatcher) {
        Map map = domainDispatchers;
        synchronized (map) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("removing domainDispatcher " + domainDispatcher.getDomain());
            }
            return (DomainDispatcher)domainDispatchers.remove(domainDispatcher.getDomain());
        }
    }

    public DispatchInterceptor(MBeanServer mBeanServer, MBeanServerInterceptor mBeanServerInterceptor) {
        this.mbs = mBeanServer;
        defaultInterceptor = mBeanServerInterceptor;
        if (mBeanServerInterceptor == null || mBeanServer == null) {
            throw new IllegalArgumentException("cannot have null arguments");
        }
    }

    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.ADD_NOTIFICATION_LISTENER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public final void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.ADD_NOTIFICATION_LISTENER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public final ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        DispatchInterceptor.checkMBeanPermission(this.getClass().getClassLoader(), string, null, null, AccessControlActionEnum.INSTANTIATE);
        DispatchInterceptor.checkMBeanPermission(this.getClass().getClassLoader(), string, null, objectName, AccessControlActionEnum.REGISTER_MBEAN);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        ObjectInstance objectInstance = mBeanServerInterceptor.createMBean(string, objectName, objectArray, stringArray);
        return objectInstance;
    }

    public final ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ClassLoader classLoader = this.getClassLoader(objectName2);
        DispatchInterceptor.checkMBeanPermission(classLoader, string, null, null, AccessControlActionEnum.INSTANTIATE);
        DispatchInterceptor.checkMBeanPermission(classLoader, string, null, objectName, AccessControlActionEnum.REGISTER_MBEAN);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        ObjectInstance objectInstance = mBeanServerInterceptor.createMBean(string, objectName, objectName2, objectArray, stringArray);
        return objectInstance;
    }

    public final Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, string, objectName, AccessControlActionEnum.GET_ATTRIBUTE);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getAttribute(objectName, string);
    }

    public final AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                DispatchInterceptor.checkMBeanPermission(null, null, stringArray[i], objectName, AccessControlActionEnum.GET_ATTRIBUTE);
                arrayList.add(stringArray[i]);
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getAttributes(objectName, stringArray2);
    }

    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            return this.getClass().getClassLoader();
        }
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.GET_CLASS_LOADER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getClassLoader(objectName);
    }

    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.GET_CLASS_LOADER_FOR);
        return DispatchInterceptor.internalGetClassLoaderFor(objectName);
    }

    public static final ClassLoader internalGetClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getClassLoaderFor(objectName);
    }

    public final String getDefaultDomain() {
        return defaultInterceptor.getDefaultDomain();
    }

    public final String[] getDomains() {
        DispatchInterceptor.checkMBeanPermission(null, null, null, null, AccessControlActionEnum.GET_DOMAINS);
        Set set = this.queryNames(null, null);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            hashSet.add(objectName.getDomain());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public final ClassLoader getMBeanClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getClassLoaderFor(objectName);
    }

    public Integer getMBeanCount() {
        return new Integer(this.queryNames(null, null).size());
    }

    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.GET_MBEAN_INFO);
        return DispatchInterceptor.internalGetMBeanInfo(objectName);
    }

    public static final MBeanInfo internalGetMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getMBeanInfo(objectName);
    }

    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.GET_OBJECT_INSTANCE);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.getObjectInstance(objectName);
    }

    public final Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, string, objectName, AccessControlActionEnum.INVOKE);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.invoke(objectName, string, objectArray, stringArray);
    }

    public final boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.IS_INSTANCE_OF);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.isInstanceOf(objectName, string);
    }

    public final boolean isRegistered(ObjectName objectName) {
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.isRegistered(objectName);
    }

    public final Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Object object;
        Object object2;
        if (queryExp != null) {
            queryExp.setMBeanServer(this.mbs);
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, null, AccessControlActionEnum.QUERY_MBEANS);
        HashSet hashSet = new HashSet();
        Iterator iterator = DispatchInterceptor.getInterceptors(objectName).iterator();
        while (iterator.hasNext()) {
            object2 = (MBeanServerInterceptor)iterator.next();
            object = object2.queryMBeans(objectName, queryExp);
            hashSet.addAll(object);
        }
        object2 = new HashSet(hashSet.size());
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                object = (ObjectInstance)iterator.next();
                DispatchInterceptor.checkMBeanPermission(DispatchInterceptor.internalGetClassLoaderFor(((ObjectInstance)object).getObjectName()), ((ObjectInstance)object).getClassName(), null, ((ObjectInstance)object).getObjectName(), AccessControlActionEnum.QUERY_MBEANS);
                object2.add(object);
            }
            catch (Exception exception) {}
        }
        return object2;
    }

    public final Set queryNames(ObjectName objectName, QueryExp queryExp) {
        Object object;
        Object object2;
        DispatchInterceptor.checkMBeanPermission(null, null, null, null, AccessControlActionEnum.QUERY_NAMES);
        if (queryExp != null) {
            queryExp.setMBeanServer(this.mbs);
        }
        HashSet hashSet = new HashSet();
        Object object3 = DispatchInterceptor.getInterceptors(objectName).iterator();
        while (object3.hasNext()) {
            object2 = (MBeanServerInterceptor)object3.next();
            object = object2.queryNames(objectName, queryExp);
            if (object.size() <= 0) continue;
            hashSet.addAll(object);
        }
        object3 = new HashSet(hashSet.size());
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            try {
                object = (ObjectName)object2.next();
                DispatchInterceptor.checkMBeanPermission(null, null, null, (ObjectName)object, AccessControlActionEnum.QUERY_NAMES);
                object3.add(object);
            }
            catch (SecurityException securityException) {}
        }
        return object3;
    }

    public final ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        DispatchInterceptor.checkMBeanPermission(object.getClass().getClassLoader(), object.getClass().getName(), null, objectName, AccessControlActionEnum.REGISTER_MBEAN);
        DispatchInterceptor.checkMBeanTrustPermission(object.getClass());
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.registerMBean(object, objectName);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.REMOVE_NOTIFICATION_LISTENER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.REMOVE_NOTIFICATION_LISTENER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.removeNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.REMOVE_NOTIFICATION_LISTENER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.removeNotificationListener(objectName, notificationListener);
    }

    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.REMOVE_NOTIFICATION_LISTENER);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.removeNotificationListener(objectName, objectName2);
    }

    public final void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, attribute.getName(), objectName, AccessControlActionEnum.SET_ATTRIBUTE);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.setAttribute(objectName, attribute);
    }

    public final AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        MBeanServerInterceptor mBeanServerInterceptor = attributeList.iterator();
        while (mBeanServerInterceptor.hasNext()) {
            try {
                Attribute attribute = (Attribute)mBeanServerInterceptor.next();
                DispatchInterceptor.checkMBeanPermission(null, null, attribute.getName(), objectName, AccessControlActionEnum.SET_ATTRIBUTE);
                attributeList2.add(attribute);
            }
            catch (SecurityException securityException) {}
        }
        mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        return mBeanServerInterceptor.setAttributes(objectName, attributeList2);
    }

    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.isRegistered(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        DispatchInterceptor.checkMBeanPermission(null, null, null, objectName, AccessControlActionEnum.UNREGISTER_MBEAN);
        MBeanServerInterceptor mBeanServerInterceptor = DispatchInterceptor.getInterceptor(objectName);
        mBeanServerInterceptor.unregisterMBean(objectName);
    }

    private static void checkMBeanPermission(ClassLoader classLoader, String string, String string2, ObjectName objectName, AccessControlActionEnum accessControlActionEnum) throws SecurityException {
        AccessControlDispatcher.checkMBeanPermission(classLoader, string, string2, objectName, accessControlActionEnum);
    }

    private static void checkMBeanTrustPermission(Class clazz) throws SecurityException {
    }

    static {
        domainDispatchers = new HashMap();
    }
}

