/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao.agent;

import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.agent.VirtualMBeanDomainDispatcher;
import com.sun.cacao.agent.VirtualMBeanInterceptor;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public abstract class CachedVirtualMBeanInterceptor
extends VirtualMBeanInterceptor {
    private Object cacheReference;
    private long cacheTimestamp;
    private Constructor referenceConstructor;
    private static Logger logger = Logger.getLogger("com.sun.cacao.agent");
    public static final String CACHE_VALIDITY_PROPERTY = "cache.validity.milliseconds";
    public static final String CACHE_TYPE_PROPERTY = "cache.reference.type";
    private long cacheValidity;

    public CachedVirtualMBeanInterceptor(MBeanServer mBeanServer, VirtualMBeanDomainDispatcher virtualMBeanDomainDispatcher, ObjectNameFactoryInterface objectNameFactoryInterface, Class clazz, Properties properties) {
        String string;
        block19: {
            String string2;
            block17: {
                super(virtualMBeanDomainDispatcher, clazz);
                this.cacheReference = null;
                this.cacheTimestamp = 0L;
                this.referenceConstructor = null;
                this.cacheValidity = 100000L;
                String string3 = null;
                string2 = objectNameFactoryInterface.getTypeName(clazz);
                try {
                    block16: {
                        try {
                            string = string2 + "." + CACHE_VALIDITY_PROPERTY;
                            string3 = properties.getProperty(string);
                        }
                        catch (Exception exception) {
                            if (!logger.isLoggable(Level.FINE)) break block16;
                            logger.fine("Could not find type for " + clazz);
                        }
                    }
                    if (string3 == null) {
                        string3 = properties.getProperty(CACHE_VALIDITY_PROPERTY);
                    }
                    if (string3 != null) {
                        this.cacheValidity = new Long(string3);
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.FINE)) break block17;
                    logger.fine("Could not get cache validity from property file for " + clazz);
                }
            }
            string = null;
            try {
                block18: {
                    try {
                        String string4 = null;
                        string4 = string2 + "." + CACHE_TYPE_PROPERTY;
                        string = properties.getProperty(string4);
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(Level.FINE)) break block18;
                        logger.fine("Could not find type for " + clazz);
                    }
                }
                if (string == null) {
                    string = properties.getProperty(CACHE_TYPE_PROPERTY);
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.FINE)) break block19;
                logger.fine("Could not get specified cache type from property file for " + clazz + " using default type");
            }
        }
        if (string != "direct" && string != "java.lang.ref.SoftReference" && string != "java.lang.ref.WeakReference") {
            string = "java.lang.ref.SoftReference";
        }
        if (string.equals("direct")) {
            this.referenceConstructor = null;
        } else {
            try {
                this.referenceConstructor = Class.forName(string).getConstructor(Object.class);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unexpected exception ", exception);
                this.referenceConstructor = null;
            }
        }
    }

    public void stop() {
        super.stop();
        this.invalidateCache();
    }

    public String[] getInstances() {
        return this.getCache().keySet().toArray(new String[0]);
    }

    public AttributeList getAttributes(String string, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
        Map map = (Map)this.getCache().get(string);
        if (map == null) {
            throw new InstanceNotFoundException("no such instance " + string);
        }
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            Attribute attribute = (Attribute)map.get(stringArray[i]);
            if (attribute == null) continue;
            attributeList.add((Attribute)map.get(stringArray[i]));
        }
        return attributeList;
    }

    public boolean isRegistered(String string) throws IOException {
        return this.getCache().containsKey(string);
    }

    protected synchronized void invalidateCache() {
        this.cacheReference = null;
    }

    protected synchronized Map getCache() {
        Map map = null;
        if (this.cacheReference != null) {
            map = this.referenceConstructor == null ? (Map)this.cacheReference : (Map)((Reference)this.cacheReference).get();
        }
        if (!this.isCacheValid() || this.cacheReference == null || map == null || System.currentTimeMillis() - this.cacheTimestamp > this.cacheValidity) {
            map = this.fillCache();
            if (this.referenceConstructor == null) {
                this.cacheReference = map;
            } else {
                try {
                    this.cacheReference = this.referenceConstructor.newInstance(map);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Unexpected exception ", exception);
                }
            }
            this.cacheTimestamp = System.currentTimeMillis();
        }
        return map;
    }

    public boolean isCacheValid() {
        return true;
    }

    protected abstract Map fillCache();

    public Map obtainBulkAttributes(String[] stringArray, QueryExp queryExp) {
        Map map = this.getCache();
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            if (queryExp != null) {
                object = this.getObjectNameFactory().getObjectName(this.getMBeanInterface(), string);
                try {
                    if (!queryExp.apply((ObjectName)object)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = (Map)map.get(string);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Iterator iterator2 = object.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (hashSet != null && !hashSet.contains(string2)) continue;
                Attribute attribute = (Attribute)object.get(string2);
                hashMap2.put(string2, attribute.getValue());
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }
}

