/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.ObjectNameFactoryInterface;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameFactory
implements ObjectNameFactoryInterface {
    private static Logger logger = Logger.getLogger("com.sun.cacao");
    private String domain = null;
    private static final String TYPE_KEY = "type";
    public static final String TYPE_CONSTANT = "TYPE";
    public static final String DOMAIN_CONSTANT = "DOMAIN";
    private static final String INSTANCE_KEY = "instance";

    public ObjectNameFactory(Class clazz) {
        String string = null;
        try {
            Field field = clazz.getField(DOMAIN_CONSTANT);
            string = (String)field.get(null);
        }
        catch (Exception exception) {
            string = clazz.getPackage().getName();
        }
        this.domain = string;
    }

    public ObjectNameFactory(String string) {
        this.domain = string;
    }

    public ObjectName getObjectName(Class clazz, String string) throws IllegalArgumentException {
        String string2 = null;
        try {
            Field field = clazz.getField(TYPE_CONSTANT);
            string2 = (String)field.get(null);
        }
        catch (Exception exception) {
            string2 = clazz.getName();
        }
        if (string != null) {
            return ObjectNameFactory.constructObjectName(this.domain + ":" + TYPE_KEY + "=" + string2 + "," + INSTANCE_KEY + "=" + ObjectName.quote(string));
        }
        return ObjectNameFactory.constructObjectName(this.domain + ":" + TYPE_KEY + "=" + string2);
    }

    public ObjectName getObjectNamePattern(Class clazz) throws IllegalArgumentException {
        String string = null;
        try {
            Field field = clazz.getField(TYPE_CONSTANT);
            string = (String)field.get(null);
        }
        catch (Exception exception) {
            string = clazz.getName();
        }
        return ObjectNameFactory.constructObjectName(this.domain + ":" + TYPE_KEY + "=" + string + "," + "*");
    }

    private static ObjectName constructObjectName(String string) throws IllegalArgumentException {
        try {
            ObjectName objectName = new ObjectName(string);
            return objectName;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            logger.log(Level.WARNING, "caught exception", malformedObjectNameException);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("illegal object name value attributes:" + malformedObjectNameException.getMessage());
            illegalArgumentException.initCause(malformedObjectNameException);
            throw illegalArgumentException;
        }
    }

    public String getInstanceName(ObjectName objectName) {
        String string = objectName.getKeyProperty(INSTANCE_KEY);
        if (string == null) {
            throw new IllegalArgumentException("Could not find instance key in " + objectName);
        }
        try {
            return ObjectName.unquote(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.WARNING, "caught exception, instance name should be quoted", illegalArgumentException);
            return string;
        }
    }

    public String getTypeName(ObjectName objectName) {
        String string = objectName.getKeyProperty(TYPE_KEY);
        return string;
    }

    public String getTypeName(Class clazz) {
        String string = null;
        try {
            Field field = clazz.getField(TYPE_CONSTANT);
            string = (String)field.get(null);
        }
        catch (Exception exception) {
            string = clazz.getName();
        }
        return string;
    }

    public String getDomain() {
        return this.domain;
    }
}

