/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.Dependency;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.ModuleClassLoader;
import com.sun.cacao.ModuleClassLoaderMBean;
import com.sun.cacao.ModuleMBean;
import com.sun.cacao.ModuleManagerMBean;
import com.sun.cacao.ObjectNameFactoryInterface;
import com.sun.cacao.container.Container;
import com.sun.cacao.container.DependenciesSupport;
import com.sun.cacao.container.MBeanServerModuleManagerNotifFilter;
import com.sun.cacao.container.ModuleInformation;
import com.sun.cacao.element.AdministrativeStateEnum;
import com.sun.cacao.element.AvailabilityStatusEnum;
import com.sun.cacao.element.OperationalStateEnum;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class ModuleManager
extends DependenciesSupport
implements ModuleManagerMBean {
    private static String ATTEMPT_KEY = "modulemanager.garbage.attempts";
    private static Logger logger = Logger.getLogger("com.sun.cacao");
    private ClassLoader cl;
    private ModuleInformation info;
    private ModuleMBean module;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleManager(DeploymentDescriptor deploymentDescriptor, ObjectName objectName) {
        block14: {
            super(deploymentDescriptor, objectName);
            this.info = this.getModuleInformation(deploymentDescriptor.getName());
            this.info.setManagerObjectName(objectName);
            try {
                if (this.areDependenciesOk(true)) {
                    this.cl = this.createModuleClassLoader();
                    try {
                        Class clazz = this.getModuleClass();
                    }
                    catch (Throwable throwable) {
                        block13: {
                            try {
                                this.setOperationalState(OperationalStateEnum.DISABLED);
                            }
                            catch (Throwable throwable2) {
                                if (!logger.isLoggable(Level.FINEST)) break block13;
                                logger.log(Level.FINEST, "Set to disable, invalid module class: " + deploymentDescriptor.getModuleClass(), throwable);
                            }
                        }
                        this.availabilityStatusSetAdd(AvailabilityStatusEnum.FAILED);
                    }
                    break block14;
                }
                this.disableWithDependencyFailure();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Dependencies are not OK for " + deploymentDescriptor.getName());
                }
            }
            catch (Throwable throwable) {
                this.disableWithDependencyFailure();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cannot create classloader for" + deploymentDescriptor.getName(), throwable);
                }
            }
            finally {
                if (deploymentDescriptor.getEnableOnDemand() && !this.isNeededByOtherModule()) {
                    this.disableWithOfflineFailure();
                }
            }
        }
    }

    protected void stop() throws RuntimeException {
        block5: {
            block4: {
                try {
                    this.removeModule();
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.fine("Error in stop when removing module for " + this.descriptor.getName());
                }
            }
            ObjectNameFactoryInterface objectNameFactoryInterface = Container.getCacaoObjectNameFactory();
            try {
                ObjectName objectName = objectNameFactoryInterface.getObjectName(ModuleClassLoaderMBean.class, this.descriptor.getName());
                Container.getMbs().unregisterMBean(objectName);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.fine("Error when unregistring the classloader for " + this.descriptor.getName());
            }
        }
        this.cl = null;
        this.garbage();
    }

    private ModuleInformation getModuleInformation(String string) {
        return Container.getModuleInformation(string);
    }

    private Map getModuleInformation() {
        return Container.getModuleInformation();
    }

    protected void start() throws RuntimeException {
        Object var1_1 = null;
        try {
            if (this.cl == null) {
                this.cl = this.createModuleClassLoader();
            }
            MBeanServer mBeanServer = Container.getMbs();
            ObjectNameFactoryInterface objectNameFactoryInterface = Container.getCacaoObjectNameFactory();
            mBeanServer.registerMBean(this.cl, objectNameFactoryInterface.getObjectName(ModuleClassLoaderMBean.class, this.descriptor.getName()));
            Class clazz = this.getModuleClass();
            Constructor constructor = clazz.getConstructor(this.descriptor.getClass());
            this.module = (ModuleMBean)constructor.newInstance(this.descriptor);
            AdministrativeStateEnum administrativeStateEnum = this.descriptor.getInitialAdministrativeState();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Module state: " + administrativeStateEnum);
            }
            this.setModuleAdministrativeState(administrativeStateEnum);
        }
        catch (Throwable throwable) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Problem when starting in ModuleManagementMBean for " + this.descriptor.getName(), throwable);
            }
            try {
                this.setOperationalState(OperationalStateEnum.DISABLED);
            }
            catch (Throwable throwable2) {
                logger.log(Level.FINEST, "Set to disable and we have an exception", throwable2);
            }
            this.availabilityStatusSetAdd(AvailabilityStatusEnum.FAILED);
        }
    }

    private void removeModule() throws RuntimeException {
        try {
            if (this.module != null) {
                this.setModuleAdministrativeState(AdministrativeStateEnum.LOCKED);
                this.module = null;
                Container.getMbs().unregisterMBean(this.getModuleObjectName());
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Cannot remove module : " + this.descriptor.getName(), throwable);
            throw new RuntimeException("Cannot remove module: " + throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setModuleAdministrativeState(AdministrativeStateEnum administrativeStateEnum) throws Exception {
        block6: {
            if (this.module != null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.cl);
                try {
                    if (administrativeStateEnum.equals(AdministrativeStateEnum.LOCKED)) {
                        this.module.lock();
                        break block6;
                    }
                    if (administrativeStateEnum.equals(AdministrativeStateEnum.UNLOCKED)) {
                        this.module.unlock();
                        break block6;
                    }
                    throw new IllegalArgumentException("Invalid state");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        }
    }

    private void garbage() {
        if (this.info != null) {
            int n;
            System.gc();
            String string = Container.getProperty(ATTEMPT_KEY);
            if (string == null) {
                n = 5;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.fine(string + " is not a valid value for " + "gc attempts in " + this.descriptor.getName());
                    n = 5;
                }
            }
            for (int i = n - 1; i >= 0; --i) {
                if (this.info.getPublicClassLoader() == null) {
                    logger.finer("Clean classloader for " + this.descriptor.getName());
                    return;
                }
                try {
                    Thread.sleep(100L);
                    System.gc();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                logger.finer("Module GC failed - number of attempts left is " + i);
            }
            Level level = Level.WARNING;
            if (Container.isShuttingDown()) {
                level = Level.FINE;
            }
            logger.log(level, "Cannot garbage collect class loader for module " + this.descriptor.getName() + " - external references " + "probably still exist. There may have problems " + "redeploying this module. See bugid 6218682.");
        }
    }

    private URLClassLoader createModuleClassLoader() throws Exception {
        Object object;
        ModuleClassLoader moduleClassLoader = null;
        String string = this.descriptor.getName();
        try {
            moduleClassLoader = this.getClassLoader(this.descriptor.getPublicPaths(), this.getClass().getClassLoader(), "public_" + string);
            object = Container.getMbs();
            ObjectNameFactoryInterface objectNameFactoryInterface = Container.getCacaoObjectNameFactory();
            List list = this.descriptor.getDependencies();
            ArrayList<WeakReference<ClassLoader>> arrayList = new ArrayList<WeakReference<ClassLoader>>();
            if (list != null) {
                URL[] uRLArray;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    uRLArray = (URL[])iterator.next();
                    String string2 = uRLArray.getModuleName();
                    ModuleInformation moduleInformation = (ModuleInformation)this.getModuleInformation().get(string2);
                    ClassLoader classLoader = moduleInformation.getPublicClassLoader();
                    if (classLoader != null) {
                        arrayList.add(new WeakReference<ClassLoader>(classLoader));
                        continue;
                    }
                    throw new RuntimeException("Missing class loader for " + string2);
                }
                if (arrayList.size() != 0) {
                    if (moduleClassLoader == null) {
                        uRLArray = new URL[]{};
                        moduleClassLoader = new ModuleClassLoader(uRLArray, "public_" + string);
                    }
                    moduleClassLoader.setDependencyClassLoader(arrayList);
                }
            }
            moduleClassLoader.setLibraryPaths(this.descriptor.getLibraryPaths());
        }
        catch (Throwable throwable) {
            throw new Exception("Cannot create public class loader for module " + string + " : " + throwable.getMessage());
        }
        try {
            logger.finer("Create classLoader for modules " + string);
            object = this.getClassLoader(this.descriptor.getPrivatePaths(), moduleClassLoader, string);
            this.info.setClassLoader((ModuleClassLoader)object);
            return object;
        }
        catch (Exception exception) {
            throw new Exception("Cannot create module private class loader for module " + string + " : " + exception.getMessage());
        }
    }

    private ModuleClassLoader getClassLoader(List list, ClassLoader classLoader, String string) {
        ModuleClassLoader moduleClassLoader = null;
        URL[] uRLArray = list != null ? list.toArray(new URL[list.size()]) : new URL[]{};
        moduleClassLoader = classLoader == null ? new ModuleClassLoader(uRLArray, string) : new ModuleClassLoader(uRLArray, classLoader, string);
        return moduleClassLoader;
    }

    private ObjectName getModuleObjectName() {
        if (this.cl == null) {
            return null;
        }
        try {
            String string = this.descriptor.getModuleClass();
            Class<?> clazz = this.cl.loadClass(string);
            return Container.getCacaoObjectNameFactory().getObjectName(clazz, this.descriptor.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected ObjectName getDependencyObjectName(String string) {
        return Container.getCacaoObjectNameFactory().getObjectName(ModuleManagerMBean.class, string);
    }

    protected void disableWithOfflineFailure() {
        logger.finest("In disableWithOfflineFailure");
        try {
            this.setOperationalState(OperationalStateEnum.DISABLED);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.FINEST, "Set to disable and we should not have thefollowing exception ", illegalArgumentException);
        }
        catch (Throwable throwable) {
            logger.log(Level.FINEST, "We have a problem to stop the module " + this.descriptor.getName(), throwable);
        }
        this.availabilityStatusSetAdd(AvailabilityStatusEnum.OFF_LINE);
        logger.finer("Operational State of ModuleManager " + this.descriptor.getName() + " is set to DISABLED");
        logger.finer("Add OFF_LINE in the availability status.");
    }

    protected void enableAndClearOfflineFailure() {
        logger.finer("In enableAndClearOfflineFailure");
        this.availabilityStatusSetRemove(AvailabilityStatusEnum.OFF_LINE);
        try {
            this.setOperationalState(OperationalStateEnum.ENABLED);
        }
        catch (Throwable throwable) {
            logger.finest("Cannot set operational state to enable for " + this.descriptor.getName());
        }
    }

    public void handleNotification(Notification notification, Object object) {
        String string = notification.getType();
        if (string.equals("JMX.mbean.unregistered")) {
            if (this.descriptor.getEnableOnDemand() && !this.isNeededByOtherModule()) {
                this.disableWithOfflineFailure();
            }
        } else {
            if (string.equals("JMX.mbean.registered")) {
                if (this.descriptor.getEnableOnDemand()) {
                    logger.finest("Check if someone need this module " + this.isNeededByOtherModule());
                    if (this.isNeededByOtherModule()) {
                        this.enableAndClearOfflineFailure();
                    }
                }
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                List list = this.getValidDependenciesObjectName();
                if (!list.contains(objectName)) {
                    return;
                }
            }
            logger.finest("Forward notification to dependencies support");
            super.handleNotification(notification, object);
        }
    }

    protected NotificationFilter getFilter() {
        logger.finer("In getFilter for ModuleManager" + this.getObjectName());
        MBeanServerModuleManagerNotifFilter mBeanServerModuleManagerNotifFilter = new MBeanServerModuleManagerNotifFilter();
        return mBeanServerModuleManagerNotifFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNeededByOtherModule() {
        List list;
        List list2 = list = Container.getStarted();
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)iterator.next();
                logger.finest(" isNeededByOtherModule dependency for " + deploymentDescriptor.getName());
                List list3 = deploymentDescriptor.getDependencies();
                Iterator iterator2 = list3.iterator();
                while (iterator2.hasNext()) {
                    Dependency dependency = (Dependency)iterator2.next();
                    if (!dependency.getModuleName().equals(this.descriptor.getName())) continue;
                    logger.finest("Check if module " + deploymentDescriptor.getName() + " is present.");
                    if (!this.isModuleManagerPresent(deploymentDescriptor.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isModuleManagerPresent(String string) {
        ObjectName objectName = this.getDependencyObjectName(string);
        MBeanServer mBeanServer = Container.getMbs();
        return mBeanServer.isRegistered(objectName);
    }

    private Class getModuleClass() throws ClassNotFoundException {
        String string = this.descriptor.getModuleClass();
        if (string == null) {
            string = "com.sun.cacao.ModuleConcreteClass";
        }
        if (this.cl == null) {
            logger.warning("Classloader for" + this.descriptor.getName() + " is null");
            throw new ClassNotFoundException("Classoader is null");
        }
        Class<?> clazz = this.cl.loadClass(string);
        return clazz;
    }
}

