/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.ModuleClassLoaderMBean;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.loading.PrivateClassLoader;

public class ModuleClassLoader
extends URLClassLoader
implements ModuleClassLoaderMBean,
PrivateClassLoader {
    private List otherClassLoader = new ArrayList();
    private String name;
    private List libraryPaths = null;
    private static Logger logger = Logger.getLogger("com.sun.cacao.container");

    public ModuleClassLoader(URL[] uRLArray, String string) {
        super(uRLArray);
        this.name = string;
    }

    public ModuleClassLoader(URL[] uRLArray, ClassLoader classLoader, String string) {
        super(uRLArray, classLoader);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Classloader for module " + this.name;
    }

    public void setDependencyClassLoader(List list) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Set dependencies for this ClassLoader " + list);
        }
        this.otherClassLoader = list;
    }

    public void setLibraryPaths(List list) {
        this.libraryPaths = list;
    }

    protected String findLibrary(String string) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        if (this.libraryPaths != null) {
            object3 = System.mapLibraryName(string);
            object2 = this.libraryPaths.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string2 = (String)object + File.separator + (String)object3;
                File file = new File(string2);
                if (!file.exists()) continue;
                return string2;
            }
        }
        if (this.otherClassLoader != null) {
            object3 = this.otherClassLoader.iterator();
            while (object3.hasNext()) {
                object2 = (WeakReference)object3.next();
                object = (ModuleClassLoader)((Reference)object2).get();
                if (object == null || (string2 = ((ModuleClassLoader)object).findLibrary(string)) == null) continue;
                return string2;
            }
        }
        return null;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("module " + this.name + " : searching for class " + string + " in dependencies");
            }
            return this.findClassInDependencies(string);
        }
    }

    private Class findClassInDependencies(String string) throws ClassNotFoundException {
        if (this.otherClassLoader != null) {
            Iterator iterator = this.otherClassLoader.iterator();
            while (iterator.hasNext()) {
                try {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    ModuleClassLoader moduleClassLoader = (ModuleClassLoader)weakReference.get();
                    if (moduleClassLoader == null) continue;
                    Class<?> clazz = moduleClassLoader.loadClass(string);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Found class  " + string + " in module " + moduleClassLoader.name);
                    }
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        throw new ClassNotFoundException("Cannot find class " + string + " in module " + this.name);
    }
}

