/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.Dependency;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.ModuleMBean;
import com.sun.cacao.container.Container;
import com.sun.cacao.container.DependenciesSupport;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;

public abstract class Module
extends DependenciesSupport
implements ModuleMBean {
    private static Logger logger = Logger.getLogger("com.sun.cacao");

    protected MBeanServer getMbs() {
        return Container.getMbs();
    }

    public Module(DeploymentDescriptor deploymentDescriptor) {
        super(deploymentDescriptor, null);
        try {
            this.setObjectName(Container.getCacaoObjectNameFactory().getObjectName(ModuleMBean.class, deploymentDescriptor.getName()));
            if (!this.areDependenciesOk(true)) {
                this.disableWithDependencyFailure();
            }
            this.getMbs().registerMBean(this, this.getObjectName());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception caught when registering module MBean", exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getDomainName() {
        return this.getClass().getPackage().getName();
    }

    public void handleNotification(Notification notification, Object object) {
        super.handleNotification(notification, object);
    }

    public boolean isHealthy() {
        return this.areDependenciesOk(false);
    }

    protected boolean isValidDependency(Dependency dependency) {
        return dependency.isStrongDependency();
    }

    protected ObjectName getDependencyObjectName(String string) {
        Iterator iterator = Container.getStarted().iterator();
        boolean bl = false;
        DeploymentDescriptor deploymentDescriptor = null;
        while (!bl) {
            deploymentDescriptor = (DeploymentDescriptor)iterator.next();
            if (!string.equals(deploymentDescriptor.getName())) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        String string2 = deploymentDescriptor.getModuleClass();
        return Container.getCacaoObjectNameFactory().getObjectName(ModuleMBean.class, string);
    }
}

