/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.DataDrivenHandler;
import com.sun.cacao.DataDrivenInfo;
import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.Module;
import com.sun.cacao.ObjectNameFactory;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DataDrivenModule
extends Module {
    private static final String MBEAN_STANDARD_TYPE = "standard";
    private static final String MBEAN_VIRTUAL_TYPE = "virtual";
    private static final String MBEAN_ITF_SUFFIX = "MBean";
    private static Logger logger = Logger.getLogger("com.sun.cacao");
    private SAXParserFactory factory = SAXParserFactory.newInstance();
    private List mbeans = null;

    public DataDrivenModule(DeploymentDescriptor deploymentDescriptor) {
        super(deploymentDescriptor);
        this.factory.setValidating(true);
        this.factory.setNamespaceAware(false);
    }

    protected void start(ObjectNameFactory objectNameFactory, ClassLoader classLoader) {
        DeploymentDescriptor deploymentDescriptor = this.getDeploymentDescriptor();
        String string = deploymentDescriptor.getMbeanInstancesDescriptor();
        if (string == null || string.equals("")) {
            String string2 = "MBean instances descriptor file name missing in the deployment descriptor of module " + deploymentDescriptor.getName();
            logger.warning(string2);
            throw new RuntimeException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = "MBean instances descriptor file doesn't exist  for module " + deploymentDescriptor.getName();
            logger.warning(string3);
            throw new RuntimeException(string3);
        }
        try {
            SAXParser sAXParser = this.factory.newSAXParser();
            DataDrivenHandler dataDrivenHandler = new DataDrivenHandler();
            InputSource inputSource = new InputSource(new FileInputStream(file));
            inputSource.setSystemId("");
            sAXParser.parse(inputSource, (DefaultHandler)dataDrivenHandler);
            this.mbeans = dataDrivenHandler.getMBeans();
            Iterator iterator = this.mbeans.iterator();
            while (iterator.hasNext()) {
                this.registerMBean((DataDrivenInfo)iterator.next(), objectNameFactory, classLoader);
            }
            dataDrivenHandler = null;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception caught: " + exception, exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected void stop(ObjectNameFactory objectNameFactory, ClassLoader classLoader) {
        if (this.mbeans == null) {
            logger.finer("No mbean instances to unregister");
            return;
        }
        try {
            Iterator iterator = this.mbeans.iterator();
            while (iterator.hasNext()) {
                this.unregisterMBean((DataDrivenInfo)iterator.next(), objectNameFactory, classLoader);
            }
        }
        catch (Exception exception) {
            logger.warning("Exception caught : " + exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void registerMBean(DataDrivenInfo dataDrivenInfo, ObjectNameFactory objectNameFactory, ClassLoader classLoader) {
        Properties properties = dataDrivenInfo.getParameters();
        String string = dataDrivenInfo.getType();
        String string2 = dataDrivenInfo.getClassName();
        String string3 = dataDrivenInfo.getInstance();
        if (string == null || !string.equals(MBEAN_STANDARD_TYPE)) {
            return;
        }
        try {
            GenericDeclaration genericDeclaration;
            Class<?> clazz = classLoader.loadClass(string2);
            Object var9_10 = null;
            if (properties != null && properties.size() != 0) {
                logger.finest("Starting Mbean instance " + string3 + " (" + string2 + ")" + " with Properties parameter");
                genericDeclaration = null;
                genericDeclaration = clazz.getConstructor(Properties.class);
                var9_10 = ((Constructor)genericDeclaration).newInstance(properties);
            } else {
                logger.finest("Starting Mbean instance " + string3 + " (" + string2 + ")" + " with no parameters");
                var9_10 = clazz.newInstance();
            }
            genericDeclaration = classLoader.loadClass(string2 + MBEAN_ITF_SUFFIX);
            ObjectName objectName = objectNameFactory.getObjectName((Class)genericDeclaration, string3);
            this.getMbs().registerMBean(var9_10, objectName);
        }
        catch (Exception exception) {
            logger.warning("Exception caught while registering mbean " + string3 + " : " + exception);
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void unregisterMBean(DataDrivenInfo dataDrivenInfo, ObjectNameFactory objectNameFactory, ClassLoader classLoader) {
        String string = dataDrivenInfo.getType();
        String string2 = dataDrivenInfo.getClassName();
        String string3 = dataDrivenInfo.getInstance();
        logger.finest("Stopping MBean instance : name = " + string3 + " class = " + string2);
        if (string == null || !string.equals(MBEAN_STANDARD_TYPE)) {
            return;
        }
        try {
            Class<?> clazz = classLoader.loadClass(string2 + MBEAN_ITF_SUFFIX);
            ObjectName objectName = objectNameFactory.getObjectName(clazz, string3);
            this.getMbs().unregisterMBean(objectName);
        }
        catch (Exception exception) {
            logger.warning("Exception caught while unregistering MBean " + string3 + " : " + exception);
            throw new RuntimeException(exception.getMessage());
        }
    }
}

