/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.DataDrivenInfo;
import com.sun.cacao.agent.JmxClient;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DataDrivenHandler
extends DefaultHandler {
    private static final String MBEANS_ELEMENT = "mbeans";
    private static final String MBEAN_ELEMENT = "mbean";
    private static final String PARAMETERS_ELEMENT = "parameters";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "instance";
    private static final String DESC_ATTRIBUTE = "description";
    private static final String PARAMETER_NAME_ATTRIBUTE = "param-name";
    private static final String PARAMETER_VALUE_ATTRIBUTE = "param-value";
    private static final String MODULE_DTD_URI = "urn:sun:n1:cacao:datadriven:dtd:1_1";
    private static Logger logger = Logger.getLogger("com.sun.cacao");
    private String text = "";
    private List mbeans = null;
    private DataDrivenInfo mbean = null;
    private Properties parameters = null;

    public List getMBeans() {
        return this.mbeans;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        String string3 = JmxClient.getStringParameter(null, "use.j2me");
        if (Boolean.valueOf(string3).booleanValue()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("no XML validation with J2ME SAX parser");
            }
            return null;
        }
        if (string2.toLowerCase().equals(MODULE_DTD_URI)) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/sun/cacao/module_xml.dtd");
            if (inputStream != null) {
                return new InputSource(inputStream);
            }
            throw new SAXException("Module DTD not found in local classloader");
        }
        return null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.text = "";
        if (string3.equals(MBEANS_ELEMENT)) {
            this.mbeans = new LinkedList();
        } else if (string3.equals(MBEAN_ELEMENT)) {
            this.mbean = new DataDrivenInfo();
            this.mbean.setType(attributes.getValue(TYPE_ATTRIBUTE));
            this.mbean.setInstance(attributes.getValue(NAME_ATTRIBUTE));
            this.mbean.setClassName(attributes.getValue(CLASS_ATTRIBUTE));
            this.mbean.setDescription(attributes.getValue(DESC_ATTRIBUTE));
        } else if (string3.equals(PARAMETERS_ELEMENT)) {
            this.parameters = new Properties();
        } else if (string3.equals(PARAMETER_ELEMENT)) {
            String string4 = attributes.getValue(PARAMETER_NAME_ATTRIBUTE);
            if (string4 == null || string4.equals("")) {
                throw new IllegalArgumentException("Missing a parameter name in parameter section");
            }
            String string5 = attributes.getValue(PARAMETER_VALUE_ATTRIBUTE);
            if (PARAMETER_VALUE_ATTRIBUTE == null) {
                string5 = "";
            }
            this.parameters.setProperty(string4, string5);
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equals(PARAMETERS_ELEMENT)) {
            this.mbean.setParameters(this.parameters);
        } else if (string3.equals(MBEAN_ELEMENT)) {
            this.mbeans.add(this.mbean);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        this.text = this.text + string.trim();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(sAXParseException.getMessage());
        }
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(sAXParseException.getMessage());
        }
        throw sAXParseException;
    }
}

