/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cacao;

import com.sun.cacao.CacaoMBean;
import com.sun.cacao.LifecycleNotification;
import com.sun.cacao.agent.auth.SecureNotificationBroadcasterSupport;
import com.sun.cacao.container.Container;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;

public class Cacao
extends SecureNotificationBroadcasterSupport
implements CacaoMBean {
    private static Logger logger;
    private long creationTime;
    private long sequenceNumber = 0L;

    public Cacao() {
        logger = Logger.getLogger("com.sun.cacao");
        this.creationTime = System.currentTimeMillis();
    }

    public String getVersion() {
        return Container.getVersion();
    }

    public long getUptime() {
        long l = System.currentTimeMillis() - this.creationTime;
        return l;
    }

    public void sendLifecycleNotification(String string) {
        ObjectName objectName = null;
        try {
            objectName = Container.getCacaoObjectNameFactory().getObjectName(CacaoMBean.class, null);
            LifecycleNotification lifecycleNotification = new LifecycleNotification(string, objectName, this.generateSequenceNumber());
            this.sendNotification(lifecycleNotification);
        }
        catch (Exception exception) {
            logger.fine("Invalid object name for shutdown notification");
        }
    }

    public void shutDown() {
        Container.shutDown();
    }

    public boolean isShuttingDown() {
        return Container.isShuttingDown();
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getMaxMemory() throws UnsupportedOperationException {
        return Runtime.getRuntime().maxMemory();
    }

    public long getUsedMemory() {
        long l;
        long l2;
        Runtime runtime = Runtime.getRuntime();
        do {
            l2 = this.getTotalMemory();
            l = this.getFreeMemory();
        } while (this.getTotalMemory() != l2);
        return l2 - l;
    }

    public String getVersionCompatibilityList() {
        return Container.getProperty("cacao.version.compatibility.list");
    }

    public void gc() {
        System.gc();
    }

    public void abort() {
        Container.abort();
    }

    private synchronized long generateSequenceNumber() {
        return this.sequenceNumber++;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"com.sun.cacao.lifecycle.started", "com.sun.cacao.lifecycle.shutdown"}, "com.sun.cacao.LifecycleNotification", "Module lifecycle notifications")};
    }

    public String getInstanceName() {
        return Container.getProperty("cacao.instance.name");
    }
}

