-- @(#)Performance-1.2.ddl	1.6 05/10/13
--
-- ##################################################################
-- 
-- What is the change: alter datatypes to double precision, real
--
-- Why change is needed: previous datatype don't support very large
--    values - got overflow errors
--
-- Risks to existing user data: any existing user data will be forfeited
--    but it is a management decision that this is OK

drop table Performance_Data cascade;

CREATE TABLE Performance_Data
(
	collector_key	    VARCHAR(128) NOT NULL,
	component_id	    VARCHAR(64) NOT NULL, 
	iops		    double precision,
	read_percentage	    real,
	write_percentage    real,
	cache_read_hit	    real,
	data_transfer	    double precision,
	bytes_read	    double precision,
	bytes_written	    double precision,
	average_read_size   double precision,
	average_write_size  double precision,
	time	    	    BIGINT,
	CONSTRAINT PK_Performance_Data
	PRIMARY KEY (collector_key, component_id, time)
);

CREATE TABLE Performance_Array_Data
(
        component_type      VARCHAR(32),
        component_name      VARCHAR(128) NOT NULL,
        CONSTRAINT PK_Performance_Array_Data
        PRIMARY KEY (collector_key, component_id, time)
) inherits (Performance_Data);
