-- @(#)Performance-1.2-undo.ddl	1.4 05/10/13
--
-- ##################################################################
-- 
-- What is the change: alter datatypes to double precision, real
--
-- Why change is needed: previous datatype don't support very large
--    values - got overflow errors
--
-- Risks to existing user data: any existing user data will be forfeited
--    but it is a management decision that this is OK

drop table Performance_Data cascade;

CREATE TABLE Performance_Data
(
	collector_key	    VARCHAR(128) NOT NULL,
	component_id	    VARCHAR(64) NOT NULL, 
	iops		    NUMERIC(10, 3),
	read_percentage	    NUMERIC(10, 3),
	write_percentage    NUMERIC(10, 3),
	cache_read_hit	    NUMERIC(10, 3),
	data_transfer	    NUMERIC(10, 3),
	bytes_read	    NUMERIC(10, 3),
	bytes_written	    NUMERIC(10, 3),
	average_read_size   NUMERIC(10, 3),
	average_write_size  NUMERIC(10, 3),
	time	    	    BIGINT,
	CONSTRAINT PK_Performance_Data
	PRIMARY KEY (collector_key, component_id, time)
);

CREATE TABLE Performance_Array_Data
(
        component_type      VARCHAR(32),
        component_name      VARCHAR(128) NOT NULL,
        CONSTRAINT PK_Performance_Array_Data
        PRIMARY KEY (collector_key, component_id, time)
) inherits (Performance_Data);
