-- @(#)Element_mgr_template-patch02-undo.ddl	1.3 05/11/16
--
-- ##################################################################
--
-- Undo the following:
--
-- What is the change: add an element_manager_template table entry for model
-- names 5210, 5310 and 6920.  
--
-- Why change is needed: StorADE patch 55 will be returning model name 6920
-- instead of model name 6320/6920 for 6920 devices.  This addition will 
-- ensure that link and launch to the 6920 element manager will still work
-- after the StorADE patch is applied.  The 6320/6920 model entry should also
-- remain in the element_manager_template table so that the lnl path will be 
-- correct when running with versions of StorADE prior to patch 55. StorADE
-- patch 55 will also be returning legitimate model names for the 5210 and 5310
-- devices.
--
-- Risks to existing user data: No risk: this is system data, not user data.
--
-- INSERT into element_manager_template values ('6920', 'Sun', 'sscs6920', 'https://<ip>:6789', null, false, false);
-- INSERT into element_manager_template values ('5210', 'Sun', 'sscs5210', 'http://<ip>', null, false, false);
-- INSERT into element_manager_template values ('5310', 'Sun', 'sscs5310', 'http://<ip>', null, false, false);
-- INSERT INTO element_manager_template values ('3320', 'Sun', 'sscs3320', '/usr/sbin/ssconsole', null, true, false);
-- INSERT INTO element_manager_template values ('6140', 'Sun', 'sscs6140', 'https://<ip>:6789', null, true, false);
--
DELETE from element_manager_template where vendor = 'Sun' and (model = '6920' or model = '5210' or model = '5310' or model = '3320' or model = '6140');
--
-- want to explicitly update element to coincide with above, instead of assuming it's OK to wait for next discovery cycle
--
UPDATE element set element_manager = null where vendor = 'Sun' and (model = '6920' or model = '5210' or model = '5310' or model = '3320' or model = '6140');
--
-- debugging aid
--
-- select model, vendor, element_manager from element where vendor = 'Sun' and (model = '6920' or model = '5210' or model = '5310' or model = '3320' or model = '6140')

