/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.SamQfsCollectorMBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.scheduler.impl.SchedulerUtilImpl;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class SamQfsCollectorImpl
extends StandardMBean
implements SamQfsCollectorMBean {
    private static final String revision = "1.0.0";
    private static final String sccs_id = "@(#)SamQfsCollectorImpl.java\t1.13 05/06/28";
    private Properties props = new Properties();
    private static Logger logger = Logger.getLogger("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs");
    private String jobName = null;
    private String jobGroup = null;
    private String jobTrigName = this.getJobTriggerName("Repeat");
    private String jobTrigGrp = null;
    private static final String CLASS_NAME = "SamQfsCollectorImpl";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean;

    public SamQfsCollectorImpl(Class clazz) throws NotCompliantMBeanException, LocalizableIllegalArgumentException {
        super(clazz);
        this.jobName = this.getJobName("Repeat");
        this.jobTrigGrp = this.getGroupTriggerName("Repeat");
        this.jobGroup = this.getGroupName("Repeat");
        this.setInitialProperties();
    }

    public void start() {
        try {
            if (this.pollingEnabled()) {
                this.startCollecting();
            }
        }
        catch (LocalizableException localizableException) {
            logger.log(Level.SEVERE, localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error starting SAM-QFS Collector", exception);
        }
    }

    public void stop() {
        try {
            this.stopCollecting(true);
            PersistenceManager.release();
        }
        catch (PersistenceException persistenceException) {
            logger.log(Level.WARNING, "Persistence exception while releasing Manager connection pool: ", persistenceException);
        }
        catch (LocalizableException localizableException) {
            logger.log(Level.SEVERE, localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception Stopping SAM-QFS Collector", exception);
        }
        logger.log(Level.INFO, "Stopped SAM-QFS Collector Job ...");
    }

    public MBeanInfo getMBeanInfo() {
        return super.getMBeanInfo();
    }

    private Scheduler getScheduler() throws LocalizableException {
        Scheduler scheduler = null;
        logger.log(Level.FINER, "entering getScheduler");
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            LocalizableException localizableException = new LocalizableException("samqfsNoSchedulerFound", (Throwable)exception, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        if (scheduler == null) {
            LocalizableException localizableException = new LocalizableException("samqfsNoSchedulerFound", "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        return scheduler;
    }

    private void schedulerChanges(boolean bl) throws LocalizableException {
        boolean bl2 = this.pollingEnabled();
        if (bl && !bl2) {
            this.stopCollecting(false);
        } else if (bl2 && !bl) {
            this.startCollecting();
        } else if (bl2 && bl) {
            this.stopCollecting(false);
            this.startCollecting();
        }
    }

    private void startCollecting() throws LocalizableException {
        try {
            JobDetail jobDetail = new JobDetail(this.jobName, this.jobGroup, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl.CollectorJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob);
            long l = this.propGetPollingInterval();
            Date date = Calendar.getInstance().getTime();
            long l2 = date.getTime() + 10000L;
            Date date2 = new Date(l2);
            SimpleTrigger simpleTrigger = new SimpleTrigger(this.jobTrigName, this.jobTrigGrp, this.jobName, this.jobGroup, date2, null, SimpleTrigger.REPEAT_INDEFINITELY, 1000L * l);
            Scheduler scheduler = this.getScheduler();
            scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
            logger.log(Level.INFO, "Job has been scheduled with a polling interval of " + l + " seconds");
            logger.log(Level.FINE, "First time trigger: " + DateFormat.getDateTimeInstance().format(date2));
            Date date3 = simpleTrigger.getNextFireTime();
            logger.log(Level.FINE, "Next time trigger: " + DateFormat.getDateTimeInstance().format(date3));
        }
        catch (LocalizableException localizableException) {
            LocalizableException localizableException2 = new LocalizableException("samqfsJobScheduleFailed", (Throwable)localizableException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException2;
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("samqfsJobScheduleFailed", (Throwable)schedulerException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        catch (Error error) {
            LocalizableException localizableException = new LocalizableException("samqfsJobScheduleFailed", (Throwable)error, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
    }

    private void startSingleCollectionJob() throws LocalizableException {
        logger.log(Level.FINE, "entering startSingleCollectionJob");
        try {
            Scheduler scheduler = this.getScheduler();
            String string = this.getJobName("OneTime");
            String string2 = this.getGroupName("OneTime");
            JobDetail jobDetail = new JobDetail(string, string2, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl.CollectorJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob);
            jobDetail.setDurability(true);
            scheduler.addJob(jobDetail, true);
            scheduler.triggerJob(string, string2);
        }
        catch (LocalizableException localizableException) {
            LocalizableException localizableException2 = new LocalizableException("samqfsJobScheduleFailed", (Throwable)localizableException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException2;
        }
        catch (SchedulerException schedulerException) {
            logger.log(Level.SEVERE, "Scheduler exception: ", schedulerException);
            LocalizableException localizableException = new LocalizableException("samqfsJobScheduleFailed", (Throwable)schedulerException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        logger.log(Level.FINE, "exiting startSingleCollectionJob");
    }

    private void stopCollecting(boolean bl) throws LocalizableException {
        logger.log(Level.FINE, "entering stopCollecting");
        try {
            Scheduler scheduler = this.getScheduler();
            logger.log(Level.INFO, "Stopping periodic collection job");
            scheduler.unscheduleJob(this.jobTrigName, this.jobTrigGrp);
            scheduler.deleteJob(this.jobName, this.jobGroup);
            if (bl) {
                logger.log(Level.INFO, "Stopping one-time collection job");
                String string = this.getJobName("OneTime");
                String string2 = this.getGroupName("OneTime");
                scheduler.unscheduleJob(string, string2);
                scheduler.deleteJob(this.jobName, this.jobGroup);
            }
        }
        catch (LocalizableException localizableException) {
            LocalizableException localizableException2 = new LocalizableException("samqfsJobRemoveFailed", (Throwable)localizableException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException2;
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("samqfsJobRemoveFailed", (Throwable)schedulerException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        catch (Error error) {
            LocalizableException localizableException = new LocalizableException("samqfsJobRemoveFailed", (Throwable)error, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        logger.log(Level.FINE, "exiting stopCollecting");
    }

    private String getProperty(String string, String string2) {
        if (this.props == null || this.props.get(string) == null) {
            return string2;
        }
        String string3 = null;
        try {
            string3 = (String)this.props.get(string);
        }
        catch (ClassCastException classCastException) {
            logger.log(Level.SEVERE, "Property class cast exception: ", classCastException);
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setInitialProperties() {
        PersistentObject[] persistentObjectArray;
        block15: {
            this.props.setProperty("pollingInterval", "3600");
            this.props.setProperty("minPollingInterval", "300");
            this.props.setProperty("pollingEnabled", "true");
            this.props.setProperty("host", "localhost");
            this.props.setProperty("port", "31218");
            this.props.setProperty("description", "");
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistentObjectArray = null;
            try {
                Object var6_4;
                try {
                    persistenceManager = PersistenceManager.getInstance();
                    transaction = persistenceManager.getTransaction();
                    persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                }
                catch (PersistenceException persistenceException) {
                    logger.log(Level.SEVERE, "Persistence exception in getting collector properties: ", persistenceException);
                    var6_4 = null;
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                    break block15;
                }
                catch (TransactionException transactionException) {
                    logger.log(Level.SEVERE, "Transaction exception in getting collector properties: ", transactionException);
                    var6_4 = null;
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                    break block15;
                }
                var6_4 = null;
                if (persistenceManager == null) break block15;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                throw throwable;
            }
            persistenceManager.releaseTransaction(transaction);
            persistenceManager = null;
        }
        if (persistentObjectArray != null) {
            SamQfsCollectorBean samQfsCollectorBean = null;
            try {
                samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
            }
            catch (ClassCastException classCastException) {
                logger.log(Level.SEVERE, classCastException.toString(), classCastException);
            }
            if (samQfsCollectorBean != null) {
                int n = samQfsCollectorBean.getPollingInterval();
                this.propSetPollingInterval(Integer.toString(n));
                boolean bl = samQfsCollectorBean.getPollingEnabled();
                this.setPollingEnabled(bl);
                String string = samQfsCollectorBean.getHost();
                if (string == null) {
                    string = "";
                }
                this.props.setProperty("host", string);
                String string2 = samQfsCollectorBean.getPort();
                if (string2 == null) {
                    string2 = "";
                }
                this.props.setProperty("port", string2);
                String string3 = samQfsCollectorBean.getDescription();
                if (string3 == null) {
                    string3 = "";
                }
                this.props.setProperty("description", string3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean persistProperty(String string) throws LocalizableException {
        Transaction transaction;
        PersistenceManager persistenceManager;
        boolean bl;
        block17: {
            boolean bl3;
            block16: {
                boolean bl2;
                block14: {
                    bl = false;
                    persistenceManager = null;
                    transaction = null;
                    PersistentObject[] persistentObjectArray = null;
                    try {
                        try {
                            SamQfsCollectorBean samQfsCollectorBean;
                            block15: {
                                persistenceManager = PersistenceManager.getInstance();
                                transaction = persistenceManager.getTransaction();
                                transaction.begin();
                                persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                                if (persistentObjectArray == null) {
                                    logger.log(Level.SEVERE, "No database record exists for " + (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean).getClass().getName());
                                    bl2 = false;
                                    Object var9_10 = null;
                                    if (persistenceManager == null) return bl2;
                                    break block14;
                                }
                                samQfsCollectorBean = null;
                                try {
                                    samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
                                    if (string.equals("pollingEnabled")) {
                                        samQfsCollectorBean.setPollingEnabled(this.pollingEnabled());
                                        break block15;
                                    }
                                    if (string.equals("pollingInterval")) {
                                        samQfsCollectorBean.setPollingInterval(this.propGetPollingInterval());
                                        break block15;
                                    }
                                    if (string.equals("host")) {
                                        samQfsCollectorBean.setHost(this.getProperty("host", "localhost"));
                                        break block15;
                                    }
                                    if (string.equals("port")) {
                                        samQfsCollectorBean.setPort(this.getProperty("port", "31218"));
                                        break block15;
                                    }
                                    if (string.equals("description")) {
                                        samQfsCollectorBean.setDescription(this.getProperty("description", ""));
                                        break block15;
                                    }
                                    logger.log(Level.SEVERE, "Unrecognized property name to persist: '" + string + "'");
                                    bl3 = false;
                                    break block16;
                                }
                                catch (ClassCastException classCastException) {
                                    logger.log(Level.SEVERE, classCastException.toString(), classCastException);
                                }
                            }
                            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                            transaction.put((PersistentObject)samQfsCollectorBean);
                            transaction.commit();
                            bl = true;
                            break block17;
                        }
                        catch (PersistenceException persistenceException) {
                            LocalizableException localizableException = new LocalizableException("fsmgrPersistPropertyFailed", (Throwable)persistenceException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
                            throw localizableException;
                        }
                        catch (TransactionException transactionException) {
                            LocalizableException localizableException = new LocalizableException("fsmgrPersistPropertyFailed", (Throwable)transactionException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
                            throw localizableException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        throw throwable;
                    }
                }
                persistenceManager.releaseTransaction(transaction);
                return bl2;
            }
            Object var9_11 = null;
            if (persistenceManager == null) return bl3;
            persistenceManager.releaseTransaction(transaction);
            return bl3;
        }
        Object var9_12 = null;
        if (persistenceManager == null) return bl;
        persistenceManager.releaseTransaction(transaction);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean persistHost(String string, String string2) throws LocalizableException {
        Transaction transaction;
        PersistenceManager persistenceManager;
        boolean bl;
        block12: {
            boolean bl2;
            block11: {
                bl = false;
                persistenceManager = null;
                transaction = null;
                PersistentObject[] persistentObjectArray = null;
                try {
                    try {
                        persistenceManager = PersistenceManager.getInstance();
                        transaction = persistenceManager.getTransaction();
                        transaction.begin();
                        persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                        if (persistentObjectArray == null) {
                            logger.log(Level.SEVERE, "No database record exists for " + (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean).getClass().getName());
                            bl2 = false;
                            Object var10_11 = null;
                            if (persistenceManager == null) return bl2;
                            break block11;
                        }
                        SamQfsCollectorBean samQfsCollectorBean = null;
                        try {
                            samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
                            samQfsCollectorBean.setHost(this.getProperty("host", "localhost"));
                            if (!string.equalsIgnoreCase(string2)) {
                                samQfsCollectorBean.setLastCollectJobDate(0L);
                                samQfsCollectorBean.setLastContentUpdateDate(0L);
                            }
                        }
                        catch (ClassCastException classCastException) {
                            logger.log(Level.SEVERE, classCastException.toString(), classCastException);
                        }
                        transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                        transaction.put((PersistentObject)samQfsCollectorBean);
                        if (!string.equalsIgnoreCase(string2)) {
                            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsFileSystemBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean);
                            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean = SamQfsCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsHostBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean);
                        }
                        transaction.commit();
                        bl = true;
                        break block12;
                    }
                    catch (PersistenceException persistenceException) {
                        LocalizableException localizableException = new LocalizableException("fsmgrPersistPropertyFailed", (Throwable)persistenceException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
                        throw localizableException;
                    }
                    catch (TransactionException transactionException) {
                        LocalizableException localizableException = new LocalizableException("fsmgrPersistPropertyFailed", (Throwable)transactionException, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
                        throw localizableException;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                    throw throwable;
                }
            }
            persistenceManager.releaseTransaction(transaction);
            return bl2;
        }
        Object var10_12 = null;
        if (persistenceManager == null) return bl;
        persistenceManager.releaseTransaction(transaction);
        return bl;
    }

    private boolean pollingEnabled() {
        String string = this.getProperty("pollingEnabled", "true");
        return new Boolean(string);
    }

    private void setPollingEnabled(boolean bl) {
        this.props.setProperty("pollingEnabled", Boolean.toString(bl));
    }

    private int propGetPollingInterval() {
        String string = this.getProperty("pollingInterval", "3600");
        return Integer.parseInt(string);
    }

    private boolean propSetPollingInterval(String string) {
        boolean bl = true;
        int n = -1;
        int n2 = Integer.parseInt("300");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < n2) {
            bl = false;
            LocalizableException localizableException = new LocalizableException("samqfsPollingIntervalInvalid", "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            logger.logp(Level.WARNING, CLASS_NAME, "setPollingInterval", localizableException.getLocalizedMessage(), localizableException);
            bl = false;
        } else {
            this.props.setProperty("pollingInterval", Integer.toString(n));
        }
        return bl;
    }

    private String getJobName(String string) {
        return "SamQfs_Job_" + string + "_" + "ContentUpdate";
    }

    private String getJobTriggerName(String string) {
        return "SamQfs_JobTrig_" + string + "_" + "ContentUpdate";
    }

    private String getGroupName(String string) {
        return "SamQfs_Grp_" + string + "_" + "ContentUpdate";
    }

    private String getGroupTriggerName(String string) {
        return "SamQfs_GrpTrig_" + string + "_" + "ContentUpdate";
    }

    public boolean isPollingEnabled() throws LocalizableException, IOException {
        String string = this.getProperty("pollingEnabled", "true");
        return new Boolean(string);
    }

    public int getPollingInterval() throws LocalizableException, IOException {
        String string = this.getProperty("pollingInterval", "3600");
        return Integer.parseInt(string);
    }

    public void setPollingInterval(int n) throws LocalizableException, IOException {
        int n2 = -1;
        int n3 = Integer.parseInt("300");
        if (n < n3) {
            LocalizableException localizableException = new LocalizableException("samqfsPollingIntervalInvalid", "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            logger.logp(Level.WARNING, CLASS_NAME, "setPollingInterval", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        try {
            int n4 = this.propGetPollingInterval();
            this.propSetPollingInterval(String.valueOf(n));
            this.persistProperty("pollingInterval");
            if (n4 != this.propGetPollingInterval()) {
                this.schedulerChanges(this.pollingEnabled());
            }
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.WARNING, CLASS_NAME, "setPollingInterval", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
    }

    public String getHost() throws LocalizableException, IOException {
        return this.props.getProperty("host", "localhost");
    }

    public void setHost(String string) throws LocalizableException, IOException {
        boolean bl = false;
        if (string == null) {
            LocalizableIllegalArgumentException localizableIllegalArgumentException = new LocalizableIllegalArgumentException();
            logger.log(Level.WARNING, "The SAM-QFS content provider host can not be null.", (Throwable)localizableIllegalArgumentException);
            throw localizableIllegalArgumentException;
        }
        try {
            string = string.trim();
            String string2 = this.props.getProperty("host", "localhost");
            this.props.setProperty("host", string);
            if (!string.equalsIgnoreCase(string2)) {
                this.stopCollecting(true);
                bl = true;
            }
            this.persistHost(string2, string);
            if (bl) {
                this.schedulerChanges(false);
            }
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setHost", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setHost", "Unexpected exception", exception);
            LocalizableException localizableException = new LocalizableException("fsmgrPersistPropertyFailed", "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            throw localizableException;
        }
        catch (Error error) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setHost", "Unexpected error", error);
        }
    }

    public String getPort() throws LocalizableException, IOException {
        return this.props.getProperty("port", "31218");
    }

    public void setPort(String string) throws LocalizableException, IOException {
        if (string == null) {
            LocalizableIllegalArgumentException localizableIllegalArgumentException = new LocalizableIllegalArgumentException();
            logger.log(Level.WARNING, "The SAM-QFS content provider port can not be null.", (Throwable)localizableIllegalArgumentException);
            throw localizableIllegalArgumentException;
        }
        string = string.trim();
        try {
            String string2 = this.props.getProperty("port", "31218");
            boolean bl = false;
            if (!string2.equalsIgnoreCase(string)) {
                this.stopCollecting(true);
                bl = true;
            }
            this.props.setProperty("port", string);
            this.persistProperty("port");
            if (bl) {
                this.schedulerChanges(false);
            }
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setPort", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
    }

    public String getDefaultPort() throws LocalizableException, IOException {
        return "31218";
    }

    public int getDefaultPollingInterval() throws LocalizableException, IOException {
        return Integer.parseInt("3600");
    }

    public int getMinPollingInterval() throws LocalizableException, IOException {
        return Integer.parseInt("300");
    }

    public String getDescription() throws LocalizableException, IOException {
        return this.props.getProperty("description", "");
    }

    public void setDescription(String string) throws LocalizableException, IOException {
        String string2 = this.props.getProperty("description", "");
        if (string == null) {
            string = "";
        } else if ((string = string.trim()).length() > 256) {
            string = string.substring(0, 256);
            logger.logp(Level.WARNING, CLASS_NAME, "setDescription", "The description was truncated because the value entered exceeded the maximum length");
        }
        try {
            this.props.setProperty("description", string);
            this.persistProperty("description");
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.SEVERE, CLASS_NAME, "setDescription", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            this.props.setProperty("description", string2);
            throw localizableException;
        }
    }

    public void refresh() throws LocalizableException, IOException {
        try {
            this.startSingleCollectionJob();
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.SEVERE, CLASS_NAME, "refresh", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Error error) {
            LocalizableException localizableException = new LocalizableException("samqfsJobScheduleFailed", (Throwable)error, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
            logger.logp(Level.SEVERE, CLASS_NAME, "refresh", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
    }

    public void disablePolling() throws LocalizableException, IOException {
        boolean bl = this.pollingEnabled();
        try {
            this.props.setProperty("pollingEnabled", Boolean.toString(false));
            this.persistProperty("pollingEnabled");
            if (bl) {
                this.stopCollecting(false);
            }
        }
        catch (LocalizableException localizableException) {
            logger.log(Level.SEVERE, localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
    }

    public void enablePolling() throws LocalizableException, IOException {
        boolean bl = this.pollingEnabled();
        try {
            this.props.setProperty("pollingEnabled", Boolean.toString(true));
            this.persistProperty("pollingEnabled");
            if (!bl) {
                this.startCollecting();
            }
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.SEVERE, CLASS_NAME, "enablePolling", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
    }

    public String getRevision() throws LocalizableException, IOException {
        return revision;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

