/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl.SamQfsParserHostBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsFileSystemBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.digester.Digester;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.xml.sax.SAXException;

public class CollectorJob
implements Job {
    private static Logger logger = Logger.getLogger("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs");
    private static boolean collectorConfigured = false;
    private static boolean configureErrorPrinted = false;
    private static final String sccs_id = "@(#)CollectorJob.java\t1.14 05/10/13";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$SamQfsParserHostBean;

    public static void main(String[] stringArray) {
        CollectorJob collectorJob = new CollectorJob();
        collectorJob.executeCollectorJob();
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.executeCollectorJob();
    }

    private void executeCollectorJob() {
        this.collect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void clearDatabase() {
        block23: {
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            logger.log(Level.FINER, "Entering clearDatabase()");
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsFileSystemBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean);
            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsHostBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean);
            transaction.commit();
            Object var6_3 = null;
            try {
                if (persistenceManager != null && transaction != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block23;
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failure to release transaction: ", exception);
            }
            break block23;
            {
                catch (PersistenceException persistenceException) {
                    logger.log(Level.SEVERE, "Persistence Exception: ", persistenceException);
                    try {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                    }
                    catch (PersistenceException persistenceException2) {
                        logger.log(Level.SEVERE, "Persistence Exception: ", persistenceException2);
                    }
                    Object var6_4 = null;
                    try {
                        if (persistenceManager != null && transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Failure to release transaction: ", exception);
                    }
                    break block23;
                }
                catch (TransactionException transactionException) {
                    logger.log(Level.SEVERE, "Transaction Exception: ", transactionException);
                    try {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                    }
                    catch (PersistenceException persistenceException) {
                        logger.log(Level.SEVERE, "Persistence Exception: ", persistenceException);
                    }
                    Object var6_5 = null;
                    try {
                        if (persistenceManager != null && transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Failure to release transaction: ", exception);
                    }
                    break block23;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Unexpected exception: ", exception);
                    Object var6_6 = null;
                    try {
                        if (persistenceManager != null && transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block23;
                    }
                    catch (Exception exception2) {
                        logger.log(Level.SEVERE, "Failure to release transaction: ", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (persistenceManager != null && transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Failure to release transaction: ", exception);
                }
                throw throwable;
            }
        }
        logger.log(Level.FINER, "Exiting clearDatabase()");
    }

    public void collect() {
        logger.log(Level.INFO, "File System data collection running.");
        try {
            String string = this.getConnectionURL();
            if (string != null && !string.equals("")) {
                SamQfsManagerData samQfsManagerData = this.getData(string);
                this.writeToDB(samQfsManagerData);
                if (samQfsManagerData != null) {
                    configureErrorPrinted = false;
                    collectorConfigured = true;
                }
            }
        }
        catch (Error error) {
            logger.log(Level.SEVERE, "Unexpected error executing SAM-QFS data collection job", error);
            throw error;
        }
        logger.log(Level.FINE, "Exiting collect()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConnectionURL() {
        String string;
        block13: {
            block12: {
                String string2;
                PersistentObject[] persistentObjectArray;
                block11: {
                    logger.log(Level.FINE, "Entering getConnectionURL");
                    string = "";
                    PersistenceManager persistenceManager = null;
                    Transaction transaction = null;
                    persistentObjectArray = null;
                    try {
                        try {
                            persistenceManager = PersistenceManager.getInstance();
                            transaction = persistenceManager.getTransaction();
                            persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                        }
                        catch (PersistenceException persistenceException) {
                            logger.log(Level.SEVERE, "Persistence exception in getting collector properties: ", persistenceException);
                            persistentObjectArray = null;
                            string2 = null;
                            if (persistenceManager != null) {
                                persistenceManager.releaseTransaction(transaction);
                                persistenceManager = null;
                            }
                            break block11;
                        }
                        catch (TransactionException transactionException) {
                            logger.log(Level.SEVERE, "Transaction exception in getting collector properties: ", transactionException);
                            persistentObjectArray = null;
                            string2 = null;
                            if (persistenceManager != null) {
                                persistenceManager.releaseTransaction(transaction);
                                persistenceManager = null;
                            }
                            break block11;
                        }
                        string2 = null;
                        if (persistenceManager == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        throw throwable;
                    }
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                if (persistentObjectArray == null || persistentObjectArray.length <= 0) break block12;
                SamQfsCollectorBean samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
                String string3 = samQfsCollectorBean.getPort();
                string2 = samQfsCollectorBean.getHost();
                if (string3 == null || string3.equals("") || string2 == null || string2.equals("")) {
                    collectorConfigured = false;
                    if (!configureErrorPrinted) {
                        logger.log(Level.INFO, "The File System Information Source is not configured correctly. The host and port must not be null. No file system data will be collected. This error message will only be printed once.");
                        configureErrorPrinted = true;
                    }
                    break block13;
                } else {
                    string = "http://" + string2 + ":" + string3 + "/fsmgra";
                }
                break block13;
            }
            logger.log(Level.SEVERE, "Unable to get collector configuration data from database");
        }
        logger.log(Level.FINE, "Exiting getConnectionURL");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SamQfsManagerData getData(String string) {
        URL uRL = null;
        InputStream inputStream = null;
        SamQfsManagerData samQfsManagerData = null;
        long l = 0L;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        l = date.getTime();
        this.updateDataCollectTime(l, 0L, false);
        logger.log(Level.FINE, "\nUsing URL: " + string + "\n");
        uRL = new URL(string);
        inputStream = uRL.openStream();
        logger.log(Level.FINE, "Parsing with DB classes");
        samQfsManagerData = this.parseXmlData(inputStream);
        Object var10_11 = null;
        if (inputStream == null) return samQfsManagerData;
        try {
            inputStream.close();
            return samQfsManagerData;
        }
        catch (Exception exception) {}
        return samQfsManagerData;
        {
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.SEVERE, "Invalid File System Manager Agent URL: " + string, malformedURLException);
                Object var10_12 = null;
                if (inputStream == null) return samQfsManagerData;
                try {
                    inputStream.close();
                    return samQfsManagerData;
                }
                catch (Exception exception) {}
                return samQfsManagerData;
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{string};
                LocalizableException localizableException = new LocalizableException("samqfsContentProviderNotReachable", (Throwable)iOException, (Serializable[])stringArray, "com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.api.Localization");
                logger.log(Level.SEVERE, localizableException.getLocalizedMessage(), iOException);
                Object var10_13 = null;
                if (inputStream == null) return samQfsManagerData;
                try {
                    inputStream.close();
                    return samQfsManagerData;
                }
                catch (Exception exception) {}
                return samQfsManagerData;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeToDB(SamQfsManagerData samQfsManagerData) {
        block14: {
            Transaction transaction;
            PersistenceManager persistenceManager;
            block13: {
                Date date;
                ArrayList arrayList = new ArrayList();
                persistenceManager = null;
                transaction = null;
                persistenceManager = PersistenceManager.getInstance();
                transaction = persistenceManager.getTransaction();
                transaction.begin();
                if (samQfsManagerData == null) break block13;
                transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsFileSystemBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean);
                transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsHostBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsHostBean);
                Iterator iterator = samQfsManagerData.getHostIterator();
                while (iterator.hasNext()) {
                    SamQfsParserHostBean samQfsParserHostBean = (SamQfsParserHostBean)((Object)iterator.next());
                    logger.log(Level.FINE, "Writing to DB Host: " + samQfsParserHostBean.getName());
                    transaction.put((PersistentObject)samQfsParserHostBean);
                    arrayList = samQfsParserHostBean.getFilesystems();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        date = (SamQfsFileSystemBean)arrayList.get(i);
                        logger.log(Level.FINER, "Writing to db FileSystem: " + date.getName() + "   Host Name: " + date.getSamHost().getName() + "    Capacity: " + date.getCapacity() + "    Usage:" + date.getUtilization());
                        transaction.put((PersistentObject)date);
                    }
                }
                transaction.commit();
                long l = 0L;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                date = gregorianCalendar.getTime();
                l = date.getTime();
                this.updateDataCollectTime(0L, l, false);
            }
            Object var10_12 = null;
            try {
                if (persistenceManager != null && transaction != null) {
                    transaction.rollback();
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                    transaction = null;
                }
                break block14;
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failure to release transaction: " + exception);
            }
            break block14;
            {
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Failure to insert data: ", exception);
                    Object var10_13 = null;
                    try {
                        if (persistenceManager != null && transaction != null) {
                            transaction.rollback();
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                            transaction = null;
                        }
                        break block14;
                    }
                    catch (Exception exception2) {
                        logger.log(Level.SEVERE, "Failure to release transaction: " + exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (persistenceManager != null && transaction != null) {
                        transaction.rollback();
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                        transaction = null;
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Failure to release transaction: " + exception);
                }
                throw throwable;
            }
        }
    }

    private SamQfsManagerData parseXmlData(InputStream inputStream) {
        logger.log(Level.FINE, "Entering parseXmlData");
        Digester digester = null;
        try {
            digester = new Digester();
            if (digester == null) {
                logger.log(Level.SEVERE, "Null Digester");
                return null;
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error creating Digester: " + exception);
            return null;
        }
        logger.log(Level.FINE, "Created new Digester");
        TreeMap treeMap = new TreeMap();
        logger.log(Level.FINE, "Created new TreeMap");
        SamQfsManagerData samQfsManagerData = new SamQfsManagerData(treeMap);
        if (samQfsManagerData == null) {
            logger.log(Level.SEVERE, "Error Creating SamQfsManagerData");
            return null;
        }
        logger.log(Level.FINE, "Created new SamQfsManagerData");
        digester.push((Object)samQfsManagerData);
        if (logger.isLoggable(Level.FINER)) {
            samQfsManagerData.print();
        }
        digester.addObjectCreate("FileSystemManagerData/Host", class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$SamQfsParserHostBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$SamQfsParserHostBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl.SamQfsParserHostBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$SamQfsParserHostBean);
        digester.addSetProperties("FileSystemManagerData/Host");
        digester.addSetNext("FileSystemManagerData/Host", "addHost");
        digester.addObjectCreate("FileSystemManagerData/Host/Filesystem", class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsFileSystemBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsFileSystemBean);
        digester.addSetProperties("FileSystemManagerData/Host/Filesystem");
        digester.addSetNext("FileSystemManagerData/Host/Filesystem", "addFilesystem");
        try {
            logger.log(Level.FINE, "Parsing SAM-QFS XML data  ");
            digester.parse(inputStream);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error reading input stream:", iOException);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Error parsing input stream:", sAXException);
        }
        return samQfsManagerData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDataCollectTime(long l, long l2, boolean bl) {
        block12: {
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            PersistentObject[] persistentObjectArray = null;
            SamQfsCollectorBean samQfsCollectorBean = null;
            try {
                block11: {
                    try {
                        persistenceManager = PersistenceManager.getInstance();
                        transaction = persistenceManager.getTransaction();
                        persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                        if (persistentObjectArray == null) break block11;
                        try {
                            samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
                        }
                        catch (ClassCastException classCastException) {
                            logger.log(Level.SEVERE, classCastException.toString(), classCastException);
                        }
                        if (samQfsCollectorBean != null) {
                            if (l != 0L || bl) {
                                samQfsCollectorBean.setLastCollectJobDate(l);
                            }
                            if (l2 != 0L || bl) {
                                samQfsCollectorBean.setLastContentUpdateDate(l2);
                            }
                            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = CollectorJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                            samQfsCollectorBean.put(transaction);
                            transaction.commit();
                        }
                    }
                    catch (PersistenceException persistenceException) {
                        logger.log(Level.SEVERE, "Persistence exception in getting collector properties: ", persistenceException);
                        Object var12_12 = null;
                        if (persistenceManager == null) return;
                        persistenceManager.releaseTransaction(transaction);
                        return;
                    }
                    catch (TransactionException transactionException) {
                        logger.log(Level.SEVERE, "Transaction exception in getting collector properties: ", transactionException);
                        Object var12_13 = null;
                        if (persistenceManager == null) return;
                        persistenceManager.releaseTransaction(transaction);
                        return;
                    }
                }
                Object var12_11 = null;
                if (persistenceManager == null) break block12;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                    transaction = null;
                    samQfsCollectorBean = null;
                    persistentObjectArray = null;
                }
                throw throwable;
            }
            persistenceManager.releaseTransaction(transaction);
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SamQfsManagerData {
        TreeMap hosts = null;

        SamQfsManagerData(TreeMap treeMap) {
            this.hosts = treeMap;
        }

        public void addHost(SamQfsParserHostBean samQfsParserHostBean) {
            this.hosts.put(samQfsParserHostBean.getName(), samQfsParserHostBean);
        }

        public TreeMap getHostList() {
            return this.hosts;
        }

        public Iterator getHostIterator() {
            return this.hosts.values().iterator();
        }

        public void print() {
            System.out.println("SAM-QFS XML data has " + this.hosts.size() + " hosts");
            Iterator iterator = this.getHostIterator();
            while (iterator.hasNext()) {
                SamQfsParserHostBean samQfsParserHostBean = (SamQfsParserHostBean)((Object)iterator.next());
                System.out.println(((Object)((Object)samQfsParserHostBean)).toString());
                ArrayList arrayList = samQfsParserHostBean.getFilesystems();
                for (int i = 0; i < arrayList.size(); ++i) {
                    SamQfsFileSystemBean samQfsFileSystemBean = (SamQfsFileSystemBean)arrayList.get(i);
                    System.out.println("FileSystem: " + samQfsFileSystemBean.toString());
                }
            }
            System.out.println("End of SAM-QFS XML data listing");
        }
    }
}

