/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl;

import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class Collector
extends StandardMBean {
    private Properties props = new Properties();
    private static Logger logger = Logger.getLogger("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs");
    private Scheduler sched = null;
    private String jobName = "SamQfs_Job";
    private String jobGroup = "SamQfs_Job";
    private String jobTrigName = "SamQfs_Job";
    private String jobTrigGrp = "SamQfs_Job";
    private static final String sccs_id = "@(#)Collector.java\t1.12 05/01/21";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean;

    public Collector(Class clazz) throws NotCompliantMBeanException, LocalizableIllegalArgumentException {
        super(clazz);
        this.setInitialProperties();
    }

    public MBeanInfo getMBeanInfo() {
        return super.getMBeanInfo();
    }

    public void start() {
        try {
            if (this.sched == null) {
                this.startScheduler();
                if (this.isPollingEnabled()) {
                    this.startCollecting();
                }
            }
        }
        catch (SchedulerException schedulerException) {
            logger.log(Level.SEVERE, "Scheduler exception: ", schedulerException);
        }
    }

    public void stop() {
        this.stopCollecting();
        try {
            PersistenceManager.release();
            if (this.sched != null) {
                this.stopScheduler();
            }
        }
        catch (PersistenceException persistenceException) {
            logger.log(Level.WARNING, "Persistence exception while releasing Manager connection pool: ", persistenceException);
        }
        catch (SchedulerException schedulerException) {
            logger.log(Level.SEVERE, "Scheduler exception: ", schedulerException);
        }
        logger.log(Level.INFO, "Scheduler stopped..");
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation");
        }
        if (!string.equalsIgnoreCase("refresh")) {
            throw new ReflectionException(new NoSuchMethodException(string), "Unrecognized operation: " + string);
        }
        this.startSingleCollectionJob();
        return null;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (this.props == null) {
            throw new AttributeNotFoundException("No properties are currently defined");
        }
        Object object = this.props.get(string);
        if (object == null) {
            throw new AttributeNotFoundException("Property not found: " + object);
        }
        return object;
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        if (stringArray == null) {
            logger.log(Level.SEVERE, "Null list of attribute names specified");
            return attributeList;
        }
        if (stringArray.length == 0) {
            logger.log(Level.SEVERE, "Empty list of attribute names specified");
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                Attribute attribute = new Attribute(stringArray[i], object);
                attributeList.add(attribute);
                continue;
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failure to get attribute: ", exception);
            }
        }
        return attributeList;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        String string = attribute.getName();
        String string2 = attribute.getValue().toString();
        boolean bl = false;
        boolean bl2 = this.isPollingEnabled();
        boolean bl3 = this.isPollingEnabled();
        if (string.equalsIgnoreCase("pollingEnabled")) {
            this.setPollingEnabled(string2);
            bl3 = this.isPollingEnabled();
            bl = true;
            this.persistProperty("pollingEnabled");
        } else if (string.equalsIgnoreCase("pollingInterval")) {
            long l = this.getPollingInterval();
            if (this.setPollingInterval(string2)) {
                if (l != this.getPollingInterval()) {
                    bl = true;
                }
                this.persistProperty("pollingInterval");
            }
        } else if (string.equalsIgnoreCase("host")) {
            this.setHost(string2);
        } else if (string.equalsIgnoreCase("port")) {
            this.setPort(string2);
        } else {
            throw new AttributeNotFoundException("Attribute not found: " + string);
        }
        if (bl) {
            if (bl2 && !bl3) {
                this.stopCollecting();
            } else if (bl3 && !bl2) {
                this.startCollecting();
            } else if (bl3 && bl2) {
                this.stopCollecting();
                this.startCollecting();
            }
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        if (attributeList == null) {
            logger.log(Level.SEVERE, "Null AttributeList specified");
            return attributeList2;
        }
        if (attributeList.isEmpty()) {
            logger.log(Level.SEVERE, "Empty AttributeList specified");
            return attributeList2;
        }
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            try {
                this.setAttribute(attribute);
                String string = attribute.getName();
                Object object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failure to set attribute: ", exception);
            }
        }
        return attributeList2;
    }

    private void startScheduler() throws SchedulerException {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        this.sched = stdSchedulerFactory.getScheduler();
        this.sched.start();
        logger.log(Level.INFO, "Scheduler started.");
    }

    private void stopScheduler() throws SchedulerException {
        this.sched.shutdown();
        this.sched = null;
        logger.log(Level.INFO, "Scheduler stopped.");
    }

    private void startCollecting() {
        try {
            if (this.sched == null) {
                this.startScheduler();
            }
            JobDetail jobDetail = new JobDetail(this.jobName, this.jobGroup, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob = Collector.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl.CollectorJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob);
            long l = this.getPollingInterval();
            Date date = Calendar.getInstance().getTime();
            long l2 = date.getTime() + 10000L;
            Date date2 = new Date(l2);
            SimpleTrigger simpleTrigger = new SimpleTrigger(this.jobTrigName, this.jobTrigGrp, this.jobName, this.jobGroup, date2, null, SimpleTrigger.REPEAT_INDEFINITELY, 1000L * l);
            this.sched.scheduleJob(jobDetail, (Trigger)simpleTrigger);
            logger.log(Level.INFO, "Job has been scheduled with a polling interval of " + l + " seconds");
            logger.log(Level.FINE, "First time trigger: " + DateFormat.getDateTimeInstance().format(date2));
            Date date3 = simpleTrigger.getNextFireTime();
            logger.log(Level.FINE, "Next time trigger: " + DateFormat.getDateTimeInstance().format(date3));
        }
        catch (SchedulerException schedulerException) {
            logger.log(Level.SEVERE, "Scheduler exception: ", schedulerException);
        }
    }

    private void startSingleCollectionJob() {
        try {
            logger.log(Level.FINE, "entering startSingleCollectionJob");
            JobDetail jobDetail = new JobDetail("onetime", "onetimeGroup", class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob = Collector.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.samqfs.impl.CollectorJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$samqfs$impl$CollectorJob);
            jobDetail.setDurability(true);
            this.sched.addJob(jobDetail, true);
            this.sched.triggerJob("onetime", "onetimeGroup");
            logger.log(Level.FINE, "exiting startSingleCollectionJob");
        }
        catch (SchedulerException schedulerException) {
            logger.log(Level.SEVERE, "Scheduler exception: ", schedulerException);
        }
    }

    private void stopCollecting() {
        try {
            if (this.sched != null) {
                this.sched.unscheduleJob(this.jobTrigName, this.jobGroup);
            }
        }
        catch (SchedulerException schedulerException) {
            logger.log(Level.SEVERE, "Scheduler exception: ", schedulerException);
        }
    }

    public String getProperty(String string, String string2) {
        if (this.props == null || this.props.get(string) == null) {
            return string2;
        }
        String string3 = null;
        try {
            string3 = (String)this.props.get(string);
        }
        catch (ClassCastException classCastException) {
            logger.log(Level.SEVERE, "Property class cast exception: ", classCastException);
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setInitialProperties() {
        PersistentObject[] persistentObjectArray;
        block14: {
            this.props.setProperty("pollingInterval", "3600");
            this.props.setProperty("minPollingInterval", "300");
            this.props.setProperty("pollingEnabled", "true");
            this.props.setProperty("host", "localhost");
            this.props.setProperty("port", "31218");
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistentObjectArray = null;
            try {
                Object var6_4;
                try {
                    persistenceManager = PersistenceManager.getInstance();
                    transaction = persistenceManager.getTransaction();
                    persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = Collector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                }
                catch (PersistenceException persistenceException) {
                    logger.log(Level.SEVERE, "Persistence exception in getting collector properties: ", persistenceException);
                    var6_4 = null;
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                    break block14;
                }
                catch (TransactionException transactionException) {
                    logger.log(Level.SEVERE, "Transaction exception in getting collector properties: ", transactionException);
                    var6_4 = null;
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                    break block14;
                }
                var6_4 = null;
                if (persistenceManager == null) break block14;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                throw throwable;
            }
            persistenceManager.releaseTransaction(transaction);
            persistenceManager = null;
        }
        if (persistentObjectArray != null) {
            SamQfsCollectorBean samQfsCollectorBean = null;
            try {
                samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
            }
            catch (ClassCastException classCastException) {
                logger.log(Level.SEVERE, classCastException.toString(), classCastException);
            }
            if (samQfsCollectorBean != null) {
                int n = samQfsCollectorBean.getPollingInterval();
                this.setPollingInterval(Integer.toString(n));
                boolean bl = samQfsCollectorBean.getPollingEnabled();
                this.setPollingEnabled(Boolean.toString(bl));
                String string = samQfsCollectorBean.getHost();
                if (string == null) {
                    string = "";
                }
                this.setHost(string);
                String string2 = samQfsCollectorBean.getPort();
                if (string2 == null) {
                    string2 = "";
                }
                this.setPort(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean persistProperty(String string) {
        Transaction transaction;
        PersistenceManager persistenceManager;
        boolean bl;
        block14: {
            boolean bl3;
            block13: {
                boolean bl2;
                block11: {
                    bl = false;
                    persistenceManager = null;
                    transaction = null;
                    PersistentObject[] persistentObjectArray = null;
                    try {
                        try {
                            SamQfsCollectorBean samQfsCollectorBean;
                            block12: {
                                persistenceManager = PersistenceManager.getInstance();
                                transaction = persistenceManager.getTransaction();
                                transaction.begin();
                                persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = Collector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                                if (persistentObjectArray == null) {
                                    logger.log(Level.SEVERE, "No database record exists for " + (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = Collector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean).getClass().getName());
                                    bl2 = false;
                                    Object var9_10 = null;
                                    if (persistenceManager == null) return bl2;
                                    break block11;
                                }
                                samQfsCollectorBean = null;
                                try {
                                    samQfsCollectorBean = (SamQfsCollectorBean)persistentObjectArray[0];
                                    if (string.equals("pollingEnabled")) {
                                        samQfsCollectorBean.setPollingEnabled(this.isPollingEnabled());
                                        break block12;
                                    }
                                    if (string.equals("pollingInterval")) {
                                        samQfsCollectorBean.setPollingInterval((int)this.getPollingInterval());
                                        break block12;
                                    }
                                    logger.log(Level.SEVERE, "Unrecognized property name to persist: '" + string + "'");
                                    bl3 = false;
                                    break block13;
                                }
                                catch (ClassCastException classCastException) {
                                    logger.log(Level.SEVERE, classCastException.toString(), classCastException);
                                }
                            }
                            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean = Collector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.SamQfsCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$SamQfsCollectorBean);
                            transaction.put((PersistentObject)samQfsCollectorBean);
                            transaction.commit();
                            bl = true;
                            break block14;
                        }
                        catch (PersistenceException persistenceException) {
                            logger.log(Level.SEVERE, "Persistence exception in getting collector bean: ", persistenceException);
                            Object var9_13 = null;
                            if (persistenceManager == null) return bl;
                            persistenceManager.releaseTransaction(transaction);
                            return bl;
                        }
                        catch (TransactionException transactionException) {
                            logger.log(Level.SEVERE, "Transaction exception in getting collector bean: ", transactionException);
                            Object var9_14 = null;
                            if (persistenceManager == null) return bl;
                            persistenceManager.releaseTransaction(transaction);
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        throw throwable;
                    }
                }
                persistenceManager.releaseTransaction(transaction);
                return bl2;
            }
            Object var9_11 = null;
            if (persistenceManager == null) return bl3;
            persistenceManager.releaseTransaction(transaction);
            return bl3;
        }
        Object var9_12 = null;
        if (persistenceManager == null) return bl;
        persistenceManager.releaseTransaction(transaction);
        return bl;
    }

    private boolean isPollingEnabled() {
        String string = this.getProperty("pollingEnabled", "true");
        return new Boolean(string);
    }

    private void setPollingEnabled(String string) {
        Boolean bl = new Boolean(string);
        this.props.setProperty("pollingEnabled", bl.toString());
    }

    private long getPollingInterval() {
        String string = this.getProperty("pollingInterval", "3600");
        return Long.parseLong(string);
    }

    private boolean setPollingInterval(String string) {
        boolean bl = true;
        int n = -1;
        int n2 = Integer.parseInt("300");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < n2) {
            logger.log(Level.SEVERE, "Polling interval not changed because the requested polling interval is invalid: " + string);
            bl = false;
        } else {
            this.props.setProperty("pollingInterval", Integer.toString(n));
        }
        return bl;
    }

    private String getHost() {
        return this.props.getProperty("host", "localhost");
    }

    private void setHost(String string) {
        this.props.setProperty("host", string);
    }

    private String getPort() {
        return this.props.getProperty("port", "31218");
    }

    private void setPort(String string) {
        this.props.setProperty("port", string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

