/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util;

import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.ChannelUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.FeedCleaner;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.common.impl.RssEnvironmental;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import de.nava.informa.utils.poller.PollerObserverIF;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PollerPersistenceObserver
implements PollerObserverIF {
    private PersistenceManagerIF _manager;
    private FeedCleaner _cleaner = null;
    private ChannelUtil _util = null;
    private RssEnvironmental _rssEnv = null;
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl = PollerPersistenceObserver.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl).getName());
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$PollerPersistenceObserver == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$PollerPersistenceObserver = PollerPersistenceObserver.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.PollerPersistenceObserver")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$PollerPersistenceObserver).getName();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$PollerPersistenceObserver;

    public PollerPersistenceObserver(PersistenceManagerIF persistenceManagerIF, ChannelUtil channelUtil, FeedCleaner feedCleaner, RssEnvironmental rssEnvironmental) {
        if (persistenceManagerIF == null) {
            throw new IllegalArgumentException("Manager should be specified.");
        }
        if (channelUtil == null) {
            throw new IllegalArgumentException("ChannelUtil should be specified.");
        }
        this._manager = persistenceManagerIF;
        this._cleaner = feedCleaner;
        this._util = channelUtil;
        this._rssEnv = rssEnvironmental;
    }

    public final void itemFound(ItemIF itemIF, ChannelIF channelIF) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "itemFound");
        }
        try {
            Date date = this._rssEnv.getCurrentDate();
            if (null == itemIF.getDate()) {
                itemIF.setDate(date);
            }
            this._manager.createItem(channelIF, itemIF);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "itemFound", "itemFound PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
        }
        catch (Exception exception) {
            logger.logp(Level.INFO, CLAZZ, "itemFound", "itemFound Exception: " + exception.getLocalizedMessage(), exception);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "itemFound");
        }
    }

    public void channelErrored(ChannelIF channelIF, Exception exception) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "channelErrored");
        }
        if (exception instanceof UnknownHostException) {
            logger.logp(Level.INFO, CLAZZ, "channelErrored", "Could not connect to: " + channelIF.getLocation().toString());
        } else {
            logger.logp(Level.INFO, CLAZZ, "channelErrored", "PersistenceManagerException: channelErrored: " + channelIF.getTitle(), exception);
        }
        this._util.releaseChannelLock(channelIF);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "channelErrored");
        }
    }

    public void channelChanged(ChannelIF channelIF) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "channelChanged");
        }
        try {
            this._manager.updateChannel(channelIF);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "channelChanged", "PersistenceManagerException: channelChanged" + channelIF.getTitle());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "channelChanged");
        }
    }

    public void pollStarted(ChannelIF channelIF) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "pollStarted");
        }
        this._util.aquireChannelLock(channelIF);
        this.processSyndicatedItems(channelIF);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "pollStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollFinished(ChannelIF channelIF) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "pollFinished");
        }
        try {
            this._manager.updateChannel(channelIF);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "pollFinished", "PersistenceManagerException: pollFinished" + channelIF.getTitle());
        }
        finally {
            this._util.releaseChannelLock(channelIF);
        }
        this._cleaner.cleanChannel(channelIF);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "pollFinished");
        }
    }

    private void processSyndicatedItems(ChannelIF channelIF) {
        ChannelIF channelIF2 = null;
        try {
            channelIF2 = FeedParser.parse((ChannelBuilderIF)new ChannelBuilder(), (URL)channelIF.getLocation());
        }
        catch (IOException iOException) {
            this.channelErrored(channelIF, iOException);
        }
        catch (ParseException parseException) {
            this.channelErrored(channelIF, (Exception)((Object)parseException));
        }
        Collection collection = channelIF2.getItems();
        Collection collection2 = channelIF.getItems();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ItemIF itemIF = (ItemIF)iterator.next();
            if (!collection.contains(itemIF)) continue;
            itemIF.setFound(this._rssEnv.getCurrentDate());
            try {
                this._manager.updateItem(itemIF);
            }
            catch (PersistenceManagerException persistenceManagerException) {
                logger.logp(Level.INFO, CLAZZ, "processSyndicatedItems", "PersistenceManagerException: processSyndicatedItems" + channelIF.getTitle());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

