/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util;

import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorConstants;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FeedValidator {
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl = FeedValidator.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl).getName());
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$FeedValidator == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$FeedValidator = FeedValidator.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.FeedValidator")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$FeedValidator).getName();
    private static final int PUSHBACK_BUFFER_SIZE = 4;
    private String proxyPassword = null;
    private String proxyUserID = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    BufferedInputStream bis = null;
    File f;
    String protocol = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$FeedValidator;

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public String getProxyUserID() {
        return this.proxyUserID;
    }

    public void setProxyUserID(String string) {
        this.proxyUserID = string;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public boolean isValid(URL uRL) throws LocalizableException {
        boolean bl = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "isValid");
        }
        try {
            HostConfiguration hostConfiguration;
            Object object;
            this.protocol = uRL.getProtocol();
            if ("file".equals(this.protocol)) {
                this.f = new File(uRL.getFile());
                object = new FileInputStream(this.f);
                this.bis = new BufferedInputStream((InputStream)object);
            } else {
                String string;
                object = new HttpClient();
                hostConfiguration = new HostConfiguration();
                hostConfiguration.setHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
                if (this.getProxyHost() != null && this.getProxyHost().length() > 0 && this.getProxyPort() > -1) {
                    hostConfiguration.setProxy(this.getProxyHost(), this.getProxyPort());
                }
                if (this.getProxyUserID() != null && this.getProxyUserID().length() > 0 || this.getProxyPassword() != null && this.getProxyPassword().length() > 0) {
                    string = new UsernamePasswordCredentials(this.getProxyUserID(), this.getProxyPassword() == null ? "" : this.getProxyPassword());
                    object.getState().setProxyCredentials(AuthScope.ANY, (Credentials)string);
                } else {
                    object.getState().setProxyCredentials(AuthScope.ANY, null);
                }
                if (uRL.getUserInfo() != null) {
                    string = new UsernamePasswordCredentials(uRL.getUserInfo());
                    object.getState().setCredentials(AuthScope.ANY, (Credentials)string);
                }
                string = uRL.toString();
                try {
                    uRL.openConnection();
                }
                catch (RuntimeException runtimeException) {
                    logger.logp(Level.INFO, CLAZZ, "isValid", "Could not open connection to: " + uRL.getHost());
                    LocalizableException localizableException = new LocalizableException("rss.agg.ioError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                    throw new LocalizableException((Throwable)localizableException);
                }
                GetMethod getMethod = null;
                int n = 0;
                HttpResult httpResult = null;
                int n2 = 200;
                boolean bl2 = false;
                do {
                    getMethod = new GetMethod(string);
                    getMethod.setRequestHeader("User-agent", RssAggregatorConstants.getUserAgent());
                    getMethod.setRequestHeader("Accept-Encoding", "gzip");
                    getMethod.setFollowRedirects(false);
                    getMethod.setDoAuthentication(true);
                    hostConfiguration.setHost(new URI(string, false));
                    httpResult = FeedValidator.executeHttpRequest(object, hostConfiguration, (HttpMethod)getMethod);
                    n2 = httpResult.getStatusCode();
                    if (n2 == 301 || n2 == 302 || n2 == 303 || n2 == 307) {
                        bl2 = true;
                        string = httpResult.getLocation();
                        continue;
                    }
                    bl2 = false;
                } while (++n < 5 && bl2);
                if (n2 == 200) {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(new ByteArrayInputStream(httpResult.getResponse()), 4);
                    FeedValidator.skipBOM(pushbackInputStream);
                    this.bis = new BufferedInputStream(pushbackInputStream);
                } else {
                    if (n2 == 407) {
                        logger.logp(Level.INFO, CLAZZ, "isValid", "Proxy authentication required, Status code: " + n2);
                        LocalizableException localizableException = new LocalizableException("rss.agg.proxyAuthenticationRequired", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                        throw new LocalizableException((Throwable)localizableException);
                    }
                    if (n2 == 401) {
                        logger.logp(Level.INFO, CLAZZ, "isValid", "Unauthorized, Status code: " + n2);
                        LocalizableException localizableException = new LocalizableException("rss.agg.unautherized", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                        throw new LocalizableException((Throwable)localizableException);
                    }
                    logger.logp(Level.INFO, CLAZZ, "isValid", "Server error, Status code: " + n2);
                    LocalizableException localizableException = new LocalizableException("rss.agg.ioError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                    throw new LocalizableException((Throwable)localizableException);
                }
            }
            object = new SAXBuilder(false);
            hostConfiguration = object.build((InputStream)this.bis);
            bl = FeedValidator.isParsable((Document)hostConfiguration);
        }
        catch (URIException uRIException) {
            logger.logp(Level.INFO, CLAZZ, "isValid", uRIException.getLocalizedMessage(), uRIException);
            LocalizableException localizableException = new LocalizableException("rss.agg.uriError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        catch (JDOMException jDOMException) {
            logger.logp(Level.INFO, CLAZZ, "isValid", jDOMException.getLocalizedMessage(), jDOMException);
            LocalizableException localizableException = new LocalizableException("rss.agg.parseError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        catch (IOException iOException) {
            logger.logp(Level.INFO, CLAZZ, "isValid", "Could not establish connection to host: " + uRL.getHost());
            if (iOException instanceof UnknownHostException) {
                LocalizableException localizableException = new LocalizableException("rss.agg.unknownHost", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            LocalizableException localizableException = new LocalizableException("rss.agg.ioError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException iOException) {
                logger.logp(Level.INFO, CLAZZ, "isValid", "Closing InputStream: " + iOException.getLocalizedMessage(), iOException);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpResult executeHttpRequest(HttpClient httpClient, HostConfiguration hostConfiguration, HttpMethod httpMethod) throws HttpException, IOException {
        int n = -1;
        try {
            Object object;
            n = httpClient.executeMethod(hostConfiguration, httpMethod);
            HttpResult httpResult = new HttpResult(n);
            Header header = httpMethod.getResponseHeader("location");
            if (header != null) {
                httpResult.setLocation(header.getValue());
            }
            if (n == 200) {
                object = httpMethod.getResponseHeader("Content-Encoding");
                if (object != null && object.getValue().equals("gzip")) {
                    int n2;
                    InputStream inputStream = httpMethod.getResponseBodyAsStream();
                    inputStream = new GZIPInputStream(inputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n2 = inputStream.read(byArray)) > -1) {
                        if (n2 <= 0) continue;
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    inputStream.close();
                    httpResult.setResponse(byteArrayOutputStream.toByteArray());
                } else {
                    httpResult.setResponse(httpMethod.getResponseBody());
                }
            } else {
                object = httpMethod.getResponseBodyAsStream();
                if (object != null) {
                    byte[] byArray = new byte[1024];
                    while (((InputStream)object).read(byArray) != -1) {
                    }
                    ((InputStream)object).close();
                }
            }
            object = httpResult;
            return object;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private static void skipBOM(PushbackInputStream pushbackInputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = pushbackInputStream.read(byArray);
        if (!(byArray[0] == 0 && byArray[1] == 0 && (byArray[2] & 0xFF) == 254 && (byArray[3] & 0xFF) == 255 || (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254 && byArray[2] == 0 && byArray[3] == 0)) {
            if ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                pushbackInputStream.unread(byArray, 2, 2);
            } else if ((byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                pushbackInputStream.unread(byArray, 2, 2);
            } else if ((byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191) {
                pushbackInputStream.unread(byArray, 3, 1);
            } else {
                pushbackInputStream.unread(byArray, 0, 4);
            }
        }
    }

    private static boolean isParsable(Document document) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "isPersistence");
        }
        boolean bl = false;
        Element element = document.getRootElement();
        String string = element.getName().toLowerCase();
        if (string.startsWith("rss")) {
            String string2 = element.getAttribute("version").getValue();
            if (string2.indexOf("0.91") >= 0) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses RSS root element (Version 0.91).");
                bl = true;
            } else if (string2.indexOf("0.92") >= 0) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses RSS root element (Version 0.92).");
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "RSS 0.92 not fully supported yet, fall back to 0.91.");
                bl = true;
            } else if (string.indexOf("0.93") >= 0) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses RSS root element (Version 0.93).");
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "RSS 0.93 not fully supported yet, fall back to 0.91.");
                bl = false;
            } else if (string.indexOf("0.94") >= 0) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses RSS root element (Version 0.94).");
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "RSS 0.94 not fully supported yet, will use RSS 2.0");
                bl = true;
            } else if (string2.indexOf("2.0") >= 0 || string2.equals("2")) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses RSS root element (Version 2.0).");
                bl = true;
            } else {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Unsupported RSS version [" + string2 + "].");
                bl = false;
            }
        } else if (string.indexOf("rdf") >= 0) {
            bl = true;
        } else if (string.indexOf("feed") >= 0) {
            String string3 = element.getAttribute("version").getValue();
            if (string3.indexOf("0.1") >= 0 || string3.indexOf("0.2") >= 0) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses feed root element (Version " + string3 + ").");
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "This atom version is not really supported yet, assume Atom 0.3 format");
                bl = true;
            } else if (string3.indexOf("0.3") >= 0) {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Channel uses feed root element (Version 0.3).");
                bl = true;
            } else {
                logger.logp(Level.INFO, CLAZZ, "isPersistence", "Unsupported feed version [" + string3 + "].");
                bl = false;
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class HttpResult {
        private int statusCode;
        private byte[] response;
        private String location;

        public HttpResult(int n) {
            this.statusCode = n;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getResponse() {
            return this.response;
        }

        public void setResponse(byte[] byArray) {
            this.response = byArray;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String string) {
            this.location = string;
        }
    }
}

