/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util;

import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorConstants;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.FeedCleaner;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.FeedPoller;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.common.impl.RssEnvironmental;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.manager.PersistenceManagerConfig;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import de.nava.informa.utils.poller.PollerObserverIF;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelUtil {
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl = ChannelUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl).getName());
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$ChannelUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$ChannelUtil = ChannelUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.ChannelUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$ChannelUtil).getName();
    private PersistenceManagerIF _manager = null;
    private FeedPoller _poller = null;
    private FeedCleaner _cleaner = null;
    private RssEnvironmental _rssEnv = null;
    private IdentityHashMap channels_locked = new IdentityHashMap();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$util$ChannelUtil;

    public ChannelUtil(int n, int n2, int n3, RssEnvironmental rssEnvironmental) throws ClassNotFoundException, IllegalAccessException, InstantiationException, PersistenceManagerException {
        PersistenceManagerConfig.setPersistenceManagerClassName((String)"de.nava.informa.utils.manager.hibernate.PersistenceManager");
        this._manager = PersistenceManagerConfig.getPersistenceManager();
        this._cleaner = new FeedCleaner(this._manager, this, n3, rssEnvironmental);
        this._cleaner.setPeriod((long)n2 * RssAggregatorConstants.ONE_HOUR_OF_MILLIS.longValue());
        this._poller = new FeedPoller(this._manager, this, this._cleaner, rssEnvironmental);
        this._poller.setPeriod(n * rssEnvironmental.getMillisToMultiply());
        this._rssEnv = rssEnvironmental;
        this.addExistingChannelsToPollerAndCleaner();
    }

    public ChannelGroupIF createGroup(String string) throws LocalizableException {
        ChannelGroupIF channelGroupIF;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "createGroup");
        }
        try {
            channelGroupIF = this._manager.createGroup("default");
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "createGroup", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "createGroup");
        }
        return channelGroupIF;
    }

    public void cleanerUnregister(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "pollUnregister");
        }
        try {
            URL uRL = new URL(string);
            ChannelIF channelIF = this.findChannel(uRL);
            this._cleaner.registerChannel(channelIF);
            this._cleaner.cleanChannel(channelIF);
            this._cleaner.unregisterChannel(channelIF);
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.INFO, CLAZZ, "pollUnregister", "MalformedURLException: " + malformedURLException.getLocalizedMessage());
            LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "pollUnregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollStaticChannel(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "pollStaticChannel");
        }
        try {
            URL uRL = new URL(string);
            ChannelIF channelIF = this.findChannel(uRL);
            StaticFeedPollObserver staticFeedPollObserver = new StaticFeedPollObserver(this, channelIF);
            this._poller.addObserver(staticFeedPollObserver);
            this._poller.registerChannel(channelIF);
            try {
                ChannelUtil channelUtil = this;
                synchronized (channelUtil) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._poller.removeObserver(staticFeedPollObserver);
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.INFO, CLAZZ, "pollStaticChannel", "MalformedURLException: " + malformedURLException.getLocalizedMessage());
            LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "pollStaticChannel");
        }
    }

    public ChannelIF addChannel(String string, String string2, String string3, boolean bl) throws LocalizableException {
        ChannelIF channelIF;
        block7: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "addChannel");
            }
            try {
                URL uRL = new URL(string3);
                channelIF = null;
                ChannelGroupIF channelGroupIF = this.findGroup(string);
                if (!this.channelExists(uRL)) {
                    channelIF = this._manager.createChannel(string2, new URL(string3));
                    this._manager.addChannelToGroup(channelIF, channelGroupIF);
                    if (bl) {
                        this._poller.registerChannel(channelIF);
                        this._cleaner.registerChannel(channelIF);
                    }
                    break block7;
                }
                logger.logp(Level.INFO, CLAZZ, "addChannel", "Channel already exists: " + string3);
                LocalizableException localizableException = new LocalizableException("rss.agg.exists", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            catch (MalformedURLException malformedURLException) {
                logger.logp(Level.INFO, CLAZZ, "addChannel", "MalformedURLException: " + malformedURLException.getLocalizedMessage());
                LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            catch (PersistenceManagerException persistenceManagerException) {
                logger.logp(Level.INFO, CLAZZ, "addChannel", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
                LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "addChannel");
        }
        return channelIF;
    }

    public ChannelIF changeChannelUrl(String string, String string2) throws LocalizableException {
        ChannelIF channelIF;
        block11: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "changeChannelUrl");
            }
            channelIF = null;
            try {
                URL uRL = new URL(string);
                channelIF = this.findChannel(uRL);
                if (channelIF != null) {
                    try {
                        this.aquireChannelLock(channelIF);
                        ChannelGroupIF channelGroupIF = this.findGroup("default");
                        this._manager.removeChannelFromGroup(channelIF, channelGroupIF);
                        URL uRL2 = new URL(string2);
                        channelIF.setLocation(uRL2);
                        this._manager.updateChannel(channelIF);
                        this._manager.addChannelToGroup(channelIF, channelGroupIF);
                        this.releaseChannelLock(channelIF);
                        break block11;
                    }
                    catch (PersistenceManagerException persistenceManagerException) {
                        logger.logp(Level.INFO, CLAZZ, "changeChannelUrl", "Persistence exception " + string);
                        LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                        throw new LocalizableException((Throwable)localizableException);
                    }
                }
                logger.logp(Level.INFO, CLAZZ, "changeChannelUrl", "Channel does not exists: " + string);
                LocalizableException localizableException = new LocalizableException("rss.agg.nonexistent", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            catch (MalformedURLException malformedURLException) {
                logger.logp(Level.INFO, CLAZZ, "changeChannelUrl", "MalformedURLException: " + malformedURLException.getLocalizedMessage());
                LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            finally {
                if (channelIF != null) {
                    // empty if block
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "changeChannelUrl");
        }
        return channelIF;
    }

    public ChannelIF registerChannelUrl(String string) throws LocalizableException {
        ChannelIF channelIF;
        block9: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "registerChannelUrl");
            }
            channelIF = null;
            try {
                URL uRL = new URL(string);
                channelIF = this.findChannel(uRL);
                if (channelIF != null) {
                    this._poller.registerChannel(channelIF);
                    this._cleaner.registerChannel(channelIF);
                    break block9;
                }
                logger.logp(Level.INFO, CLAZZ, "registerChannelUrl", "Channel does not exists: " + string);
                LocalizableException localizableException = new LocalizableException("rss.agg.nonexistent", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            catch (MalformedURLException malformedURLException) {
                logger.logp(Level.INFO, CLAZZ, "registerChannelUrl", "MalformedURLException: " + malformedURLException.getLocalizedMessage());
                LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
            }
            finally {
                if (channelIF != null) {
                    // empty if block
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "registerChannelUrl");
        }
        return channelIF;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteChannel(String string, String string2) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "deleteChannel");
        }
        ChannelIF channelIF = null;
        try {
            URL uRL = new URL(string2);
            ChannelGroupIF channelGroupIF = this.findGroup(string);
            channelIF = this.findChannel(uRL);
            this.aquireChannelLock(channelIF);
            this._poller.unregisterChannel(channelIF);
            this._cleaner.unregisterChannel(channelIF);
            this._manager.removeChannelFromGroup(channelIF, channelGroupIF);
            this._manager.updateGroup(channelGroupIF);
            this._manager.deleteChannel(channelIF);
            this.releaseChannelLock(channelIF);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                logger.logp(Level.INFO, CLAZZ, "deleteChannel", "MalformedURLException: " + malformedURLException.getLocalizedMessage(), malformedURLException);
                LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                throw new LocalizableException((Throwable)localizableException);
                catch (PersistenceManagerException persistenceManagerException) {
                    logger.logp(Level.INFO, CLAZZ, "deleteChannel", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
                    LocalizableException localizableException2 = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                    throw new LocalizableException((Throwable)localizableException2);
                }
            }
            catch (Throwable throwable) {
                this.releaseChannelLock(channelIF);
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "deleteChannel");
        }
    }

    public void updateGroupAndChannel(String string, String string2) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "updateGroupAndChannel");
        }
        try {
            URL uRL = new URL(string2);
            ChannelGroupIF channelGroupIF = this.findGroup(string);
            ChannelIF channelIF = this.findChannel(uRL);
            this._manager.updateGroup(channelGroupIF);
            this._manager.updateChannel(channelIF);
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.INFO, CLAZZ, "updateGroupAndChannel", "MalformedURLException: " + malformedURLException.getLocalizedMessage(), malformedURLException);
            LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "updateGroupAndChannel", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "updateGroupAndChannel");
        }
    }

    public void refreshChannels() throws PersistenceManagerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "refreshChannels");
        }
        ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
        for (int i = 0; i < channelGroupIFArray.length; ++i) {
            Collection collection = channelGroupIFArray[i].getAll();
            ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
            for (int j = 0; j < channelIFArray.length; ++j) {
                this._poller.updateChannel(channelIFArray[j]);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "refreshChannels");
        }
    }

    public void refreshChannel(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "refreshChannel");
        }
        try {
            URL uRL = new URL(string);
            ChannelIF channelIF = this.findChannel(uRL);
            this._poller.updateChannel(channelIF);
            this._manager.updateChannel(channelIF);
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.INFO, CLAZZ, "refreshChannel", "MalformedURLException: " + malformedURLException.getLocalizedMessage(), malformedURLException);
            LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "refreshChannel", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "refreshChannel");
        }
    }

    public String getChannelTitle(String string) throws LocalizableException {
        String string2 = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getChannelTitle");
        }
        try {
            URL uRL = new URL(string);
            ChannelIF channelIF = this.findChannel(uRL);
            string2 = channelIF.getTitle();
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.INFO, CLAZZ, "getChannelTitle", "MalformedURLException: " + malformedURLException.getLocalizedMessage(), malformedURLException);
            LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getChannelTitle");
        }
        return string2;
    }

    protected void addExistingChannelsToPollerAndCleaner() throws PersistenceManagerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "addExistingChannelsToPollerAndCleaner");
        }
        ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
        for (int i = 0; i < channelGroupIFArray.length; ++i) {
            Collection collection = channelGroupIFArray[i].getAll();
            ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
            for (int j = 0; j < channelIFArray.length; ++j) {
                if (this.isStatic(channelIFArray[j])) continue;
                this._cleaner.registerChannel(channelIFArray[j]);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._poller.registerChannel(channelIFArray[j]);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "addExistingChannelsToPollerAndCleaner");
        }
    }

    public boolean isStatic(ChannelIF channelIF) {
        String string = channelIF.getLocation().getHost();
        return string.equals(this._rssEnv.getCurrentHostName());
    }

    public void cleanChannels() throws PersistenceManagerException {
        ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
        for (int i = 0; i < channelGroupIFArray.length; ++i) {
            Collection collection = channelGroupIFArray[i].getAll();
            ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
            for (int j = 0; j < channelIFArray.length; ++j) {
                this._cleaner.cleanChannel(channelIFArray[j]);
                this._manager.updateChannel(channelIFArray[j]);
            }
        }
    }

    public void setCleaningInterval(int n) {
        long l = n * RssAggregatorConstants.ONE_HOUR_OF_MILLIS;
        this._cleaner.setPeriod(l);
    }

    public void setPollingInterval(int n) {
        long l = n * this._rssEnv.getMillisToMultiply();
        this._poller.setPeriod(l);
    }

    public void setAgeValue(int n) {
        long l = n * this._rssEnv.getMillisToMultiply();
        this._cleaner.setAgeValue(l);
    }

    public boolean groupExists(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "groupExists");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                if (!channelGroupIFArray[i].getTitle().equals(string)) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(CLAZZ, "groupExists: true");
                }
                return true;
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "groupExists", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "groupExists: false");
        }
        return false;
    }

    public ChannelGroupIF findGroup(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "findGroup");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                if (!channelGroupIFArray[i].getTitle().equals(string)) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(CLAZZ, "findGroup: true");
                }
                return channelGroupIFArray[i];
            }
            logger.logp(Level.INFO, CLAZZ, "findGroup", "Group does not exist: " + string);
            LocalizableException localizableException = new LocalizableException("rss.agg.nonexistent", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "findGroup", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
    }

    public boolean channelExists(URL uRL) throws PersistenceManagerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "channelExists");
        }
        ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
        for (int i = 0; i < channelGroupIFArray.length; ++i) {
            Collection collection = channelGroupIFArray[i].getAll();
            ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
            for (int j = 0; j < channelIFArray.length; ++j) {
                if (!channelIFArray[j].getLocation().equals(uRL)) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(CLAZZ, "channelExists: true");
                }
                return true;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "channelExists: false");
        }
        return false;
    }

    public ChannelIF findChannel(URL uRL) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "findChannel");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                Collection collection = channelGroupIFArray[i].getAll();
                ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
                for (int j = 0; j < channelIFArray.length; ++j) {
                    if (!channelIFArray[j].getLocation().equals(uRL)) continue;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.exiting(CLAZZ, "findChannel: true");
                    }
                    return channelIFArray[j];
                }
            }
            logger.logp(Level.INFO, CLAZZ, "findChannel", "Channel does not exist: " + uRL.toString());
            LocalizableException localizableException = new LocalizableException("rss.agg.nonexistent", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "findChannel", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
    }

    public String[] getChannelTitles() throws LocalizableException {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getChannelTitles");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                Collection collection = channelGroupIFArray[i].getAll();
                ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
                for (int j = 0; j < channelIFArray.length; ++j) {
                    String string = channelIFArray[j].getTitle();
                    arrayList.add(string);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.INFO, CLAZZ, "getChannelTitles", "channel title:  " + channelIFArray[j].getTitle());
                }
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "getChannelTitles", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        stringArray = arrayList.toArray(new String[0]);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getChannelTitles");
        }
        return stringArray;
    }

    public String[] getChannelURLs() throws LocalizableException {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getChannelURLs");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                Collection collection = channelGroupIFArray[i].getAll();
                ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
                for (int j = 0; j < channelIFArray.length; ++j) {
                    URL uRL = channelIFArray[j].getLocation();
                    arrayList.add(uRL.toString());
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.INFO, CLAZZ, "getChannelURLs", "channel title:  " + channelIFArray[j].getTitle());
                }
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "getChannelURLs", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        stringArray = arrayList.toArray(new String[0]);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getChannelURLs");
        }
        return stringArray;
    }

    public void shutdown() {
    }

    public void enable() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "enable");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                Collection collection = channelGroupIFArray[i].getAll();
                ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
                for (int j = 0; j < channelIFArray.length; ++j) {
                    this._poller.registerChannel(channelIFArray[j]);
                    this._cleaner.registerChannel(channelIFArray[j]);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.INFO, CLAZZ, "enable", "register channel title:  " + channelIFArray[j].getTitle());
                }
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "enable", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "enable");
        }
    }

    public void disable() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "disable");
        }
        try {
            ChannelGroupIF[] channelGroupIFArray = this._manager.getGroups();
            for (int i = 0; i < channelGroupIFArray.length; ++i) {
                Collection collection = channelGroupIFArray[i].getAll();
                ChannelIF[] channelIFArray = collection.toArray(new ChannelIF[collection.size()]);
                for (int j = 0; j < channelIFArray.length; ++j) {
                    this._poller.unregisterChannel(channelIFArray[j]);
                    this._cleaner.unregisterChannel(channelIFArray[j]);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.INFO, CLAZZ, "disable", "unregister channel title:  " + channelIFArray[j].getTitle());
                }
            }
        }
        catch (PersistenceManagerException persistenceManagerException) {
            logger.logp(Level.INFO, CLAZZ, "disable", "PersistenceManagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "disable");
        }
    }

    protected FeedPoller getPoller() {
        return this._poller;
    }

    protected FeedCleaner getCleaner() {
        return this._cleaner;
    }

    protected PersistenceManagerIF getManager() {
        return this._manager;
    }

    boolean isChannelLocked(ChannelIF channelIF) {
        return this.channels_locked.containsKey(channelIF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aquireChannelLock(ChannelIF channelIF) {
        ChannelIF channelIF2 = channelIF;
        synchronized (channelIF2) {
            while (this.isChannelLocked(channelIF)) {
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.entering(CLAZZ, "aquireChannelLock");
                        logger.logp(Level.INFO, CLAZZ, "aquireChannelLock", "wait for lock: " + channelIF);
                    }
                    channelIF.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.channels_locked.put(channelIF, null);
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "aquireChannelLock");
                logger.logp(Level.INFO, CLAZZ, "aquireChannelLock", "acquired lock: " + channelIF);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseChannelLock(ChannelIF channelIF) {
        ChannelIF channelIF2 = channelIF;
        synchronized (channelIF2) {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "releaseChannelLock");
                logger.logp(Level.INFO, CLAZZ, "releaseChannelLock", "release lock: " + channelIF);
            }
            this.channels_locked.remove(channelIF);
            channelIF.notifyAll();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class StaticFeedPollObserver
    implements PollerObserverIF {
        ChannelUtil _syncObject = null;
        ChannelIF _staticChannel;

        protected StaticFeedPollObserver(ChannelUtil channelUtil2, ChannelIF channelIF) {
            this._syncObject = channelUtil2;
            this._staticChannel = channelIF;
        }

        public void itemFound(ItemIF itemIF, ChannelIF channelIF) {
        }

        public void channelErrored(ChannelIF channelIF, Exception exception) {
        }

        public void channelChanged(ChannelIF channelIF) {
        }

        public void pollStarted(ChannelIF channelIF) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pollFinished(ChannelIF channelIF) {
            if (channelIF == this._staticChannel) {
                ChannelUtil channelUtil = this._syncObject;
                synchronized (channelUtil) {
                    ChannelUtil.this.aquireChannelLock(channelIF);
                    ChannelUtil.this._poller.unregisterChannel(channelIF);
                    ChannelUtil.this.releaseChannelLock(channelIF);
                    this._syncObject.notifyAll();
                }
            }
        }
    }
}

