/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorConstants;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorStateBean;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.db.PostgresStateDAO;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.ChannelUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.FeedPopulator;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.FeedValidator;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.ProxyDAO;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.util.ReparentUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.common.impl.RssEnvironmental;
import com.sun.netstorage.mgmt.esm.logic.collector.rss.common.impl.State;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.scheduler.impl.SchedulerUtilImpl;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.manager.PersistenceManagerException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;
import org.w3c.dom.Document;

public class RssAggregatorImpl
extends StandardMBean
implements RssAggregatorMBean,
NotificationListener {
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl).getName());
    private static org.apache.log4j.Logger log_hib = org.apache.log4j.Logger.getLogger((String)"net.sf.hibernate");
    private static org.apache.log4j.Logger log_inf = org.apache.log4j.Logger.getLogger((String)"de.nava.informa");
    private static org.apache.log4j.Logger log_http = org.apache.log4j.Logger.getLogger((String)"org.apache.commons.httpclient");
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl).getName();
    private static String ONESHOT = "OneShot";
    private static String POLL = "Poll";
    private RssEnvironmental _rssEnv = null;
    private MBeanServer myMbs = null;
    private PostgresStateDAO dao = null;
    ChannelUtil _util = null;
    ReparentUtil _reUtil = null;
    String xmlRoot = null;
    private List urlPollList = null;
    private boolean proxyEnable;
    private String proxyHost;
    private int proxyPort;
    private String proxyUserID;
    private String proxyPassword;
    private String noProxyList;
    private int _pollerInterval = RssAggregatorConstants.DEFAULT_POLLING_INTERVAL;
    private int _cleanerInterval = RssAggregatorConstants.DEFAULT_CLEANING_INTERVAL;
    private int _ageInterval = RssAggregatorConstants.DEFAULT_AGE_INTERVAL;
    private String _rev = "1.0.0";
    private boolean _pollOn = false;
    private boolean _storeRemoveOn = false;
    private String _state = "ON";
    private boolean _persisted = false;
    private String _key = null;
    private Date _nextPollTime = null;
    int _jobsExecuted = 0;
    private boolean _verboseOn;
    org.apache.log4j.Level _log_hib_level = null;
    org.apache.log4j.Level _log_inf_level = null;
    org.apache.log4j.Level _log_http_level = null;
    String _level;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorMBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean;

    public RssAggregatorImpl(String string, Properties properties, RssEnvironmental rssEnvironmental) throws Exception {
        super(class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorMBean = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorMBean);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "RssAggregatorImpl");
        }
        this._rssEnv = rssEnvironmental;
        if (properties != null && string != null) {
            boolean bl;
            int n;
            this.setKey(string);
            String string2 = properties.getProperty("pollingInterval");
            try {
                n = Integer.parseInt(string2);
                this.setInitialPollInterval(n);
            }
            catch (Exception exception) {
                this.setInitialPollInterval(RssAggregatorConstants.DEFAULT_POLLING_INTERVAL);
            }
            this.setInitialCleanInterval(RssAggregatorConstants.DEFAULT_CLEANING_INTERVAL);
            string2 = properties.getProperty("ageInterval");
            try {
                n = Integer.parseInt(string2);
                this.setInitialAgeInterval(n);
            }
            catch (Exception exception) {
                this.setInitialAgeInterval(RssAggregatorConstants.DEFAULT_AGE_INTERVAL);
            }
            this.xmlRoot = properties.getProperty("xmlRoot");
            if (this.xmlRoot == null) {
                this.xmlRoot = "/etc/opt/SUNWesmportal/xml/";
            }
            this.dao = new PostgresStateDAO();
            if (!this.dao.stateTableExists()) {
                this.dao.createTable();
            }
            if (!(bl = this.persistenceCheck(true))) {
                this.pickleProperties();
            }
            this.setLevel(this.getLogLevel());
            log_hib.setLevel(org.apache.log4j.Level.ERROR);
            log_inf.setLevel(org.apache.log4j.Level.ERROR);
            log_http.setLevel(org.apache.log4j.Level.ERROR);
            this._log_hib_level = log_hib.getLevel();
            this._log_inf_level = log_inf.getLevel();
            this._log_http_level = log_http.getLevel();
            this.checkProxySettings();
            this.start();
            this.initialize();
            if (this.urlPollList != null && !this.urlPollList.isEmpty()) {
                this.schedulePollJob("channelJob", 5);
            }
        } else {
            logger.logp(Level.SEVERE, CLAZZ, "RssAggregatorImpl", "missing call argument");
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "RssAggregatorImpl");
        }
    }

    protected void checkProxySettings() {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "checkProxySettings");
        }
        ProxyDAO proxyDAO = new ProxyDAO();
        this.setProxyEnabled(proxyDAO.isEnabled());
        String string = proxyDAO.getHost();
        if (string != null && !string.equals("")) {
            this.setProxyHost(string);
        } else {
            this.setProxyHost("");
        }
        String string2 = proxyDAO.getPort();
        if (string2 != null && !string2.equals("")) {
            object = new Integer(string2);
            this.setProxyPort((Integer)object);
        } else {
            this.setProxyPort(0);
        }
        object = proxyDAO.getNoProxyList();
        if (object != null && !((String)object).equals("")) {
            this.setNoProxyList((String)object);
        } else {
            this.setNoProxyList("");
        }
        String string3 = proxyDAO.getPassword();
        if (string3 != null && !string3.equals("")) {
            this.setProxyPassword(string3);
        } else {
            this.setProxyPassword("");
        }
        String string4 = proxyDAO.getUser();
        if (string4 != null && !string4.equals("")) {
            this.setProxyUserID(string4);
            Authenticator.setDefault(new MyAuthenticator());
        } else {
            this.setProxyUserID("");
            Authenticator.setDefault(new MyAuthenticator());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "checkProxySettings");
        }
    }

    protected void loadFeedsFromConfigFile() throws LocalizableException {
        FeedPopulator feedPopulator;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "loadFeedsFromConfigFile");
        }
        if ((feedPopulator = new FeedPopulator(this.xmlRoot)).configFileExisits()) {
            logger.logp(Level.INFO, CLAZZ, "loadFeedsFromConfigFile", "Loading Rss Configuration.");
            Document document = feedPopulator.loadConfiguration();
            List list = feedPopulator.parseFeeds(document);
            this._reUtil = new ReparentUtil(this._rssEnv, this, this._util);
            this.urlPollList = this._reUtil.processFeedList(list);
        } else {
            logger.logp(Level.INFO, CLAZZ, "loadFeedsFromConfigFile", "Configuration file does NOT exists.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "loadFeedsFromConfigFile");
        }
    }

    protected synchronized void processFeedList(List list) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "processFeedList");
        }
        this.urlPollList = new ArrayList();
        if (list != null & !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                String string = (String)map.get("title");
                String string2 = (String)map.get("staticURL");
                String string3 = (String)map.get("activeURL");
                try {
                    if (string2 != null && !string2.equals("")) {
                        if (string2.startsWith("rsscache:")) {
                            String string4 = "http://" + this._rssEnv.getCurrentHostName();
                            String string5 = string2.replaceFirst("rsscache:", string4);
                            URL uRL = new URL(string5);
                            if (!this.isChannelValid(string5)) {
                                this.urlPollList.add(map);
                                continue;
                            }
                            if (!this._util.channelExists(uRL)) {
                                this._util.addChannel("default", string, string5, false);
                            }
                            this._util.pollStaticChannel(string5);
                            if (string3 == null || string3.equals("")) continue;
                            try {
                                if (this.isChannelValid(string3)) {
                                    this._util.changeChannelUrl(string5, string3);
                                    this._util.registerChannelUrl(string3);
                                    continue;
                                }
                                this.urlPollList.add(map);
                            }
                            catch (Exception exception) {
                                this.urlPollList.add(map);
                            }
                            continue;
                        }
                        logger.logp(Level.INFO, CLAZZ, "processFeedList", "Malformed static URL: " + string2);
                        continue;
                    }
                    if (string3 == null || string3.equals("")) continue;
                    try {
                        if (!this.isChannelValid(string3)) {
                            this.urlPollList.add(map);
                            continue;
                        }
                        this._util.addChannel("default", string, string3, false);
                    }
                    catch (Exception exception) {
                        this.urlPollList.add(map);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    logger.logp(Level.INFO, CLAZZ, "processFeedList", "MalformedURLException: " + string);
                }
                catch (PersistenceManagerException persistenceManagerException) {
                    logger.logp(Level.INFO, CLAZZ, "processFeedList", "PersistenceManagerException: " + string + " : " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
                }
                catch (LocalizableException localizableException) {
                    logger.logp(Level.INFO, CLAZZ, "processFeedList", "LocalizableException: " + string + " : " + localizableException.getLocalizedMessage());
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "processFeedList");
        }
    }

    public void addChannel(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "addChannel");
        }
        ChannelIF channelIF = this._util.addChannel("default", "dflt_chan_title", string, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.INFO, CLAZZ, "addChannel", "channel add:  " + channelIF.toString());
            logger.exiting(CLAZZ, "addChannel");
        }
    }

    public void removeChannel(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "removeChannel");
        }
        this._util.deleteChannel("default", string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "removeChannel");
        }
    }

    public boolean isChannelValid(String string) throws LocalizableException {
        boolean bl = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "isChannelValid");
        }
        try {
            FeedValidator feedValidator = new FeedValidator();
            feedValidator.setProxyHost(this.getProxyHost());
            feedValidator.setProxyPort(this.getProxyPort());
            feedValidator.setProxyUserID(this.getProxyUserID());
            feedValidator.setProxyPassword(this.getProxyPassword());
            URL uRL = new URL(string);
            bl = feedValidator.isValid(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.INFO, CLAZZ, "isChannelValid", malformedURLException.getLocalizedMessage(), malformedURLException);
            LocalizableException localizableException = new LocalizableException("rss.agg.malformedURL", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "isChannelValid");
        }
        return bl;
    }

    public String[] getChannelTitles() throws LocalizableException {
        String[] stringArray = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getChannelTitles");
        }
        stringArray = this._util.getChannelTitles();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getChannelTitles");
        }
        return stringArray;
    }

    public String[] getChannelURLs() throws LocalizableException {
        String[] stringArray = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getChannelURLs");
        }
        stringArray = this._util.getChannelURLs();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getChannelURLs");
        }
        return stringArray;
    }

    public void handleNotification(Notification notification, Object object) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "handleNotification");
            logger.logp(Level.INFO, CLAZZ, "handleNotification", "\nNotification: type.." + notification.getType() + "\n              msg..." + notification.getMessage());
        }
        if (notification.getType().equalsIgnoreCase("Proxy.Changed")) {
            this.checkProxySettings();
            try {
                if (this.isProxyEnabled()) {
                    this.refresh();
                }
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "handleNotification");
        }
    }

    public void initialize() throws LocalizableException, Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "execute");
        }
        try {
            this._util = new ChannelUtil(this.getPollInterval(), this.getCleanInterval(), this.getAgeInterval(), this._rssEnv);
            if (!this._util.groupExists("default")) {
                this._util.createGroup("default");
            }
            try {
                this.loadFeedsFromConfigFile();
            }
            catch (LocalizableException localizableException) {}
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, CLAZZ, "execute", "Throwable Exception: " + throwable.getLocalizedMessage(), throwable);
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            throw new LocalizableException((Throwable)localizableException);
        }
        if (this.getState().equalsIgnoreCase("ON")) {
            this.enablePolling();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "execute");
        }
    }

    public void execute() throws LocalizableException, Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "execute");
        }
        ++this._jobsExecuted;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "execute");
        }
    }

    public void executeList() throws LocalizableException, Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "executeList");
        }
        ++this._jobsExecuted;
        if (this.urlPollList != null && !this.urlPollList.isEmpty()) {
            this.urlPollList = this._reUtil.processFeedList(this.urlPollList);
            if (this.urlPollList == null || this.urlPollList.isEmpty()) {
                this.unschedulePollJob("channelJob");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "executeList");
        }
    }

    private void start() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "start");
        }
        try {
            this.scheduleOneShotPollJob();
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            logger.logp(Level.INFO, CLAZZ, "start", objectAlreadyExistsException.getLocalizedMessage());
            throw new SchedulerException((Exception)((Object)objectAlreadyExistsException));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "start");
        }
    }

    public void stop() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "stop");
        }
        try {
            this.unschedulePollJob("channelJob");
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        try {
            this.unscheduleOneshotJob();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        this._util.shutdown();
        if (this.isStoreRemoveOn()) {
            try {
                this.dao.removeTables();
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "stop");
        }
        if (this.isVerboseOn()) {
            try {
                this.setLogLevel(this.getLevel());
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
    }

    private void changeSchedule() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "changeSchedule");
        }
        String string = this.getJobTriggerName(POLL);
        String string2 = this.getJobTriggerGroupName(POLL);
        String string3 = this.getJobName(POLL);
        String string4 = this.getJobGroupName(POLL);
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        if (this.getState().equalsIgnoreCase("ON")) {
            scheduler.unscheduleJob(string, string2);
            scheduler.deleteJob(string3, string4);
            this.startSchedule();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "changeSchedule");
        }
    }

    private void startSchedule() throws ObjectAlreadyExistsException, SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "startSchedule");
        }
        this.schedulePollJob("pollJob", this.getPollInterval());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "startSchedule");
        }
    }

    private String getJobTriggerName(String string) {
        String string2 = "JobTrig_" + string + "_" + this.getKey() + "_End";
        return string2;
    }

    private String getJobTriggerGroupName(String string) {
        String string2 = "GrpTrig_" + string + "_" + this.getKey() + "_End";
        return string2;
    }

    private String getJobName(String string) {
        String string2 = "Job_" + string + "_" + this.getKey() + "_End";
        return string2;
    }

    private String getJobGroupName(String string) {
        String string2 = "Grp_" + string + "_" + this.getKey() + "_End";
        return string2;
    }

    private void scheduleOneShotPollJob() throws SchedulerException, ObjectAlreadyExistsException {
        Scheduler scheduler;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "scheduleOneShotPollJob");
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobName(ONESHOT);
        String string2 = this.getJobGroupName(ONESHOT);
        JobDetail jobDetail = new JobDetail(string, string2, class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorPollJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob);
        jobDetail.getJobDataMap().put("Key", this.getKey());
        jobDetail.getJobDataMap().put((Object)"object", (Object)this);
        jobDetail.setDurability(true);
        scheduler.addJob(jobDetail, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.INFO, CLAZZ, "scheduleOneShotPollJob", "oneshot job scheduled");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "scheduleOneShotPollJob");
        }
    }

    private void fireOneShotPollJob(String string) throws SchedulerException {
        Scheduler scheduler;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "fireOneShotPollJob : command= " + string);
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string2 = this.getJobName(string);
        String string3 = this.getJobGroupName(string);
        JobDetail jobDetail = scheduler.getJobDetail(string2, string3);
        jobDetail.getJobDataMap().put("cmd", string);
        scheduler.triggerJob(string2, string3);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.INFO, CLAZZ, "fireOneShotPollJob", "oneshot job started");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "fireOneShotPollJob");
        }
    }

    private void schedulePollJob(String string, int n) throws SchedulerException {
        Scheduler scheduler;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "schedulePollJob");
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        long l = TriggerUtils.getNextGivenSecondDate(null, (int)15).getTime();
        String string2 = this.getJobTriggerName(string);
        String string3 = this.getJobTriggerGroupName(string);
        String string4 = this.getJobName(string);
        String string5 = this.getJobGroupName(string);
        JobDetail jobDetail = new JobDetail(string4, string5, class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.impl.RssAggregatorPollJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$impl$RssAggregatorPollJob);
        jobDetail.getJobDataMap().put("cmd", string);
        jobDetail.getJobDataMap().put((Object)"object", (Object)this);
        SimpleTrigger simpleTrigger = new SimpleTrigger(string2, string3, string4, string5, new Date(l), null, SimpleTrigger.REPEAT_INDEFINITELY, 60000L * (long)n);
        Date date = null;
        try {
            date = scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
            this._pollOn = true;
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            logger.logp(Level.INFO, CLAZZ, "schedulePollJob", "job exists [" + string4 + " ]");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "schedulePollJob");
        }
    }

    private void stopSchedule() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "stopSchedule");
        }
        this.unschedulePollJob("pollJob");
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "stopSchedule");
        }
    }

    private void unscheduleOneshotJob() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "unscheduleOneshotJob");
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobName(ONESHOT);
        String string2 = this.getJobGroupName(ONESHOT);
        scheduler.deleteJob(string, string2);
        this._pollOn = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "unscheduleOneshotJob");
        }
    }

    private void unschedulePollJob(String string) throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "unschedulePollJob");
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string2 = this.getJobTriggerName(string);
        String string3 = this.getJobTriggerGroupName(string);
        String string4 = this.getJobName(string);
        String string5 = this.getJobGroupName(string);
        scheduler.unscheduleJob(string2, string3);
        scheduler.deleteJob(string4, string5);
        this._pollOn = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "unschedulePollJob");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pickleProperties() throws PersistenceException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "pickleProperties");
        }
        PersistenceManager persistenceManager = null;
        persistenceManager = PersistenceManager.getInstance();
        RssAggregatorStateBean rssAggregatorStateBean = new RssAggregatorStateBean();
        rssAggregatorStateBean.setKey(this.getKey());
        rssAggregatorStateBean.setState(this.getState());
        rssAggregatorStateBean.setPollingInterval(Integer.toString(this.getPollInterval()));
        rssAggregatorStateBean.setCleaningInterval(Integer.toString(this.getCleanInterval()));
        rssAggregatorStateBean.setAgeInterval(Integer.toString(this.getAgeInterval()));
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "key...........[ " + this.getKey() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "state.........[ " + this.getState() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "pollInterval..[ " + this.getPollInterval() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "cleanInterval.[ " + this.getCleanInterval() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "ageInterval.[ " + this.getAgeInterval() + " ]");
        }
        Transaction transaction = null;
        try {
            try {
                transaction = persistenceManager.getTransaction();
            }
            catch (TransactionException transactionException) {
                // empty catch block
            }
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorStateBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean, (Filter)new EqualsFilter("key", this.getKey()));
            transaction.put((PersistentObject)rssAggregatorStateBean);
            transaction.commit();
        }
        finally {
            persistenceManager.releaseTransaction(transaction);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "pickleProperties");
        }
    }

    public boolean isPersisted() {
        return this._persisted;
    }

    /*
     * Loose catch block
     */
    private boolean persistenceCheck(boolean bl) throws LocalizableException {
        boolean bl2;
        block18: {
            bl2 = false;
            PersistentObject[] persistentObjectArray = null;
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "persistenceCheck");
            }
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean = RssAggregatorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api.RssAggregatorStateBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$rss$aggregator$api$RssAggregatorStateBean, (Filter)new EqualsFilter("key", this.getKey()));
            transaction.commit();
            Object var10_6 = null;
            persistenceManager.releaseTransaction(transaction);
            if (persistentObjectArray == null || persistentObjectArray.length == 0) break block18;
            bl2 = true;
            if (!bl) break block18;
            this.setState(((RssAggregatorStateBean)persistentObjectArray[0]).getState());
            try {
                this.setInitialPollInterval(Integer.parseInt(((RssAggregatorStateBean)persistentObjectArray[0]).getPollingInterval()));
                this.setInitialCleanInterval(Integer.parseInt(((RssAggregatorStateBean)persistentObjectArray[0]).getCleaningInterval()));
                this.setInitialAgeInterval(Integer.parseInt(((RssAggregatorStateBean)persistentObjectArray[0]).getAgeInterval()));
            }
            catch (NumberFormatException numberFormatException) {
                logger.logp(Level.INFO, CLAZZ, "persistenceCheck", "NumberFormatException: " + numberFormatException.getLocalizedMessage(), numberFormatException);
            }
            catch (Exception exception) {
                logger.logp(Level.INFO, CLAZZ, "persistenceCheck", "Exception:\t" + exception.getLocalizedMessage(), exception);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "key...........[ " + this.getKey() + " ]");
                logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "state.........[ " + this.getState() + " ]");
                logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "pollInterval..[ " + this.getPollInterval() + " ]");
                logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "cleanInterval.[ " + this.getCleanInterval() + " ]");
                logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "ageInterval...[ " + this.getAgeInterval() + " ]");
            }
            break block18;
            {
                catch (PersistenceException persistenceException) {
                    LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                    logger.logp(Level.INFO, CLAZZ, "persistenceCheck", "PersistenceException: " + localizableException.getLocalizedMessage(), persistenceException);
                    throw localizableException;
                }
                catch (TransactionException transactionException) {
                    LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
                    logger.logp(Level.INFO, CLAZZ, "persistenceCheck", "TransactionException: " + localizableException.getLocalizedMessage(), transactionException);
                    throw localizableException;
                }
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                persistenceManager.releaseTransaction(transaction);
                if (persistentObjectArray != null && persistentObjectArray.length != 0) {
                    bl2 = true;
                    if (bl) {
                        this.setState(((RssAggregatorStateBean)persistentObjectArray[0]).getState());
                        try {
                            this.setInitialPollInterval(Integer.parseInt(((RssAggregatorStateBean)persistentObjectArray[0]).getPollingInterval()));
                            this.setInitialCleanInterval(Integer.parseInt(((RssAggregatorStateBean)persistentObjectArray[0]).getCleaningInterval()));
                            this.setInitialAgeInterval(Integer.parseInt(((RssAggregatorStateBean)persistentObjectArray[0]).getAgeInterval()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.logp(Level.INFO, CLAZZ, "persistenceCheck", "NumberFormatException: " + numberFormatException.getLocalizedMessage(), numberFormatException);
                        }
                        catch (Exception exception) {
                            logger.logp(Level.INFO, CLAZZ, "persistenceCheck", "Exception:\t" + exception.getLocalizedMessage(), exception);
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "key...........[ " + this.getKey() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "state.........[ " + this.getState() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "pollInterval..[ " + this.getPollInterval() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "cleanInterval.[ " + this.getCleanInterval() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "persistenceCheck", "ageInterval...[ " + this.getAgeInterval() + " ]");
                        }
                    }
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "persistenceCheck");
        }
        return bl2;
    }

    protected void setRssAggregatorEnvironment(RssEnvironmental rssEnvironmental) {
        this._rssEnv = rssEnvironmental;
    }

    private void setPersisted(boolean bl) {
        this._persisted = bl;
    }

    public String getNextPollTime() {
        String string = null;
        if (this._nextPollTime != null) {
            string = this._nextPollTime.toString();
        }
        return string;
    }

    public void setNextPollTime(Date date) {
        this._nextPollTime = date;
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String string) {
        this._key = string;
    }

    public String getState() {
        return this._state;
    }

    public void setState(String string) throws IllegalArgumentException {
        boolean bl = false;
        Enumeration enumeration = State.elements();
        while (enumeration.hasMoreElements()) {
            State state = (State)enumeration.nextElement();
            if (!state.toString().equalsIgnoreCase(string)) continue;
            this._state = string;
            bl = true;
            if (!logger.isLoggable(Level.FINER)) break;
            logger.logp(Level.INFO, CLAZZ, "setState", " :\tstate strg= " + state.toString() + "  ord= " + state.ord);
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public String getRevision() {
        return this._rev;
    }

    public int getMinPollInterval() {
        int n = RssAggregatorConstants.MIN_POLLING_INTERVAL;
        return n;
    }

    public int getMaxPollInterval() {
        int n = RssAggregatorConstants.MAX_POLLING_INTERVAL;
        return n;
    }

    public int getDefaultPollInterval() {
        int n = RssAggregatorConstants.DEFAULT_POLLING_INTERVAL;
        return n;
    }

    public int getPollInterval() {
        return this._pollerInterval;
    }

    public void setPollInterval(int n) throws Exception {
        if (n < RssAggregatorConstants.MIN_POLLING_INTERVAL || n > RssAggregatorConstants.MAX_POLLING_INTERVAL) {
            LocalizableException localizableException = new LocalizableException("rss.intervalError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "setPollInterval", "IntervalException:\t" + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        this._pollerInterval = n;
        if (this._util != null) {
            this._util.setPollingInterval(this._pollerInterval);
        }
        this.pickleProperties();
    }

    public int getMinCleanInterval() {
        int n = RssAggregatorConstants.MIN_CLEANING_INTERVAL;
        return n;
    }

    public int getMaxCleanInterval() {
        int n = RssAggregatorConstants.MAX_CLEANING_INTERVAL;
        return n;
    }

    public int getCleanInterval() {
        return this._cleanerInterval;
    }

    public void setCleanInterval(int n) throws Exception {
        logger.logp(Level.INFO, CLAZZ, "setCleanerInterval", "This function has been disabled. Cleaning interval remains at default level.\t");
    }

    public int getDefaultCleanInterval() {
        int n = RssAggregatorConstants.DEFAULT_CLEANING_INTERVAL;
        return n;
    }

    public int getMinAgeInterval() {
        int n = RssAggregatorConstants.MIN_AGE_INTERVAL;
        return n;
    }

    public int getMaxAgeInterval() {
        int n = RssAggregatorConstants.MAX_AGE_INTERVAL;
        return n;
    }

    public int getAgeInterval() {
        return this._ageInterval;
    }

    public void setAgeInterval(int n) throws Exception {
        if (n < RssAggregatorConstants.MIN_AGE_INTERVAL || n > RssAggregatorConstants.MAX_AGE_INTERVAL) {
            LocalizableException localizableException = new LocalizableException("rss.intervalError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "setAgeInterval", "IntervalException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        this._ageInterval = n;
        if (this._util != null) {
            this._util.setAgeValue(this._ageInterval);
        }
        this.pickleProperties();
    }

    public int getDefaultAgeInterval() {
        int n = RssAggregatorConstants.DEFAULT_AGE_INTERVAL;
        return n;
    }

    private void setInitialPollInterval(int n) throws Exception {
        if (n < RssAggregatorConstants.MIN_POLLING_INTERVAL || n > RssAggregatorConstants.MAX_POLLING_INTERVAL) {
            LocalizableException localizableException = new LocalizableException("rss.intervalError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "setInitialPollInterval", "IntervalException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        this._pollerInterval = n;
    }

    private void setInitialCleanInterval(int n) throws Exception {
        if (n < RssAggregatorConstants.MIN_CLEANING_INTERVAL || n > RssAggregatorConstants.MAX_CLEANING_INTERVAL) {
            LocalizableException localizableException = new LocalizableException("rss.intervalError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "setInitalCleanInterval", "IntervalException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        this._cleanerInterval = n;
    }

    private void setInitialAgeInterval(int n) throws Exception {
        if (n < RssAggregatorConstants.MIN_AGE_INTERVAL || n > RssAggregatorConstants.MAX_AGE_INTERVAL) {
            LocalizableException localizableException = new LocalizableException("rss.intervalError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "setInitialAgeInterval", "IntervalException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        this._ageInterval = n;
    }

    public int getJobsExecuted() {
        return this._jobsExecuted;
    }

    public boolean isPollingOn() {
        return this._pollOn;
    }

    public boolean isVerboseOn() {
        return this._verboseOn;
    }

    public void poll() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "poll");
        }
        try {
            this.fireOneShotPollJob("poll");
            this._util.refreshChannels();
        }
        catch (PersistenceManagerException persistenceManagerException) {
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "poll", "PersistencemanagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            throw localizableException;
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("rss.schedulingError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "poll", "SchedulerException: " + schedulerException.getLocalizedMessage(), schedulerException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "poll");
        }
    }

    public void refresh() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "refresh");
        }
        try {
            this._util.refreshChannels();
        }
        catch (PersistenceManagerException persistenceManagerException) {
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "refresh", "PersistencemanagerException: " + persistenceManagerException.getLocalizedMessage(), persistenceManagerException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "refresh");
        }
    }

    public void refresh(String string) throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "poll");
        }
        this._util.refreshChannel(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "poll");
        }
    }

    public String getChannelTitle(String string) throws LocalizableException {
        String string2 = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getChannelTitle");
        }
        string2 = this._util.getChannelTitle(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getChannelTitle");
        }
        return string2;
    }

    public void enablePolling() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "enablePolling");
        }
        try {
            this.setState("ON");
            this.pickleProperties();
        }
        catch (PersistenceException persistenceException) {
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "enablePolling", "PersistenceException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LocalizableException localizableException = new LocalizableException("rss.agg.configError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "enablePolling", "ConfigException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "enablePolling");
        }
    }

    public void disablePolling() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "disablePolling");
        }
        try {
            this.stopSchedule();
            this.setState("OFF");
            this.pickleProperties();
            this._nextPollTime = null;
        }
        catch (PersistenceException persistenceException) {
            LocalizableException localizableException = new LocalizableException("rss.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "disablePolling", "PersistenceException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LocalizableException localizableException = new LocalizableException("rss.agg.configError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "disablePolling", "ConfigException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("rss.schedulingError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "disablePolling", "SchedulerException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "disablePolling");
        }
    }

    public boolean isStoreRemoveOn() {
        return this._storeRemoveOn;
    }

    public void enableStoreRemove() {
        if (!this.isStoreRemoveOn()) {
            this._storeRemoveOn = true;
        }
    }

    public void disableStoreRemove() {
        if (this.isStoreRemoveOn()) {
            this._storeRemoveOn = false;
        }
    }

    public void enableVerbose() {
        this._log_hib_level = log_hib.getLevel();
        this._log_inf_level = log_inf.getLevel();
        this._log_http_level = log_http.getLevel();
        log_hib.setLevel(org.apache.log4j.Level.ALL);
        log_inf.setLevel(org.apache.log4j.Level.ALL);
        log_http.setLevel(org.apache.log4j.Level.ALL);
        if (!this.isVerboseOn()) {
            this._verboseOn = true;
            try {
                this.setLevel(this.getLogLevel());
                this.setLogLevel("FINER");
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
    }

    public void disableVerbose() {
        log_hib.setLevel(this._log_hib_level);
        log_inf.setLevel(this._log_inf_level);
        log_http.setLevel(this._log_http_level);
        if (this.isVerboseOn()) {
            this._verboseOn = false;
            try {
                this.setLogLevel(this.getLevel());
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
    }

    public String getLogLevel() {
        Level level = logger.getLevel();
        if (level == null) {
            return "null";
        }
        String string = logger.getLevel().getName();
        if (string == null) {
            string = Integer.toString(logger.getLevel().intValue());
        }
        return string;
    }

    protected void setLogLevel(String string) throws LocalizableException {
        try {
            if (string != null && string.length() != 0) {
                if (string.toLowerCase().equals("null")) {
                    logger.setLevel(null);
                } else {
                    logger.setLevel(Level.parse(string.toUpperCase()));
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.logp(Level.CONFIG, CLAZZ, "setLogLevel(String)", "Log level set to " + string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LocalizableException((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            LocalizableException localizableException = new LocalizableException("rss.agg.configError", "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization");
            logger.logp(Level.INFO, CLAZZ, "setLogLevel(String)", "ConfigException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
    }

    public String getLevel() {
        return this._level;
    }

    public void setLevel(String string) {
        this._level = string;
    }

    public Logger getMBeanLogger() {
        return logger;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnable;
    }

    public void setProxyEnabled(boolean bl) {
        if (bl) {
            this.proxyEnable = true;
            System.getProperties().put("proxySet", "true");
        } else {
            this.proxyEnable = false;
            System.getProperties().put("proxySet", "false");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "setProxyEnabled", "proxy enable.........[ " + System.getProperty("proxySet") + " ]");
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
        System.getProperties().put("proxyHost", this.proxyHost);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "setProxyHost", "proxy host.........[ " + System.getProperty("proxyHost") + " ]");
        }
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "setProxyPassword", "proxy password changed");
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
        System.getProperties().put("proxyPort", new Integer(this.proxyPort).toString());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "setProxyPort", "proxy port.........[ " + System.getProperty("proxyPort") + " ]");
        }
    }

    public String getProxyUserID() {
        return this.proxyUserID;
    }

    public void setProxyUserID(String string) {
        this.proxyUserID = string;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "setProxyUserID", "proxy user ID.........[ " + this.proxyUserID + " ]");
        }
    }

    public String getNoProxyList() {
        return this.noProxyList;
    }

    public void setNoProxyList(String string) {
        this.noProxyList = string;
        System.getProperties().setProperty("http.noProxyHosts", string);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "seNoProxyList", "no proxy list.........[ " + this.noProxyList + " ]");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MyAuthenticator
    extends Authenticator {
        MyAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(RssAggregatorImpl.this.getProxyUserID(), RssAggregatorImpl.this.getProxyPassword().toCharArray());
        }
    }
}

