/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.rss.aggregator.api;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class RssAggregatorConstants {
    public static final String DEFAULT_GROUP = "default";
    public static final String DEFAULT_CHANNEL_TITLE = "dflt_chan_title";
    public static final String DEFAULT_PROXY_HOST = "webgate.central.sun.com";
    public static final int DEFAULT_PROXY_PORT = 8080;
    private static String platform;
    private static String userAgent;
    public static final RssAggregatorConstants aggConstants;
    public static final String RSS_CONFIGURATION_FILE = "rss-config.xml";
    public static final String RSS_PUBLISH_CONFIGURATION_FILE = "xml/publish-config.xml";
    public static final String USERS_CONFIG = "users.properties";
    public static final String VERSION = "1.0.0";
    public static final int OPEN_ENDED_RANGE = -1;
    public static final int CONTENT_TYPE_TEXT = 1;
    public static final int CONTENT_TYPE_HTML = 2;
    public static final int CONTENT_TYPE_MIXED = 3;
    public static final String POLLING_INTERVAL_PROPERTY = "pollingInterval";
    public static final String AGE_INTERVAL_PROPERTY = "ageInterval";
    public static final String XML_ROOT_PROPERTY = "xmlRoot";
    public static final String XML_DEFAULT_ROOT = "/etc/opt/SUNWesmportal/xml/";
    public static final String REVISION = "1.0.0";
    public static final Integer MIN_POLLING_INTERVAL;
    public static final Integer MAX_POLLING_INTERVAL;
    public static final Integer DEFAULT_POLLING_INTERVAL;
    public static final Integer DEFAULT_CLEANING_INTERVAL;
    public static final Integer MIN_CLEANING_INTERVAL;
    public static final Integer MAX_CLEANING_INTERVAL;
    public static final Integer MIN_AGE_INTERVAL;
    public static final Integer MAX_AGE_INTERVAL;
    public static final Integer DEFAULT_AGE_INTERVAL;
    public static final Integer ONE_HOUR_OF_MILLIS;
    public static final Integer ONE_DAY_OF_MILLIS;
    public static final Integer ONE_WEEK_OF_MILLIS;
    public static final String RESOURCE_BUNDLE = "com/sun/netstorage/mgmt/esm/logic/collector/rss/aggregator/api/Localization";
    public static final String SCHEDULE_ERROR = "rss.schedulingError";
    public static final String UNSCHEDULE_ERROR = "rss.unschedulingError";
    public static final String PERSISTENCE_ERROR = "rss.persistenceError";
    public static final String INTERVAL_ERROR = "rss.intervalError";
    public static final String CONFIG_ERROR = "rss.agg.configError";
    public static final String UNKNOWN_HOST_ERROR = "rss.agg.unknownHost";
    public static final String MALFORMED_URL_ERROR = "rss.agg.malformedURL";
    public static final String IO_ERROR = "rss.agg.ioError";
    public static final String PARSE_ERROR = "rss.agg.parseError";
    public static final String URI_ERROR = "rss.agg.uriError";
    public static final String PROXY_AUTHENTICATION_REQUITED = "rss.agg.proxyAuthenticationRequired";
    public static final String UNAUTHERIZED = "rss.agg.unautherized";
    public static final String DOES_NOT_EXIST = "rss.agg.nonexistent";
    public static final String DECRYPT_ERROR = "rss.agg.decrypt";
    public static final String CHANNEL_EXISTS = "rss.agg.exists";
    public static final String JOB_PREFIX = "Job_";
    public static final String GRP_PREFIX = "Grp_";
    public static final String JOB_TRIG_PREFIX = "JobTrig_";
    public static final String GRP_TRIG_PREFIX = "GrpTrig_";
    public static final String SUFFIX = "_End";
    public static final String POLL_KEY = "Key";

    private RssAggregatorConstants() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        if ((string = System.getProperty("os.version")) != null) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        String string3 = System.getProperty("os.arch");
        if (string != null) {
            stringBuffer.append(string3);
        }
        platform = stringBuffer.toString();
        userAgent = "rss_aggregator/1.0.0 (" + platform + "; http://www.sun.com)";
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static String getCurrentHostName() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            inetAddress = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress());
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string == null) {
            string = "127.0.0.1";
        }
        return string;
    }

    static {
        aggConstants = new RssAggregatorConstants();
        MIN_POLLING_INTERVAL = new Integer(1);
        MAX_POLLING_INTERVAL = new Integer(24);
        DEFAULT_POLLING_INTERVAL = new Integer(3);
        MIN_CLEANING_INTERVAL = DEFAULT_CLEANING_INTERVAL = new Integer(MAX_POLLING_INTERVAL + 1);
        MAX_CLEANING_INTERVAL = DEFAULT_CLEANING_INTERVAL;
        MIN_AGE_INTERVAL = new Integer(8);
        MAX_AGE_INTERVAL = new Integer(1708);
        DEFAULT_AGE_INTERVAL = new Integer(8);
        ONE_HOUR_OF_MILLIS = new Integer(3600000);
        ONE_DAY_OF_MILLIS = new Integer(86400000);
        ONE_WEEK_OF_MILLIS = new Integer(604800000);
    }

    public static interface PollProps {
        public static final String CMD_KEY = "cmd";
        public static final String CHANNEL_JOB = "channelJob";
        public static final String OBJECT = "object";
        public static final String POLL_JOB = "pollJob";
    }

    public static interface FeedProps {
        public static final String TITLE_KEY = "title";
        public static final String STATIC_URL_KEY = "staticURL";
        public static final String ACTIVE_URL_KEY = "activeURL";
    }
}

