/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.data.api;

import java.util.HashSet;

public class StorageProfileTable {
    public static final String PROFILE_NAME_FIELD = "profile_name";
    public static final String PRODUCT_VERSION_FIELD = "product_version";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String RAID_LEVEL_FIELD = "raid_level";
    public static final String SEGMENT_SIZE_FIELD = "segment_size";
    public static final String READ_AHEAD_MODE_FIELD = "read_ahead_mode";
    public static final String DRIVE_TYPE_FIELD = "drive_type";
    public static final String NUMBER_OF_DISKS_FIELD = "number_of_disks";
    public static final String FACTORY_DEFINED_FIELD = "factory_defined";
    public static final String POOL_NAME_KEY_FIELD = "pool_name_key";
    public static final String DEVICE_NAME_KEY_FIELD = "device_name_key";
    public static final String STORAGE_DOMAIN_KEY_FIELD = "storage_domain_key";
    public static final String[] factory_names = new String[]{"Default", "Random5a", "Broadcast", "Legacy", "Random1", "MailSpooling", "HPC", "Sequential", "Oracle_OLTP", "Oracle_OLTP_HA", "Oracle_DSS", "Sybase_OLTP", "Sybase_OLTP_HA", "Sybase_DSS", "NFS_Stripe", "NFS_Mirror"};
    public HashSet hs_names = new HashSet();
    public String profile_name;
    public String product_version;
    public String description;
    public String raid_level;
    public String segment_size;
    public String read_ahead_mode;
    public String drive_type;
    public String number_of_disks;
    public boolean factory_defined = true;
    public String pool_name_key = "";
    public String device_name_key = "";
    public String storage_domain_key = "";

    public StorageProfileTable() {
        for (int i = 0; i < factory_names.length; ++i) {
            this.hs_names.add(factory_names[i]);
        }
    }

    public String getProfileName() {
        return this.profile_name;
    }

    public void setProfileName(String string) {
        this.profile_name = string;
    }

    public String getProductVersion() {
        return this.product_version;
    }

    public void setProductVersion(String string) {
        this.product_version = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getRaidLevel() {
        return this.raid_level;
    }

    public void setRaidLevel(String string) {
        this.raid_level = string;
    }

    public void setRaidLevel(boolean bl, int n, int n2, int n3) {
        String string = "5";
        if (n == 2) {
            string = "1";
        } else if (n2 == 0) {
            string = "0";
        }
        this.raid_level = string;
    }

    public String getSegmentSize() {
        return this.segment_size;
    }

    public void setSegmentSize(String string) {
        this.segment_size = string;
    }

    public void setSegmentSize(int n) {
        String string = "64K";
        if (n >= 0 && n < 5) {
            switch (n) {
                case 0: {
                    string = "4K";
                    break;
                }
                case 1: {
                    string = "8K";
                    break;
                }
                case 2: {
                    string = "16K";
                    break;
                }
                case 3: {
                    string = "32K";
                    break;
                }
                case 4: {
                    string = "64K";
                }
            }
        }
        this.segment_size = string;
    }

    public String getReadAheadMode() {
        return this.read_ahead_mode;
    }

    public void setReadAheadMode(String string) {
        this.read_ahead_mode = string;
    }

    public void setReadAheadMode(int n) {
        String string = "on";
        if (n > 5 && n <= 10) {
            string = "off";
        }
        this.read_ahead_mode = string;
    }

    public String getDriveType() {
        return this.drive_type;
    }

    public void setDriveType(String string) {
        this.drive_type = string;
    }

    public String getNumberOfDisks() {
        return this.number_of_disks;
    }

    public void setNumberOfDisks(String string) {
        this.number_of_disks = string;
    }

    public void setNumberOfDisks(int n) {
        String string = "variable";
        if (n > 0) {
            string = new String("" + n);
        }
        this.number_of_disks = string;
    }

    public boolean isFactoryDefined() {
        return this.hs_names.contains(this.getProfileName());
    }

    public void setFactoryDefined(boolean bl) {
        this.factory_defined = bl;
    }

    public String getPoolNameKey() {
        return this.pool_name_key;
    }

    public void setPoolNameKey(String string) {
        this.pool_name_key = string;
    }

    public String getDeviceNameKey() {
        if (this.isFactoryDefined()) {
            return "Factory";
        }
        return this.device_name_key;
    }

    public void setDeviceNameKey(String string) {
        this.device_name_key = string;
    }

    public String getStorageDomainKey() {
        return this.storage_domain_key;
    }

    public void setStorageDomainKey(String string) {
        this.storage_domain_key = string;
    }
}

