/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.data.api;

import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolTable;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Sort;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class StoragePoolBean
extends StoragePoolTable
implements PersistentObject {
    public static final String TABLE_NAME = "storage_pool";
    private static final String INSERT_COLUMN_NAMES = "pool_name, device_name, storage_domain, storage_profile, total_capacity, available_capacity, util_percentage, in_use, operations";

    public StoragePoolBean() {
    }

    public StoragePoolBean(StoragePoolTable storagePoolTable) {
        this.pool_name = storagePoolTable.getPoolName();
        this.device_name = storagePoolTable.getDeviceName();
        this.storage_domain = storagePoolTable.getStorageDomain();
        this.storage_profile = storagePoolTable.getStorageProfile();
        this.total_capacity = storagePoolTable.getTotalCapacity();
        this.available_capacity = storagePoolTable.getAvailableCapacity();
        this.util_percentage = storagePoolTable.getUtilPercentage();
        this.in_use = storagePoolTable.isInUse();
        this.operations = storagePoolTable.getOperations();
    }

    public void create(ResultSet resultSet, Transaction transaction) throws PersistenceException {
        try {
            this.pool_name = resultSet.getString("pool_name");
            this.device_name = resultSet.getString("device_name");
            this.storage_domain = resultSet.getString("storage_domain");
            this.storage_profile = resultSet.getString("storage_profile");
            this.total_capacity = resultSet.getLong("total_capacity");
            this.available_capacity = resultSet.getLong("available_capacity");
            this.util_percentage = resultSet.getFloat("util_percentage");
            this.in_use = resultSet.getBoolean("in_use");
            this.operations = resultSet.getString("operations");
        }
        catch (SQLException sQLException) {
            throw new PersistenceException((Throwable)sQLException);
        }
    }

    public String getInsertColumnNames() {
        return INSERT_COLUMN_NAMES;
    }

    public String getInsertString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'").append(this.getPoolName()).append("', ");
        stringBuffer.append("'").append(this.getDeviceName()).append("', ");
        stringBuffer.append("'").append(this.getStorageDomain()).append("', ");
        stringBuffer.append("'").append(this.getStorageProfile()).append("', ");
        stringBuffer.append(this.getTotalCapacity()).append(",");
        stringBuffer.append(this.getAvailableCapacity()).append(",");
        stringBuffer.append(this.getUtilPercentage()).append(",");
        stringBuffer.append("'").append(this.isInUse()).append("', ");
        stringBuffer.append("'").append(this.getOperations()).append("'");
        return stringBuffer.toString();
    }

    public HashMap getUpdateValues() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistentObject[] get(Transaction transaction, Filter filter, Sort[] sortArray) throws PersistenceException {
        PersistentObject[] persistentObjectArray;
        Statement statement = null;
        try {
            try {
                ResultSet resultSet;
                ArrayList<PersistentObject[]> arrayList = new ArrayList<PersistentObject[]>();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ").append(this.getInsertColumnNames());
                stringBuffer.append(" FROM ").append(this.getTableName());
                stringBuffer.append(filter == null ? "" : " WHERE " + filter.getFilterString());
                if (sortArray != null && sortArray.length > 0) {
                    stringBuffer.append(" ORDER BY ");
                    for (int i = 0; i < sortArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(sortArray[i].asSortString());
                    }
                }
                if ((resultSet = (statement = transaction.sendStatement(stringBuffer.toString())).getResultSet()) != null) {
                    while (resultSet.next()) {
                        persistentObjectArray = new StoragePoolBean();
                        persistentObjectArray.create(resultSet, transaction);
                        arrayList.add(persistentObjectArray);
                    }
                }
                persistentObjectArray = arrayList.toArray(new PersistentObject[arrayList.size()]);
                Object var10_12 = null;
                if (statement == null) return persistentObjectArray;
            }
            catch (PersistenceException persistenceException) {
                throw persistenceException;
            }
            catch (Exception exception) {
                throw new PersistenceException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return persistentObjectArray;
        }
        statement.close();
        return persistentObjectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StoragePoolBean[] getAll() throws PersistenceException {
        StoragePoolBean[] storagePoolBeanArray;
        block7: {
            storagePoolBeanArray = new StoragePoolBean[]{};
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            try {
                try {
                    persistenceManager = PersistenceManager.getInstance();
                    transaction = persistenceManager.getTransaction();
                    PersistentObject[] persistentObjectArray = this.get(transaction, null, null);
                    if (persistentObjectArray.length > 0) {
                        storagePoolBeanArray = new StoragePoolBean[persistentObjectArray.length];
                        for (int i = 0; i < persistentObjectArray.length; ++i) {
                            storagePoolBeanArray[i] = (StoragePoolBean)persistentObjectArray[i];
                        }
                    }
                    Object var7_8 = null;
                    if (persistenceManager == null) break block7;
                }
                catch (Exception exception) {
                    PersistenceException persistenceException = new PersistenceException((Throwable)exception);
                    throw persistenceException;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    transaction = null;
                    persistenceManager = null;
                }
                throw throwable;
            }
            persistenceManager.releaseTransaction(transaction);
            return storagePoolBeanArray;
        }
        return storagePoolBeanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(Transaction transaction) throws PersistenceException {
        Statement statement = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO " + this.getTableName());
            stringBuffer.append(" ( ");
            stringBuffer.append(this.getInsertColumnNames());
            stringBuffer.append(" ) ");
            stringBuffer.append("VALUES ( ");
            stringBuffer.append(this.getInsertString());
            stringBuffer.append(" ) ");
            statement = transaction.sendStatement(stringBuffer.toString());
            Object var5_4 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException sQLException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(Transaction transaction, Filter filter) throws PersistenceException {
        Statement statement = null;
        String string = filter == null ? "" : " WHERE " + filter.getFilterString();
        int n = 0;
        try {
            try {
                String string2 = "DELETE FROM " + this.getTableName() + string;
                statement = transaction.sendStatement(string2);
                n = statement.getUpdateCount();
            }
            catch (Exception exception) {
                throw new PersistenceException((Throwable)exception);
            }
            Object var8_8 = null;
            if (statement == null) return n;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return n;
    }

    public String getBeanName() {
        return "StoragePoolBean";
    }

    public String getTableName() {
        return TABLE_NAME;
    }
}

