/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.data.api;

import com.sun.netstorage.mgmt.esm.logic.data.api.Element;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ElementTable {
    public static final String NAME_FIELD = "name";
    public static final String TYPE_FIELD = "type";
    public static final String IP_ADDRESS_FIELD = "ip_address";
    public static final String MODEL_FIELD = "model";
    public static final String VENDOR_FIELD = "vendor";
    public static final String WWN_FIELD = "wwn";
    public static final String DEVICE_KEY_FIELD = "device_key";
    public static final String ELEMENT_MANAGER_FIELD = "element_manager";
    public static final String REMOVED_FIELD = "removed";
    public static final String DISCOVERED_FIELD = "discovered";
    private final Properties myProperties;
    private String name;
    private String type;
    private String ipAddress;
    private String model;
    private String vendor;
    private String wwn;
    private String deviceKey;
    private String elementManager;
    private String removed;
    private String discovered;

    public static String[] toStringArray(String string) {
        String[] stringArray = new String[]{};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public ElementTable(Element element) {
        this.myProperties = new Properties();
        this.name = element.getName();
        this.type = element.getType();
        this.ipAddress = element.getIpAddress();
        this.model = element.getModel();
        this.vendor = element.getVendor();
        this.wwn = element.getWwn();
        this.deviceKey = element.getDeviceKey();
        this.setProperty(NAME_FIELD, this.name);
        this.setProperty(TYPE_FIELD, this.type);
        this.setProperty(IP_ADDRESS_FIELD, this.ipAddress);
        this.setProperty(MODEL_FIELD, this.model);
        this.setProperty(VENDOR_FIELD, this.vendor);
        this.setProperty(WWN_FIELD, this.wwn);
        this.setProperty(DEVICE_KEY_FIELD, this.deviceKey);
    }

    public ElementTable(Properties properties) {
        this.myProperties = properties != null ? properties : new Properties();
    }

    public ElementTable() {
        this(new Properties());
    }

    public final Properties toProperties() {
        return this.myProperties;
    }

    public final String getProperty(String string) {
        if (string != null) {
            if (this.myProperties.contains(string)) {
                return this.myProperties.getProperty(string);
            }
            if (this.myProperties.contains(string.toLowerCase())) {
                return this.myProperties.getProperty(string.toLowerCase());
            }
            if (this.myProperties.contains(string.toUpperCase())) {
                return this.myProperties.getProperty(string.toUpperCase());
            }
        }
        return null;
    }

    public final void setProperty(String string, String string2) {
        if (string != null && string2 != null) {
            this.myProperties.setProperty(string, string2);
        }
    }

    public String getName() {
        if (this.name != null && this.name.length() > 127) {
            return "";
        }
        return this.name;
    }

    public String getType() {
        if (this.type != null && this.type.length() > 127) {
            return "";
        }
        return this.type;
    }

    public String getIpAddress() {
        if (this.ipAddress != null && this.ipAddress.length() > 32) {
            return "0.0.0.0";
        }
        return this.ipAddress;
    }

    public String getModel() {
        if (this.model != null && this.model.length() > 64) {
            return "";
        }
        return this.model;
    }

    public String getVendor() {
        if (this.vendor != null && this.vendor.length() > 64) {
            return "";
        }
        return this.vendor;
    }

    public String getWWN() {
        if (this.wwn != null && this.wwn.length() > 64) {
            return "unknown";
        }
        return this.wwn;
    }

    public String getDeviceKey() {
        if (this.deviceKey != null && this.deviceKey.length() > 127) {
            return "";
        }
        return this.deviceKey;
    }

    public String getElementManager() {
        if (this.elementManager != null && this.elementManager.length() > 1024) {
            return "";
        }
        return this.elementManager;
    }

    public String getRemoved() {
        if (this.removed != null && this.removed.length() > 32) {
            return "";
        }
        return this.removed;
    }

    public String getDiscovered() {
        if (this.discovered != null & this.discovered.length() > 32) {
            return "";
        }
        return this.discovered;
    }

    private Set getValueSet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.myProperties.getProperty(string);
        if (string2 != null) {
            String[] stringArray = ElementTable.toStringArray(string2);
            hashSet.addAll(Arrays.asList(stringArray));
        }
        return hashSet;
    }
}

