/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130;

import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Sort;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class PerformanceArray6130ControlBean
implements PersistentObject {
    public static final String TABLE_NAME = "Performance_6130_Collector";
    public static final String CONTROL_KEY_FIELD = "key";
    public static final String IP_ADDRESS_FIELD = "ip_address";
    public static final String ALTERNATE_IP_ADDRESS_FIELD = "alt_ip_address";
    public static final String WWN_FIELD = "wwn";
    public static final String NAME_FIELD = "name";
    public static final String STATE_FIELD = "state";
    public static final String STATUS_FIELD = "status";
    public static final String DATA_RETENTION_FIELD = "data_retention";
    public static final String POLLING_INTERVAL_FIELD = "pollingInterval";
    public static final String LAST_POLL_TIME_FIELD = "last_data_collection";
    private static final String INSERT_COLUMN_NAMES = "key, ip_address, alt_ip_address, wwn, name, state, status, data_retention, pollingInterval, last_data_collection";
    private String controlKey;
    private String ipAddress;
    private String alternateIpAddress;
    private String wwn;
    private String name;
    private String state;
    private String status;
    private long dataRetention;
    private long pollingInterval;
    private long lastPollTime;

    public void create(ResultSet resultSet, Transaction transaction) throws PersistenceException {
        try {
            this.controlKey = resultSet.getString(CONTROL_KEY_FIELD);
            this.ipAddress = resultSet.getString(IP_ADDRESS_FIELD);
            this.alternateIpAddress = resultSet.getString(ALTERNATE_IP_ADDRESS_FIELD);
            if (this.alternateIpAddress.length() == 0) {
                this.alternateIpAddress = null;
            }
            this.wwn = resultSet.getString(WWN_FIELD);
            this.name = resultSet.getString(NAME_FIELD);
            this.state = resultSet.getString(STATE_FIELD);
            if (this.state.length() == 0) {
                this.state = null;
            }
            this.status = resultSet.getString(STATUS_FIELD);
            if (this.status.length() == 0) {
                this.status = null;
            }
            this.dataRetention = resultSet.getLong(DATA_RETENTION_FIELD);
            this.pollingInterval = resultSet.getLong(POLLING_INTERVAL_FIELD);
            this.lastPollTime = resultSet.getLong(LAST_POLL_TIME_FIELD);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException((Throwable)sQLException);
        }
        catch (Exception exception) {
            throw new PersistenceException((Throwable)exception);
        }
    }

    public String getInsertColumnNames() {
        return INSERT_COLUMN_NAMES;
    }

    public String getInsertString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'").append(this.getControlKey());
        stringBuffer.append("', '").append(this.getIpAddress());
        String string = this.getAlternateIpAddress();
        if (string == null) {
            string = "";
        }
        stringBuffer.append("', '").append(string);
        stringBuffer.append("', '").append(this.getWWN());
        stringBuffer.append("', '").append(this.getName());
        string = this.getState();
        if (string == null) {
            string = "";
        }
        stringBuffer.append("', '").append(string);
        stringBuffer.append("', '").append(this.getStatus());
        stringBuffer.append("', ").append(this.getDataRetention());
        stringBuffer.append(", ").append(this.getPollingInterval());
        stringBuffer.append(", ").append(this.getLastPollTime());
        return stringBuffer.toString();
    }

    public String getBeanName() {
        return "PerformanceArray6130ControlBean";
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public HashMap getUpdateValues() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistentObject[] get(Transaction transaction, Filter filter, Sort[] sortArray) throws PersistenceException {
        PersistentObject[] persistentObjectArray;
        Statement statement = null;
        try {
            try {
                ResultSet resultSet;
                ArrayList<PersistentObject[]> arrayList = new ArrayList<PersistentObject[]>();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ").append(this.getInsertColumnNames());
                stringBuffer.append(" FROM ").append(this.getTableName());
                stringBuffer.append(filter == null ? "" : " WHERE " + filter.getFilterString());
                if (sortArray != null && sortArray.length > 0) {
                    stringBuffer.append(" ORDER BY ");
                    for (int i = 0; i < sortArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(sortArray[i].asSortString());
                    }
                }
                if ((resultSet = (statement = transaction.sendStatement(stringBuffer.toString())).getResultSet()) != null) {
                    while (resultSet.next()) {
                        persistentObjectArray = new PerformanceArray6130ControlBean();
                        persistentObjectArray.create(resultSet, transaction);
                        arrayList.add(persistentObjectArray);
                    }
                }
                persistentObjectArray = arrayList.toArray(new PersistentObject[arrayList.size()]);
                Object var10_12 = null;
                if (statement == null) return persistentObjectArray;
            }
            catch (PersistenceException persistenceException) {
                throw persistenceException;
            }
            catch (Exception exception) {
                throw new PersistenceException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return persistentObjectArray;
        }
        statement.close();
        return persistentObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(Transaction transaction) throws PersistenceException {
        Statement statement = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO " + this.getTableName());
            stringBuffer.append(" ( ");
            stringBuffer.append(this.getInsertColumnNames());
            stringBuffer.append(" ) ");
            stringBuffer.append("VALUES ( ");
            stringBuffer.append(this.getInsertString());
            stringBuffer.append(" ) ");
            statement = transaction.sendStatement(stringBuffer.toString());
            Object var5_4 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException sQLException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(Transaction transaction, Filter filter) throws PersistenceException {
        Statement statement = null;
        String string = filter == null ? "" : " WHERE " + filter.getFilterString();
        int n = 0;
        try {
            try {
                String string2 = "DELETE FROM " + this.getTableName() + string;
                statement = transaction.sendStatement(string2);
                n = statement.getUpdateCount();
            }
            catch (Exception exception) {
                throw new PersistenceException((Throwable)exception);
            }
            Object var8_8 = null;
            if (statement == null) return n;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return n;
    }

    public String getAlternateIpAddress() {
        return this.alternateIpAddress;
    }

    public void setAlternateIpAddress(String string) {
        this.alternateIpAddress = string;
    }

    public InetAddress getAlternateInetAddress() throws LocalizableException {
        try {
            String string = this.getAlternateIpAddress();
            if (string == null) {
                return null;
            }
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new LocalizableException("perfDataCollector.6130.unknownHostException", (Throwable)unknownHostException, new Serializable[]{this.getAlternateIpAddress()}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/array6130/api/Localization");
        }
    }

    public String getControlKey() {
        return this.controlKey;
    }

    public void setControlKey(String string) {
        this.controlKey = string;
    }

    public long getDataRetention() {
        return this.dataRetention;
    }

    public void setDataRetention(long l) {
        this.dataRetention = l;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public InetAddress getInetAddress() throws LocalizableException {
        try {
            String string = this.getIpAddress();
            if (string == null) {
                return null;
            }
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new LocalizableException("perfDataCollector.6130.unknownHostException", (Throwable)unknownHostException, new Serializable[]{this.getIpAddress()}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/array6130/api/Localization");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long l) {
        this.lastPollTime = l;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long l) {
        this.pollingInterval = l;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getWWN() {
        return this.wwn;
    }

    public void setWWN(String string) {
        this.wwn = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Key=\"").append(this.getControlKey());
        stringBuffer.append("\", Name=\"").append(this.getName());
        stringBuffer.append("\", IpAddress=").append(this.getIpAddress());
        stringBuffer.append(", Alt IpAddress=").append(this.getAlternateIpAddress());
        stringBuffer.append(", WWN=").append(this.getWWN());
        stringBuffer.append(", Data Retention=").append(this.getDataRetention());
        stringBuffer.append(", Polling Interval=").append(this.getPollingInterval());
        stringBuffer.append(", Last Poll Completed At=");
        stringBuffer.append(new Date(this.getLastPollTime()));
        stringBuffer.append(" (").append(this.getLastPollTime()).append(")");
        stringBuffer.append(", State=").append(this.getState());
        stringBuffer.append(", Status=").append(this.getStatus());
        return stringBuffer.toString();
    }
}

