/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.data.api.performance;

import com.sun.netstorage.mgmt.esm.logic.data.api.performance.MeasurementType;
import com.sun.netstorage.mgmt.esm.util.l10n.Localize;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;

public final class PerfMetricType
implements Serializable {
    private final transient String name;
    private final transient MeasurementType measurementType;
    public static PerfMetricType IOPS = new PerfMetricType("ios", MeasurementType.PER_SEC);
    public static PerfMetricType READ_PERCENTAGE = new PerfMetricType("readPercentage", MeasurementType.PERCENTAGE);
    public static PerfMetricType WRITE_PERCENTAGE = new PerfMetricType("writePercentage", MeasurementType.PERCENTAGE);
    public static PerfMetricType CACHE_READ_HIT_PERCENTAGE = new PerfMetricType("cacheReadHitPercentage", MeasurementType.PERCENTAGE);
    public static PerfMetricType TOTAL_DATA_TRANSFERRED_KB_PER_SEC = new PerfMetricType("xTransferredKBperSec", MeasurementType.KB_PER_SEC);
    public static PerfMetricType DATA_READ_KB_PER_SEC = new PerfMetricType("dataReadKBperSec", MeasurementType.KB_PER_SEC);
    public static PerfMetricType DATA_WRITTEN_KB_PER_SEC = new PerfMetricType("dataWrittenKBperSec", MeasurementType.KB_PER_SEC);
    public static PerfMetricType AVERAGE_READ_SIZE_BYTES = new PerfMetricType("averageReadSizeBytes", MeasurementType.BYTES);
    public static PerfMetricType AVERAGE_WRITE_SIZE_BYTES = new PerfMetricType("averageWriteSizeBytes", MeasurementType.BYTES);
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    private static final PerfMetricType[] METRIC_TYPE = new PerfMetricType[]{IOPS, READ_PERCENTAGE, WRITE_PERCENTAGE, CACHE_READ_HIT_PERCENTAGE, TOTAL_DATA_TRANSFERRED_KB_PER_SEC, DATA_READ_KB_PER_SEC, DATA_WRITTEN_KB_PER_SEC, AVERAGE_READ_SIZE_BYTES, AVERAGE_WRITE_SIZE_BYTES};

    PerfMetricType(String string, MeasurementType measurementType) {
        this.name = string;
        this.measurementType = measurementType;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedString(Locale locale) {
        return Localize.getString((String)"com/sun/netstorage/mgmt/esm/logic/data/api/performance/Localization", (String)this.name, (Locale)locale);
    }

    public MeasurementType getMeasurementType() {
        return this.measurementType;
    }

    public static PerfMetricType getObject(String string) {
        for (int i = 0; i < METRIC_TYPE.length; ++i) {
            if (!METRIC_TYPE[i].getName().equals(string)) continue;
            return METRIC_TYPE[i];
        }
        return null;
    }

    public String toString() {
        return this.getLocalizedString(Locale.getDefault());
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    Object readResolve() throws ObjectStreamException {
        return METRIC_TYPE[this.ordinal];
    }
}

