/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl;

import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSummary;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.common.impl.StoradeClientException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.AlarmDataObject;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthEnvironmental;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StringPrintWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoradeHealthCollectorUtil {
    private static final String INSERT_STATEMENT_PREFIX = "INSERT INTO ALARM (id, devicekey, devicename, devicetype, element, description, time, severity, state) ";
    private static final String DELETE_ALL_ROWS = "DELETE FROM ALARM";
    private static final boolean debug = true;
    private StoradeHealthEnvironmental storadeEnv = null;
    private String agentLocation = null;
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl = StoradeHealthCollectorUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthCollectorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl).getName());
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorUtil = StoradeHealthCollectorUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthCollectorUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorUtil).getName();
    private static final String sccs_id = "@(#)StoradeHealthCollectorUtil.java 1.13    05/07/29 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorUtil;

    public StoradeHealthCollectorUtil(StoradeHealthEnvironmental storadeHealthEnvironmental, String string) throws StoradeClientException {
        this.storadeEnv = storadeHealthEnvironmental;
        this.agentLocation = string;
    }

    public AlarmDataObject[] getAlarmSummaries() throws StoradeClientException {
        AlarmDataObject[] alarmDataObjectArray;
        block17: {
            alarmDataObjectArray = null;
            try {
                AlarmSummary[] alarmSummaryArray = this.storadeEnv.getAlarms(this.agentLocation);
                if (alarmSummaryArray != null && alarmSummaryArray.length > 0) {
                    alarmDataObjectArray = new AlarmDataObject[alarmSummaryArray.length];
                    for (int i = 0; i < alarmSummaryArray.length; ++i) {
                        String string;
                        alarmDataObjectArray[i] = new AlarmDataObject();
                        Date date = alarmSummaryArray[i].getDate();
                        if (date != null) {
                            alarmDataObjectArray[i].date = date.getTime();
                        } else {
                            alarmDataObjectArray[i].date = new GregorianCalendar().getTimeInMillis();
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.WARNING, CLAZZ, "getAlarmSummaries", "Manufacturing an alarm date: " + new Date(alarmDataObjectArray[i].date).toString());
                            }
                        }
                        alarmDataObjectArray[i].id = alarmSummaryArray[i].getId();
                        alarmDataObjectArray[i].severity = alarmSummaryArray[i].getSeverity();
                        alarmDataObjectArray[i].state = alarmSummaryArray[i].getState();
                        alarmDataObjectArray[i].devicekey = alarmSummaryArray[i].getDeviceKey();
                        alarmDataObjectArray[i].devicename = alarmSummaryArray[i].getDeviceName();
                        alarmDataObjectArray[i].devicetype = alarmSummaryArray[i].getDeviceType();
                        alarmDataObjectArray[i].element = alarmSummaryArray[i].getElement();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.INFO, CLAZZ, "getAlarmSummaries", "ALARM[" + i + "]\n" + "id...........[ " + alarmDataObjectArray[i].id + " ]\n" + "deviceKey....[ " + alarmDataObjectArray[i].devicekey + " ]\n" + "deviceName...[ " + alarmDataObjectArray[i].devicename + "\t]\n" + "element......[ " + alarmDataObjectArray[i].element + " ]\n" + "time.........[ " + new Date(alarmDataObjectArray[i].date).toString() + " ]\n" + "severity.....[ " + alarmDataObjectArray[i].severity + " ]\n" + "state........[ " + alarmDataObjectArray[i].state + " ]\n");
                        }
                        try {
                            alarmDataObjectArray[i].description = this.storadeEnv.getAlarmDescription(this.agentLocation, alarmSummaryArray[i].getId());
                        }
                        catch (StoradeException storadeException) {
                            logger.logp(Level.WARNING, CLAZZ, "getAlarmSummaries", "StoradeException: " + storadeException.getLocalizedMessage());
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.WARNING, CLAZZ, "getAlarmSummaries", "StoradeException stack trace: " + storadeException.getLocalizedMessage(), storadeException);
                            }
                            alarmDataObjectArray[i].description = "Unable to aquire";
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.INFO, CLAZZ, "getAlarmSummaries", "description..[ " + alarmDataObjectArray[i].description + " ]\n");
                        }
                        if ((string = alarmSummaryArray[i].getDeviceType()) != null && !string.equalsIgnoreCase("host")) {
                            String string2 = alarmSummaryArray[i].getDeviceKey();
                            try {
                                alarmDataObjectArray[i].devicetype = this.storadeEnv.getCategory(this.agentLocation, string2);
                            }
                            catch (StoradeException storadeException) {
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.WARNING, CLAZZ, "getAlarmSummaries", "StoradeException stack trace: " + storadeException.getLocalizedMessage(), storadeException);
                                }
                                alarmDataObjectArray[i].devicetype = "Unable to aquire";
                            }
                        }
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.INFO, CLAZZ, "getAlarmSummaries", "deviceType...[ " + alarmDataObjectArray[i].devicetype + " ]\n");
                    }
                    break block17;
                }
                alarmDataObjectArray = new AlarmDataObject[]{};
            }
            catch (StoradeException storadeException) {
                logger.logp(Level.WARNING, CLAZZ, "getAlarmSummaries", "StoradeException: " + storadeException.getLocalizedMessage());
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.WARNING, CLAZZ, "getAlarmSummaries", "StoradeException stack trace: " + storadeException.getLocalizedMessage(), storadeException);
                }
                alarmDataObjectArray = new AlarmDataObject[]{};
            }
        }
        return alarmDataObjectArray;
    }

    public static String escapeText(String string) {
        return StoradeHealthCollectorUtil.escapeTextStyleString(string, false);
    }

    public static void escapeText(Writer writer, String string) throws IOException {
        StoradeHealthCollectorUtil.escapeTextStyleString(writer, string, false);
    }

    public static String escapeTextScript(String string) {
        return StoradeHealthCollectorUtil.escapeTextStyleString(string, true);
    }

    public static void escapeTextScript(Writer writer, String string) throws IOException {
        StoradeHealthCollectorUtil.escapeTextStyleString(writer, string, true);
    }

    private static String escapeTextStyleString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            StringPrintWriter stringPrintWriter = new StringPrintWriter(string.length() * 2);
            StoradeHealthCollectorUtil.escapeTextStyleString(stringPrintWriter, string, bl);
            return stringPrintWriter.getString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static void escapeTextStyleString(Writer writer, String string, boolean bl) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                writer.write("\\u" + StoradeHealthCollectorUtil.hex(c));
                continue;
            }
            if (c > '\u00ff') {
                writer.write("\\u0" + StoradeHealthCollectorUtil.hex(c));
                continue;
            }
            if (c > '\u007f') {
                writer.write("\\u00" + StoradeHealthCollectorUtil.hex(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        writer.write(92);
                        writer.write(98);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\f': {
                        writer.write(92);
                        writer.write(102);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            writer.write("\\u00" + StoradeHealthCollectorUtil.hex(c));
                            break;
                        }
                        writer.write("\\u000" + StoradeHealthCollectorUtil.hex(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    if (bl) {
                        writer.write(92);
                    }
                    writer.write(39);
                    continue block12;
                }
                case '\"': {
                    writer.write(92);
                    writer.write(34);
                    continue block12;
                }
                case '\\': {
                    writer.write(92);
                    writer.write(92);
                    continue block12;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase();
    }

    public static String unescapeText(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringPrintWriter stringPrintWriter = new StringPrintWriter(string.length());
            StoradeHealthCollectorUtil.unescapeText(stringPrintWriter, string);
            return stringPrintWriter.getString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void unescapeText(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(4);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer.append(c);
                if (stringBuffer.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer.toString(), 16);
                    writer.write((char)n2);
                    stringBuffer.setLength(0);
                    bl2 = false;
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        break;
                    }
                    case '\'': {
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(34);
                        break;
                    }
                    case 'r': {
                        writer.write(13);
                        break;
                    }
                    case 'f': {
                        writer.write(12);
                        break;
                    }
                    case 't': {
                        writer.write(9);
                        break;
                    }
                    case 'n': {
                        writer.write(10);
                        break;
                    }
                    case 'b': {
                        writer.write(8);
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        writer.write(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            writer.write(c);
        }
        if (bl) {
            writer.write(92);
        }
    }

    public static String unescapeTextScript(String string) {
        return StoradeHealthCollectorUtil.unescapeText(string);
    }

    public static void unescapeTextScript(Writer writer, String string) throws IOException {
        StoradeHealthCollectorUtil.unescapeText(writer, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

