/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.common.impl.StoradeClientException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.api.StoradeHealthCollectorConstants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.api.StoradeHealthMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.AlarmDataObject;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.State;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthCollectorUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthEnvironmental;
import com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.Element_alarm;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthCollectorBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.AndFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.scheduler.impl.SchedulerUtilImpl;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;

public class StoradeHealthCollectorImpl
extends StandardMBean
implements StoradeHealthMBean,
NotificationListener {
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthCollectorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl).getName());
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthCollectorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl).getName();
    private static String ONESHOT = "OneShot";
    private static String POLL = "Poll";
    private StoradeHealthEnvironmental f_storadeEnv = null;
    private MBeanServer myMbs = null;
    private Object myMutex = new Object();
    private String _name = "StorADE_Health_Collector";
    private int _interval = StoradeHealthCollectorConstants.DEFAULT_POLLING_INTERVAL;
    private String _rev = "1.0.0";
    private String _host = "localhost";
    private String _port = "7654";
    private boolean _pollOn = false;
    private boolean _pollInProgress = false;
    private String _state = "ON";
    private boolean _persisted = false;
    private String _key = null;
    private Date _nextPollTime = null;
    int _jobsExecuted = 0;
    private boolean _verboseOn;
    String _level;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthCollectorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean;

    public StoradeHealthCollectorImpl(Class clazz, String string, Properties properties, StoradeHealthEnvironmental storadeHealthEnvironmental) throws Exception {
        super(clazz);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "StoradeHealthCollectorImpl");
        }
        this.f_storadeEnv = storadeHealthEnvironmental;
        if (properties != null && string != null && clazz != null) {
            int n;
            this.setKey(string);
            String string2 = properties.getProperty("pollingInterval");
            if (string2 == null) {
                try {
                    n = Integer.parseInt(string2);
                    this.setPollInterval(n);
                }
                catch (Exception exception) {
                    this.setPollInterval(StoradeHealthCollectorConstants.DEFAULT_POLLING_INTERVAL);
                }
            }
            if ((string2 = properties.getProperty("host")) == null) {
                this.setHost("localhost");
            } else {
                this.setHost(string2);
            }
            string2 = properties.getProperty("port");
            if (string2 == null) {
                this.setPort("7654");
            } else {
                this.setPort(string2);
            }
            n = this.isPersistence(true) ? 1 : 0;
            if (n == 0) {
                this.pickleProperties();
                if (this.getState().equalsIgnoreCase("ON")) {
                    this.enablePolling();
                }
            }
        } else {
            logger.logp(Level.CONFIG, CLAZZ, "StoradeHealthCollectorImpl", "missing call argument");
            throw new IllegalArgumentException();
        }
        this.start();
        this.setLevel(this.getLogLevel());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "StoradeHealthCollectorImpl");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "handleNotification");
            logger.logp(Level.INFO, CLAZZ, "handleNotification", "\nNotification: type.." + notification.getType() + "\n              msg..." + notification.getMessage());
        }
        if (notification.getType().equalsIgnoreCase("Element.Update")) {
            try {
                this.fireOneShotPollJob();
            }
            catch (SchedulerException schedulerException) {
                logger.logp(Level.INFO, CLAZZ, "handleNotification", "Event error:", schedulerException.getMessage());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collectAll() throws LocalizableException, StoradeClientException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "collectAll");
        }
        ++this._jobsExecuted;
        PersistentObject[] persistentObjectArray = this.myMutex;
        synchronized (this.myMutex) {
            if (this._pollInProgress) {
                LocalizableException localizableException = new LocalizableException("health.pollInProgress", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
                if (!logger.isLoggable(Level.FINER)) throw localizableException;
                logger.logp(Level.INFO, CLAZZ, "collectAll", "Poll already in progress: " + localizableException.getLocalizedMessage());
                throw localizableException;
            }
            this._pollInProgress = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            try {
                AlarmDataObject[][] alarmDataObjectArrayArray;
                block25: {
                    persistentObjectArray = null;
                    PersistenceManager persistenceManager = null;
                    Transaction transaction = null;
                    try {
                        try {
                            persistenceManager = PersistenceManager.getInstance();
                            transaction = persistenceManager.getTransaction();
                            alarmDataObjectArrayArray = new EqualsFilter("type", "storade");
                            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean, (Filter)alarmDataObjectArrayArray);
                            persistenceManager.releaseTransaction(transaction);
                        }
                        catch (PersistenceException persistenceException) {
                            LocalizableException localizableException = new LocalizableException("health.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
                            logger.logp(Level.WARNING, CLAZZ, "collectAll", "PersistenceException: " + localizableException.getLocalizedMessage(), localizableException);
                            throw localizableException;
                        }
                        catch (TransactionException transactionException) {
                            LocalizableException localizableException = new LocalizableException("health.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
                            logger.logp(Level.WARNING, CLAZZ, "collectAll", "TransactionException: " + localizableException.getLocalizedMessage(), localizableException);
                            throw localizableException;
                        }
                        Object var8_8 = null;
                        if (persistenceManager == null) break block25;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (persistenceManager == null) throw throwable;
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                        throw throwable;
                    }
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                if (persistentObjectArray == null) {
                    if (!logger.isLoggable(Level.FINER)) return;
                    logger.logp(Level.FINER, CLAZZ, "collectAll", "agent table empty");
                    return;
                }
                alarmDataObjectArrayArray = new AlarmDataObject[persistentObjectArray.length][];
                String[] stringArray = new String[persistentObjectArray.length];
                int n = 0;
                for (int i = 0; i < persistentObjectArray.length; ++i) {
                    AgentLocationBean agentLocationBean = (AgentLocationBean)persistentObjectArray[i];
                    if (agentLocationBean == null) continue;
                    String string = agentLocationBean.getAgentLocation();
                    String string2 = agentLocationBean.getType();
                    try {
                        if (!string2.equals("storade")) continue;
                        alarmDataObjectArrayArray[n] = this.getAlarmData(string);
                        stringArray[n] = string;
                        ++n;
                        continue;
                    }
                    catch (StoradeClientException storadeClientException) {
                        logger.logp(Level.WARNING, CLAZZ, "collectAll", "StoradeClientException: " + storadeClientException.getLocalizedMessage() + " [" + string + "]");
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.WARNING, CLAZZ, "collectAll", "StoradeClientException stack trace:", storadeClientException);
                    }
                }
                try {
                    StoradeHealthCollectorImpl.markAlarms();
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "collectAll", "Exception caught marking alarms", exception);
                }
                if (n != 0) {
                    for (int i = 0; i < n; ++i) {
                        if (alarmDataObjectArrayArray[i] == null) continue;
                        try {
                            this.persistAlarmsUsingBean(stringArray[i], alarmDataObjectArrayArray[i]);
                            continue;
                        }
                        catch (PersistenceException persistenceException) {
                            logger.logp(Level.WARNING, CLAZZ, "collectAll", "PersistenceException: URL - " + stringArray[i] + persistenceException.getLocalizedMessage());
                        }
                    }
                    StoradeHealthCollectorImpl.removeStaleAlarms();
                    try {
                        this.materializeElementAlarmTable();
                    }
                    catch (PersistenceException persistenceException) {
                        logger.logp(Level.WARNING, CLAZZ, "collectAll", "PersistenceException: element_alarm table", persistenceException);
                    }
                }
            }
            finally {
                this._pollInProgress = false;
            }
            if (!logger.isLoggable(Level.FINER)) return;
            logger.exiting(CLAZZ, "collectAll");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void materializeElementAlarmTable() throws PersistenceException {
        block15: {
            Transaction transaction;
            PersistenceManager persistenceManager;
            block14: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.entering(CLAZZ, "materializeElementAlarmTable");
                }
                persistenceManager = null;
                try {
                    persistenceManager = PersistenceManager.getInstance();
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "materializeElementAlarmTable", "PersistenceManager");
                    throw new PersistenceException((Throwable)exception);
                }
                transaction = null;
                Object var4_4 = null;
                transaction = persistenceManager.getTransaction();
                try {
                    transaction.begin();
                    new Element_alarm().addAlarmSeverityInfo(transaction);
                    transaction.commit();
                }
                catch (Exception exception) {
                    transaction.rollback();
                    logger.logp(Level.WARNING, CLAZZ, "materializeElementAlarmTable", "materializeElementAlarmTable drop", exception);
                }
                if (!logger.isLoggable(Level.FINER)) break block14;
                logger.logp(Level.FINER, CLAZZ, "materializeElementAlarmTable", "materializeElementAlarmTable successful");
            }
            Object var7_7 = null;
            try {
                persistenceManager.releaseTransaction(transaction);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "materializeElementAlarmTable", "release transaction", exception);
            }
            break block15;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "materializeElementAlarmTable", "materializeElementAlarmTable", exception);
                    Object var7_8 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "materializeElementAlarmTable", "release transaction", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "materializeElementAlarmTable", "release transaction", exception);
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "materializeElementAlarmTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeAlarmsFromPersistence() throws PersistenceException {
        block10: {
            PersistenceManager persistenceManager = null;
            try {
                persistenceManager = PersistenceManager.getInstance();
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "removeAlarmsFromPersistence", "PersistenceManager");
                throw new PersistenceException((Throwable)exception);
            }
            Transaction transaction = null;
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.deleteAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean);
            transaction.commit();
            Object var6_4 = null;
            try {
                persistenceManager.releaseTransaction(transaction);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "removeAlarmsFromPersistence", "release transaction", exception);
            }
            break block10;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "removeAlarmsFromPersistence", "deleteAll", exception);
                    Object var6_5 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "removeAlarmsFromPersistence", "release transaction", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "removeAlarmsFromPersistence", "release transaction", exception);
                }
                throw throwable;
            }
        }
    }

    private AlarmDataObject[] getAlarmData(String string) throws StoradeClientException {
        AlarmDataObject[] alarmDataObjectArray;
        block4: {
            StoradeHealthCollectorUtil storadeHealthCollectorUtil = null;
            alarmDataObjectArray = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "getAlarmData");
            }
            try {
                storadeHealthCollectorUtil = new StoradeHealthCollectorUtil(this.f_storadeEnv, string);
                alarmDataObjectArray = storadeHealthCollectorUtil.getAlarmSummaries();
            }
            catch (StoradeClientException storadeClientException) {
                logger.logp(Level.WARNING, CLAZZ, "getAlarmData", "StoradeClientException: " + storadeClientException.getLocalizedMessage() + "\t[" + string + "]");
                if (!logger.isLoggable(Level.FINER)) break block4;
                logger.logp(Level.WARNING, CLAZZ, "getAlarmData", "StoradeClientException stack trace:", storadeClientException);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getAlarmData");
        }
        return alarmDataObjectArray;
    }

    private void collect(String string, String string2) throws PersistenceException, StoradeClientException {
        StoradeHealthCollectorUtil storadeHealthCollectorUtil = null;
        AlarmDataObject[] alarmDataObjectArray = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "collect");
        }
        try {
            storadeHealthCollectorUtil = new StoradeHealthCollectorUtil(this.f_storadeEnv, string);
            alarmDataObjectArray = storadeHealthCollectorUtil.getAlarmSummaries();
        }
        catch (StoradeClientException storadeClientException) {
            logger.logp(Level.WARNING, CLAZZ, "collect", "StoradeClientException: " + storadeClientException.getLocalizedMessage() + "\t[" + string + "]", storadeClientException);
            throw storadeClientException;
        }
        this.persistAlarmsUsingBean(string, alarmDataObjectArray);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "collect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistAlarmsUsingBean(String string, AlarmDataObject[] alarmDataObjectArray) throws PersistenceException {
        int n = 0;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "persistAlarmsUsingBeans");
        }
        StoradeHealthBean storadeHealthBean = new StoradeHealthBean();
        storadeHealthBean.setAgent(string);
        storadeHealthBean.setAgentType("storade");
        storadeHealthBean.setLocation(string);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.INFO, CLAZZ, "persistAlarmsUsingBeans", " : [ " + alarmDataObjectArray.length + "\t] alarms from [\t" + string + " ]");
        }
        for (int i = 0; i < alarmDataObjectArray.length; ++i) {
            storadeHealthBean.setAlarmId(alarmDataObjectArray[i].id);
            storadeHealthBean.setDeviceKey(alarmDataObjectArray[i].devicekey);
            storadeHealthBean.setDeviceName(StoradeHealthCollectorUtil.escapeTextScript(alarmDataObjectArray[i].devicename));
            storadeHealthBean.setDeviceType(alarmDataObjectArray[i].devicetype);
            storadeHealthBean.setElement(alarmDataObjectArray[i].element);
            storadeHealthBean.setDescription(StoradeHealthCollectorUtil.escapeTextScript(alarmDataObjectArray[i].description));
            storadeHealthBean.setTime(alarmDataObjectArray[i].date);
            storadeHealthBean.setSeverity((short)alarmDataObjectArray[i].severity);
            storadeHealthBean.setState((short)alarmDataObjectArray[i].state);
            storadeHealthBean.setDiscovered(true);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.INFO, CLAZZ, "persistAlarmsUsingBeans", "BEAN[" + i + "]\n" + "id...........[ " + storadeHealthBean.getAlarmId() + " ]\n" + "deviceKey....[ " + storadeHealthBean.getDeviceKey() + " ]\n" + "deviceName...[ " + storadeHealthBean.getDeviceName() + "\t]\n" + "deviceType...[ " + storadeHealthBean.getDeviceType() + " ]\n" + "element......[ " + storadeHealthBean.getElement() + " ]\n" + "description..[ " + storadeHealthBean.getDescription() + " ]\n" + "time.........[ " + new Date(storadeHealthBean.getTime()).toString() + " ]\n" + "severity.....[ " + storadeHealthBean.getSeverity() + " ]\n" + "state........[ " + storadeHealthBean.getState() + " ]\n");
            }
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            boolean bl = false;
            transaction = null;
            try {
                try {
                    persistenceManager = PersistenceManager.getInstance();
                    transaction = persistenceManager.getTransaction();
                    transaction.begin();
                }
                catch (PersistenceException persistenceException) {
                    logger.logp(Level.WARNING, CLAZZ, "persistAlarmsUsingBeans", "PersistenceException(get transaction):  alarmId = " + storadeHealthBean.getAlarmId() + "\tdeviceKey = " + storadeHealthBean.getDeviceKey() + "\tmsg = " + persistenceException.getLocalizedMessage(), persistenceException);
                    throw persistenceException;
                }
                catch (TransactionException transactionException) {
                    logger.logp(Level.WARNING, CLAZZ, "persistAlarmsUsingBeans", "TransactionException(get transaction):  alarmId = " + storadeHealthBean.getAlarmId() + "\tdeviceKey = " + storadeHealthBean.getDeviceKey() + "\tmsg = " + transactionException.getLocalizedMessage(), transactionException);
                    throw new PersistenceException((Throwable)transactionException);
                }
                EqualsFilter equalsFilter = new EqualsFilter("time", storadeHealthBean.getTime());
                EqualsFilter equalsFilter2 = new EqualsFilter("id", storadeHealthBean.getAlarmId());
                AndFilter andFilter = new AndFilter((Filter)equalsFilter, (Filter)equalsFilter2);
                PersistentObject[] persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean == null ? StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthBean") : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean, (Filter)andFilter);
                if (persistentObjectArray == null || persistentObjectArray.length == 0) {
                    if (alarmDataObjectArray[i].state != 1) {
                        try {
                            transaction.put((PersistentObject)storadeHealthBean);
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, CLAZZ, "persistAlarmsUsingBeans", "BEAN[" + i + "] INSERTED");
                            }
                        }
                        catch (PersistenceException persistenceException) {
                            logger.logp(Level.WARNING, CLAZZ, "persistAlarmsUsingBeans", "PersistenceException(put alarm): alarmId = " + storadeHealthBean.getAlarmId() + " deviceKey =\t" + storadeHealthBean.getDeviceKey() + " time = " + storadeHealthBean.getTime() + " msg\t= " + persistenceException.getLocalizedMessage(), persistenceException);
                            transaction.rollback();
                        }
                        catch (RuntimeException runtimeException) {
                            logger.logp(Level.WARNING, CLAZZ, "persistAlarmsUsingBeans", "PersistenceException(RuntimeException): alarmId = " + storadeHealthBean.getAlarmId() + " deviceKey =\t" + storadeHealthBean.getDeviceKey() + " msg\t= " + runtimeException.getLocalizedMessage(), runtimeException);
                            transaction.rollback();
                        }
                        try {
                            transaction.commit();
                        }
                        catch (PersistenceException persistenceException) {
                            logger.logp(Level.WARNING, CLAZZ, "persistAlarmsUsingBeans", "PersistenceException(commit alarm):  alarmId =\t" + storadeHealthBean.getAlarmId() + " deviceKey =\t" + storadeHealthBean.getDeviceKey() + " msg\t= " + persistenceException.getLocalizedMessage(), persistenceException);
                            transaction.rollback();
                        }
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLAZZ, "persistAlarmsUsingBeans", "BEAN[" + i + "] has been acknowledged; ignore");
                    continue;
                }
                String[] stringArray = new String[]{"discovered"};
                String[] stringArray2 = new String[]{Boolean.toString(true)};
                try {
                    transaction.begin();
                    StoradeHealthBean.update((Transaction)transaction, (String[])stringArray, (String[])stringArray2, (Filter)andFilter);
                    transaction.commit();
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLAZZ, "persistAlarmsUsingBeans", "BEAN[" + i + "] UPDATED");
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "persistAlarmsUsingBeans", "Exception caught persisting alarm: alarmId = " + storadeHealthBean.getAlarmId() + " deviceKey = " + storadeHealthBean.getDeviceKey() + " msg = " + exception.getLocalizedMessage(), exception);
                    transaction.rollback();
                }
                continue;
            }
            catch (PersistenceException persistenceException) {
                ++n;
                continue;
            }
            finally {
                if (transaction != null) {
                    StoradeHealthCollectorImpl.cleanupTransaction(persistenceManager, transaction);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "persistAlarmsUsingBeans");
        }
        if (n != 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.INFO, CLAZZ, "persistAlarmsUsingBeans", " : errors processing alarms[ " + n + " ] ");
            }
            throw new PersistenceException("health.persistenceError");
        }
    }

    private void start() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "start");
        }
        try {
            this.scheduleOneShotPollJob();
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            logger.logp(Level.WARNING, CLAZZ, "start", objectAlreadyExistsException.getLocalizedMessage());
            throw new SchedulerException((Exception)((Object)objectAlreadyExistsException));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "start");
        }
    }

    public void stop() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "stop");
        }
        this.unschedulePollJob();
        this.unscheduleOneshotJob();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "stop");
        }
        if (this.isVerboseOn()) {
            try {
                this.setLogLevel(this.getLevel());
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
    }

    protected String getAgentLocation() {
        String string = this.getHost();
        String string2 = this.getPort();
        return "http://" + string + ":" + string2;
    }

    private void changeSchedule() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "changeSchedule");
        }
        String string = this.getJobTriggerName(POLL);
        String string2 = this.getJobTriggerGroupName(POLL);
        String string3 = this.getJobTriggerName(POLL);
        String string4 = this.getJobTriggerName(POLL);
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        if (this.getState().equalsIgnoreCase("ON")) {
            scheduler.unscheduleJob(string, string2);
            scheduler.deleteJob(string3, string4);
            this.startSchedule();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "changeSchedule");
        }
    }

    private void startSchedule() throws ObjectAlreadyExistsException, SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "startSchedule");
        }
        this.schedulePollJob(this.getPollInterval());
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "startSchedule");
        }
    }

    private String getJobTriggerName(String string) {
        String string2 = "JobTrig_" + string + "_" + this.getKey() + "_Health";
        return string2;
    }

    private String getJobTriggerGroupName(String string) {
        String string2 = "GrpTrig_" + string + "_" + this.getKey() + "_Health";
        return string2;
    }

    private String getJobName(String string) {
        String string2 = "Job_" + string + "_" + this.getKey() + "_Health";
        return string2;
    }

    private String getJobGroupName(String string) {
        String string2 = "Grp_" + string + "_" + this.getKey() + "_Health";
        return string2;
    }

    private void scheduleOneShotPollJob() throws SchedulerException, ObjectAlreadyExistsException {
        Scheduler scheduler;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "scheduleOneShotPollJob");
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobTriggerName(ONESHOT);
        String string2 = this.getJobTriggerName(ONESHOT);
        JobDetail jobDetail = new JobDetail(string, string2, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthPollJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob);
        jobDetail.getJobDataMap().put("Key", this.getKey());
        jobDetail.getJobDataMap().put((Object)"object", (Object)this);
        jobDetail.setDurability(true);
        scheduler.addJob(jobDetail, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.WARNING, CLAZZ, "scheduleOneShotPollJob", "oneshot job scheduled");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "scheduleOneShotPollJob");
        }
    }

    private void fireOneShotPollJob() throws SchedulerException {
        Scheduler scheduler;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "fireOneShotPollJob");
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobTriggerName(ONESHOT);
        String string2 = this.getJobTriggerName(ONESHOT);
        scheduler.triggerJob(string, string2);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.WARNING, CLAZZ, "fireOneShotPollJob", "oneshot job started");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "fireOneShotPollJob");
        }
    }

    private void schedulePollJob(int n) throws SchedulerException {
        Scheduler scheduler;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "schedulePollJob");
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        long l = TriggerUtils.getNextGivenSecondDate(null, (int)15).getTime();
        String string = this.getJobTriggerName(POLL);
        String string2 = this.getJobTriggerGroupName(POLL);
        String string3 = this.getJobTriggerName(POLL);
        String string4 = this.getJobTriggerName(POLL);
        JobDetail jobDetail = new JobDetail(string3, string4, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.health.impl.StoradeHealthPollJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$health$impl$StoradeHealthPollJob);
        jobDetail.getJobDataMap().put("Key", this.getKey());
        jobDetail.getJobDataMap().put((Object)"object", (Object)this);
        SimpleTrigger simpleTrigger = new SimpleTrigger(string, string2, string3, string4, new Date(l), null, SimpleTrigger.REPEAT_INDEFINITELY, 60000L * (long)n);
        Date date = null;
        try {
            date = scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
            this._pollOn = true;
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            logger.logp(Level.INFO, CLAZZ, "schedulePollJob", "job exists [" + string3 + " ]");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "schedulePollJob");
        }
    }

    private void stopSchedule() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "stopSchedule");
        }
        this.unschedulePollJob();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "stopSchedule");
        }
    }

    private void unscheduleOneshotJob() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "unscheduleOneshotJob");
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobTriggerName(ONESHOT);
        String string2 = this.getJobTriggerName(ONESHOT);
        scheduler.deleteJob(string, string2);
        this._pollOn = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "unscheduleOneshotJob");
        }
    }

    private void unschedulePollJob() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "unschedulePollJob");
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobTriggerName(POLL);
        String string2 = this.getJobTriggerGroupName(POLL);
        String string3 = this.getJobTriggerName(POLL);
        String string4 = this.getJobTriggerName(POLL);
        scheduler.unscheduleJob(string, string2);
        scheduler.deleteJob(string3, string4);
        this._pollOn = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "unschedulePollJob");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pickleProperties() throws PersistenceException {
        Object object;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "pickleProperties");
        }
        PersistenceManager persistenceManager = null;
        persistenceManager = PersistenceManager.getInstance();
        StoradeHealthCollectorBean storadeHealthCollectorBean = new StoradeHealthCollectorBean();
        storadeHealthCollectorBean.setCollectorKey(this.getKey());
        storadeHealthCollectorBean.setName(this.getName());
        storadeHealthCollectorBean.setHostName(this.getHost());
        storadeHealthCollectorBean.setPort(this.getPort());
        storadeHealthCollectorBean.setState(this.getState());
        storadeHealthCollectorBean.setPollingRate(Integer.toString(this.getPollInterval()));
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "key.........[ " + this.getKey() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "host........[ " + this.getHost() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "port........[ " + this.getPort() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "state.......[ " + this.getPort() + " ]");
            logger.logp(Level.FINER, CLAZZ, "pickleProperties", "polInterval.[ " + this.getPort() + " ]");
            object = this.getName();
            if (object != null) {
                logger.logp(Level.FINER, CLAZZ, "pickleProperties", "name........[ " + this.getName() + "\t]");
            }
        }
        object = null;
        try {
            try {
                object = persistenceManager.getTransaction();
            }
            catch (TransactionException transactionException) {
                // empty catch block
            }
            object.begin();
            object.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean, (Filter)new EqualsFilter("collectorKey", this.getKey()));
            object.put((PersistentObject)storadeHealthCollectorBean);
            object.commit();
        }
        finally {
            persistenceManager.releaseTransaction(object);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "pickleProperties");
        }
    }

    public boolean isPersisted() {
        return this._persisted;
    }

    /*
     * Loose catch block
     */
    private boolean isPersistence(boolean bl) throws LocalizableException {
        boolean bl2;
        block19: {
            bl2 = false;
            PersistentObject[] persistentObjectArray = null;
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "isPersistence");
            }
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthCollectorBean, (Filter)new EqualsFilter("collectorKey", this.getKey()));
            transaction.commit();
            Object var10_6 = null;
            persistenceManager.releaseTransaction(transaction);
            if (persistentObjectArray == null || persistentObjectArray.length == 0) break block19;
            bl2 = true;
            if (!bl) break block19;
            this.setHost(((StoradeHealthCollectorBean)persistentObjectArray[0]).getHostName());
            this.setPort(((StoradeHealthCollectorBean)persistentObjectArray[0]).getPort());
            this.setState(((StoradeHealthCollectorBean)persistentObjectArray[0]).getState());
            try {
                this.setPollInterval(Integer.parseInt(((StoradeHealthCollectorBean)persistentObjectArray[0]).getPollingRate()));
            }
            catch (NumberFormatException object) {
                logger.logp(Level.WARNING, CLAZZ, "isPersistence", "NumberFormatException: " + ((Throwable)object).getLocalizedMessage(), (Throwable)object);
            }
            catch (Exception object) {
                logger.logp(Level.WARNING, CLAZZ, "isPersistence", "Exception:\t" + ((Throwable)object).getLocalizedMessage(), (Throwable)object);
            }
            if (!logger.isLoggable(Level.FINER)) break block19;
            logger.logp(Level.FINER, CLAZZ, "isPersistence", "key.........[ " + this.getKey() + " ]");
            logger.logp(Level.FINER, CLAZZ, "isPersistence", "host........[ " + this.getHost() + " ]");
            logger.logp(Level.FINER, CLAZZ, "isPersistence", "port........[ " + this.getPort() + " ]");
            logger.logp(Level.FINER, CLAZZ, "isPersistence", "state.......[ " + this.getState() + " ]");
            logger.logp(Level.FINER, CLAZZ, "isPersistence", "polInterval.[ " + this.getPollInterval() + " ]");
            object = this.getName();
            if (object != null) {
                logger.logp(Level.FINER, CLAZZ, "isPersistence", "name........[ " + this.getName() + " ]");
            }
            break block19;
            {
                catch (PersistenceException persistenceException) {
                    LocalizableException localizableException = new LocalizableException("health.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
                    logger.logp(Level.WARNING, CLAZZ, "isPersistence", "PersistenceException: " + localizableException.getLocalizedMessage(), localizableException);
                    throw localizableException;
                }
                catch (TransactionException transactionException) {
                    LocalizableException localizableException = new LocalizableException("health.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
                    logger.logp(Level.WARNING, CLAZZ, "isPersistence", "TransactionException: " + localizableException.getLocalizedMessage(), localizableException);
                    throw localizableException;
                }
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                persistenceManager.releaseTransaction(transaction);
                if (persistentObjectArray != null && persistentObjectArray.length != 0) {
                    bl2 = true;
                    if (bl) {
                        this.setHost(((StoradeHealthCollectorBean)persistentObjectArray[0]).getHostName());
                        this.setPort(((StoradeHealthCollectorBean)persistentObjectArray[0]).getPort());
                        this.setState(((StoradeHealthCollectorBean)persistentObjectArray[0]).getState());
                        try {
                            this.setPollInterval(Integer.parseInt(((StoradeHealthCollectorBean)persistentObjectArray[0]).getPollingRate()));
                        }
                        catch (NumberFormatException object) {
                            logger.logp(Level.WARNING, CLAZZ, "isPersistence", "NumberFormatException: " + ((Throwable)object).getLocalizedMessage(), (Throwable)object);
                        }
                        catch (Exception object) {
                            logger.logp(Level.WARNING, CLAZZ, "isPersistence", "Exception:\t" + ((Throwable)object).getLocalizedMessage(), (Throwable)object);
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLAZZ, "isPersistence", "key.........[ " + this.getKey() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "isPersistence", "host........[ " + this.getHost() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "isPersistence", "port........[ " + this.getPort() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "isPersistence", "state.......[ " + this.getState() + " ]");
                            logger.logp(Level.FINER, CLAZZ, "isPersistence", "polInterval.[ " + this.getPollInterval() + " ]");
                            object = this.getName();
                            if (object != null) {
                                logger.logp(Level.FINER, CLAZZ, "isPersistence", "name........[ " + this.getName() + " ]");
                            }
                        }
                    }
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "isPersistence");
        }
        return bl2;
    }

    protected void setStoradeHealthEnvironment(StoradeHealthEnvironmental storadeHealthEnvironmental) {
        this.f_storadeEnv = storadeHealthEnvironmental;
    }

    private void setPersisted(boolean bl) {
        this._persisted = bl;
    }

    public String getNextPollTime() {
        String string = null;
        if (this._nextPollTime != null) {
            string = this._nextPollTime.toString();
        }
        return string;
    }

    public void setNextPollTime(Date date) {
        this._nextPollTime = date;
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String string) {
        this._key = string;
    }

    public String getState() {
        return this._state;
    }

    public void setState(String string) throws IllegalArgumentException {
        boolean bl = false;
        Enumeration enumeration = State.elements();
        while (enumeration.hasMoreElements()) {
            State state = (State)enumeration.nextElement();
            if (!state.toString().equalsIgnoreCase(string)) continue;
            this._state = string;
            bl = true;
            if (!logger.isLoggable(Level.FINER)) break;
            logger.logp(Level.INFO, CLAZZ, "setState", " :\tstate strg= " + state.toString() + "  ord= " + state.ord);
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String string) {
        this._port = string;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getRevision() {
        return this._rev;
    }

    public int getMinPollInterval() {
        int n = StoradeHealthCollectorConstants.MIN_POLLING_INTERVAL;
        return n;
    }

    public int getMaxPollInterval() {
        int n = StoradeHealthCollectorConstants.MAX_POLLING_INTERVAL;
        return n;
    }

    public int getDefaultPollInterval() {
        int n = StoradeHealthCollectorConstants.DEFAULT_POLLING_INTERVAL;
        return n;
    }

    public int getPollInterval() {
        return this._interval;
    }

    public void setPollInterval(int n) throws Exception {
        if (n < StoradeHealthCollectorConstants.MIN_POLLING_INTERVAL || n > StoradeHealthCollectorConstants.MAX_POLLING_INTERVAL) {
            LocalizableException localizableException = new LocalizableException("health.intervalError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "setPollInterval", "IntervalException:\t" + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        this._interval = n;
        this.changeSchedule();
    }

    public int getJobsExecuted() {
        return this._jobsExecuted;
    }

    public boolean isPollingOn() {
        return this._pollOn;
    }

    public boolean isVerboseOn() {
        return this._verboseOn;
    }

    public void poll() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "poll");
        }
        if (this._pollInProgress) {
            LocalizableException localizableException = new LocalizableException("health.pollInProgress", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLAZZ, "poll", "Poll already in progress: " + localizableException.getLocalizedMessage());
            }
            throw localizableException;
        }
        try {
            this.fireOneShotPollJob();
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("health.schedulingError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "poll", "SchedulerException: " + schedulerException.getLocalizedMessage(), schedulerException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "poll");
        }
    }

    public void enablePolling() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "enablePolling");
        }
        try {
            this.startSchedule();
            this.setState("ON");
            this.pickleProperties();
        }
        catch (PersistenceException persistenceException) {
            LocalizableException localizableException = new LocalizableException("health.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "enablePolling", "PersistenceException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LocalizableException localizableException = new LocalizableException("health.configError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "enablePolling", "ConfigException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("health.schedulingError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "enablePolling", "SchedulerException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "enablePolling");
        }
    }

    public void disablePolling() throws LocalizableException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "disablePolling");
        }
        try {
            this.stopSchedule();
            this.setState("OFF");
            this.pickleProperties();
            this._nextPollTime = null;
        }
        catch (PersistenceException persistenceException) {
            LocalizableException localizableException = new LocalizableException("health.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "disablePolling", "PersistenceException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LocalizableException localizableException = new LocalizableException("health.configError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "disablePolling", "ConfigException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        catch (SchedulerException schedulerException) {
            LocalizableException localizableException = new LocalizableException("health.schedulingError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "disablePolling", "SchedulerException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "disablePolling");
        }
    }

    public void enableVerbose() {
        if (!this.isVerboseOn()) {
            this._verboseOn = true;
            try {
                this.setLevel(this.getLogLevel());
                this.setLogLevel("FINER");
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
    }

    public void disableVerbose() {
        if (this.isVerboseOn()) {
            this._verboseOn = false;
            try {
                this.setLogLevel(this.getLevel());
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
        }
    }

    public String getLogLevel() {
        Level level = logger.getLevel();
        if (level == null) {
            return "null";
        }
        String string = logger.getLevel().getName();
        if (string == null) {
            string = Integer.toString(logger.getLevel().intValue());
        }
        return string;
    }

    protected void setLogLevel(String string) throws LocalizableException {
        try {
            if (string != null && string.length() != 0) {
                if (string.toLowerCase().equals("null")) {
                    logger.setLevel(null);
                } else {
                    logger.setLevel(Level.parse(string.toUpperCase()));
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.logp(Level.CONFIG, CLAZZ, "setLogLevel(String)", "Log level set to " + string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LocalizableException((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            LocalizableException localizableException = new LocalizableException("health.configError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/health/api/Localization");
            logger.logp(Level.WARNING, CLAZZ, "setLogLevel(String)", "ConfigException: " + localizableException.getLocalizedMessage(), localizableException);
            throw localizableException;
        }
    }

    public String getLevel() {
        return this._level;
    }

    public void setLevel(String string) {
        this._level = string;
    }

    public Logger getMBeanLogger() {
        return logger;
    }

    private static void cleanupTransaction(PersistenceManager persistenceManager, Transaction transaction) {
        if (persistenceManager != null) {
            try {
                persistenceManager.releaseTransaction(transaction);
                persistenceManager = null;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "cleanupTransaction", "Exception caught releasing database transaction", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void markAlarms() throws Exception {
        block13: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "markAlarms");
            }
            Object var1 = null;
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            StoradeHealthBean.update((Transaction)transaction, (String[])new String[]{"discovered"}, (String[])new String[]{"false"}, null);
            transaction.commit();
            Object var6_3 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block13;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "markAlarms", "exception caught releasing transaction", exception);
            }
            break block13;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "markAlarms", "Exception caught marking alarms as stale");
                    Object var6_4 = null;
                    try {
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block13;
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "markAlarms", "exception caught releasing transaction", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "markAlarms", "exception caught releasing transaction", exception);
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "markAlarms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void removeStaleAlarms() {
        block13: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "removeStaleAlarms");
            }
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean = StoradeHealthCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeHealthBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeHealthBean, (Filter)new EqualsFilter("discovered", false));
            transaction.commit();
            Object var5_2 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block13;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "removeStaleAlarms", "Exception caught releasing transaction", exception);
            }
            break block13;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "removeStaleAlarms", "Exception caught deleting stale alarms", exception);
                    Object var5_3 = null;
                    try {
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block13;
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "removeStaleAlarms", "Exception caught releasing transaction", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "removeStaleAlarms", "Exception caught releasing transaction", exception);
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "removeStaleAlarms");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

