/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.CollectorState;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.api.PoolConstants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.impl.ActiveCimomThread;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.PoolTaskThread;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.Trace;
import com.sun.netstorage.mgmt.esm.logic.data.api.ElementTable;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.PoolControlBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolTable;
import com.sun.netstorage.mgmt.esm.logic.data.api.StorageProfileBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.StorageProfileTable;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoolCollectorImpl
implements PoolConstants {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final int DEFAULT_POLLING_RATE = 5;
    private static final String CLASSNAME = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorImpl = PoolCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.PoolCollectorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorImpl).getName();
    private static final Logger logger = PoolConstants.LOGGER;
    private static final String COLLECTOR_NAME_PREFIX = "Pool Collector: ";
    private static final ClockDaemon clockDaemon = new ClockDaemon();
    private Object dataCollectionLock = new Object();
    private Hashtable poolTable = new Hashtable();
    private Object poolTaskID = null;
    private String collectorName;
    private PoolControlBean controlBean;
    private ActiveCimomThread activethread = new ActiveCimomThread();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean;

    public PoolCollectorImpl(String string, String string2, String string3) throws LocalizableException {
        if (string != null) {
            this.controlBean = new PoolControlBean();
            this.controlBean.setIpAddress(string);
            this.controlBean.setUsername(string2);
            this.controlBean.setPassword(string3);
            this.controlBean.setStatus(OperationalStatus.STOPPED.toString());
            this.controlBean.setPollingInterval(5L);
            this.setCollectorName(null, string);
            this.setState(CollectorState.OFF);
            this.updateControlRecord();
        }
    }

    public PoolCollectorImpl(PoolControlBean poolControlBean) {
        this.controlBean = poolControlBean;
        poolControlBean.setStatus(OperationalStatus.UNKNOWN.toString());
        if (poolControlBean.getPollingInterval() == 0L) {
            poolControlBean.setPollingInterval(5L);
        }
        this.setCollectorName(null, poolControlBean.getIpAddress());
        CollectorState collectorState = CollectorState.getState((String)poolControlBean.getState());
        if (CollectorState.ON.equals((Object)collectorState)) {
            this.start();
        } else {
            this.stop();
        }
    }

    public String getKey() {
        return this.controlBean.getIpAddress();
    }

    public String[] getCredentials() {
        if (this.controlBean.getUsername() == null || this.controlBean.getPassword() == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.controlBean.getPassword().length(); ++i) {
            stringBuffer.append("*");
        }
        return new String[]{this.controlBean.getUsername(), stringBuffer.toString()};
    }

    public long getLastPollTime() {
        return this.controlBean.getLastPollTime();
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    private void setCollectorName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(COLLECTOR_NAME_PREFIX);
        if (string != null) {
            stringBuffer.append(string);
        } else if (string2 != null) {
            stringBuffer.append("(").append(string2).append(")");
        }
        if (stringBuffer.length() > 64) {
            stringBuffer.delete(64, stringBuffer.length());
        }
        this.collectorName = stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void start(long l) {
        block27: {
            if (this.poolTaskID != null && OperationalStatus.OK.equals((Object)this.getOperationalStatus())) {
                return;
            }
            try {
                this.activethread.add(this.controlBean.getIpAddress(), this.controlBean.getUsername(), this.controlBean.getPassword());
            }
            catch (Exception exception) {
                try {
                    this.setOperationalStatus(OperationalStatus.NON_RECOVERABLE_ERROR);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            this.activethread.start();
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean = PoolCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean, (Filter)new EqualsFilter("device_name", this.controlBean.getIpAddress()));
            transaction.commit();
            Object var8_6 = null;
            try {
                if (transaction != null) {
                    persistenceManager.releaseTransaction(transaction);
                }
                transaction = null;
            }
            catch (Exception exception) {
                Trace.error(this, exception);
            }
            break block27;
            {
                catch (Exception exception) {
                    Trace.verbose((Object)this, "start", "delete transaction failed");
                    Object var8_7 = null;
                    try {
                        if (transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                        }
                        transaction = null;
                    }
                    catch (Exception exception3) {
                        Trace.error(this, exception3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    transaction = null;
                }
                catch (Exception exception) {
                    Trace.error(this, exception);
                }
                throw throwable;
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.dataCollectionLock;
        synchronized (object) {
            PoolCollectorImpl poolCollectorImpl = this;
            synchronized (poolCollectorImpl) {
                this.setState(CollectorState.ON);
                if (this.poolTaskID == null) {
                    this.setOperationalStatus(OperationalStatus.STARTING);
                } else {
                    if (!OperationalStatus.OK.equals((Object)this.getOperationalStatus())) {
                        this.setOperationalStatus(OperationalStatus.STARTING);
                    }
                    ClockDaemon.cancel((Object)this.poolTaskID);
                }
                this.setOperationalStatus(OperationalStatus.OK);
                boolean bl = false;
                this.poolTaskID = clockDaemon.executePeriodically(l, (Runnable)new PoolTaskThread(this), bl);
            }
        }
    }

    public void start() {
        this.start(this.controlBean.getPollingInterval() * 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void shutdown() {
        block27: {
            Transaction transaction;
            PersistenceManager persistenceManager;
            block25: {
                this.stop();
                this.activethread.stop();
                persistenceManager = null;
                transaction = null;
                persistenceManager = PersistenceManager.getInstance();
                transaction = persistenceManager.getTransaction();
                transaction.begin();
                transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean = PoolCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.PoolControlBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean, (Filter)new EqualsFilter("ip_address", this.controlBean.getIpAddress()));
                transaction.commit();
                Object var6_3 = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    break block25;
                }
                catch (Exception exception) {
                    logger.logp(Level.FINEST, CLASSNAME, "shutdown", exception.getMessage(), exception);
                }
                break block25;
                {
                    catch (PersistenceException persistenceException) {
                        logger.logp(Level.SEVERE, CLASSNAME, "shutdown", "Failed to delete pool control record for collector " + this.getCollectorName(), persistenceException);
                        Object var6_4 = null;
                        try {
                            if (transaction != null) {
                                persistenceManager.releaseTransaction(transaction);
                            }
                            break block25;
                        }
                        catch (Exception exception) {
                            logger.logp(Level.FINEST, CLASSNAME, "shutdown", exception.getMessage(), exception);
                        }
                        break block25;
                    }
                    catch (TransactionException transactionException) {
                        logger.logp(Level.SEVERE, CLASSNAME, "shutdown", "Transaction failed on delete of pool control record for collector" + this.getCollectorName(), transactionException);
                        Object var6_5 = null;
                        try {
                            if (transaction != null) {
                                persistenceManager.releaseTransaction(transaction);
                            }
                            break block25;
                        }
                        catch (Exception exception) {
                            logger.logp(Level.FINEST, CLASSNAME, "shutdown", exception.getMessage(), exception);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        if (transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                        }
                    }
                    catch (Exception exception) {
                        logger.logp(Level.FINEST, CLASSNAME, "shutdown", exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean = PoolCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean, (Filter)new EqualsFilter("device_name", this.controlBean.getIpAddress()));
            transaction.commit();
            Object var9_15 = null;
            try {
                if (transaction != null) {
                    persistenceManager.releaseTransaction(transaction);
                }
                transaction = null;
            }
            catch (Exception exception) {
                Trace.error(this, exception);
            }
            break block27;
            {
                catch (Exception exception) {
                    Trace.verbose((Object)this, "shutdown", "delete transaction failed");
                    Object var9_16 = null;
                    try {
                        if (transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                        }
                        transaction = null;
                    }
                    catch (Exception exception2) {
                        Trace.error(this, exception2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    transaction = null;
                }
                catch (Exception exception) {
                    Trace.error(this, exception);
                }
                throw throwable;
            }
        }
    }

    public void stop() {
        this.setState(CollectorState.OFF);
        if (!OperationalStatus.STOPPED.equals((Object)this.getOperationalStatus())) {
            if (this.poolTaskID != null) {
                this.setOperationalStatus(OperationalStatus.STOPPING);
                ClockDaemon.cancel((Object)this.poolTaskID);
                this.poolTaskID = null;
            }
            this.setOperationalStatus(OperationalStatus.STOPPED);
        }
    }

    public String getOperationalStatus() {
        return this.controlBean.getStatus().toString();
    }

    void setOperationalStatus(OperationalStatus operationalStatus) {
        if (!this.controlBean.getStatus().equals(operationalStatus.toString())) {
            this.controlBean.setStatus(operationalStatus.toString());
            this.updateControlRecord();
        }
    }

    public String getState() {
        return this.controlBean.getState();
    }

    void setState(CollectorState collectorState) {
        this.controlBean.setState(collectorState.toString());
    }

    public int getPollingInterval() {
        return (int)this.controlBean.getPollingInterval();
    }

    public void setPollingInterval(int n) throws LocalizableException {
        this.controlBean.setPollingInterval((long)n);
        this.updateControlRecord();
    }

    private void findAndHandleDeletedPools(List list) {
        String[] stringArray = this.poolTable.keySet().toArray(new String[this.poolTable.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (list.contains(stringArray[i])) continue;
            this.poolTable.remove(stringArray[i]);
        }
    }

    private void handleElementInfo(Set set) {
        ElementTable[] elementTableArray = set.toArray(new ElementTable[set.size()]);
        if (elementTableArray == null || elementTableArray.length != 1) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void fetch() {
        StorageProfileTable[] storageProfileTableArray;
        StorageProfileBean storageProfileBean;
        Transaction transaction;
        PersistenceManager persistenceManager;
        block39: {
            block38: {
                if (!this.activethread.getRunFlag()) {
                    this.setOperationalStatus(OperationalStatus.STOPPED);
                    return;
                }
                long l = new Date().getTime() - this.activethread.getLastActiveCimomConnectTime();
                if (l > 0L && l < 10000L) {
                    try {
                        Thread.sleep(15000L - l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                persistenceManager = null;
                transaction = null;
                try {
                    persistenceManager = PersistenceManager.getInstance();
                }
                catch (PersistenceException persistenceException) {
                    Trace.error(this, (Exception)((Object)persistenceException));
                    return;
                }
                transaction = persistenceManager.getTransaction();
                transaction.begin();
                transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean = PoolCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoragePoolBean, (Filter)new EqualsFilter("device_name", this.controlBean.getIpAddress()));
                transaction.commit();
                storageProfileBean = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    transaction = null;
                }
                catch (Exception exception) {
                    Trace.error(this, exception);
                }
                break block38;
                {
                    catch (Exception exception) {
                        Trace.verbose((Object)this, "fetch", "delete transaction failed");
                        Object var8_9 = null;
                        try {
                            if (transaction != null) {
                                persistenceManager.releaseTransaction(transaction);
                            }
                            transaction = null;
                        }
                        catch (Exception exception2) {
                            Trace.error(this, exception2);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                        }
                        transaction = null;
                    }
                    catch (Exception exception) {
                        Trace.error(this, exception);
                    }
                    throw throwable;
                }
            }
            StoragePoolTable[] storagePoolTableArray = this.activethread.getDiscoveredStoragePools();
            storageProfileTableArray = this.activethread.getDiscoveredStorageProfiles();
            if (storagePoolTableArray != null && storagePoolTableArray.length > 0) {
                transaction = persistenceManager.getTransaction();
                transaction.begin();
                for (int i = 0; i < storagePoolTableArray.length; ++i) {
                    storageProfileBean = new StoragePoolBean(storagePoolTableArray[i]);
                    transaction.put((PersistentObject)storageProfileBean);
                }
                transaction.commit();
                Object var11_20 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                    transaction = null;
                }
                catch (Exception exception3) {
                    Trace.error(this, exception3);
                }
                break block39;
                {
                    catch (Exception exception) {
                        Trace.verbose((Object)this, "fetch", "databean put transaction failed");
                        var11_20 = null;
                        try {
                            persistenceManager.releaseTransaction(transaction);
                            transaction = null;
                        }
                        catch (Exception exception3) {
                            Trace.error(this, exception3);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_21 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                        transaction = null;
                    }
                    catch (Exception exception) {
                        Trace.error(this, exception);
                    }
                    throw throwable;
                }
            }
        }
        for (int i = 0; i < storageProfileTableArray.length; ++i) {
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            storageProfileBean = new StorageProfileBean(storageProfileTableArray[i]);
            transaction.put((PersistentObject)storageProfileBean);
            transaction.commit();
            Object var14_26 = null;
            try {
                persistenceManager.releaseTransaction(transaction);
                transaction = null;
            }
            catch (Exception exception4) {
                Trace.error(this, exception4);
            }
            continue;
            {
                catch (Exception exception) {
                    var14_26 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                        transaction = null;
                    }
                    catch (Exception exception4) {
                        Trace.error(this, exception4);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_26 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                    transaction = null;
                }
                catch (Exception exception4) {
                    Trace.error(this, exception4);
                }
                throw throwable;
            }
        }
        persistenceManager = null;
        long l = new Date().getTime();
        if (l != this.controlBean.getLastPollTime()) {
            this.controlBean.setLastPollTime(l);
            this.updateControlRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void updateControlRecord() {
        block10: {
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean = PoolCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.PoolControlBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$PoolControlBean, (Filter)new EqualsFilter("ip_address", this.controlBean.getIpAddress()));
            transaction.put((PersistentObject)this.controlBean);
            transaction.commit();
            Object var6_3 = null;
            try {
                persistenceManager.releaseTransaction(transaction);
                transaction = null;
            }
            catch (Exception exception) {
                logger.logp(Level.FINEST, CLASSNAME, "updateControlRecord", exception.getMessage(), exception);
            }
            break block10;
            {
                catch (PersistenceException persistenceException) {
                    logger.logp(Level.SEVERE, CLASSNAME, "updateControlRecord", "Failed to persist pool data records for collector " + this.getCollectorName(), persistenceException);
                    Object var6_4 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                        transaction = null;
                    }
                    catch (Exception exception) {
                        logger.logp(Level.FINEST, CLASSNAME, "updateControlRecord", exception.getMessage(), exception);
                    }
                    break block10;
                }
                catch (TransactionException transactionException) {
                    logger.logp(Level.SEVERE, CLASSNAME, "updateControlRecord", "Transaction failed on update of pool data records for collector" + this.getCollectorName(), transactionException);
                    Object var6_5 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                        transaction = null;
                    }
                    catch (Exception exception) {
                        logger.logp(Level.FINEST, CLASSNAME, "updateControlRecord", exception.getMessage(), exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                    transaction = null;
                }
                catch (Exception exception) {
                    logger.logp(Level.FINEST, CLASSNAME, "updateControlRecord", exception.getMessage(), exception);
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.controlBean.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

