/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.api.PoolCollectorFactoryMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.api.UnableToCommunicateException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.FactoryTaskThread;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.PoolCollectorImpl;
import com.sun.netstorage.mgmt.esm.logic.data.api.Element;
import com.sun.netstorage.mgmt.esm.logic.data.api.ElementTable;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.PoolControlBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.OrFilter;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableNotFoundException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.VendorException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.StandardMBean;

public class PoolCollectorFactory
extends StandardMBean
implements PoolCollectorFactoryMBean {
    private static final ClockDaemon clockDaemon = new ClockDaemon();
    private static final String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory = PoolCollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.PoolCollectorFactory")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory).getName();
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory = PoolCollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.impl.PoolCollectorFactory")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory).getName());
    private static final String[] MODEL_6920 = new String[]{"6320/6920", "6920"};
    private static final Filter modelFilter = new OrFilter((Filter)new EqualsFilter("model", "6920"), (Filter)new EqualsFilter("model", "6320/6920"));
    private static final long ONE_MINUTE = 60000L;
    private int pollingInterval = 60;
    private boolean pollingEnabled = true;
    private Date lastPollTime = null;
    private boolean verboseEnabled = false;
    private String revision = "1.0.0";
    private Level level;
    private MBeanServer mBeanServer = null;
    private Hashtable map = new Hashtable();
    private OperationalStatus status = OperationalStatus.STOPPED;
    private Object factoryTaskID = null;
    private Object statusChangeLock = new Object();
    private Set discoveredElements = new HashSet();
    private Set lastDiscoveredElements = new HashSet();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$impl$PoolCollectorFactory;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$Element;

    public PoolCollectorFactory(Class clazz) throws Exception {
        super(clazz);
    }

    public String[] getModels() {
        String[] stringArray = new String[this.discoveredElements.size()];
        ElementTable[] elementTableArray = this.discoveredElements.toArray(new ElementTable[this.discoveredElements.size()]);
        for (int i = 0; i < elementTableArray.length; ++i) {
            stringArray[i] = elementTableArray[i].getModel();
        }
        return stringArray;
    }

    public String[] getDeviceNames() {
        String[] stringArray = new String[this.discoveredElements.size()];
        ElementTable[] elementTableArray = this.discoveredElements.toArray(new ElementTable[this.discoveredElements.size()]);
        for (int i = 0; i < elementTableArray.length; ++i) {
            stringArray[i] = elementTableArray[i].getName();
        }
        return stringArray;
    }

    public String[] getIpAddresses() {
        String[] stringArray = new String[this.discoveredElements.size()];
        ElementTable[] elementTableArray = this.discoveredElements.toArray(new ElementTable[this.discoveredElements.size()]);
        for (int i = 0; i < elementTableArray.length; ++i) {
            stringArray[i] = elementTableArray[i].getIpAddress();
        }
        return stringArray;
    }

    public String[] getCredentials(String string) {
        if (!this.map.containsKey(string)) {
            return null;
        }
        PoolCollectorImpl poolCollectorImpl = (PoolCollectorImpl)this.map.get(string);
        String[] stringArray = poolCollectorImpl.getCredentials();
        return poolCollectorImpl.getCredentials();
    }

    public String[][] getAllArrayProperties() {
        String[][] stringArray = new String[this.map.size()][6];
        PoolCollectorImpl[] poolCollectorImplArray = this.map.values().toArray(new PoolCollectorImpl[this.map.size()]);
        for (int i = 0; i < poolCollectorImplArray.length; ++i) {
            String[] stringArray2 = poolCollectorImplArray[i].getCredentials();
            stringArray[i][0] = poolCollectorImplArray[i].getKey();
            stringArray[i][1] = stringArray2[0];
            stringArray[i][2] = stringArray2[1];
            stringArray[i][3] = poolCollectorImplArray[i].getState();
            stringArray[i][4] = poolCollectorImplArray[i].getOperationalStatus();
            stringArray[i][5] = new Date(poolCollectorImplArray[i].getLastPollTime()).toString();
        }
        return stringArray;
    }

    public String getOperationalStatus() {
        return this.status.toString();
    }

    public void addCollector(String string, String string2, String string3) throws LocalizableException {
        try {
            Object object;
            if (string == null || string.length() == 0) {
                throw new LocalizableException("poolCollector.noIPAddressSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/poolagg/api/Localization");
            }
            try {
                object = InetAddress.getByName(string);
                string = ((InetAddress)object).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new UnableToCommunicateException("poolCollector.unknownHostException", unknownHostException, new Serializable[]{string}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/poolagg/api/Localization");
            }
            object = null;
            if (this.map.containsKey(string)) {
                object = this.getCollector(string);
                String[] stringArray = ((PoolCollectorImpl)object).getCredentials();
                if (stringArray[0].equals(string2) && stringArray[1].equals(string3)) {
                    return;
                }
                this.removeCollector(string);
            }
            object = new PoolCollectorImpl(string, string2, string3);
            ((PoolCollectorImpl)object).start();
            this.map.put(string, object);
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.INFO, CLAZZ, "addCollector(ipAddr, uname, passwd)", localizableException.getLocalizedMessage(Locale.ENGLISH));
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            logger.logp(Level.SEVERE, CLAZZ, "addCollector(ipAddr, uname, passwd)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public void removeCollector(String string) throws LocalizableException {
        try {
            PoolCollectorImpl poolCollectorImpl = this.getCollector(string);
            poolCollectorImpl.shutdown();
            this.map.remove(string);
        }
        catch (LocalizableException localizableException) {
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            logger.logp(Level.SEVERE, CLAZZ, "removeCollector(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public void startCollector(String string) throws LocalizableException {
        try {
            PoolCollectorImpl poolCollectorImpl = this.getCollector(string);
            poolCollectorImpl.start();
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.INFO, CLAZZ, "startCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, CLAZZ, "startCollector(String)", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            throw new VendorException(exception);
        }
    }

    public PoolCollectorImpl getCollector(String string) throws LocalizableException {
        if (string == null) {
            throw new LocalizableIllegalArgumentException("illegalArgument.keyIsNull", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/poolagg/api/Localization");
        }
        PoolCollectorImpl poolCollectorImpl = (PoolCollectorImpl)this.map.get(string);
        if (poolCollectorImpl == null) {
            throw new LocalizableNotFoundException("poolCollectorFactory.canNotFindSpecifiedCollector", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/poolagg/api/Localization");
        }
        return poolCollectorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        int n;
        PoolCollectorImpl[] poolCollectorImplArray;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.INFO, CLAZZ, "start()", "Attempting to start service");
        }
        PoolControlBean[] poolControlBeanArray = new PoolControlBean[]{};
        try {
            poolCollectorImplArray = new PoolControlBean();
            poolControlBeanArray = poolCollectorImplArray.getAll();
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.SEVERE, CLAZZ, "start()", "Error attempting to access database.");
        }
        if (poolControlBeanArray.length > 0 && poolControlBeanArray[0].getPollingInterval() != 5L) {
            this.pollingInterval = (int)poolControlBeanArray[0].getPollingInterval();
        }
        poolCollectorImplArray = this.statusChangeLock;
        synchronized (poolCollectorImplArray) {
            n = 1;
            if (this.factoryTaskID == null) {
                this.status = OperationalStatus.STARTING;
            } else {
                if (!OperationalStatus.OK.equals((Object)this.getOperationalStatus())) {
                    this.status = OperationalStatus.STARTING;
                }
                ClockDaemon.cancel((Object)this.factoryTaskID);
                n = 0;
                this.lastPollTime = new Date();
            }
            this.factoryTaskID = clockDaemon.executePeriodically((long)this.pollingInterval * 60000L, (Runnable)new FactoryTaskThread(this), n != 0);
            this.status = OperationalStatus.OK;
        }
        if (this.map.size() > 0) {
            poolCollectorImplArray = this.map.values().toArray(new PoolCollectorImpl[this.map.size()]);
            for (n = 0; n < poolCollectorImplArray.length; ++n) {
                poolCollectorImplArray[n].start();
            }
        } else {
            for (int i = 0; i < poolControlBeanArray.length; ++i) {
                try {
                    this.addCollector(poolControlBeanArray[i].getIpAddress(), poolControlBeanArray[i].getUsername(), poolControlBeanArray[i].getPassword());
                    continue;
                }
                catch (LocalizableException localizableException) {
                    // empty catch block
                }
            }
        }
    }

    public void stopCollector(String string) throws LocalizableException {
        try {
            PoolCollectorImpl poolCollectorImpl = this.getCollector(string);
            poolCollectorImpl.stop();
        }
        catch (LocalizableException localizableException) {
            logger.logp(Level.INFO, CLAZZ, "stopCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            logger.logp(Level.SEVERE, CLAZZ, "stopCollector(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.status = OperationalStatus.STOPPING;
            if (this.map.size() > 0) {
                PoolCollectorImpl[] poolCollectorImplArray = this.map.values().toArray(new PoolCollectorImpl[this.map.size()]);
                for (int i = 0; i < poolCollectorImplArray.length; ++i) {
                    try {
                        poolCollectorImplArray[i].stop();
                        continue;
                    }
                    catch (Exception exception) {
                        logger.logp(Level.SEVERE, CLAZZ, "stop()", "VENDOR ERROR: Caught an unexpected exception: " + exception.getMessage(), exception);
                    }
                }
            }
            ClockDaemon.cancel((Object)this.factoryTaskID);
            this.factoryTaskID = null;
            this.lastPollTime = null;
            this.status = OperationalStatus.STOPPED;
        }
    }

    public void updateCollector(String string, String string2, String string3) throws LocalizableException {
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean isPollingOn() {
        return this.pollingEnabled;
    }

    public int getMinPollInterval() {
        return 5;
    }

    public int getMaxPollInterval() {
        return 1440;
    }

    public int getDefaultPollInterval() {
        return 60;
    }

    public int getPollInterval() {
        return this.pollingInterval;
    }

    public void setPollInterval(int n) {
        if (n == this.pollingInterval) {
            return;
        }
        if (this.getMinPollInterval() <= n && n <= this.getMaxPollInterval()) {
            this.pollingInterval = n;
            try {
                PoolControlBean poolControlBean = new PoolControlBean();
                PoolControlBean[] poolControlBeanArray = poolControlBean.getAll();
                PoolCollectorImpl poolCollectorImpl = null;
                for (int i = 0; i < poolControlBeanArray.length; ++i) {
                    try {
                        poolCollectorImpl = (PoolCollectorImpl)this.map.get(poolControlBeanArray[i].getIpAddress());
                        poolCollectorImpl.setPollingInterval(this.pollingInterval);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (PersistenceException persistenceException) {
                logger.logp(Level.SEVERE, CLAZZ, "setPollInterval", "Error attempting to access database.");
            }
            this.start();
        }
    }

    public String[] getCollectorProperties() {
        String[] stringArray = new String[]{"" + this.getPollInterval(), "" + this.getMinPollInterval(), "" + this.getMaxPollInterval(), this.getOperationalStatus()};
        return stringArray;
    }

    public String getNextPollTime() {
        String string = null;
        Date date = null;
        if (this.lastPollTime != null) {
            date = new Date(this.lastPollTime.getTime() + (long)this.pollingInterval * 60000L);
            string = date.toString();
        }
        return string;
    }

    public void enablePolling() throws LocalizableException {
        if (this.pollingEnabled) {
            return;
        }
        this.start();
        this.pollingEnabled = true;
    }

    public void disablePolling() throws LocalizableException {
        if (!this.pollingEnabled) {
            return;
        }
        this.stop();
        this.pollingEnabled = false;
    }

    public void poll() throws LocalizableException {
        this.doPoll();
        if (this.map.size() > 0) {
            PoolCollectorImpl[] poolCollectorImplArray = this.map.values().toArray(new PoolCollectorImpl[this.map.size()]);
            for (int i = 0; i < poolCollectorImplArray.length; ++i) {
                poolCollectorImplArray[i].fetch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPoll() throws LocalizableException {
        boolean bl;
        PersistentObject[] persistentObjectArray;
        ElementTable[] elementTableArray;
        block13: {
            this.lastPollTime = new Date();
            this.lastDiscoveredElements.clear();
            elementTableArray = this.discoveredElements.toArray(new ElementTable[this.discoveredElements.size()]);
            for (int i = 0; i < elementTableArray.length; ++i) {
                this.lastDiscoveredElements.add(elementTableArray[i]);
            }
            persistentObjectArray = new PersistentObject[]{};
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            bl = false;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$Element == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$Element = PoolCollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.data.api.Element")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$Element, modelFilter);
            bl = true;
            Object var9_7 = null;
            try {
                persistenceManager.releaseTransaction(transaction);
                persistenceManager = null;
                transaction = null;
            }
            catch (Exception exception2) {
                logger.logp(Level.WARNING, CLAZZ, "doPoll", "Exception caught releasing transaction.");
            }
            break block13;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "doPoll", "Exception caught attempting to get elements.");
                    var9_7 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                        transaction = null;
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "doPoll", "Exception caught releasing transaction.");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                    transaction = null;
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "doPoll", "Exception caught releasing transaction.");
                }
                throw throwable;
            }
        }
        if (!bl) {
            return;
        }
        this.discoveredElements.clear();
        for (int i = 0; i < persistentObjectArray.length; ++i) {
            ElementTable elementTable;
            if (persistentObjectArray[i] == null || !(elementTable = new ElementTable((Element)persistentObjectArray[i])).getName().startsWith("6920")) continue;
            this.discoveredElements.add(elementTable);
        }
        ElementTable[] elementTableArray2 = this.discoveredElements.toArray(new ElementTable[this.discoveredElements.size()]);
        for (int i = 0; i < elementTableArray.length; ++i) {
            boolean bl2 = false;
            for (int j = 0; j < elementTableArray2.length; ++j) {
                if (!elementTableArray[i].getWWN().equals(elementTableArray2[j].getWWN())) continue;
                bl2 = true;
                break;
            }
            if (bl2 || !this.map.containsKey(elementTableArray[i].getIpAddress())) continue;
            this.removeCollector(elementTableArray[i].getIpAddress());
        }
    }

    public boolean isVerboseOn() {
        return this.verboseEnabled;
    }

    public void enableVerbose() throws LocalizableException {
        this.verboseEnabled = true;
    }

    public void disableVerbose() throws LocalizableException {
        this.verboseEnabled = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

