/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.util;

import java.net.URI;
import java.security.Principal;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class CimomURLConnection {
    public static String HOST_DEFAULT = "localhost";
    public static String USER_DEFAULT = "root";
    public static String XML_PROTOCOL = "cim-xml";
    public static String RMI_PROTOCOL = "cim-rmi";
    public static String PROTOCOL_DEFAULT = XML_PROTOCOL;
    private String myURL;
    private URI myURI;
    private transient CIMClient myClient = null;
    private transient CIMNameSpace myNameSpace = null;
    private transient Principal myPrincipal = null;
    private transient PasswordCredential myCredential = null;
    private transient String myProtocol = null;
    private CIMException myFailureCause = null;
    private CIMException myInvalidContext = null;

    public CimomURLConnection(String string) {
        this.myURL = string;
    }

    public CimomURLConnection(URI uRI) {
        this.myURI = uRI;
    }

    public CIMOMHandle getHandle() {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.getConnection();
    }

    public CIMInstance getIndicationListener(CIMListener cIMListener) {
        try {
            return this.getConnection().getIndicationListener(cIMListener);
        }
        catch (CIMException cIMException) {
            return null;
        }
    }

    public boolean isConnected() {
        return this.myClient != null;
    }

    public void connect() {
        if (!this.isConnected()) {
            try {
                this.myClient = new CIMClient(this.getNameSpace(), this.getPrincipal(), (Object)this.getCredential(), this.getProtocol());
            }
            catch (CIMException cIMException) {
                this.setFailureCause(cIMException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.myClient != null) {
            try {
                this.myClient.close();
            }
            catch (CIMException cIMException) {
            }
            finally {
                this.myClient = null;
            }
        }
    }

    public CIMNameSpace getNameSpace() {
        if (this.myNameSpace == null) {
            String string = this.getHost(this.myURL);
            String string2 = this.getNameSpace(this.myURL);
            if (string2 != null) {
                int n = this.getPort(this.myURL);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n == 5988 ? "http://" : "https://");
                stringBuffer.append(string).append(":").append(n);
                stringBuffer.append("/").append(string2);
                this.myNameSpace = new CIMNameSpace(stringBuffer.toString());
            } else {
                this.myNameSpace = new CIMNameSpace(string);
            }
        }
        return this.myNameSpace;
    }

    public String getProtocol() {
        if (this.myProtocol == null) {
            String string = this.getProtocol(this.myURL);
            this.myProtocol = string != null ? (string.indexOf("rmi") >= 0 ? "cim-rmi" : "cim-xml") : "cim-xml";
        }
        return this.myProtocol;
    }

    public String getURL() {
        return this.myURL;
    }

    public URI getURI() {
        return this.myURI;
    }

    public boolean hasFailureCause() {
        return this.myFailureCause != null;
    }

    public CIMException getFailureCause() {
        return this.myFailureCause;
    }

    public boolean hasInvalidContext() {
        return this.myInvalidContext != null;
    }

    public CIMException getInvalidContext() {
        return this.myInvalidContext;
    }

    private CIMClient getConnection() {
        return this.myClient;
    }

    private Principal getPrincipal() {
        if (this.myPrincipal == null) {
            String string = this.getUser(this.myURL);
            this.myPrincipal = new UserPrincipal(string);
        }
        return this.myPrincipal;
    }

    private PasswordCredential getCredential() {
        if (this.myCredential == null) {
            String string = this.getPassword(this.myURL);
            this.myCredential = new PasswordCredential(string);
        }
        return this.myCredential;
    }

    void reset() throws CIMException {
        this.close();
        this.myClient = new CIMClient(this.getNameSpace(), this.getPrincipal(), (Object)this.getCredential(), this.getProtocol());
    }

    void reset(CIMException cIMException) throws CIMException {
        if (this.hasInvalidContext()) {
            throw this.myInvalidContext;
        }
        if (!this.isRecoverable(cIMException)) {
            throw cIMException;
        }
        this.reset();
    }

    private void setFailureCause(CIMException cIMException) {
        this.myFailureCause = cIMException;
        if (this.isInvalidContext(cIMException)) {
            this.myInvalidContext = cIMException;
        }
    }

    private boolean isInvalidContext(CIMException cIMException) {
        String string;
        boolean bl = false;
        String string2 = string = cIMException != null ? cIMException.getID() : null;
        if ("NO_SUCH_PRINCIPAL".equals(string) || "NO_SUCH_ROLE".equals(string) || "CANNOT_ASSUME_ROLE".equals(string) || "INVALID_CREDENTIAL".equals(string) || "CIM_ERR_ACCESS_DENIED".equals(string) || "UNKNOWNHOST".equals(string) || "CIM_ERR_INVALID_NAMESPACE".equals(string)) {
            bl = true;
        }
        return bl;
    }

    boolean isRecoverable(CIMException cIMException) {
        return this.isClosed(cIMException) || this.isDisconnected(cIMException);
    }

    boolean isClosed(CIMException cIMException) {
        String string = cIMException != null ? cIMException.getID() : null;
        boolean bl = false;
        if ("NO_SUCH_SESSION".equals(string)) {
            bl = true;
        }
        return bl;
    }

    boolean isDisconnected(CIMException cIMException) {
        Object object;
        Object[] objectArray;
        boolean bl = false;
        String string = cIMException != null ? cIMException.getID() : null;
        Object[] objectArray2 = objectArray = cIMException != null ? cIMException.getParams() : null;
        if ("RMIERROR".equals(string) && objectArray != null && objectArray.length >= 2 && (object = objectArray[1]) != null) {
            String string2 = object.getClass().getName();
            bl = string2.equals("java.rmi.ConnectException");
        }
        return bl;
    }

    private String getHostURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getPort(string);
        if (n > 0) {
            stringBuffer.append("http://");
        }
        stringBuffer.append(this.getHost(string));
        if (n > 0) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    private String getHost(String string) {
        String string2 = "";
        if (this.getURI() != null) {
            string2 = this.getURI().getHost();
            if (string2 == null) {
                string2 = HOST_DEFAULT;
            }
        } else {
            string2 = new String(string);
            if (string.indexOf("@") != -1) {
                string2 = string2.substring(string.indexOf("@") + 1);
                string2 = string2.substring(0, string2.indexOf(":"));
            } else if (string.indexOf(":") != -1) {
                string2 = string2.substring(string.indexOf(":") + 3);
                string2 = string2.substring(0, string2.indexOf(":"));
            } else {
                string2 = "";
            }
        }
        return string2;
    }

    private int getPort(String string) {
        int n = 0;
        String string2 = new String(string);
        if (string.indexOf(":") != -1 && (string2 = string2.substring(string.indexOf(":") + 1)).indexOf(":") != -1) {
            int n2 = string2.indexOf(":");
            string2 = string2.substring(n2 + 1, n2 + 5);
            try {
                n = new Integer(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private String getNameSpace(String string) {
        String string2 = "";
        if (this.getURI() != null) {
            String string3 = this.getURI().getPath();
            if (string3 != null) {
                string2 = string3.length() > 1 ? string3.substring(1) : null;
            }
        } else {
            String string4 = new String(string);
            String string5 = this.getHost(string);
            if (string5 != null && !string5.equals("") && (string4 = string4.substring(string4.indexOf(string5))).indexOf("/") != -1) {
                string2 = (string4 = string4.substring(string4.indexOf("/"))).indexOf("?") != -1 ? string4.substring(1, string4.indexOf("?")) : string4.substring(1);
            }
        }
        return string2;
    }

    private String getUser(String string) {
        String string2 = "";
        if (this.getURI() != null) {
            string2 = this.getURI().getUserInfo();
            if (string2 == null) {
                string2 = USER_DEFAULT;
            }
        } else {
            String string3 = new String(string);
            if (string3.indexOf("@") != -1 && (string3 = string3.substring(0, string3.indexOf("@"))).indexOf("//") != -1) {
                string2 = string3.substring(string3.indexOf("//") + 2);
            }
        }
        return string2;
    }

    private String getPassword(String string) {
        String string2 = "";
        String string3 = null;
        if (this.getURI() != null) {
            string3 = this.getURI().getQuery();
        } else if (string.indexOf("?") != -1) {
            string3 = string.substring(string.indexOf("?") + 1);
        }
        if (string3 != null) {
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            String string5 = stringTokenizer.nextToken();
            string2 = string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        }
        return string2;
    }

    private String getProtocol(String string) {
        String string2 = "";
        if (this.getURI() != null) {
            string2 = this.getURI().getScheme();
            string2 = string2 != null ? string2.toLowerCase() : PROTOCOL_DEFAULT;
        } else {
            String string3 = new String(string);
            if (string3 != null && string3.indexOf(":") != -1) {
                string2 = string3.substring(string3.indexOf(":"));
                if (!(string2 = string2.toLowerCase()).equals(XML_PROTOCOL) && !string2.equals(RMI_PROTOCOL)) {
                    string2 = "";
                }
            }
        }
        return string2;
    }

    public String toString() {
        if (this.getURI() != null) {
            return this.getURI().toString();
        }
        String string = "" + this.myClient;
        return this.myURL + '#' + string;
    }
}

