/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.host;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ComputerSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.FCPort;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.SystemDevice;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class FcHbaSystem
extends ComputerSystem {
    private FCPort[] myFCPorts = null;
    private SystemDevice[] mySysDevs = null;

    public static FcHbaSystem[] create(CimObjectManager cimObjectManager, ComputerSystem[] computerSystemArray) {
        FcHbaSystem[] fcHbaSystemArray = null;
        if (computerSystemArray != null) {
            ArrayList<FcHbaSystem> arrayList = new ArrayList<FcHbaSystem>(computerSystemArray.length);
            for (int i = 0; i < computerSystemArray.length; ++i) {
                ComputerSystem computerSystem = computerSystemArray[i];
                if (!computerSystem.isFcHbaSystem()) continue;
                arrayList.add(new FcHbaSystem(cimObjectManager, computerSystem));
            }
            fcHbaSystemArray = arrayList.toArray(new FcHbaSystem[arrayList.size()]);
        } else {
            fcHbaSystemArray = new FcHbaSystem[]{};
        }
        return fcHbaSystemArray;
    }

    public FcHbaSystem(CimObjectManager cimObjectManager, CIMObjectPath cIMObjectPath) {
        super(cimObjectManager, cIMObjectPath);
    }

    public FcHbaSystem(CimObjectManager cimObjectManager, ComputerSystem computerSystem) {
        this(cimObjectManager, computerSystem.getObjectPath());
    }

    public FCPort[] getFCPorts() {
        Enumeration enumeration;
        if (this.myFCPorts == null && (enumeration = this.getAssociators("CIM_SystemDevice", "CIM_FCPort", "GroupComponent", "PartComponent", false, false, new String[]{"PermanentAddress"})) != null) {
            ArrayList<FCPort> arrayList = new ArrayList<FCPort>();
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                arrayList.add(FCPort.create((ComputerSystem)this, cIMInstance));
            }
            this.myFCPorts = arrayList.toArray(new FCPort[arrayList.size()]);
        }
        return this.myFCPorts;
    }

    public SystemDevice[] getSystemDevices() {
        if (this.mySysDevs == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getReferenceNames("CIM_FCPort", "GroupComponent");
            this.mySysDevs = SystemDevice.create((CimObjectManager)this.getContext(), cIMObjectPathArray);
        }
        return this.mySysDevs;
    }
}

