/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.fabric;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ComputerSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.FCPort;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.SystemDevice;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public class SwitchSystem
extends ComputerSystem {
    private FCPort[] myFCPorts = null;
    private SystemDevice[] mySysDevs = null;

    public static SwitchSystem[] create(CimObjectManager cimObjectManager, ComputerSystem[] computerSystemArray) {
        SwitchSystem[] switchSystemArray = null;
        if (computerSystemArray != null) {
            ArrayList<SwitchSystem> arrayList = new ArrayList<SwitchSystem>(computerSystemArray.length);
            for (int i = 0; i < computerSystemArray.length; ++i) {
                ComputerSystem computerSystem = computerSystemArray[i];
                if (!computerSystem.isSwitchSystem()) continue;
                arrayList.add(new SwitchSystem(cimObjectManager, computerSystem));
            }
            switchSystemArray = arrayList.toArray(new SwitchSystem[arrayList.size()]);
        } else {
            switchSystemArray = new SwitchSystem[]{};
        }
        return switchSystemArray;
    }

    public SwitchSystem(CimObjectManager cimObjectManager, CIMObjectPath cIMObjectPath) {
        super(cimObjectManager, cIMObjectPath);
    }

    public SwitchSystem(CimObjectManager cimObjectManager, ComputerSystem computerSystem) {
        this(cimObjectManager, computerSystem.getObjectPath());
    }

    public FCPort[] getFCPorts() {
        if (this.myFCPorts == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_FCPort", "GroupComponent", "PartComponent");
            this.myFCPorts = FCPort.create((ComputerSystem)this, cIMObjectPathArray);
        }
        return this.myFCPorts;
    }

    public SystemDevice[] getSystemDevices() {
        if (this.mySysDevs == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getReferenceNames("CIM_FCPort", "GroupComponent");
            this.mySysDevs = SystemDevice.create((CimObjectManager)this.getContext(), cIMObjectPathArray);
        }
        return this.mySysDevs;
    }
}

