/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.blockserver;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObject;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ComputerSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.FCPort;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ProductData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.blockserver.Volume;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.util.CimContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import javax.wbem.cim.CIMObjectPath;

public class BlockServer
extends ComputerSystem {
    private BlockServer[] myComponentSystems = null;
    private FCPort[] myFCPorts = null;
    private Volume[] myVolumes = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$blockserver$BlockServer;

    public static BlockServer createBS(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        CimObjectManager cimObjectManager = new CimObjectManager(cimContext);
        BlockServer blockServer = null;
        if (cIMObjectPath != null) {
            blockServer = new BlockServer((CimContext)cimObjectManager, cIMObjectPath);
        }
        return blockServer;
    }

    public static BlockServer[] createBS(CimObjectManager cimObjectManager, CIMObjectPath[] cIMObjectPathArray) {
        BlockServer[] blockServerArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<BlockServer> arrayList = new ArrayList<BlockServer>(cIMObjectPathArray.length);
            for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                if (cIMObjectPath == null) continue;
                BlockServer blockServer = new BlockServer((CimContext)cimObjectManager, cIMObjectPath);
                arrayList.add(blockServer);
            }
            blockServerArray = arrayList.toArray(new BlockServer[arrayList.size()]);
        } else {
            blockServerArray = new BlockServer[]{};
        }
        return blockServerArray;
    }

    public static BlockServer[] create(CimObjectManager cimObjectManager, ComputerSystem[] computerSystemArray) {
        BlockServer[] blockServerArray = null;
        if (computerSystemArray != null) {
            ArrayList<BlockServer> arrayList = new ArrayList<BlockServer>(computerSystemArray.length);
            for (int i = 0; i < computerSystemArray.length; ++i) {
                ComputerSystem computerSystem = computerSystemArray[i];
                if (!computerSystem.isStorageSystem()) continue;
                arrayList.add(new BlockServer((CimContext)cimObjectManager, computerSystem));
            }
            blockServerArray = arrayList.toArray(new BlockServer[arrayList.size()]);
        } else {
            blockServerArray = new BlockServer[]{};
        }
        return blockServerArray;
    }

    protected static CIMObjectPath[] toObjectPaths(Object object) {
        CIMObjectPath[] cIMObjectPathArray = null;
        if (object instanceof CimObject[]) {
            CimObject[] cimObjectArray = (CimObject[])object;
            cIMObjectPathArray = new CIMObjectPath[cimObjectArray.length];
            for (int i = 0; i < cimObjectArray.length; ++i) {
                cIMObjectPathArray[i] = cimObjectArray[i].getObjectPath();
            }
        } else if (object instanceof CimObject) {
            CimObject cimObject = (CimObject)object;
            cIMObjectPathArray = new CIMObjectPath[]{cimObject.getObjectPath()};
        } else if (object instanceof CIMObjectPath[]) {
            cIMObjectPathArray = (CIMObjectPath[])object;
        } else if (object instanceof CIMObjectPath) {
            cIMObjectPathArray = new CIMObjectPath[]{(CIMObjectPath)object};
        }
        return cIMObjectPathArray;
    }

    public BlockServer(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        super(cimContext, cIMObjectPath);
    }

    public BlockServer(CimContext cimContext, ComputerSystem computerSystem) {
        this(cimContext, computerSystem.getObjectPath());
    }

    public BlockServer clearVolumes() {
        this.myVolumes = null;
        return this;
    }

    public Volume[] getVolumes() {
        if (this.myVolumes == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_StorageVolume");
            this.myVolumes = Volume.create(this, cIMObjectPathArray);
        }
        return this.myVolumes;
    }

    public Volume getVolume(String string) {
        Volume volume = null;
        if (string != null) {
            String string2 = this.getName();
            String[] stringArray = new String[]{"SystemName='" + string2 + "'", "DeviceID='" + string + "'"};
            CIMObjectPath cIMObjectPath = this.queryName("CIM_StorageVolume", stringArray);
            volume = cIMObjectPath != null ? new Volume(this, cIMObjectPath) : this.findVolume(string);
        }
        return volume;
    }

    private Volume findVolume(String string) {
        Volume volume = null;
        if (string != null) {
            Volume[] volumeArray = this.getVolumes();
            for (int i = 0; i < volumeArray.length; ++i) {
                Volume volume2 = volumeArray[i];
                String string2 = volume2.getPropertyValue("Name").getStringValue();
                String string3 = volume2.getPropertyValue("DeviceID").getStringValue();
                if (!string.equalsIgnoreCase(string2) && !string.equalsIgnoreCase(string3)) continue;
                volume = volume2;
                break;
            }
        }
        return volume;
    }

    public void clearFCPorts() {
        this.myFCPorts = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCPort[] getFCPorts() {
        if (this.myFCPorts == null) {
            BlockServer blockServer = this;
            synchronized (blockServer) {
                CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_FCPort", "getFCPorts");
                this.myFCPorts = FCPort.create((ComputerSystem)this, cIMObjectPathArray);
            }
        }
        return this.myFCPorts;
    }

    public ProductData getVitalProductData() {
        FCPort[] fCPortArray;
        ProductData productData = super.getVitalProductData();
        if (productData != null && (fCPortArray = this.getFCPorts()) != null && fCPortArray.length > 0) {
            String[] stringArray = FCPort.toNameStrings(fCPortArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            productData.setPortWWN(stringBuffer.toString());
            if (productData.getHostWWN() == null) {
                productData.setHostWWN(stringArray[0]);
            }
        }
        return productData;
    }

    public BlockServer[] getComponentBlockServers() {
        if (this.myComponentSystems == null) {
            this.myComponentSystems = BlockServer.create((CimObjectManager)this.getContext(), this.getComponentSystems());
        }
        return this.myComponentSystems;
    }

    public CIMObjectPath[] getAssociatedNames(String string, String string2, String string3) {
        CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames(string, string2);
        if (this.isCluster()) {
            Object object;
            BlockServer[] blockServerArray = this.getComponentBlockServers();
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            HashSet<String> hashSet = new HashSet<String>();
            if (cIMObjectPathArray != null && cIMObjectPathArray.length > 0) {
                for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                    CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                    object = cIMObjectPath.toString();
                    hashSet.add((String)object);
                    arrayList.add(cIMObjectPath);
                }
            }
            try {
                Method method = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$blockserver$BlockServer == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$blockserver$BlockServer = BlockServer.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.blockserver.BlockServer")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$blockserver$BlockServer).getMethod(string3, null);
                if (method != null && blockServerArray != null) {
                    for (int i = 0; i < blockServerArray.length; ++i) {
                        object = method.invoke((Object)blockServerArray[i], null);
                        CIMObjectPath[] cIMObjectPathArray2 = BlockServer.toObjectPaths(object);
                        if (cIMObjectPathArray2 == null || cIMObjectPathArray2.length <= 0) continue;
                        for (int j = 0; j < cIMObjectPathArray2.length; ++j) {
                            CIMObjectPath cIMObjectPath = cIMObjectPathArray2[j];
                            String string4 = cIMObjectPath.toString();
                            if (hashSet.contains(string4)) continue;
                            hashSet.add(string4);
                            arrayList.add(cIMObjectPath);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            cIMObjectPathArray = arrayList.toArray(new CIMObjectPath[arrayList.size()]);
        }
        return cIMObjectPathArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

