/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimValue;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.AbstractSetting;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.StorageSetting;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Volume;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.VolumeProfile;
import javax.wbem.cim.CIMObjectPath;

public class VolumeSetting
extends AbstractSetting {
    private PoolCapabilities myCapabilities = null;
    private Volume myVolume = null;

    public static VolumeSetting create(PoolCapabilities poolCapabilities, CIMObjectPath cIMObjectPath) {
        VolumeSetting volumeSetting = null;
        if (cIMObjectPath != null) {
            volumeSetting = new VolumeSetting(poolCapabilities, cIMObjectPath);
        }
        return volumeSetting;
    }

    public VolumeSetting(Volume volume, CIMObjectPath cIMObjectPath) {
        super(volume, cIMObjectPath);
        this.myVolume = volume;
    }

    public VolumeSetting(PoolCapabilities poolCapabilities, CIMObjectPath cIMObjectPath) {
        super(poolCapabilities, cIMObjectPath);
        this.myCapabilities = poolCapabilities;
    }

    public PoolCapabilities getCapabilities() {
        if (this.myCapabilities == null) {
            // empty if block
        }
        return this.myCapabilities;
    }

    public Volume getVolume() {
        CIMObjectPath cIMObjectPath;
        if (this.myVolume == null && (cIMObjectPath = this.getAssociatedName("CIM_ElementSettingData", "CIM_StorageVolume")) != null) {
            this.myVolume = new Volume(this, cIMObjectPath);
        }
        return this.myVolume;
    }

    public void destroyInstance() {
        try {
            super.deleteInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isVolumeProfile() {
        boolean bl = false;
        Object object = this.getPropertyValue("StorageCostHint").getObjectValue();
        if (object != null && object instanceof Number) {
            bl = true;
        }
        return bl;
    }

    public VolumeProfile toVolumeProfile() {
        VolumeProfile volumeProfile = null;
        if (this.isVolumeProfile()) {
            volumeProfile = new VolumeProfile(this.myCapabilities, this.getObjectPath());
        }
        return volumeProfile;
    }

    public void init(StorageSetting storageSetting) {
        if (storageSetting != null) {
            this.setNoSinglePointOfFailure(storageSetting.isNoSinglePointOfFailure());
            this.setDataRedundancyGoal(storageSetting.getDataRedundancy());
            this.setPackageRedundancyGoal(storageSetting.getPackageRedundancy());
            this.setDeltaReservationGoal(storageSetting.getDeltaReservation());
            this.setInstance();
        }
    }

    public boolean isNoSinglePointOfFailure() {
        boolean bl = this.getPropertyValue("NoSinglePointOfFailure").booleanValue();
        return bl;
    }

    public void setNoSinglePointOfFailure(boolean bl) {
        this.getPropertyValue("NoSinglePointOfFailure").setValue(bl);
    }

    public int getDataRedundancyMin() {
        int n = this.getPropertyValue("DataRedundancyMin").intValue();
        return n;
    }

    public int getDataRedundancyMax() {
        int n = this.getPropertyValue("DataRedundancyMax").intValue();
        return n;
    }

    public int getDataRedundancyGoal() {
        int n = this.getPropertyValue("DataRedundancyGoal").intValue();
        return n;
    }

    public void setDataRedundancyGoal(int n) {
        this.getPropertyValue("DataRedundancyGoal").setValue(n, CimValue.NumberType.UINT16);
    }

    public int getPackageRedundancyMin() {
        int n = this.getPropertyValue("PackageRedundancyMin").intValue();
        return n;
    }

    public int getPackageRedundancyMax() {
        int n = this.getPropertyValue("PackageRedundancyMax").intValue();
        return n;
    }

    public int getPackageRedundancyGoal() {
        int n = this.getPropertyValue("PackageRedundancyGoal").intValue();
        return n;
    }

    public void setPackageRedundancyGoal(int n) {
        this.getPropertyValue("PackageRedundancyGoal").setValue(n, CimValue.NumberType.UINT16);
    }

    public int getDeltaReservationMin() {
        int n = this.getPropertyValue("DeltaReservationMin").intValue();
        return n;
    }

    public int getDeltaReservationMax() {
        int n = this.getPropertyValue("DeltaReservationMax").intValue();
        return n;
    }

    public int getDeltaReservationGoal() {
        int n = this.getPropertyValue("DeltaReservationGoal").intValue();
        return n;
    }

    public void setDeltaReservationGoal(int n) {
        this.getPropertyValue("DeltaReservationGoal").setValue(n, CimValue.NumberType.UINT16);
    }
}

