/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Extent;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.VolumeSetting;
import javax.wbem.cim.CIMObjectPath;

public class Volume
extends Extent {
    private StorageSystem myStorageSystem = null;
    private AllocatedPool myPool = null;
    private VolumeSetting mySetting = null;

    public static Volume create(AllocatedPool allocatedPool, CIMObjectPath cIMObjectPath) {
        Volume volume = null;
        if (cIMObjectPath != null) {
            volume = new Volume(allocatedPool, cIMObjectPath);
        }
        return volume;
    }

    public static Volume[] create(AllocatedPool allocatedPool, CIMObjectPath[] cIMObjectPathArray) {
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        Volume[] volumeArray = new Volume[n];
        for (int i = 0; i < n; ++i) {
            volumeArray[i] = new Volume(allocatedPool, cIMObjectPathArray[i]);
        }
        return volumeArray;
    }

    public static Volume[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        Volume[] volumeArray = new Volume[n];
        for (int i = 0; i < n; ++i) {
            volumeArray[i] = new Volume(storageSystem, cIMObjectPathArray[i]);
        }
        return volumeArray;
    }

    public Volume(AllocatedPool allocatedPool, CIMObjectPath cIMObjectPath) {
        super(allocatedPool, cIMObjectPath);
        this.myPool = allocatedPool;
    }

    public Volume(VolumeSetting volumeSetting, CIMObjectPath cIMObjectPath) {
        super(volumeSetting, cIMObjectPath);
        this.mySetting = volumeSetting;
    }

    public Volume(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public StorageSystem getStorageSystem() {
        if (this.myStorageSystem == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_SystemDevice", "CIM_ComputerSystem");
            this.myStorageSystem = StorageSystem.createSS(this, cIMObjectPath);
        }
        return this.myStorageSystem;
    }

    public AllocatedPool getPool() {
        if (this.myPool == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            this.myPool = AllocatedPool.createAP(null, cIMObjectPath);
        }
        return this.myPool;
    }

    public VolumeSetting getSetting() {
        if (this.mySetting == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementSettingData", "CIM_StorageSetting");
            this.mySetting = new VolumeSetting(this, cIMObjectPath);
        }
        return this.mySetting;
    }
}

