/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObject;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ComputerSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.FCPort;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ProductData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Pool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Volume;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.util.CimContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import javax.wbem.cim.CIMObjectPath;

public class StorageSystem
extends ComputerSystem {
    private Pool[] myPools = null;
    private PrimordialPool[] myPrimordialPools = null;
    private AllocatedPool[] myAllocatedPools = null;
    private Volume[] myVolumes = null;
    private FCPort[] myFCPorts = null;
    private StorageSystem[] myComponentSystems = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$array$StorageSystem;

    public static StorageSystem createSS(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        CimObjectManager cimObjectManager = new CimObjectManager(cimContext);
        StorageSystem storageSystem = null;
        if (cIMObjectPath != null) {
            storageSystem = new StorageSystem((CimContext)cimObjectManager, cIMObjectPath);
        }
        return storageSystem;
    }

    public static StorageSystem[] createSS(CimObjectManager cimObjectManager, CIMObjectPath[] cIMObjectPathArray) {
        StorageSystem[] storageSystemArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<StorageSystem> arrayList = new ArrayList<StorageSystem>(cIMObjectPathArray.length);
            for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                if (cIMObjectPath == null) continue;
                StorageSystem storageSystem = new StorageSystem((CimContext)cimObjectManager, cIMObjectPath);
                arrayList.add(storageSystem);
            }
            storageSystemArray = arrayList.toArray(new StorageSystem[arrayList.size()]);
        } else {
            storageSystemArray = new StorageSystem[]{};
        }
        return storageSystemArray;
    }

    public static StorageSystem[] create(CimObjectManager cimObjectManager, ComputerSystem[] computerSystemArray) {
        StorageSystem[] storageSystemArray = null;
        if (computerSystemArray != null) {
            ArrayList<StorageSystem> arrayList = new ArrayList<StorageSystem>(computerSystemArray.length);
            for (int i = 0; i < computerSystemArray.length; ++i) {
                ComputerSystem computerSystem = computerSystemArray[i];
                if (!computerSystem.isStorageSystem()) continue;
                arrayList.add(new StorageSystem((CimContext)cimObjectManager, computerSystem));
            }
            storageSystemArray = arrayList.toArray(new StorageSystem[arrayList.size()]);
        } else {
            storageSystemArray = new StorageSystem[]{};
        }
        return storageSystemArray;
    }

    protected static CIMObjectPath[] toObjectPaths(Object object) {
        CIMObjectPath[] cIMObjectPathArray = null;
        if (object instanceof CimObject[]) {
            CimObject[] cimObjectArray = (CimObject[])object;
            cIMObjectPathArray = new CIMObjectPath[cimObjectArray.length];
            for (int i = 0; i < cimObjectArray.length; ++i) {
                cIMObjectPathArray[i] = cimObjectArray[i].getObjectPath();
            }
        } else if (object instanceof CimObject) {
            CimObject cimObject = (CimObject)object;
            cIMObjectPathArray = new CIMObjectPath[]{cimObject.getObjectPath()};
        } else if (object instanceof CIMObjectPath[]) {
            cIMObjectPathArray = (CIMObjectPath[])object;
        } else if (object instanceof CIMObjectPath) {
            cIMObjectPathArray = new CIMObjectPath[]{(CIMObjectPath)object};
        }
        return cIMObjectPathArray;
    }

    public StorageSystem(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        super(cimContext, cIMObjectPath);
    }

    public StorageSystem(CimContext cimContext, ComputerSystem computerSystem) {
        this(cimContext, computerSystem.getObjectPath());
    }

    public Pool[] getPools() {
        if (this.myPools == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_HostedStoragePool", "CIM_StoragePool");
            this.myPools = Pool.create(this, cIMObjectPathArray);
        }
        return this.myPools;
    }

    public Pool getPool(String string) {
        Pool pool = null;
        if (string != null) {
            String[] stringArray = new String[]{"InstanceID='" + string + "'"};
            CIMObjectPath cIMObjectPath = this.queryName("CIM_StoragePool", stringArray);
            pool = cIMObjectPath != null ? new Pool(this, cIMObjectPath) : this.findPool(string);
        }
        return pool;
    }

    private Pool findPool(String string) {
        Pool pool = null;
        if (string != null) {
            Pool[] poolArray = this.getPools();
            for (int i = 0; i < poolArray.length; ++i) {
                Pool pool2 = poolArray[i];
                String string2 = pool2.getPropertyValue("InstanceID").getStringValue();
                if (!string.equals(string2)) continue;
                pool = pool2;
                break;
            }
        }
        return pool;
    }

    public PrimordialPool[] getPrimordialPools() {
        if (this.myPrimordialPools == null) {
            Pool[] poolArray = this.getPools();
            this.myPrimordialPools = PrimordialPool.create(this, poolArray);
        }
        return this.myPrimordialPools;
    }

    public PrimordialPool getPrimordialPool(String string) {
        Pool pool;
        PrimordialPool primordialPool = null;
        if (string != null && (pool = this.getPool(string)).isPrimordial()) {
            primordialPool = new PrimordialPool(this, pool.getObjectPath());
        }
        return primordialPool;
    }

    public AllocatedPool[] getAllocatedPools() {
        if (this.myAllocatedPools == null) {
            Pool[] poolArray = this.getPools();
            this.myAllocatedPools = AllocatedPool.create(this, poolArray);
        }
        return this.myAllocatedPools;
    }

    public AllocatedPool getAllocatedPool(String string) {
        Pool pool;
        AllocatedPool allocatedPool = null;
        if (string != null && (pool = this.getPool(string)).isAllocated()) {
            allocatedPool = new AllocatedPool(this, pool.getObjectPath());
        }
        return allocatedPool;
    }

    public StorageSystem clearVolumes() {
        this.myVolumes = null;
        return this;
    }

    public Volume[] getVolumes() {
        if (this.myVolumes == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_StorageVolume");
            this.myVolumes = Volume.create(this, cIMObjectPathArray);
        }
        return this.myVolumes;
    }

    public Volume getVolume(String string) {
        Volume volume = null;
        if (string != null) {
            String string2 = this.getName();
            String[] stringArray = new String[]{"SystemName='" + string2 + "'", "DeviceID='" + string + "'"};
            CIMObjectPath cIMObjectPath = this.queryName("CIM_StorageVolume", stringArray);
            volume = cIMObjectPath != null ? new Volume(this, cIMObjectPath) : this.findVolume(string);
        }
        return volume;
    }

    private Volume findVolume(String string) {
        Volume volume = null;
        if (string != null) {
            Volume[] volumeArray = this.getVolumes();
            for (int i = 0; i < volumeArray.length; ++i) {
                Volume volume2 = volumeArray[i];
                String string2 = volume2.getPropertyValue("Name").getStringValue();
                String string3 = volume2.getPropertyValue("DeviceID").getStringValue();
                if (!string.equalsIgnoreCase(string2) && !string.equalsIgnoreCase(string3)) continue;
                volume = volume2;
                break;
            }
        }
        return volume;
    }

    public void clearFCPorts() {
        this.myFCPorts = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FCPort[] getFCPorts() {
        if (this.myFCPorts == null) {
            StorageSystem storageSystem = this;
            synchronized (storageSystem) {
                CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_SystemDevice", "CIM_FCPort", "getFCPorts");
                this.myFCPorts = FCPort.create((ComputerSystem)this, cIMObjectPathArray);
            }
        }
        return this.myFCPorts;
    }

    public long getArraySize() {
        long l = 0L;
        PrimordialPool[] primordialPoolArray = this.getPrimordialPools();
        for (int i = 0; i < primordialPoolArray.length; ++i) {
            l += primordialPoolArray[i].getTotalManagedSpace();
        }
        return l;
    }

    public long getUnallocatedSpace() {
        long l = 0L;
        PrimordialPool[] primordialPoolArray = this.getPrimordialPools();
        for (int i = 0; i < primordialPoolArray.length; ++i) {
            l += primordialPoolArray[i].getUnallocatedSpace();
        }
        return l;
    }

    public ProductData getVitalProductData() {
        FCPort[] fCPortArray;
        ProductData productData = super.getVitalProductData();
        if (productData != null && (fCPortArray = this.getFCPorts()) != null && fCPortArray.length > 0) {
            String[] stringArray = FCPort.toNameStrings(fCPortArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            productData.setPortWWN(stringBuffer.toString());
            if (productData.getHostWWN() == null) {
                productData.setHostWWN(stringArray[0]);
            }
        }
        return productData;
    }

    public StorageSystem[] getComponentStorageSystems() {
        if (this.myComponentSystems == null) {
            this.myComponentSystems = StorageSystem.create((CimObjectManager)this.getContext(), this.getComponentSystems());
        }
        return this.myComponentSystems;
    }

    public CIMObjectPath[] getAssociatedNames(String string, String string2, String string3) {
        CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames(string, string2);
        if (this.isCluster()) {
            Object object;
            StorageSystem[] storageSystemArray = this.getComponentStorageSystems();
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            HashSet<String> hashSet = new HashSet<String>();
            if (cIMObjectPathArray != null && cIMObjectPathArray.length > 0) {
                for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                    CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                    object = cIMObjectPath.toString();
                    hashSet.add((String)object);
                    arrayList.add(cIMObjectPath);
                }
            }
            try {
                Method method = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$array$StorageSystem == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$array$StorageSystem = StorageSystem.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.StorageSystem")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$poolagg$core$model$common$array$StorageSystem).getMethod(string3, null);
                if (method != null && storageSystemArray != null) {
                    for (int i = 0; i < storageSystemArray.length; ++i) {
                        object = method.invoke((Object)storageSystemArray[i], null);
                        CIMObjectPath[] cIMObjectPathArray2 = StorageSystem.toObjectPaths(object);
                        if (cIMObjectPathArray2 == null || cIMObjectPathArray2.length <= 0) continue;
                        for (int j = 0; j < cIMObjectPathArray2.length; ++j) {
                            CIMObjectPath cIMObjectPath = cIMObjectPathArray2[j];
                            String string4 = cIMObjectPath.toString();
                            if (hashSet.contains(string4)) continue;
                            hashSet.add(string4);
                            arrayList.add(cIMObjectPath);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            cIMObjectPathArray = arrayList.toArray(new CIMObjectPath[arrayList.size()]);
        }
        return cIMObjectPathArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

