/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Pool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.VolumeSetting;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public class PrimordialPool
extends Pool {
    private AllocatedPool[] myAllocatedPools = null;

    public static PrimordialPool createPP(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        PrimordialPool primordialPool = null;
        if (cIMObjectPath != null) {
            primordialPool = new PrimordialPool(storageSystem, cIMObjectPath);
        }
        return primordialPool;
    }

    public static PrimordialPool[] create(StorageSystem storageSystem, Pool[] poolArray) {
        PrimordialPool[] primordialPoolArray = null;
        if (poolArray != null) {
            ArrayList<PrimordialPool> arrayList = new ArrayList<PrimordialPool>(poolArray.length);
            for (int i = 0; i < poolArray.length; ++i) {
                Pool pool = poolArray[i];
                if (pool == null || !pool.isPrimordial()) continue;
                CIMObjectPath cIMObjectPath = pool.getObjectPath();
                PrimordialPool primordialPool = new PrimordialPool(storageSystem, cIMObjectPath);
                arrayList.add(primordialPool);
            }
            primordialPoolArray = arrayList.toArray(new PrimordialPool[arrayList.size()]);
        } else {
            primordialPoolArray = new PrimordialPool[]{};
        }
        return primordialPoolArray;
    }

    public PrimordialPool(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
    }

    public void clearAllocatedPools() {
        this.myAllocatedPools = null;
    }

    public AllocatedPool[] getAllocatedPools() {
        if (this.myAllocatedPools == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            this.myAllocatedPools = AllocatedPool.create(this, cIMObjectPathArray);
        }
        return this.myAllocatedPools;
    }

    public long[] getSupportedSizes(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizes(volumeSetting, 2);
        return lArray;
    }

    public long[] getSupportedSizeRange(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizeRange(volumeSetting, 2);
        return lArray;
    }
}

