/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimValue;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.LogicalElement;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PoolSettingWithHints;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.VolumeSetting;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.smis_1_0_2.api.CIM_StoragePool;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class Pool
extends LogicalElement {
    private StorageSystem myStorageSystem = null;
    private PoolCapabilities myCapabilities = null;
    private PoolSettingWithHints myHints = null;
    private long myTotalManagedSpace = 0L;
    private long myRemainingManagedSpace = 0L;

    public static Pool create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Pool pool = new Pool(storageSystem, cIMObjectPath);
        return pool;
    }

    public static Pool[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        Pool[] poolArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<Pool> arrayList = new ArrayList<Pool>(cIMObjectPathArray.length);
            for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                if (cIMObjectPath == null) continue;
                Pool pool = new Pool(storageSystem, cIMObjectPath);
                arrayList.add(pool);
            }
            poolArray = Pool.toPoolArray(arrayList);
        } else {
            poolArray = new Pool[]{};
        }
        return poolArray;
    }

    public static Pool[] toPoolArray(List list) {
        int n = list != null ? list.size() : 0;
        Pool[] poolArray = new Pool[n];
        if (n > 0) {
            poolArray = list.toArray(poolArray);
        }
        return poolArray;
    }

    public Pool(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public PoolCapabilities getCapabilities() {
        if (this.myCapabilities == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementCapabilities", "CIM_StorageCapabilities");
            this.myCapabilities = PoolCapabilities.create(this, cIMObjectPath);
        }
        return this.myCapabilities;
    }

    public PoolSettingWithHints getHints() {
        if (this.myHints == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementSettingData", "CIM_StorageSettingWithHints");
            this.myHints = PoolSettingWithHints.create(this, cIMObjectPath);
        }
        return this.myHints;
    }

    public boolean isPrimordial() {
        return this.getPropertyValue("Primordial").booleanValue();
    }

    public boolean isAllocated() {
        return !this.isPrimordial();
    }

    public long getTotalManagedSpace() {
        this.myTotalManagedSpace = this.getPropertyValue("TotalManagedSpace").longValue();
        return this.myTotalManagedSpace;
    }

    public long getUnallocatedSpace() {
        this.myRemainingManagedSpace = this.getPropertyValue("RemainingManagedSpace").longValue();
        return this.myRemainingManagedSpace;
    }

    public long getAvailableSize(VolumeSetting volumeSetting, long l) {
        long l2;
        block10: {
            l2 = 0L;
            try {
                long[] lArray = this.getSupportedSizes(volumeSetting);
                if (lArray != null) {
                    for (int i = 0; i < lArray.length; ++i) {
                        long l3 = lArray[i];
                        if (l > l3) continue;
                        l2 = l3;
                        break block10;
                    }
                    break block10;
                }
                lArray = this.getSupportedSizeRange(volumeSetting);
                if (lArray != null && lArray.length == 3) {
                    long l4 = lArray[0];
                    long l5 = lArray[1];
                    long l6 = lArray[2];
                    if (l < l4) {
                        l2 = l4;
                    } else if (l % l6 == 0L) {
                        l2 = l;
                    } else if (l >= l4 && l <= l5) {
                        l2 = (l / l6 + 1L) * l6;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l2;
    }

    public long[] getSupportedSizes(VolumeSetting volumeSetting) {
        return this.getSupportedSizes(volumeSetting, 2);
    }

    protected long[] getSupportedSizes(VolumeSetting volumeSetting, int n) {
        long[] lArray = null;
        CimArgumentMap cimArgumentMap = CIM_StoragePool.GetSupportedSizes.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StoragePool.GetSupportedSizes.Factory.createOutputs();
        cimArgumentMap.getValue("ElementType").setValue(n, CimValue.NumberType.UINT16);
        cimArgumentMap.getValue("Goal").setValue(volumeSetting);
        int n2 = this.intMethod("GetSupportedSizes", cimArgumentMap, cimArgumentMap2);
        switch (n2) {
            case 0: {
                lArray = cimArgumentMap2.getValue("Sizes").longValues();
                break;
            }
        }
        return lArray;
    }

    public long[] getSupportedSizeRange(VolumeSetting volumeSetting) {
        return this.getSupportedSizes(volumeSetting, 2);
    }

    protected long[] getSupportedSizeRange(VolumeSetting volumeSetting, int n) {
        long[] lArray = new long[3];
        CimArgumentMap cimArgumentMap = CIM_StoragePool.GetSupportedSizeRange.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StoragePool.GetSupportedSizeRange.Factory.createOutputs();
        cimArgumentMap.getValue("ElementType").setValue(n, CimValue.NumberType.UINT16);
        cimArgumentMap.getValue("Goal").setValue(volumeSetting);
        int n2 = this.intMethod("GetSupportedSizeRange", cimArgumentMap, cimArgumentMap2);
        switch (n2) {
            case 0: {
                lArray = new long[]{cimArgumentMap2.getValue("MinimumVolumeSize").longValue(0L), cimArgumentMap2.getValue("MaximumVolumeSize").longValue(0L), cimArgumentMap2.getValue("VolumeSizeDivisor").longValue(0L)};
                break;
            }
        }
        return lArray;
    }
}

