/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Pool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PrimordialPool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Volume;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.VolumeSetting;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public class AllocatedPool
extends Pool {
    private PrimordialPool myPrimordialPool = null;
    private Volume[] myVolumes = null;
    private VolumeSetting myVolumeSetting = null;

    public static AllocatedPool createAP(PrimordialPool primordialPool, CIMObjectPath cIMObjectPath) {
        AllocatedPool allocatedPool = null;
        if (cIMObjectPath != null) {
            allocatedPool = new AllocatedPool(primordialPool, cIMObjectPath);
        }
        return allocatedPool;
    }

    public static Volume[] create(AllocatedPool allocatedPool, CIMObjectPath[] cIMObjectPathArray) {
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        Volume[] volumeArray = new Volume[n];
        for (int i = 0; i < n; ++i) {
            volumeArray[i] = new Volume(allocatedPool, cIMObjectPathArray[i]);
        }
        return volumeArray;
    }

    public static AllocatedPool[] create(PrimordialPool primordialPool, CIMObjectPath[] cIMObjectPathArray) {
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        AllocatedPool[] allocatedPoolArray = new AllocatedPool[n];
        for (int i = 0; i < n; ++i) {
            allocatedPoolArray[i] = new AllocatedPool(primordialPool, cIMObjectPathArray[i]);
        }
        return allocatedPoolArray;
    }

    public static AllocatedPool[] create(StorageSystem storageSystem, Pool[] poolArray) {
        AllocatedPool[] allocatedPoolArray = null;
        if (poolArray != null) {
            ArrayList<AllocatedPool> arrayList = new ArrayList<AllocatedPool>(poolArray.length);
            for (int i = 0; i < poolArray.length; ++i) {
                Pool pool = poolArray[i];
                if (pool == null || !pool.isAllocated()) continue;
                CIMObjectPath cIMObjectPath = pool.getObjectPath();
                AllocatedPool allocatedPool = new AllocatedPool(storageSystem, cIMObjectPath);
                arrayList.add(allocatedPool);
            }
            allocatedPoolArray = arrayList.toArray(new AllocatedPool[arrayList.size()]);
        } else {
            allocatedPoolArray = new AllocatedPool[]{};
        }
        return allocatedPoolArray;
    }

    public AllocatedPool(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
    }

    public AllocatedPool(PrimordialPool primordialPool, CIMObjectPath cIMObjectPath) {
        this(primordialPool.getStorageSystem(), cIMObjectPath);
        this.myPrimordialPool = primordialPool;
    }

    public PrimordialPool getPrimordialPool() {
        if (this.myPrimordialPool == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            this.myPrimordialPool = PrimordialPool.createPP(this.getStorageSystem(), cIMObjectPath);
        }
        return this.myPrimordialPool;
    }

    public Volume[] getVolumes() {
        if (this.myVolumes == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AllocatedFromStoragePool", "CIM_StorageVolume");
            this.myVolumes = Volume.create(this, cIMObjectPathArray);
        }
        return this.myVolumes;
    }

    public VolumeSetting getVolumeSetting() {
        PoolCapabilities poolCapabilities;
        if (this.myVolumeSetting == null && (poolCapabilities = this.getCapabilities()) != null) {
            this.myVolumeSetting = poolCapabilities.createGoalSetting();
        }
        return this.myVolumeSetting;
    }

    public long[] getSupportedSizes(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizes(volumeSetting, 3);
        return lArray;
    }

    public long[] getSupportedSizeRange(VolumeSetting volumeSetting) {
        long[] lArray = this.getSupportedSizeRange(volumeSetting, 3);
        return lArray;
    }
}

