/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ComputerSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.LogicalPort;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ProtocolEndpoint;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.SystemDevice;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class FCPort
extends LogicalPort {
    private ComputerSystem myComputerSystem = null;
    private ProtocolEndpoint[] myEndpoints = null;
    private String myElementName = null;
    private String myPermanentAddress = null;
    private int myUsageRestriction = 0;
    private int[] mySupportedCOSs = null;

    public static FCPort create(ComputerSystem computerSystem, CIMObjectPath cIMObjectPath) {
        FCPort fCPort = new FCPort(computerSystem, cIMObjectPath);
        return fCPort;
    }

    public static FCPort[] create(ComputerSystem computerSystem, CIMObjectPath[] cIMObjectPathArray) {
        FCPort[] fCPortArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<FCPort> arrayList = new ArrayList<FCPort>(cIMObjectPathArray.length);
            for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                if (cIMObjectPath == null) continue;
                FCPort fCPort = new FCPort(computerSystem, cIMObjectPath);
                arrayList.add(fCPort);
            }
            fCPortArray = FCPort.toFCPortArray(arrayList);
        } else {
            fCPortArray = new FCPort[]{};
        }
        return fCPortArray;
    }

    public static FCPort create(ComputerSystem computerSystem, CIMInstance cIMInstance) {
        FCPort fCPort = new FCPort(computerSystem, cIMInstance);
        return fCPort;
    }

    public static FCPort create(ProtocolEndpoint protocolEndpoint, CIMInstance cIMInstance) {
        FCPort fCPort = new FCPort(protocolEndpoint, cIMInstance);
        return fCPort;
    }

    public static FCPort[] toFCPortArray(List list) {
        int n = list != null ? list.size() : 0;
        FCPort[] fCPortArray = new FCPort[n];
        if (n > 0) {
            fCPortArray = list.toArray(fCPortArray);
        }
        return fCPortArray;
    }

    public static String[] toNameStrings(FCPort[] fCPortArray) {
        String[] stringArray = null;
        if (fCPortArray != null) {
            stringArray = new String[fCPortArray.length];
            for (int i = 0; i < fCPortArray.length; ++i) {
                stringArray[i] = fCPortArray[i].getPermanentAddress();
            }
        }
        return stringArray;
    }

    public FCPort(ComputerSystem computerSystem, CIMObjectPath cIMObjectPath) {
        super(computerSystem, cIMObjectPath);
        this.myComputerSystem = computerSystem;
    }

    public FCPort(ComputerSystem computerSystem, CIMInstance cIMInstance) {
        super(computerSystem, cIMInstance.getObjectPath());
        this.myComputerSystem = computerSystem;
        this.setInstance(cIMInstance);
        this.myPermanentAddress = this.getPropertyValue("PermanentAddress").getStringValue().toUpperCase();
    }

    public FCPort(ProtocolEndpoint protocolEndpoint, CIMInstance cIMInstance) {
        super(protocolEndpoint, cIMInstance.getObjectPath());
        this.myEndpoints = new ProtocolEndpoint[]{protocolEndpoint};
        this.setInstance(cIMInstance);
        this.myPermanentAddress = this.getPropertyValue("PermanentAddress").getStringValue();
    }

    public ComputerSystem getComputerSystem() {
        return this.myComputerSystem;
    }

    public ProtocolEndpoint[] getProtocolEndpoints() {
        if (this.myEndpoints == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_DeviceSAPImplementation", "CIM_ProtocolEndpoint", "Antecedent", "Dependent");
            this.myEndpoints = ProtocolEndpoint.create(this, cIMObjectPathArray);
        }
        return this.myEndpoints;
    }

    public SystemDevice[] getSystemDevices() {
        CIMObjectPath[] cIMObjectPathArray = this.getReferenceNames("CIM_SystemDevice", "PartComponent");
        SystemDevice[] systemDeviceArray = SystemDevice.create(this, cIMObjectPathArray);
        return systemDeviceArray;
    }

    public String getElementName() {
        if (this.myElementName == null) {
            this.myElementName = this.getPropertyValue("ElementName").getStringValue();
        }
        return this.myElementName;
    }

    public String getPermanentAddress() {
        if (this.myPermanentAddress == null) {
            this.myPermanentAddress = this.getPropertyValue("PermanentAddress").getStringValue().toUpperCase();
        }
        return this.myPermanentAddress;
    }

    public int getUsageRestriction() {
        if (this.myUsageRestriction == 0) {
            this.myUsageRestriction = this.getPropertyValue("UsageRestriction").intValue();
        }
        return this.myUsageRestriction;
    }

    public boolean isFrontEnd() {
        return this.getUsageRestriction() == 2;
    }

    public boolean isBackEnd() {
        return this.getUsageRestriction() == 3;
    }

    private int[] getSupportedCOSs() {
        if (this.mySupportedCOSs == null) {
            this.mySupportedCOSs = this.getPropertyValue("SupportedCOS").intValues();
        }
        return this.mySupportedCOSs;
    }

    private boolean isSupportedCOS(int n) {
        boolean bl = false;
        int[] nArray = this.getSupportedCOSs();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

