/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.AbstractSystem;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.PhysicalPackage;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.Product;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ProductData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.RemoteServiceAccessPoint;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.util.CimContext;
import javax.wbem.cim.CIMObjectPath;

public class ComputerSystem
extends AbstractSystem {
    private PhysicalPackage myPhysicalPackage = null;
    private Product myProduct = null;
    private RemoteServiceAccessPoint myRemoteSvcAccessPoint = null;
    private ComputerSystem myCluster = null;
    private ComputerSystem[] myComponentSystems = null;
    private int[] myDedicated = null;

    public static ComputerSystem[] create(CimObjectManager cimObjectManager, CIMObjectPath[] cIMObjectPathArray) {
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        ComputerSystem[] computerSystemArray = new ComputerSystem[n];
        if (cIMObjectPathArray != null) {
            for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[i];
                computerSystemArray[i] = new ComputerSystem(cimObjectManager, cIMObjectPath);
            }
        }
        return computerSystemArray;
    }

    public static ComputerSystem create(CimObjectManager cimObjectManager, CIMObjectPath cIMObjectPath) {
        ComputerSystem computerSystem = new ComputerSystem(cimObjectManager, cIMObjectPath);
        return computerSystem;
    }

    public ComputerSystem(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        super(cimContext, cIMObjectPath);
    }

    public PhysicalPackage getPhysicalPackage() {
        CIMObjectPath cIMObjectPath;
        if (this.myPhysicalPackage == null && (cIMObjectPath = this.getAssociatedName("CIM_ComputerSystemPackage", "CIM_PhysicalPackage")) != null) {
            this.myPhysicalPackage = new PhysicalPackage(this, cIMObjectPath);
        }
        return this.myPhysicalPackage;
    }

    public Product getProduct() {
        if (this.myProduct == null && this.getPhysicalPackage() != null) {
            this.myProduct = this.getPhysicalPackage().getProduct();
        }
        return this.myProduct;
    }

    public ProductData getProductProperties() {
        return this.getVitalProductData();
    }

    public ProductData getVitalProductData() {
        ProductData productData = null;
        if (this.getProduct() != null && (productData = this.getProduct().getVitalProductData()) != null) {
            productData.merge(this);
        }
        return productData;
    }

    public RemoteServiceAccessPoint getRemoteServiceAccessPoint() {
        CIMObjectPath cIMObjectPath;
        if (this.myRemoteSvcAccessPoint == null && (!this.isStorageSystem() || this.isCluster()) && (cIMObjectPath = this.getAssociatedName("CIM_HostedAccessPoint", "CIM_RemoteServiceAccessPoint", "Antecedent", "Dependent")) != null) {
            this.myRemoteSvcAccessPoint = new RemoteServiceAccessPoint(this, cIMObjectPath);
        }
        return this.myRemoteSvcAccessPoint;
    }

    public ComputerSystem getCluster() {
        CIMObjectPath cIMObjectPath;
        if (this.myCluster == null && (cIMObjectPath = this.getAssociatedName("CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent")) != null) {
            this.myCluster = new ComputerSystem(this, cIMObjectPath);
        }
        return this.myCluster;
    }

    public boolean isClusterComponent() {
        return this.getCluster() != null;
    }

    public ComputerSystem[] getComponentSystems() {
        if (this.myComponentSystems == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_ComponentCS", "CIM_ComputerSystem", "GroupComponent", "PartComponent");
            this.myComponentSystems = ComputerSystem.create((CimObjectManager)this.getContext(), cIMObjectPathArray);
        }
        return this.myComponentSystems;
    }

    public boolean isCluster() {
        return this.getComponentSystems() != null && this.getComponentSystems().length > 0;
    }

    protected final int[] getDedicated() {
        if (this.myDedicated == null) {
            this.myDedicated = this.getPropertyValue("Dedicated").intValues();
        }
        return this.myDedicated;
    }

    protected final boolean isDedicated(int n) {
        boolean bl = false;
        int[] nArray = this.getDedicated();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isDedicatedStorage() {
        return this.isDedicated(3);
    }

    public boolean isDedicatedBlockServer() {
        return this.isDedicated(15);
    }

    public boolean isDedicatedSwitch() {
        return this.isDedicated(5);
    }

    public boolean isNotDedicated() {
        return this.isDedicated(0);
    }

    public boolean isTopLevelStorageSystem() {
        return this.isStorageSystem() && !this.isClusterComponent();
    }

    public boolean isStorageSystem() {
        return this.isDedicatedStorage() || this.isDedicatedBlockServer();
    }

    public boolean isSwitchSystem() {
        return this.isDedicatedSwitch();
    }

    public boolean isFcHbaSystem() {
        return this.isNotDedicated();
    }

    public String getCSName() {
        String string = this.getPropertyValue("NameFormat").getStringValue();
        return this.getPropertyValue("Name").getStringValue();
    }

    public String getNameFormat() {
        return this.getPropertyValue("NameFormat").getStringValue();
    }

    public String getDescription() {
        return this.getPropertyValue("Description").getStringValue();
    }

    public String getElementName() {
        return this.getPropertyValue("ElementName").getStringValue();
    }

    public String[] getOtherIdentifyingInfo() {
        return this.getPropertyValue("OtherIdentifyingInfo").getStringValues();
    }

    public String[] getIdentifyingDescriptions() {
        return this.getPropertyValue("IdentifyingDescriptions").getStringValues();
    }

    public String getCreationClassName() {
        return this.getPropertyValue("CreationClassName").getStringValue();
    }
}

