/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObject;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public final class CimValue {
    private CIMValue myDelegate = null;
    private CIMArgument myAssociatedArgument = null;
    private CIMProperty myAssociatedProperty = null;

    public CimValue(CIMValue cIMValue) {
        this.myDelegate = cIMValue;
    }

    CimValue(CIMArgument cIMArgument) {
        this(cIMArgument.getValue());
        this.myAssociatedArgument = cIMArgument;
    }

    CimValue(CIMProperty cIMProperty) {
        this(cIMProperty.getValue());
        this.myAssociatedProperty = cIMProperty;
    }

    public final CIMValue getDelegate() {
        return this.myDelegate;
    }

    protected final void setDelegate(CIMValue cIMValue) {
        this.myDelegate = cIMValue;
        if (this.hasAssociatedArgument()) {
            this.getAssociatedArgument().setValue(this.myDelegate);
        } else if (this.hasAssociatedProperty()) {
            this.getAssociatedProperty().setValue(this.myDelegate);
        }
    }

    boolean hasAssociatedArgument() {
        return this.myAssociatedArgument != null;
    }

    CIMArgument getAssociatedArgument() {
        return this.myAssociatedArgument;
    }

    boolean hasAssociatedProperty() {
        return this.myAssociatedProperty != null;
    }

    CIMProperty getAssociatedProperty() {
        return this.myAssociatedProperty;
    }

    public Object getObjectValue() {
        Object object = null;
        if (this.myDelegate != null) {
            object = this.myDelegate.getValue();
        }
        return object;
    }

    public Vector getVectorValue() {
        Vector<Object> vector = null;
        Object object = this.getObjectValue();
        if (object instanceof Vector) {
            vector = (Vector<Object>)object;
        } else {
            vector = new Vector<Object>();
            if (object != null) {
                vector.add(object);
            }
        }
        return vector;
    }

    public CIMObjectPath getObjectPathValue() {
        CIMObjectPath cIMObjectPath = null;
        Object object = this.getObjectValue();
        if (object instanceof CIMObjectPath) {
            cIMObjectPath = (CIMObjectPath)object;
        }
        return cIMObjectPath;
    }

    public String getStringValue(String string) {
        String string2 = string;
        Object object = this.getObjectValue();
        if (object instanceof String) {
            string2 = (String)object;
        }
        return string2;
    }

    public String getStringValue() {
        return this.getStringValue(null);
    }

    public String[] getStringValues() {
        Vector vector = this.getVectorValue();
        int n = vector != null ? vector.size() : 0;
        String[] stringArray = new String[n];
        if (vector != null) {
            stringArray = vector.toArray(stringArray);
        }
        return stringArray;
    }

    public Date getDateValue(Date date) {
        Date date2 = date;
        Object object = this.getObjectValue();
        if (object instanceof CIMDateTime) {
            CIMDateTime cIMDateTime = (CIMDateTime)object;
            date2 = cIMDateTime.getCalendar().getTime();
        }
        return date2;
    }

    public Date getDateValue() {
        return this.getDateValue(null);
    }

    public Number getNumberValue(Number number) {
        Number number2 = number;
        Object object = this.getObjectValue();
        if (object instanceof Number) {
            number2 = (Number)object;
        } else if (object instanceof String) {
            String string = (String)object;
            try {
                number2 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number2;
    }

    public Number getNumberValue() {
        return this.getNumberValue(null);
    }

    public Number[] getNumberValues() {
        Vector vector = this.getVectorValue();
        int n = vector != null ? vector.size() : 0;
        Number[] numberArray = new Number[n];
        if (vector != null) {
            numberArray = vector.toArray(numberArray);
        }
        return numberArray;
    }

    private BigInteger toBigInteger(Number number) {
        return this.toBigInteger(number, BigInteger.ZERO);
    }

    private BigInteger toBigInteger(Number number, BigInteger bigInteger) {
        BigInteger bigInteger2 = null;
        if (number instanceof BigInteger) {
            bigInteger2 = (BigInteger)number;
        } else if (number instanceof UnsignedInt64) {
            UnsignedInt64 unsignedInt64 = (UnsignedInt64)number;
            bigInteger2 = unsignedInt64.bigIntValue();
        } else {
            bigInteger2 = number != null ? new BigInteger(number.toString()) : bigInteger;
        }
        return bigInteger2;
    }

    public BigInteger getBigIntegerValue(BigInteger bigInteger) {
        Number number = this.getNumberValue(bigInteger);
        BigInteger bigInteger2 = this.toBigInteger(number, bigInteger);
        return bigInteger2;
    }

    public BigInteger getBigIntegerValue() {
        return this.getBigIntegerValue(null);
    }

    public BigInteger[] getBigIntegerValues() {
        Number[] numberArray = this.getNumberValues();
        BigInteger[] bigIntegerArray = new BigInteger[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            bigIntegerArray[i] = this.toBigInteger(numberArray[i]);
        }
        return bigIntegerArray;
    }

    byte byteValue(Byte by) {
        Number number = this.getNumberValue(by);
        return number.byteValue();
    }

    public byte byteValue(byte by) {
        return this.byteValue(new Byte(by));
    }

    public byte byteValue() {
        return this.byteValue((byte)-128);
    }

    public byte[] byteValues() {
        Number[] numberArray = this.getNumberValues();
        byte[] byArray = new byte[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            byArray[i] = numberArray[i].byteValue();
        }
        return byArray;
    }

    short shortValue(Short s) {
        Number number = this.getNumberValue(s);
        return number.shortValue();
    }

    public short shortValue(short s) {
        return this.shortValue(new Short(s));
    }

    public short shortValue() {
        return this.shortValue((short)Short.MIN_VALUE);
    }

    public short[] shortValues() {
        Number[] numberArray = this.getNumberValues();
        short[] sArray = new short[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            sArray[i] = numberArray[i].shortValue();
        }
        return sArray;
    }

    int intValue(Integer n) {
        Number number = this.getNumberValue(n);
        return number.intValue();
    }

    public int intValue(int n) {
        return this.intValue(new Integer(n));
    }

    public int intValue() {
        return this.intValue(Integer.MIN_VALUE);
    }

    public int[] intValues() {
        Number[] numberArray = this.getNumberValues();
        int[] nArray = new int[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            nArray[i] = numberArray[i].intValue();
        }
        return nArray;
    }

    long longValue(Long l) {
        Number number = this.getNumberValue(l);
        return number.longValue();
    }

    public long longValue(long l) {
        return this.longValue(new Long(l));
    }

    public long longValue() {
        return this.longValue(Long.MIN_VALUE);
    }

    public long[] longValues() {
        Number[] numberArray = this.getNumberValues();
        long[] lArray = new long[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            lArray[i] = numberArray[i].longValue();
        }
        return lArray;
    }

    float floatValue(Float f) {
        Number number = this.getNumberValue(f);
        return number.floatValue();
    }

    public float floatValue(float f) {
        return this.floatValue(new Float(f));
    }

    public float floatValue() {
        return this.floatValue(Float.MIN_VALUE);
    }

    public float[] floatValues() {
        Number[] numberArray = this.getNumberValues();
        float[] fArray = new float[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            fArray[i] = numberArray[i].floatValue();
        }
        return fArray;
    }

    double doubleValue(Double d) {
        Number number = this.getNumberValue(d);
        return number.doubleValue();
    }

    public double doubleValue(double d) {
        return this.doubleValue(new Double(d));
    }

    public double doubleValue() {
        return this.doubleValue(Double.MIN_VALUE);
    }

    public double[] doubleValues() {
        Number[] numberArray = this.getNumberValues();
        double[] dArray = new double[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            dArray[i] = numberArray[i].doubleValue();
        }
        return dArray;
    }

    public boolean booleanValue(boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        Object object = this.getObjectValue();
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        return bl2;
    }

    public boolean booleanValue() {
        return this.booleanValue(false);
    }

    public boolean[] booleanValues() {
        Vector vector = this.getVectorValue();
        int n = vector != null ? vector.size() : 0;
        boolean[] blArray = new boolean[n];
        if (vector != null) {
            for (int i = 0; i < n; ++i) {
                Boolean bl = (Boolean)vector.get(i);
                blArray[i] = bl;
            }
        }
        return blArray;
    }

    public void setValue(Object object) {
        this.setDelegate(new CIMValue(object));
    }

    public void setValue(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                vector.add(objectArray[i]);
            }
        }
        this.setValue(vector);
    }

    public void setValue(CimObject cimObject) {
        this.setValue(cimObject.getObjectPath());
    }

    public void setValue(CimObject[] cimObjectArray) {
        this.setValue(cimObjectArray, true);
    }

    public void setValue(CimObject[] cimObjectArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (cimObjectArray != null) {
            for (int i = 0; i < cimObjectArray.length; ++i) {
                if (bl) {
                    vector.add(cimObjectArray[i].getObjectPath().toString());
                    continue;
                }
                vector.add((String)cimObjectArray[i].getObjectPath());
            }
        }
        this.setValue(vector);
    }

    public void setValue(boolean bl) {
        this.setValue(new Boolean(bl));
    }

    private Number toNumber(Number number, NumberType numberType) {
        Number number2 = null;
        boolean bl = numberType.isSigned();
        switch (numberType.getBits()) {
            case 8: {
                number2 = bl ? new Byte(number.byteValue()) : new UnsignedInt8(number.shortValue());
                break;
            }
            case 16: {
                number2 = bl ? new Short(number.shortValue()) : new UnsignedInt16(number.intValue());
                break;
            }
            case 32: {
                number2 = bl ? new Integer(number.intValue()) : new UnsignedInt32(number.longValue());
                break;
            }
            case 64: {
                number2 = bl ? new Long(number.longValue()) : new UnsignedInt64(number.toString());
            }
        }
        return number2;
    }

    public void setValue(byte by) {
        this.setValue(by, NumberType.SINT8);
    }

    public void setValue(byte by, NumberType numberType) {
        Byte by2 = new Byte(by);
        Number number = this.toNumber(by2, numberType);
        this.setValue(number);
    }

    public void setValue(byte[] byArray) {
        this.setValue(byArray, NumberType.SINT8);
    }

    public void setValue(byte[] byArray, NumberType numberType) {
        int n = byArray != null ? byArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        for (int i = 0; i < n; ++i) {
            Byte by = new Byte(byArray[i]);
            Number number = this.toNumber(by, numberType);
            vector.add(number);
        }
        this.setValue(vector);
    }

    public void setValue(short s) {
        this.setValue(s, NumberType.SINT16);
    }

    public void setValue(short s, NumberType numberType) {
        Short s2 = new Short(s);
        Number number = this.toNumber(s2, numberType);
        this.setValue(number);
    }

    public void setValue(short[] sArray) {
        this.setValue(sArray, NumberType.SINT16);
    }

    public void setValue(short[] sArray, NumberType numberType) {
        int n = sArray != null ? sArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        for (int i = 0; i < n; ++i) {
            Short s = new Short(sArray[i]);
            Number number = this.toNumber(s, numberType);
            vector.add(number);
        }
        this.setValue(vector);
    }

    public void setValue(int n) {
        this.setValue(n, NumberType.SINT32);
    }

    public void setValue(int n, NumberType numberType) {
        Integer n2 = new Integer(n);
        Number number = this.toNumber(n2, numberType);
        this.setValue(number);
    }

    public void setValue(int[] nArray) {
        this.setValue(nArray, NumberType.SINT32);
    }

    public void setValue(int[] nArray, NumberType numberType) {
        int n = nArray != null ? nArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(nArray[i]);
            Number number = this.toNumber(n2, numberType);
            vector.add(number);
        }
        this.setValue(vector);
    }

    public void setValue(long l) {
        this.setValue(l, NumberType.SINT64);
    }

    public void setValue(long l, NumberType numberType) {
        Long l2 = new Long(l);
        Number number = this.toNumber(l2, numberType);
        this.setValue(number);
    }

    public void setValue(long[] lArray) {
        this.setValue(lArray, NumberType.SINT64);
    }

    public void setValue(long[] lArray, NumberType numberType) {
        int n = lArray != null ? lArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        for (int i = 0; i < n; ++i) {
            Long l = new Long(lArray[i]);
            Number number = this.toNumber(l, numberType);
            vector.add(number);
        }
        this.setValue(vector);
    }

    public void setValue(BigInteger bigInteger) {
        this.setValue(bigInteger, NumberType.UINT64);
    }

    public void setValue(BigInteger bigInteger, NumberType numberType) {
        BigInteger bigInteger2 = bigInteger;
        Number number = this.toNumber(bigInteger2, numberType);
        this.setValue(number);
    }

    public void setValue(BigInteger[] bigIntegerArray) {
        this.setValue(bigIntegerArray, NumberType.UINT64);
    }

    public void setValue(BigInteger[] bigIntegerArray, NumberType numberType) {
        int n = bigIntegerArray != null ? bigIntegerArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger = bigIntegerArray[i] != null ? bigIntegerArray[i] : BigInteger.ZERO;
            Number number = this.toNumber(bigInteger, numberType);
            vector.add(number);
        }
        this.setValue(vector);
    }

    public void setValue(String string, NumberType numberType) {
        BigInteger bigInteger = string != null ? new BigInteger(string) : BigInteger.ZERO;
        Number number = this.toNumber(bigInteger, numberType);
        this.setValue(number);
    }

    public void setValue(String[] stringArray, NumberType numberType) {
        int n = stringArray != null ? stringArray.length : 0;
        Vector<Number> vector = new Vector<Number>(n);
        for (int i = 0; i < n; ++i) {
            BigInteger bigInteger = stringArray[i] != null ? new BigInteger(stringArray[i]) : BigInteger.ZERO;
            Number number = this.toNumber(bigInteger, numberType);
            vector.add(number);
        }
        this.setValue(vector);
    }

    public void setValue(float f) {
        this.setValue(new Float(f));
    }

    public void setValue(float[] fArray) {
        int n = fArray != null ? fArray.length : 0;
        Vector<Float> vector = new Vector<Float>(n);
        for (int i = 0; i < n; ++i) {
            Float f = new Float(fArray[i]);
            vector.add(f);
        }
        this.setValue(vector);
    }

    public void setValue(double d) {
        this.setValue(new Double(d));
    }

    public void setValue(double[] dArray) {
        int n = dArray != null ? dArray.length : 0;
        Vector<Double> vector = new Vector<Double>(n);
        for (int i = 0; i < n; ++i) {
            Double d = new Double(dArray[i]);
            vector.add(d);
        }
        this.setValue(vector);
    }

    public String toString() {
        return "" + this.getObjectValue();
    }

    public static class NumberType {
        public static final int _8 = 8;
        public static final int _16 = 16;
        public static final int _32 = 32;
        public static final int _64 = 64;
        public static final NumberType SINT8 = new NumberType(8, true);
        public static final NumberType SINT16 = new NumberType(16, true);
        public static final NumberType SINT32 = new NumberType(32, true);
        public static final NumberType SINT64 = new NumberType(64, true);
        public static final NumberType UINT8 = new NumberType(8, false);
        public static final NumberType UINT16 = new NumberType(16, false);
        public static final NumberType UINT32 = new NumberType(32, false);
        public static final NumberType UINT64 = new NumberType(64, false);
        private final int myBits;
        private final boolean mySigned;

        private NumberType(int n, boolean bl) {
            this.myBits = n;
            this.mySigned = bl;
        }

        public final int getBits() {
            return this.myBits;
        }

        public final boolean isSigned() {
            return this.mySigned;
        }
    }
}

