/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.mgmt.common;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.mgmt.Recipe;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.Pool;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.PoolSettingWithHints;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolTable;
import com.sun.netstorage.mgmt.esm.logic.data.api.StorageProfileTable;
import java.util.Vector;

public class FindPoolProfileHelper
extends Recipe {
    public static final String TLO_6920 = "sunstoredge_dspstoragesystem";
    public static final String NOT_APPL = "-";
    private String ipAddr = null;
    private StorageSystem mySystem = null;
    private StorageSystem[] myDomains = new StorageSystem[0];
    private StoragePoolTable[] myPools = new StoragePoolTable[0];
    private StorageProfileTable[] myProfiles = new StorageProfileTable[0];

    public FindPoolProfileHelper(String string, CimObjectManager cimObjectManager) {
        super(cimObjectManager);
        this.ipAddr = string;
    }

    public void closeRecipe() {
    }

    public StorageSystem getStorageSystem() {
        return this.mySystem;
    }

    public StorageSystem[] getDomains() {
        return this.myDomains;
    }

    public StoragePoolTable[] getStoragePools() {
        return this.myPools;
    }

    public StorageProfileTable[] getStorageProfiles() {
        return this.myProfiles;
    }

    public StorageSystem[] getTLOStorageSystems() {
        Vector<StorageSystem> vector = new Vector<StorageSystem>();
        StorageSystem[] storageSystemArray = this.getCimObjectManager().getStorageSystems();
        int n = storageSystemArray != null ? storageSystemArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!storageSystemArray[i].isCluster()) continue;
            vector.addElement(storageSystemArray[i]);
        }
        StorageSystem[] storageSystemArray2 = new StorageSystem[vector.size()];
        vector.toArray(storageSystemArray2);
        return storageSystemArray2;
    }

    protected final void runRecipe() {
        this.setInProgressFlag(true);
        StorageSystem[] storageSystemArray = this.getTLOStorageSystems();
        int n = storageSystemArray != null ? storageSystemArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (storageSystemArray.length > 1 && storageSystemArray[i].getObjectPath().toString().toLowerCase().indexOf(TLO_6920) == -1) continue;
            this.mySystem = storageSystemArray[i];
        }
        if (this.mySystem != null) {
            this.myDomains = this.mySystem.getComponentStorageSystems();
            Vector<StoragePoolTable> vector = new Vector<StoragePoolTable>();
            Vector<StorageProfileTable> vector2 = new Vector<StorageProfileTable>();
            Pool[] poolArray = null;
            PoolSettingWithHints poolSettingWithHints = null;
            for (int i = 0; i < this.myDomains.length; ++i) {
                poolArray = this.myDomains[i].getPools();
                for (int j = 0; j < poolArray.length; ++j) {
                    String string;
                    poolSettingWithHints = null;
                    if (poolArray[j].getTotalManagedSpace() == 0L || (poolSettingWithHints = poolArray[j].getHints()) == null) continue;
                    StoragePoolTable storagePoolTable = new StoragePoolTable();
                    storagePoolTable.setDeviceName(this.ipAddr);
                    String string2 = new String(this.myDomains[i].getName());
                    if (string2.indexOf(".") != -1 && (string = string2.substring(0, string2.indexOf("."))) != null && string.length() == 16) {
                        string2 = string2.substring(string2.indexOf(".") + 1);
                    }
                    storagePoolTable.setStorageDomain(string2);
                    storagePoolTable.setPoolName(poolArray[j].getElementName());
                    storagePoolTable.setStorageProfile(poolSettingWithHints.getElementName());
                    storagePoolTable.setTotalCapacity(poolArray[j].getTotalManagedSpace());
                    storagePoolTable.setAvailableCapacity(poolArray[j].getUnallocatedSpace());
                    float f = (float)poolArray[j].getTotalManagedSpace() - (float)poolArray[j].getUnallocatedSpace();
                    float f2 = f / (float)poolArray[j].getTotalManagedSpace() * 100.0f;
                    storagePoolTable.setUtilPercentage(f2);
                    storagePoolTable.setInUse(true);
                    vector.addElement(storagePoolTable);
                    StorageProfileTable storageProfileTable = new StorageProfileTable();
                    storageProfileTable.setProfileName(poolSettingWithHints.getElementName());
                    String string3 = poolSettingWithHints.getProductVersion();
                    if (string3 == null || string3.length() == 0) {
                        storageProfileTable.setProductVersion(NOT_APPL);
                    } else {
                        storageProfileTable.setProductVersion(string3);
                    }
                    storageProfileTable.setDescription(poolSettingWithHints.getDescription());
                    storageProfileTable.setRaidLevel(poolSettingWithHints.isNoSinglePointOfFailure(), poolSettingWithHints.getDataRedundancyGoal(), poolSettingWithHints.getPackageRedundancyGoal(), poolSettingWithHints.getNumberOfDisks());
                    storageProfileTable.setSegmentSize(poolSettingWithHints.getSegmentSize());
                    storageProfileTable.setReadAheadMode(poolSettingWithHints.getAccessDirectionHint());
                    storageProfileTable.setDriveType("FC");
                    storageProfileTable.setNumberOfDisks(poolSettingWithHints.getNumberOfDisks());
                    if (!storageProfileTable.isFactoryDefined()) {
                        storageProfileTable.setPoolNameKey(poolSettingWithHints.getInstanceID());
                        storageProfileTable.setDeviceNameKey(storagePoolTable.getDeviceName());
                        storageProfileTable.setStorageDomainKey(storagePoolTable.getStorageDomain());
                    }
                    vector2.addElement(storageProfileTable);
                }
            }
            this.myPools = new StoragePoolTable[vector.size()];
            this.myProfiles = new StorageProfileTable[vector2.size()];
            vector.toArray(this.myPools);
            vector2.toArray(this.myProfiles);
        }
        this.setInProgressFlag(false);
    }
}

