/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.impl.ElementTable;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.mgmt.Recipe;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.mgmt.common.FindPoolProfileHelper;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.mgmt.common.FindProductDataHelper;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.CimObjectManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.model.common.ProductData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.util.CimomProxy;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.poolagg.core.util.Trace;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoragePoolTable;
import com.sun.netstorage.mgmt.esm.logic.data.api.StorageProfileTable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ActiveCimomThread
extends Thread {
    private String ipAddress = null;
    private HashMap cimomMgrs = new HashMap();
    private HashMap recipehm = new HashMap();
    private boolean recipeComplete = true;
    private Throwable failure = null;
    private long lastActiveCimomConnectTime = 0L;
    private Set discoveredElements = new HashSet();
    private Set lastDiscoveredElements = new HashSet();
    private StoragePoolTable[] discoveredPools = new StoragePoolTable[0];
    private StorageProfileTable[] discoveredProfiles = new StorageProfileTable[0];
    private long RETRY_SLEEP_TIME = 300000L;
    private long ticks = 0L;
    private boolean okToRun = true;
    private boolean inProgress = true;
    private Object dataLock = new Object();

    public ActiveCimomThread() {
    }

    public ActiveCimomThread(long l) {
        this.setRetrySleepTime(l);
    }

    public synchronized void add(String string, String string2, String string3) {
        if (this.cimomMgrs.containsKey(string)) {
            return;
        }
        this.ipAddress = string;
        String string4 = "cim-xml://" + string2 + "@" + string + ":5989/root/se6x20?password=" + string3;
        CimomProxy cimomProxy = new CimomProxy(string4);
        CimObjectManager cimObjectManager = CimObjectManager.create(cimomProxy);
        this.cimomMgrs.put(string, cimObjectManager);
    }

    public synchronized void remove(String string) {
        if (this.cimomMgrs.containsKey(string)) {
            this.cimomMgrs.remove(string);
        }
        string = null;
    }

    public long getRetrySleepTime() {
        return this.RETRY_SLEEP_TIME;
    }

    public void setRetrySleepTime(long l) {
        this.RETRY_SLEEP_TIME = l;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public long getLastActiveCimomConnectTime() {
        return this.lastActiveCimomConnectTime;
    }

    public Set getDiscoveredElements(boolean bl) {
        if (bl) {
            return this.discoveredElements;
        }
        return this.lastDiscoveredElements;
    }

    public boolean getRunFlag() {
        return this.okToRun;
    }

    protected synchronized void setRunFlag(boolean bl) {
        this.okToRun = bl;
    }

    public boolean getInProgress() {
        return this.inProgress;
    }

    private synchronized void setInProgress(boolean bl) {
        if (!bl) {
            this.lastActiveCimomConnectTime = new Date().getTime();
        }
        this.inProgress = bl;
    }

    public synchronized StoragePoolTable[] getDiscoveredStoragePools() {
        if (this.ipAddress == null || this.recipehm.isEmpty()) {
            return this.discoveredPools;
        }
        Object v = this.recipehm.get(this.ipAddress);
        if (v == null) {
            return this.discoveredPools;
        }
        Recipe[] recipeArray = (Recipe[])v;
        FindPoolProfileHelper findPoolProfileHelper = (FindPoolProfileHelper)recipeArray[0];
        if (!findPoolProfileHelper.getInProgressFlag()) {
            this.discoveredPools = findPoolProfileHelper.getStoragePools();
            this.discoveredProfiles = findPoolProfileHelper.getStorageProfiles();
        }
        return this.discoveredPools;
    }

    public StorageProfileTable[] getDiscoveredStorageProfiles() {
        return this.discoveredProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCimomModels() {
        block13: {
            try {
                Object object;
                Recipe[] recipeArray;
                this.setInProgress(true);
                Iterator iterator = null;
                Map.Entry entry = null;
                String string = null;
                CimObjectManager cimObjectManager = null;
                ++this.ticks;
                if (this.ticks % 6L != 0L && this.ticks >= 4L) break block13;
                this.lastDiscoveredElements.clear();
                ElementTable[] elementTableArray = this.discoveredElements.toArray(new ElementTable[this.discoveredElements.size()]);
                for (int i = 0; i < elementTableArray.length; ++i) {
                    this.lastDiscoveredElements.add(elementTableArray[i]);
                }
                this.discoveredElements.clear();
                iterator = this.cimomMgrs.entrySet().iterator();
                while (iterator.hasNext() && !this.recipehm.isEmpty()) {
                    entry = iterator.next();
                    string = (String)entry.getKey();
                    Object v = this.recipehm.get(string);
                    if (v == null) continue;
                    recipeArray = (Recipe[])v;
                    this.recipeComplete = true;
                    this.failure = null;
                    for (int i = 0; i < recipeArray.length; ++i) {
                        if (!recipeArray[i].getInProgressFlag()) continue;
                        Trace.verbose((Object)this, "setCimomModels", string + "recipe " + i + " did not complete in time. There may be an issue" + " with this data source.");
                        this.recipeComplete = false;
                        this.failure = recipeArray[i].getFailure();
                        break;
                    }
                    if (!this.recipeComplete) continue;
                    FindPoolProfileHelper findPoolProfileHelper = (FindPoolProfileHelper)recipeArray[0];
                    object = this.dataLock;
                    synchronized (object) {
                        this.discoveredPools = findPoolProfileHelper.getStoragePools();
                        this.discoveredProfiles = findPoolProfileHelper.getStorageProfiles();
                    }
                    object = (FindProductDataHelper)recipeArray[1];
                    if (((FindProductDataHelper)object).getProductData() == null) continue;
                    ProductData[] productDataArray = ((FindProductDataHelper)object).getProductData();
                    for (int i = 0; i < productDataArray.length; ++i) {
                        ElementTable elementTable = new ElementTable(productDataArray[i]);
                        this.discoveredElements.add(elementTable);
                    }
                }
                Object object2 = this.dataLock;
                synchronized (object2) {
                    this.recipehm.clear();
                    iterator = this.cimomMgrs.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        string = (String)entry.getKey();
                        cimObjectManager = (CimObjectManager)entry.getValue();
                        recipeArray = new Recipe[2];
                        recipeArray[0] = new FindPoolProfileHelper(string, cimObjectManager);
                        Thread thread = new Thread(recipeArray[0]);
                        thread.start();
                        recipeArray[1] = new FindProductDataHelper(cimObjectManager);
                        object = new Thread(recipeArray[1]);
                        ((Thread)object).start();
                        this.recipehm.put(string, recipeArray);
                    }
                }
            }
            catch (Exception exception) {
                Trace.error((Object)this, "setCimomModels", exception);
            }
        }
        this.setInProgress(false);
    }

    public void closeRecipes() {
        Iterator iterator = this.cimomMgrs.entrySet().iterator();
        Map.Entry entry = null;
        String string = null;
        while (iterator.hasNext()) {
            Object v;
            entry = iterator.next();
            string = (String)entry.getKey();
            if (this.recipehm.isEmpty() || (v = this.recipehm.get(string)) == null) continue;
            Recipe[] recipeArray = (Recipe[])v;
            for (int i = 0; i < recipeArray.length; ++i) {
                recipeArray[i].closeRecipe();
            }
        }
    }

    public void run() {
        while (this.getRunFlag()) {
            this.setCimomModels();
            try {
                ActiveCimomThread.sleep(this.getRetrySleepTime());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closeRecipes();
    }
}

