/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.api.PerfDataCollectorFactoryMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130CollectorFactory;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.impl.PerfDataCollectorFactoryConstants;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.PerfFactoryBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.scheduler.impl.SchedulerUtilImpl;
import com.sun.netstorage.mgmt.esm.logic.thread.ThreadPool;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableNotFoundException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.VendorException;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.management.MBeanServer;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;

public class PerfDataCollectorFactory
implements PerfDataCollectorFactoryMBean {
    private String logfile = null;
    private Handler logfileHandler = null;
    private Logger logger = PerfDataCollectorFactoryConstants.LOGGER;
    private static final String CLASSNAME = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$PerfDataCollectorFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$PerfDataCollectorFactory = PerfDataCollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.impl.PerfDataCollectorFactory")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$PerfDataCollectorFactory).getName();
    public static final JobDetail databaseScrubberJobDetail = new JobDetail("Performance: Database Scrubber", "All Arrays", class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$DatabaseScrubberJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$DatabaseScrubberJob = PerfDataCollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.impl.DatabaseScrubberJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$DatabaseScrubberJob);
    private Trigger databaseScrubberTigger = null;
    Hashtable map = new Hashtable();
    PerfFactoryBean factoryDataBean = null;
    Object statusChangeLock = new Object();
    private MBeanServer mBeanServer = null;
    private static PerfDataCollectorFactory INSTANCE = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$PerfDataCollectorFactory;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$impl$DatabaseScrubberJob;

    public PerfDataCollectorFactory() {
        INSTANCE = this;
        try {
            this.factoryDataBean = PerfFactoryBean.get();
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "<init>", "Failed to retrieve saved settings from database", localizableException);
        }
        if (this.factoryDataBean == null) {
            this.factoryDataBean = new PerfFactoryBean(0, 2, 0);
            if (this.logger.isLoggable(Level.CONFIG)) {
                this.logger.logp(Level.CONFIG, CLASSNAME, "<init>", "Using default factory settings: scheduler - run daily 2:00 am.");
            }
        }
    }

    public static PerfDataCollectorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PerfDataCollectorFactory();
        }
        return INSTANCE;
    }

    public String addCollector(String string, String string2) throws LocalizableException {
        if (string.equals("6130") || string == null) {
            return Perf6130CollectorFactory.getInstance().addCollector(string2);
        }
        throw new LocalizableException("perfDataCollectorFactory.unknownDeviceType", new Serializable[]{string}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
    }

    public void removeCollector(String string) throws LocalizableException {
        try {
            if (!Perf6130CollectorFactory.getInstance().containsCollector(string)) {
                throw new LocalizableNotFoundException("perfDataCollectorFactory.canNotFindSpecifiedCollector", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
            }
            Perf6130CollectorFactory.getInstance().removeCollector(string);
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "removeCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "removeCollector(String)", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            throw new LocalizableException((Throwable)exception);
        }
    }

    public boolean containsCollector(String string) {
        return Perf6130CollectorFactory.getInstance().containsCollector(string);
    }

    public void startCollector(String string) throws LocalizableException {
        Perf6130CollectorFactory.getInstance().startCollector(string);
    }

    public LocalizableException[] reloadCollectors() throws LocalizableException {
        return Perf6130CollectorFactory.getInstance().reloadCollectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.logger.logp(Level.INFO, CLASSNAME, "start()", "Attempting to start service");
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.factoryDataBean.setOperationalStatus(OperationalStatus.STARTING);
            try {
                this.factoryDataBean.update();
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
            Perf6130CollectorFactory.getInstance().start();
            try {
                this.setScrubberSchedule(this.factoryDataBean.getDataScrubberScheduledHour(), this.factoryDataBean.getDataScrubberScheduledMinute());
            }
            catch (LocalizableException localizableException) {
                this.logger.logp(Level.WARNING, CLASSNAME, "start()", "Problem encountered starting database scrubber job.  Details: " + localizableException.getLocalizedMessage(Locale.ENGLISH));
            }
            this.factoryDataBean.setOperationalStatus(OperationalStatus.OK);
            this.logger.logp(Level.INFO, CLASSNAME, "start()", "Service successfully started");
        }
        try {
            this.factoryDataBean.update();
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.WARNING, CLASSNAME, "start()", localizableException.getLocalizedMessage(Locale.ENGLISH));
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "start()", vendorException.getLocalizedMessage());
        }
    }

    public synchronized void startAllCollectors() throws LocalizableException {
        Perf6130CollectorFactory.getInstance().startAllCollectors();
    }

    public void stopCollector(String string) throws LocalizableException {
        Perf6130CollectorFactory.getInstance().stopCollector(string);
    }

    public synchronized void stopAllCollectors() throws LocalizableException {
        Perf6130CollectorFactory.getInstance().stopAllCollectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.factoryDataBean.setOperationalStatus(OperationalStatus.STOPPING);
            try {
                this.factoryDataBean.update();
            }
            catch (LocalizableException localizableException) {
                // empty catch block
            }
            Perf6130CollectorFactory.getInstance().stop();
            try {
                PersistenceManager.release();
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
            try {
                this.unscheduleDatabaseScrubberJob();
            }
            catch (LocalizableException localizableException) {
                this.logger.logp(Level.WARNING, CLASSNAME, "stop()", "Problem unscheduling database scrubber job. Details: " + localizableException.getLocalizedMessage(Locale.ENGLISH));
            }
            this.factoryDataBean.setOperationalStatus(OperationalStatus.STOPPED);
            this.logger.logp(Level.INFO, CLASSNAME, "stop()", "Service successfully stopped.");
        }
        try {
            this.factoryDataBean.update();
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.WARNING, CLASSNAME, "stop()", localizableException.getLocalizedMessage(Locale.ENGLISH));
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "stop()", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
        }
    }

    public String getLogFile() {
        return this.logfile;
    }

    public void setLogFile(String string) throws LocalizableException {
        if (string.equals(this.logfile)) {
            return;
        }
        if (this.logfileHandler != null) {
            try {
                this.logfileHandler.close();
                this.logger.removeHandler(this.logfileHandler);
            }
            catch (Exception exception) {
                this.logger.logp(Level.WARNING, CLASSNAME, "setLogFile(String)", "Failed to remove previous logfile handler for" + this.logfile);
            }
        }
        try {
            if ("null".equals(string)) {
                string = null;
            }
            this.logfile = string;
            if (this.logfile != null) {
                this.logfileHandler = new FileHandler(string);
                SimpleFormatter simpleFormatter = new SimpleFormatter();
                this.logfileHandler.setFormatter(simpleFormatter);
                this.logger.addHandler(this.logfileHandler);
            }
        }
        catch (Exception exception) {
            throw new LocalizableException((Throwable)exception);
        }
    }

    public String getEffectiveLogLevel() {
        Logger logger;
        for (logger = this.logger; logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return "null";
        }
        Level level = logger.getLevel();
        if (level == null) {
            return "null";
        }
        String string = level.getName();
        if (string == null) {
            string = Integer.toString(level.intValue());
        }
        return string;
    }

    public String getLogLevel() {
        Level level = this.logger.getLevel();
        if (level == null) {
            return "null";
        }
        String string = this.logger.getLevel().getName();
        if (string == null) {
            string = Integer.toString(this.logger.getLevel().intValue());
        }
        return string;
    }

    public void setLogLevel(String string) throws LocalizableException {
        try {
            if (string != null && string.length() != 0) {
                if (string.toLowerCase().equals("null")) {
                    this.logger.setLevel(null);
                } else {
                    this.logger.setLevel(Level.parse(string.toUpperCase()));
                }
            }
            if (this.logger.isLoggable(Level.CONFIG)) {
                this.logger.logp(Level.CONFIG, CLASSNAME, "setLogLevel(String)", "Log level set to " + string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LocalizableException((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "setLogLevel(String)", "VENDER ERROR: Caught an unexpected exception: " + exception.getMessage(), exception);
            throw new LocalizableException((Throwable)exception);
        }
    }

    public String getOperationalStatus() {
        return this.factoryDataBean.getOperationalStatus().toString();
    }

    public void setDataRetentionIntervalOnCollectorsTo(int n) throws LocalizableException {
        Perf6130CollectorFactory.getInstance().setDataRetentionIntervalOnCollectorsTo(n);
    }

    public void setPollIntervalOnCollectorsTo(int n) throws LocalizableException {
        Perf6130CollectorFactory.getInstance().setPollIntervalOnCollectorsTo(n);
    }

    void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
        Perf6130CollectorFactory.getInstance().setMBeanServer(mBeanServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrubDatabase() throws LocalizableException {
        try {
            PerfDataCollectorFactory perfDataCollectorFactory = this;
            synchronized (perfDataCollectorFactory) {
                int n = Perf6130CollectorFactory.getInstance().scrubDatabase();
                this.updateDatabaseScrubTimes(new Date());
                if (n > 0) {
                    throw new LocalizableException("perfDataCollectorFactory.databaseScrubFailedForXCollectors", new Serializable[]{Integer.toString(n)}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
                }
            }
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "scrubDatabase", localizableException.getLocalizedMessage(Locale.ENGLISH));
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "scrubDatabase", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            throw new VendorException(exception);
        }
    }

    public int getScrubberScheduledHour() {
        return this.factoryDataBean.getDataScrubberScheduledHour();
    }

    public int getScrubberScheduledMinute() {
        return this.factoryDataBean.getDataScrubberScheduledMinute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrubberSchedule(int n, int n2) throws LocalizableException {
        try {
            Object object;
            this.factoryDataBean.setScrubber(0, n, n2);
            CronTrigger cronTrigger = (CronTrigger)TriggerUtils.makeDailyTrigger((int)n, (int)n2);
            cronTrigger.setName(databaseScrubberJobDetail.getName());
            cronTrigger.setGroup(databaseScrubberJobDetail.getGroup());
            cronTrigger.setStartTime(new Date());
            cronTrigger.setTimeZone(TimeZone.getDefault());
            if (this.logger.isLoggable(Level.CONFIG)) {
                object = new StringBuffer("Trigger scheduled to run daily at ");
                ((StringBuffer)object).append(n).append(":");
                if (n2 < 10) {
                    ((StringBuffer)object).append("0");
                }
                ((StringBuffer)object).append(n2);
                cronTrigger.setDescription(((StringBuffer)object).toString());
                this.logger.logp(Level.CONFIG, CLASSNAME, "setScrubberSchedule(int, int)", ((StringBuffer)object).toString());
            }
            object = this.statusChangeLock;
            synchronized (object) {
                if (OperationalStatus.OK.equals((Object)this.factoryDataBean.getOperationalStatus()) || OperationalStatus.STARTING.equals((Object)this.factoryDataBean.getOperationalStatus())) {
                    this.scheduleDatabaseScrubberJob((Trigger)cronTrigger);
                } else {
                    this.unscheduleDatabaseScrubberJob();
                }
            }
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "setScrubberSchedule(int, int)", localizableException.getLocalizedMessage(Locale.ENGLISH));
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "setScrubberSchedule(int, int)", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            throw new VendorException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDatabaseScrubberJob(Trigger trigger) throws LocalizableException {
        Scheduler scheduler;
        if (trigger == null) {
            return;
        }
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new LocalizableException("perfDataCollectorFactory.scheduleJob.failedToGetScheduler", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
        try {
            JobDetail jobDetail = databaseScrubberJobDetail;
            synchronized (jobDetail) {
                if (this.databaseScrubberTigger != null) {
                    this.unscheduleDatabaseScrubberJob();
                }
                this.databaseScrubberTigger = trigger;
                scheduler.scheduleJob(databaseScrubberJobDetail, this.databaseScrubberTigger);
                if (this.logger.isLoggable(Level.CONFIG)) {
                    StringBuffer stringBuffer = new StringBuffer("Successfully schedule job:");
                    stringBuffer.append(databaseScrubberJobDetail.getName()).append(".  ");
                    stringBuffer.append(this.databaseScrubberTigger.getDescription());
                    this.logger.logp(Level.FINER, CLASSNAME, "schedulePollJob", stringBuffer.toString());
                }
            }
            this.updateDatabaseScrubTimes(null);
        }
        catch (SchedulerException schedulerException) {
            throw new LocalizableException("perfDataCollectorFactory.scheduleJobFailed", new Serializable[]{schedulerException.getLocalizedMessage()}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "schedulePollJob", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            throw new VendorException(exception);
        }
    }

    public long getScrubberLastExecution() {
        return this.factoryDataBean.getScrubberLastExecutionTime();
    }

    void updateDatabaseScrubTimes(Date date) throws LocalizableException {
        Date date2;
        if (date != null) {
            this.factoryDataBean.setScrubberLastExecutionTime(date.getTime());
        }
        if (this.databaseScrubberTigger != null && (date2 = this.databaseScrubberTigger.getNextFireTime()) != null) {
            this.factoryDataBean.setScrubberNextScheduledExecutionTime(date2.getTime());
        }
        try {
            this.factoryDataBean.update();
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.WARNING, CLASSNAME, "updateDatabaseScrubTimes(Date)", localizableException.getLocalizedMessage(Locale.ENGLISH));
            throw localizableException;
        }
        catch (Exception exception) {
            this.logger.logp(Level.SEVERE, CLASSNAME, "updateDatabaseScrubTimes(Date)", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            throw new VendorException(exception);
        }
    }

    public long getScrubberNextScheduledExecution() {
        return this.factoryDataBean.getScrubberNextScheduledExecutionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getDatabaseScrubberNextExcecution() {
        JobDetail jobDetail = databaseScrubberJobDetail;
        synchronized (jobDetail) {
            if (this.databaseScrubberTigger == null) {
                return 0L;
            }
            return this.databaseScrubberTigger.getNextFireTime().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleDatabaseScrubberJob() throws LocalizableException {
        if (this.databaseScrubberTigger == null) {
            return;
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new LocalizableException("perfDataCollectorFactory.unscheduleJob.failedToGetScheduler", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
        try {
            JobDetail jobDetail = databaseScrubberJobDetail;
            synchronized (jobDetail) {
                scheduler.unscheduleJob(this.databaseScrubberTigger.getName(), this.databaseScrubberTigger.getGroup());
                scheduler.deleteJob(databaseScrubberJobDetail.getName(), databaseScrubberJobDetail.getGroup());
                this.databaseScrubberTigger = null;
            }
        }
        catch (SchedulerException schedulerException) {
            throw new LocalizableException("perfDataCollectorFactory.unscheduleJobFailed", new Serializable[]{schedulerException.getLocalizedMessage()}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
        this.factoryDataBean.setScrubberNextScheduledExecutionTime(0L);
    }

    public int getThreadPoolMaximumSize() {
        ThreadPool threadPool = ThreadPool.getInstance();
        return threadPool.getMaximumPoolSize();
    }

    public void setThreadPoolMaximumSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid pool size specified.");
        }
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.setMaximumPoolSize(n);
        this.logger.logp(Level.CONFIG, CLASSNAME, "setThreadPoolMaximumSize()", "Common Thread Pool maximum thread pool size set to " + threadPool.getMaximumPoolSize());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

