/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataType;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.VolPerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.util.Convert;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.PerfVolInfoBean;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;

class VolPerfData
extends PerfData {
    protected VolPerfCounterData diffPerfData = null;
    protected VolPerfCounterData currentPerfData = null;
    protected boolean controllerResetAfterStart = false;
    protected boolean volumeCreatedAfterStart = false;

    public VolPerfData(String string, String string2) {
        super(string, string2, PerfDataType.VOLUME);
    }

    public synchronized void releaseDiffData() {
        this.diffPerfData = null;
    }

    public synchronized VolPerfCounterData getDiffData() {
        return this.diffPerfData;
    }

    public VolPerfCounterData getPerfData() {
        return this.currentPerfData;
    }

    public boolean controllerResetAfterStart() {
        return this.controllerResetAfterStart;
    }

    public void setControllerResetAfterStart() {
        this.controllerResetAfterStart = true;
        this.currentPerfData = null;
        this.diffPerfData = null;
        this.markDataAsNotAvailable();
    }

    public void setVolumeCreatedAfterStart() {
        this.volumeCreatedAfterStart = true;
    }

    public boolean volumeCreatedAfterStart() {
        return this.volumeCreatedAfterStart;
    }

    public void markInvalidDueToBlockSize() {
        this.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        this.setAverageReadSize(-1.0);
        this.setAverageWriteSize(-1.0);
        this.setReadsPerSec(-1.0);
        this.setWritesPerSec(-1.0);
    }

    public boolean hasPerfData() {
        return this.currentPerfData.totalRequestsServiced != 0L;
    }

    public void setPerfData(VolPerfCounterData volPerfCounterData) {
        if (this.currentPerfData != null) {
            this.diffPerfData = this.currentPerfData.subtract(volPerfCounterData);
        }
        this.currentPerfData = volPerfCounterData;
        if (this.diffPerfData == null) {
            if (this.controllerResetAfterStart()) {
                this.addErrorCode(PerfErrorCode.CONTROLLER_RESET);
            }
            return;
        }
        if (this.diffPerfData.isDataValid() && this.diffPerfData.interval > 0L) {
            long l = this.diffPerfData.totalRequestsServiced;
            if (l == 0L) {
                this.setTotalIOPs(0.0);
            } else {
                this.setTotalIOPs((double)l / (double)this.diffPerfData.interval);
            }
            if (!this.diffPerfData.isBlockSizeValid()) {
                this.markInvalidDueToBlockSize();
            } else {
                if (this.diffPerfData.totalReadBlocksRequested == 0L || this.diffPerfData.totalReadRequests == 0L) {
                    this.setAverageReadSize(0.0);
                } else {
                    this.setAverageReadSize((double)this.diffPerfData.totalReadBlocksRequested / (double)this.diffPerfData.totalReadRequests * (double)this.diffPerfData.blockSize);
                }
                if (this.diffPerfData.totalWriteBlocksRequested == 0L || this.diffPerfData.totalWriteRequests == 0L) {
                    this.setAverageWriteSize(0.0);
                } else {
                    this.setAverageWriteSize((double)this.diffPerfData.totalWriteBlocksRequested / (double)this.diffPerfData.totalWriteRequests * (double)this.diffPerfData.blockSize);
                }
            }
            this.setReadsPerSec((double)this.diffPerfData.totalReadBlocksRequested * (double)this.diffPerfData.blockSize / (double)this.diffPerfData.interval);
            this.setWritesPerSec((double)this.diffPerfData.totalWriteBlocksRequested * (double)this.diffPerfData.blockSize / (double)this.diffPerfData.interval);
            if (this.diffPerfData.totalCacheReadChecks == 0L || this.diffPerfData.totalCacheReadCheckHits == 0L) {
                this.setCacheReadHitPercentage(0.0f);
            } else {
                this.setCacheReadHitPercentage((float)this.diffPerfData.totalCacheReadCheckHits / (float)this.diffPerfData.totalCacheReadChecks * 100.0f);
            }
            if (this.diffPerfData.totalReadRequests == 0L) {
                this.setReadPercentage(0.0f);
            } else {
                this.setReadPercentage((float)this.diffPerfData.totalReadRequests / (float)this.diffPerfData.totalRequestsServiced * 100.0f);
            }
            if (this.diffPerfData.totalWriteRequests == 0L) {
                this.setWritePercentage(0.0f);
            } else {
                this.setWritePercentage((float)this.diffPerfData.totalWriteRequests / (float)this.diffPerfData.totalRequestsServiced * 100.0f);
            }
            this.setPollTime(this.diffPerfData.time);
        } else {
            this.addErrorCodes(this.diffPerfData.getErrorCodes());
            this.markDataAsNotAvailable();
        }
    }

    public PerfVolInfoBean getVolInfoBean(String string) {
        return new PerfVolInfoBean(string, this.getName(), this.getWWN());
    }

    public static String getVolumeKey(Volume volume) {
        String string = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
        if (string == null || string.length() == 0) {
            string = Convert.bytesToString(volume.getWorldWideName());
        }
        return string;
    }
}

