/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;
import devmgr.versioned.symbol.VolumePerformance;

public class VolPerfCounterData
extends PerfCounterData
implements Cloneable {
    private static final long OVERFLOW_ADJUSTMENT = (long)Math.pow(2.0, 32.0);
    private static final long MAX_LONG = (long)Math.pow(2.0, 63.0) - 1L;
    long time = 0L;
    long interval = 1L;
    long totalBlocksRequested = 0L;
    long totalCacheReadCheckHits = 0L;
    long totalCacheReadChecks = 0L;
    long totalReadBlocksRequested = 0L;
    long totalReadRequests = 0L;
    long totalRequestsServiced = 0L;
    long totalWriteBlocksRequested = 0L;
    long totalWriteRequests = 0L;
    String ref = null;
    int blockSize;
    boolean blockSizeValidity = true;
    boolean dataValidity = true;

    public VolPerfCounterData(long l, String string, int n) {
        this.time = l;
        this.blockSize = n;
        this.interval = 0L;
        this.ref = string;
    }

    public VolPerfCounterData(VolumePerformance volumePerformance, String string, int n) {
        this(volumePerformance.getTime() * 1000L, string, n);
        this.totalBlocksRequested = volumePerformance.getTotalBlocksRequested();
        this.totalCacheReadChecks = volumePerformance.getTotalCacheReadChecks();
        this.totalCacheReadCheckHits = volumePerformance.getTotalCacheReadCheckHits();
        this.totalReadBlocksRequested = volumePerformance.getTotalReadBlocksRequested();
        this.totalReadRequests = volumePerformance.getTotalReadRequests();
        this.totalRequestsServiced = volumePerformance.getTotalRequestsServiced();
        this.totalWriteBlocksRequested = volumePerformance.getTotalWriteBlocksRequested();
        this.totalWriteRequests = volumePerformance.getTotalWriteRequests();
        if (this.totalBlocksRequested < 0L) {
            this.totalBlocksRequested += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalCacheReadChecks < 0L) {
            this.totalCacheReadChecks += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalCacheReadCheckHits < 0L) {
            this.totalCacheReadCheckHits += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalReadBlocksRequested < 0L) {
            this.totalReadBlocksRequested += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalReadRequests < 0L) {
            this.totalReadRequests += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalRequestsServiced < 0L) {
            this.totalRequestsServiced += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalWriteBlocksRequested < 0L) {
            this.totalWriteBlocksRequested += OVERFLOW_ADJUSTMENT;
        }
        if (this.totalWriteRequests < 0L) {
            this.totalWriteRequests += OVERFLOW_ADJUSTMENT;
        }
        this.interval = 1L;
    }

    public void add(VolPerfCounterData volPerfCounterData) {
        if (this.blockSize != volPerfCounterData.blockSize) {
            volPerfCounterData.setBlockSizeValid(false);
            volPerfCounterData.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        }
        if (this.ref != null && !this.ref.equals(volPerfCounterData.ref)) {
            volPerfCounterData.setDataValid(false);
            volPerfCounterData.addErrorCode(PerfErrorCode.VOLUME_PRIMARY_PATH_CHANGED);
            return;
        }
        if (!volPerfCounterData.isDataValid()) {
            this.setDataValid(false);
            this.addErrorCodes(volPerfCounterData.getErrorCodes());
            return;
        }
        this.totalBlocksRequested += volPerfCounterData.totalBlocksRequested;
        this.totalCacheReadCheckHits += volPerfCounterData.totalCacheReadCheckHits;
        this.totalCacheReadChecks += volPerfCounterData.totalCacheReadChecks;
        this.totalReadBlocksRequested += volPerfCounterData.totalReadBlocksRequested;
        this.totalReadRequests += volPerfCounterData.totalReadRequests;
        this.totalRequestsServiced += volPerfCounterData.totalRequestsServiced;
        this.totalWriteBlocksRequested += volPerfCounterData.totalWriteBlocksRequested;
        this.totalWriteRequests += volPerfCounterData.totalWriteRequests;
    }

    public VolPerfCounterData subtract(VolPerfCounterData volPerfCounterData) {
        VolPerfCounterData volPerfCounterData2 = new VolPerfCounterData(volPerfCounterData.time, volPerfCounterData.ref, volPerfCounterData.blockSize);
        volPerfCounterData2.interval = (volPerfCounterData.time - this.time) / 1000L;
        if (volPerfCounterData2.interval <= 0L) {
            volPerfCounterData2.interval = 1L;
        }
        if (this.blockSize != volPerfCounterData.blockSize) {
            volPerfCounterData2.setBlockSizeValid(false);
            volPerfCounterData2.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        }
        if (this.ref != null && !this.ref.equals(volPerfCounterData.ref)) {
            volPerfCounterData2.setDataValid(false);
            volPerfCounterData2.addErrorCode(PerfErrorCode.VOLUME_PRIMARY_PATH_CHANGED);
        } else if (!volPerfCounterData.isDataValid()) {
            volPerfCounterData2.setDataValid(false);
            volPerfCounterData2.addErrorCodes(volPerfCounterData.getErrorCodes());
        } else if (!this.isDataValid()) {
            volPerfCounterData2.setDataValid(false);
            volPerfCounterData2.addErrorCodes(this.getErrorCodes());
        } else {
            volPerfCounterData2.totalBlocksRequested = this.subtractWithOverFlowProtection(volPerfCounterData.totalBlocksRequested, this.totalBlocksRequested);
            volPerfCounterData2.totalCacheReadChecks = this.subtractWithOverFlowProtection(volPerfCounterData.totalCacheReadChecks, this.totalCacheReadChecks);
            volPerfCounterData2.totalCacheReadCheckHits = this.subtractWithOverFlowProtection(volPerfCounterData.totalCacheReadCheckHits, this.totalCacheReadCheckHits);
            volPerfCounterData2.totalReadBlocksRequested = this.subtractWithOverFlowProtection(volPerfCounterData.totalReadBlocksRequested, this.totalReadBlocksRequested);
            volPerfCounterData2.totalReadRequests = this.subtractWithOverFlowProtection(volPerfCounterData.totalReadRequests, this.totalReadRequests);
            volPerfCounterData2.totalRequestsServiced = this.subtractWithOverFlowProtection(volPerfCounterData.totalRequestsServiced, this.totalRequestsServiced);
            volPerfCounterData2.totalWriteBlocksRequested = this.subtractWithOverFlowProtection(volPerfCounterData.totalWriteBlocksRequested, this.totalWriteBlocksRequested);
            volPerfCounterData2.totalWriteRequests = this.subtractWithOverFlowProtection(volPerfCounterData.totalWriteRequests, this.totalWriteRequests);
        }
        return volPerfCounterData2;
    }

    public boolean isBlockSizeValid() {
        return this.blockSizeValidity;
    }

    public void setBlockSizeValid(boolean bl) {
        this.blockSizeValidity = bl;
    }

    public boolean isDataValid() {
        return this.dataValidity;
    }

    public void setDataValid(boolean bl) {
        this.dataValidity = bl;
    }

    protected long subtractWithOverFlowProtection(long l, long l2) {
        if (l < l2) {
            return MAX_LONG - l2 + l;
        }
        return l - l2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Assertion failure");
        }
    }
}

