/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.ControllerPerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.ControllerPerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataType;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;

class StorageArrayPerfData
extends ControllerPerfData {
    public StorageArrayPerfData(String string, String string2) {
        super(string, string2, PerfDataType.SYSTEM);
    }

    public void setVolumeCreatedAfterStart() {
        super.setVolumeCreatedAfterStart();
        this.addErrorCode(PerfErrorCode.NEW_VOL_FOUND);
    }

    public void setVolumeDeletedAfterStart() {
        super.setVolumeDeletedAfterStart();
        this.addErrorCode(PerfErrorCode.VOLUME_DELETED);
    }

    public void setPerfData(ControllerPerfData[] controllerPerfDataArray) {
        ControllerPerfCounterData controllerPerfCounterData = new ControllerPerfCounterData();
        boolean bl = false;
        this.clearAllErrors();
        for (int i = 0; i < controllerPerfDataArray.length && controllerPerfCounterData.isDataValid(); ++i) {
            ControllerPerfCounterData controllerPerfCounterData2;
            if (controllerPerfDataArray[i] == null) {
                controllerPerfCounterData.setDataValid(false);
                this.markDataAsNotAvailable();
                controllerPerfCounterData.addErrorCode(PerfErrorCode.NO_PATH_TO_CONTROLLER);
                continue;
            }
            if (controllerPerfDataArray[i].volumeDeletedAfterStart()) {
                this.setVolumeDeletedAfterStart();
            }
            if (controllerPerfDataArray[i].volumeCreatedAfterStart()) {
                this.setVolumeCreatedAfterStart();
            }
            if ((controllerPerfCounterData2 = controllerPerfDataArray[i].getPerfData()) == null) {
                controllerPerfCounterData.setDataValid(false);
                this.addErrorCodes(controllerPerfDataArray[i].getErrorCodes());
                continue;
            }
            if (!controllerPerfCounterData2.isDataValid()) {
                controllerPerfCounterData.setDataValid(false);
                controllerPerfCounterData.addErrorCodes(controllerPerfCounterData2.getErrorCodes());
                continue;
            }
            if (controllerPerfCounterData.time < controllerPerfCounterData2.time) {
                controllerPerfCounterData.time = controllerPerfCounterData2.time;
            }
            controllerPerfCounterData.add(controllerPerfCounterData2);
        }
        if (controllerPerfCounterData.isDataValid()) {
            if (controllerPerfCounterData.totalCacheReadChecks == 0L || controllerPerfCounterData.totalCacheReadCheckHits == 0L) {
                this.setCacheReadHitPercentage(0.0f);
            } else {
                this.setCacheReadHitPercentage((float)(controllerPerfCounterData.totalCacheReadCheckHits / controllerPerfCounterData.totalCacheReadChecks) * 100.0f);
            }
            if (controllerPerfCounterData.totalReadRequests == 0.0) {
                this.setReadPercentage(0.0f);
            } else {
                this.setReadPercentage((float)(controllerPerfCounterData.totalReadRequests / controllerPerfCounterData.totalIOs) * 100.0f);
            }
            if (controllerPerfCounterData.totalWriteRequests == 0.0) {
                this.setWritePercentage(0.0f);
            } else {
                this.setWritePercentage((float)(controllerPerfCounterData.totalWriteRequests / controllerPerfCounterData.totalIOs) * 100.0f);
            }
            this.setTotalIOPs(controllerPerfCounterData.totalIOPs);
            if (controllerPerfCounterData.isBlockSizeValid()) {
                this.setAverageReadSize(controllerPerfCounterData.totalAverageReadSize);
                this.setAverageWriteSize(controllerPerfCounterData.totalAverageWriteSize);
                this.setReadsPerSec(controllerPerfCounterData.totalBytesReadPerSec);
                this.setWritesPerSec(controllerPerfCounterData.totalBytesWrittenPerSec);
            } else {
                this.markInvalidDueToBlockSize();
            }
        } else {
            this.markDataAsNotAvailable();
        }
        this.currentPerfData = controllerPerfCounterData;
        this.addErrorCodes(controllerPerfCounterData.getErrorCodes());
    }
}

