/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataCollector;
import java.util.Date;
import java.util.logging.Level;

class PerfDataCollectorThread
extends Thread {
    PerfDataCollector collector;
    final String CLASSNAME = this.getClass().getName();

    public PerfDataCollectorThread(PerfDataCollector perfDataCollector) {
        this.collector = perfDataCollector;
    }

    public void run() {
        try {
            OperationalStatus operationalStatus = OperationalStatus.getStatus((String)this.collector.getOperationalStatus());
            if (!operationalStatus.equals((Object)OperationalStatus.STOPPED) && !operationalStatus.equals((Object)OperationalStatus.STOPPING)) {
                long l = 0L;
                if (this.collector.isLoggable(Level.FINE)) {
                    l = new Date().getTime();
                }
                this.collector.fetchAndProcessPerfSample();
                if (this.collector.isLoggable(Level.FINE)) {
                    Date date = new Date();
                    long l2 = date.getTime() - l;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Data collection sample completed at ");
                    stringBuffer.append(date.toString());
                    stringBuffer.append(". Elapsed time ").append(l2).append(" milliseconds.");
                    this.collector.logp(Level.FINE, this.CLASSNAME, "run()", stringBuffer.toString());
                }
            } else {
                this.collector.logp(Level.FINE, this.CLASSNAME, "run()", "Ignoring scheduled fetch request since collector state is " + this.collector.getOperationalStatus().toString());
            }
        }
        catch (ThreadDeath threadDeath) {
            this.collector.logp(Level.FINE, this.CLASSNAME, "run()", null, threadDeath);
            threadDeath.printStackTrace();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.collector.logp(Level.FINE, this.CLASSNAME, "run()", null, throwable);
            throwable.printStackTrace();
        }
    }
}

