/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.CollectorState;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.UnableToCommunicateException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.api.ComponentType;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.WWNChangeException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.PerfDataCollectorMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core.ArrayReg;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core.ObjectBundleManager;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.ArrayUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.ControllerPerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130Constants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataCollectorKeyFactory;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfTaskThread;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.StorageArrayPerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.VolPerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.VolPerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.util.Convert;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.PerfPersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.PerfTransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.PerfVolInfoBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.CleanUpHelper;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.ControlBeanHelper;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.PerformanceArray6130ControlBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.PerformanceArray6130DataBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.VendorException;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.AbstractVolRefList;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumePerformance;
import devmgr.versioned.symbol.VolumePerformanceList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class PerfDataCollector
extends StandardMBean
implements PerfDataCollectorMBean {
    private static final String CLASSNAME = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$PerfDataCollector == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$PerfDataCollector = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataCollector")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$PerfDataCollector).getName();
    private static final Logger logger = Perf6130Constants.LOGGER;
    private static final String COLLECTOR_NAME_PREFIX = "6130 Perf Collector: ";
    Hashtable volPerfTable = new Hashtable();
    Hashtable controllerPerfTable = new Hashtable(2);
    StorageArrayPerfData systemPerfData = null;
    ArrayReg arrayReg = null;
    private static final int DEFAULT_POLLING_RATE = 15;
    private static final int DEFAULT_DATA_RETENTION_RATE = 14;
    private static final ClockDaemon clockDaemon = new ClockDaemon();
    private Object perfTaskID = null;
    private PerfTaskThread perfTaskThread = null;
    private Object flushTaskID = null;
    protected long samplesTaken = 0L;
    private String collectorName;
    private String key;
    PerformanceArray6130ControlBean controlBean;
    int[] controllerFetchFailures = new int[]{0, 0, 0, 0};
    ArrayList volsToAdd = null;
    ArrayList volsToRemove = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$PerfDataCollector;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$PerfVolInfoBean;

    public PerfDataCollector(String string) throws LocalizableException, NotCompliantMBeanException {
        super(class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.PerfDataCollectorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean);
        this.initialize(ControlBeanHelper.getControlBean((String)string));
    }

    public PerfDataCollector(PerformanceArray6130ControlBean performanceArray6130ControlBean) throws NotCompliantMBeanException {
        super(class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.PerfDataCollectorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean);
        this.initialize(performanceArray6130ControlBean);
    }

    public void initialize(PerformanceArray6130ControlBean performanceArray6130ControlBean) {
        ArrayReg arrayReg;
        this.controlBean = performanceArray6130ControlBean;
        this.key = performanceArray6130ControlBean.getControlKey();
        performanceArray6130ControlBean.setStatus(OperationalStatus.UNKNOWN.toString());
        if (performanceArray6130ControlBean.getDataRetention() == 0L) {
            performanceArray6130ControlBean.setDataRetention(14L);
        }
        if (performanceArray6130ControlBean.getPollingInterval() == 0L) {
            performanceArray6130ControlBean.setPollingInterval(15L);
        }
        if (performanceArray6130ControlBean.getState() == null) {
            this.setState(CollectorState.ON);
        }
        this.setCollectorName(performanceArray6130ControlBean.getName());
        try {
            arrayReg = ArrayUtil.getArrayReg(performanceArray6130ControlBean);
            this.setArrayReg(arrayReg);
        }
        catch (WWNChangeException wWNChangeException) {
            this.logp(Level.SEVERE, CLASSNAME, "<init> PerfDataCollector(PerfornceArray6130ControlBean)", wWNChangeException.getLocalizedMessage(Locale.ENGLISH));
            this.setOperationalStatus(OperationalStatus.NON_RECOVERABLE_ERROR);
            this.setState(CollectorState.OFF);
            return;
        }
        catch (LocalizableException localizableException) {
            this.logp(Level.WARNING, CLASSNAME, "<init> PerfDataCollector(PerfornceArray6130ControlBean)", localizableException.getLocalizedMessage(Locale.ENGLISH));
            this.createPollJob(false, performanceArray6130ControlBean.getPollingInterval() * 60000L);
            this.setOperationalStatus(OperationalStatus.NO_CONTACT);
            return;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logp(Level.SEVERE, CLASSNAME, "<init> PerfDataCollector(PerfornceArray6130ControlBean)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            this.createPollJob(false, performanceArray6130ControlBean.getPollingInterval() * 60000L);
            this.setOperationalStatus(OperationalStatus.NO_CONTACT);
            return;
        }
        arrayReg = CollectorState.getState((String)performanceArray6130ControlBean.getState());
        if (CollectorState.ON.equals((Object)arrayReg)) {
            this.start();
        } else {
            this.stop();
        }
        logger.setLevel(Level.ALL);
        this.logp(Level.FINE, CLASSNAME, "<constructor>", "Successfully reinstantiated collector.");
        this.logp(Level.FINEST, CLASSNAME, "<constructor>", this.toString());
    }

    public PerfDataCollector(String string, ArrayReg arrayReg) throws NotCompliantMBeanException, LocalizableException {
        super(class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.PerfDataCollectorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean);
        if (string == null) {
            PerfDataCollectorKeyFactory perfDataCollectorKeyFactory = PerfDataCollectorKeyFactory.getInstance();
            string = perfDataCollectorKeyFactory.add(arrayReg);
        }
        this.key = string;
        this.controlBean = new PerformanceArray6130ControlBean();
        this.controlBean.setControlKey(string);
        this.setArrayReg(arrayReg);
        this.controlBean.setStatus(OperationalStatus.STOPPED.toString());
        this.controlBean.setPollingInterval(15L);
        this.controlBean.setDataRetention(14L);
        this.setState(CollectorState.OFF);
        this.updateControlRecord();
        logger.setLevel(Level.ALL);
        this.logp(Level.FINE, CLASSNAME, "<constructor>", "New collector successfully created");
    }

    public String getKey() {
        return this.controlBean.getControlKey();
    }

    public String getWWN() {
        return this.controlBean.getWWN();
    }

    public long getLastPollTime() {
        return this.controlBean.getLastPollTime();
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    private void setCollectorName(String string) {
        StringBuffer stringBuffer = new StringBuffer(COLLECTOR_NAME_PREFIX);
        if (string != null) {
            stringBuffer.append(string);
        } else {
            String[] stringArray = this.arrayReg.getIps();
            stringBuffer.append("(").append(stringArray[0]);
            if (stringArray.length > 1) {
                stringBuffer.append(", ").append(stringArray[1]);
            }
            stringBuffer.append(")");
        }
        if (stringBuffer.length() > 64) {
            stringBuffer.delete(64, stringBuffer.length());
        }
        this.collectorName = stringBuffer.toString();
    }

    private void setCollectorName(ArrayReg arrayReg) {
        this.setCollectorName(arrayReg.getNodeName());
    }

    private void createPollJob(boolean bl, long l) {
        this.logp(Level.FINE, CLASSNAME, "createPollJob()", "Scheduling polling job to run at " + l);
        if (this.perfTaskID != null) {
            ClockDaemon.cancel((Object)this.perfTaskID);
        }
        if (this.perfTaskThread == null) {
            this.perfTaskThread = new PerfTaskThread(this);
        }
        this.perfTaskID = clockDaemon.executePeriodically(l, (Runnable)this.perfTaskThread, bl);
        clockDaemon.restart();
        if (this.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Polling task scheduled to run at a interval of ");
            stringBuffer.append(l);
            stringBuffer.append(". Take initial sample is ").append(bl);
            stringBuffer.append("\n TaskID=").append(this.perfTaskID);
            this.logp(Level.FINE, CLASSNAME, "createPollJob()", stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(long l) {
        try {
            PerfDataCollector perfDataCollector = this;
            synchronized (perfDataCollector) {
                this.setState(CollectorState.ON);
                boolean bl = this.perfTaskID == null;
                this.createPollJob(bl, l);
            }
        }
        catch (Throwable throwable) {
            this.logp(Level.SEVERE, CLASSNAME, "start(long)", null, throwable);
        }
    }

    public void start() {
        if (this.perfTaskID == null) {
            this.setOperationalStatus(OperationalStatus.STARTING);
        } else {
            OperationalStatus operationalStatus = OperationalStatus.getStatus((String)this.getOperationalStatus());
            if (!OperationalStatus.OK.equals((Object)operationalStatus)) {
                this.setOperationalStatus(OperationalStatus.STARTING);
            }
        }
        this.start(this.controlBean.getPollingInterval() * 60000L);
        this.setOperationalStatus(OperationalStatus.OK);
    }

    public void stop() {
        this.setState(CollectorState.OFF);
        this.shutdown();
        this.samplesTaken = 0L;
        this.volPerfTable = new Hashtable();
        this.controllerPerfTable = new Hashtable(2);
        if (this.isLoggable(Level.FINE)) {
            this.logp(Level.FINE, CLASSNAME, "stop", null);
        }
    }

    public void shutdown() {
        if (this.perfTaskID != null) {
            this.setOperationalStatus(OperationalStatus.STOPPING);
            ClockDaemon.cancel((Object)this.perfTaskID);
            this.perfTaskID = null;
            this.perfTaskThread = null;
        }
        this.setOperationalStatus(OperationalStatus.STOPPED);
        this.updateControlRecord();
        this.logp(Level.INFO, CLASSNAME, "shutdown", "Successfully shutdown. ");
    }

    void setOperationalStatus(OperationalStatus operationalStatus) {
        if (!this.controlBean.getStatus().equals(operationalStatus.toString())) {
            this.controlBean.setStatus(operationalStatus.toString());
            this.updateControlRecord();
            this.logp(Level.FINE, CLASSNAME, "setOperationalStatus()", operationalStatus.toString());
        }
    }

    public String getOperationalStatus() {
        return this.controlBean.getStatus().toString();
    }

    public String getState() {
        return this.controlBean.getState();
    }

    void setState(CollectorState collectorState) {
        this.controlBean.setState(collectorState.toString());
    }

    public int getPollingInterval() {
        return (int)this.controlBean.getPollingInterval();
    }

    public void setPollingInterval(int n) throws LocalizableException {
        if (this.isLoggable(Level.CONFIG)) {
            this.logp(Level.CONFIG, CLASSNAME, "setPollingInterval", "Set polling interval to " + n + " minutes.");
        }
        this.controlBean.setPollingInterval((long)n);
        CollectorState collectorState = CollectorState.getState((String)this.controlBean.getState());
        if (CollectorState.ON.equals((Object)collectorState)) {
            this.logp(Level.FINE, CLASSNAME, "setPollingInterval", "Reset polling job via start()");
            this.start((long)n * 60000L);
        } else {
            this.logp(Level.FINE, CLASSNAME, "setPollingInterval", "Reset polling job via start()");
        }
        this.updateControlRecord();
    }

    public int getDataRetentionInterval() {
        return (int)this.controlBean.getDataRetention();
    }

    public void setDataRetentionInterval(int n) throws LocalizableException {
        if (this.isLoggable(Level.CONFIG)) {
            this.logp(Level.CONFIG, CLASSNAME, "setDataRetentionInterval", "Set data retention to " + n);
        }
        this.controlBean.setDataRetention((long)n);
        this.updateControlRecord();
    }

    /*
     * Loose catch block
     */
    static PerformanceArray6130ControlBean load(String string) throws LocalizableException {
        PerformanceArray6130ControlBean performanceArray6130ControlBean;
        block12: {
            PersistenceManager persistenceManager = null;
            PersistentObject[] persistentObjectArray = null;
            Transaction transaction = null;
            performanceArray6130ControlBean = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.PerformanceArray6130ControlBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean, (Filter)new EqualsFilter("key", string));
            if (persistentObjectArray != null && persistentObjectArray.length != 0) {
                performanceArray6130ControlBean = (PerformanceArray6130ControlBean)persistentObjectArray[0];
            }
            transaction.commit();
            Object var8_5 = null;
            try {
                if (transaction != null) {
                    persistenceManager.releaseTransaction(transaction);
                }
                break block12;
            }
            catch (Exception exception) {
                logger.logp(Level.FINEST, CLASSNAME, "load(String)", string, exception);
            }
            break block12;
            {
                catch (PersistenceException persistenceException) {
                    throw new PerfPersistenceException((Exception)((Object)persistenceException));
                }
                catch (TransactionException transactionException) {
                    throw new PerfTransactionException((Exception)((Object)transactionException));
                }
                catch (Exception exception) {
                    throw new VendorException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.FINEST, CLASSNAME, "load(String)", string, exception);
                }
                throw throwable;
            }
        }
        return performanceArray6130ControlBean;
    }

    void updateControlRecord() {
        try {
            this.persistControlData(this.controlBean);
        }
        catch (LocalizableException localizableException) {
            this.logp(Level.WARNING, CLASSNAME, "updateControlRecord", "Failed to update data records.  Cause: " + localizableException.getLocalizedMessage(Locale.ENGLISH));
        }
    }

    /*
     * Loose catch block
     */
    void persistControlData(PerformanceArray6130ControlBean performanceArray6130ControlBean) throws LocalizableException {
        block11: {
            if (performanceArray6130ControlBean == null) {
                throw new IllegalArgumentException();
            }
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.PerformanceArray6130ControlBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$array6130$PerformanceArray6130ControlBean, (Filter)new EqualsFilter("key", this.key));
            transaction.put((PersistentObject)performanceArray6130ControlBean);
            transaction.commit();
            Object var7_4 = null;
            try {
                if (transaction != null) {
                    persistenceManager.releaseTransaction(transaction);
                }
                break block11;
            }
            catch (Exception exception) {
                this.logp(Level.FINEST, CLASSNAME, "persistControlData(PerformanceArray6130ControlBean)", null, exception);
            }
            break block11;
            {
                catch (PersistenceException persistenceException) {
                    this.logp(Level.FINE, CLASSNAME, "persistControlData(PerformanceArray6130ControlBean)", "Update failed, bean=" + performanceArray6130ControlBean.toString(), persistenceException);
                    throw new PerfPersistenceException((Exception)((Object)persistenceException));
                }
                catch (TransactionException transactionException) {
                    this.logp(Level.FINE, CLASSNAME, "persistControlData(PerformanceArray6130ControlBean)", "Update failed, bean=" + performanceArray6130ControlBean.toString(), transactionException);
                    throw new PerfTransactionException((Exception)((Object)transactionException));
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                }
                catch (Exception exception) {
                    this.logp(Level.FINEST, CLASSNAME, "persistControlData(PerformanceArray6130ControlBean)", null, exception);
                }
                throw throwable;
            }
        }
    }

    public void unload() throws LocalizableException {
        if (this.key == null) {
            return;
        }
        try {
            this.stop();
            CleanUpHelper.deletePerfEntries((String)this.key);
        }
        catch (LocalizableException localizableException) {
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logp(Level.SEVERE, CLASSNAME, "unload()", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public void scrub() throws LocalizableException {
        if (this.key == null || this.key.length() == 0) {
            return;
        }
        Date date = new Date();
        long l = date.getTime() - this.controlBean.getDataRetention() * 86400000L;
        CleanUpHelper.scrub((String)this.key, (long)l);
    }

    public ArrayReg getArrayReg() throws LocalizableException {
        if (this.arrayReg == null) {
            this.arrayReg = ArrayUtil.getArrayReg(this.controlBean);
            this.setArrayReg(this.arrayReg);
        }
        return this.arrayReg;
    }

    public void setArrayReg(ArrayReg arrayReg) {
        if (arrayReg == null) {
            throw new IllegalArgumentException("Null ArrayReg not allowed.");
        }
        this.arrayReg = arrayReg;
        String[] stringArray = this.arrayReg.getIps();
        this.controlBean.setIpAddress(stringArray[0]);
        if (stringArray.length == 2) {
            this.controlBean.setAlternateIpAddress(stringArray[1]);
        } else {
            this.controlBean.setAlternateIpAddress("");
        }
        this.controlBean.setWWN(arrayReg.getWWN());
        this.controlBean.setName(this.arrayReg.getNodeName());
        this.setCollectorName(this.arrayReg);
    }

    private String getVolumeRefKey(byte[] byArray) {
        return Convert.bytesToString(byArray);
    }

    private String getControllerRefKey(byte[] byArray) {
        return Convert.bytesToString(byArray);
    }

    public VolumePerformanceList getPerfData(SYMbolAPIClientV1 sYMbolAPIClientV1, ControllerRef controllerRef, AbstractVolRefList abstractVolRefList) throws RPCError, IOException {
        ControllerDescriptor controllerDescriptor = new ControllerDescriptor();
        controllerDescriptor.setControllerRef(controllerRef);
        sYMbolAPIClientV1.bindToController(controllerDescriptor);
        return sYMbolAPIClientV1.getVolumePerformance(abstractVolRefList);
    }

    private void findAndHandleDeletedVolumes(List list) {
        String[] stringArray = this.volPerfTable.keySet().toArray(new String[this.volPerfTable.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer;
            Object object;
            if (list.contains(stringArray[i])) continue;
            VolPerfData volPerfData = (VolPerfData)this.volPerfTable.get(stringArray[i]);
            this.volsToRemove.add(volPerfData);
            if (!volPerfData.hasPerfData()) {
                this.volPerfTable.remove(stringArray[i]);
                continue;
            }
            VolPerfCounterData volPerfCounterData = volPerfData.getPerfData();
            if (volPerfCounterData == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("VolPerfCounterData for volume ").append(stringArray[i]);
                ((StringBuffer)object).append(" was null, when it should not of been.");
                this.logp(Level.WARNING, CLASSNAME, "findAndHandleDeletedVolumes", ((StringBuffer)object).toString());
            } else {
                object = (ControllerPerfData)this.controllerPerfTable.get(volPerfCounterData.ref);
                if (object != null) {
                    ((ControllerPerfData)object).setVolumeDeletedAfterStart();
                } else {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("Failed to find controller ref in controllerPerfTable with key of ");
                    stringBuffer.append(volPerfCounterData.ref);
                    this.logp(Level.WARNING, CLASSNAME, "findAndHandleDeletedVolumes", stringBuffer.toString());
                }
            }
            object = this.volPerfTable.remove(stringArray[i]);
            if (object != null) continue;
            stringBuffer = new StringBuffer();
            stringBuffer.append(": removal of the volume (key=").append(stringArray[i]);
            stringBuffer.append("failed.");
            this.logp(Level.WARNING, CLASSNAME, "findAndHandleDeletedVolumes", stringBuffer.toString());
        }
    }

    private VolPerfData[] markVolumeStatsInvalid(PerfErrorCode perfErrorCode, HashMap hashMap, AbstractVolRefList abstractVolRefList) {
        long l = new Date().getTime();
        AbstractVolRef[] abstractVolRefArray = abstractVolRefList.getAbstractVolRef();
        Vector<VolPerfData> vector = new Vector<VolPerfData>();
        for (int i = 0; i < abstractVolRefArray.length; ++i) {
            CharSequence charSequence;
            String string = this.getVolumeRefKey(abstractVolRefArray[i].getRefToken());
            Volume volume = (Volume)hashMap.get(string);
            if (volume != null) {
                Object object;
                VolPerfData volPerfData;
                charSequence = Convert.bytesToString(volume.getWorldWideName());
                if (this.volPerfTable.containsKey(charSequence)) {
                    volPerfData = (VolPerfData)this.volPerfTable.get(charSequence);
                } else {
                    object = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
                    volPerfData = new VolPerfData((String)object, (String)charSequence);
                    this.volsToAdd.add(volPerfData.getVolInfoBean(this.getKey()));
                }
                object = new VolPerfCounterData(l, this.getControllerRefKey(volume.getPreferredManager().getRefToken()), volume.getBlkSize());
                ((VolPerfCounterData)object).setDataValid(false);
                ((PerfCounterData)object).addErrorCode(perfErrorCode);
                volPerfData.setPerfData((VolPerfCounterData)object);
                object = null;
                this.volPerfTable.put(charSequence, volPerfData);
                vector.add(volPerfData);
                continue;
            }
            if (string != null && string.equals("0X0000000000000000000000000000000000000000")) continue;
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(": Failed to find volRef ");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append(".  Was volume deleted? Did controller volume being exported on change? ");
            if (string == null || string.equals("0X0000000000000000000000000000000000000000")) {
                ((StringBuffer)charSequence).append("volume reference token=" + abstractVolRefArray[i].getRefToken());
            } else {
                ((StringBuffer)charSequence).append("\nvolMap=");
                ((StringBuffer)charSequence).append(hashMap.toString());
            }
            this.logp(Level.FINE, CLASSNAME, "markVolumeStatsInvalid", ((StringBuffer)charSequence).toString());
        }
        return vector.toArray(new VolPerfData[vector.size()]);
    }

    private VolPerfData[] calcVolumePerfStats(HashMap hashMap, VolumePerformanceList volumePerformanceList, boolean bl) {
        VolumePerformance[] volumePerformanceArray = volumePerformanceList.getVolumePerf();
        Vector<VolPerfData> vector = new Vector<VolPerfData>();
        for (int i = 0; i < volumePerformanceArray.length; ++i) {
            CharSequence charSequence;
            VolumePerformance volumePerformance = volumePerformanceArray[i];
            String string = this.getVolumeRefKey(volumePerformance.getVolumeRef().getRefToken());
            Volume volume = (Volume)hashMap.get(string);
            if (volume != null) {
                Object object;
                VolPerfData volPerfData;
                charSequence = Convert.bytesToString(volume.getWorldWideName());
                if (this.volPerfTable.containsKey(charSequence)) {
                    volPerfData = (VolPerfData)this.volPerfTable.get(charSequence);
                } else {
                    object = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
                    volPerfData = new VolPerfData((String)object, (String)charSequence);
                    this.volPerfTable.put(charSequence, volPerfData);
                    this.volsToAdd.add(volPerfData.getVolInfoBean(this.getKey()));
                    if (this.samplesTaken > 0L) {
                        volPerfData.setVolumeCreatedAfterStart();
                    }
                }
                object = new VolPerfCounterData(volumePerformance, this.getControllerRefKey(volume.getPreferredManager().getRefToken()), volume.getBlkSize());
                if (bl) {
                    volPerfData.setControllerResetAfterStart();
                }
                volPerfData.setPerfData((VolPerfCounterData)object);
                object = null;
                vector.add(volPerfData);
                continue;
            }
            if (string != null && string.equals("0X0000000000000000000000000000000000000000")) continue;
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(": Unable to calculate volume metrics for volume.  ");
            ((StringBuffer)charSequence).append("Failed to find volRef ").append(string).append(" in volMap.");
            ((StringBuffer)charSequence).append("Was volume deleted? Did controller volume being exported on change? ");
            ((StringBuffer)charSequence).append("\nvolMap=");
            ((StringBuffer)charSequence).append(hashMap.toString());
            this.logp(Level.WARNING, CLASSNAME, "calcVolumePerfStats", ((StringBuffer)charSequence).toString());
        }
        return vector.toArray(new VolPerfData[vector.size()]);
    }

    private void release() {
        if (this.volPerfTable.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.volPerfTable.elements();
        while (enumeration.hasMoreElements()) {
            VolPerfData volPerfData = (VolPerfData)enumeration.nextElement();
            volPerfData.releaseDiffData();
        }
    }

    private void displayVolumePerfStats() {
        if (this.volPerfTable.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.volPerfTable.elements();
        while (enumeration.hasMoreElements()) {
            VolPerfData volPerfData = (VolPerfData)enumeration.nextElement();
            String string = volPerfData.getErrorCodeStr();
            if (string != null && string.length() != 0) {
                System.out.println(string);
            }
            System.out.println(volPerfData.getStatsStr("\n", false));
        }
    }

    private ControllerPerfData getControllerPerStats(ControllerRef controllerRef) {
        String string = this.getControllerRefKey(controllerRef.getRefToken());
        ControllerPerfData controllerPerfData = (ControllerPerfData)this.controllerPerfTable.get(string);
        if (controllerPerfData == null) {
            String string2 = string.substring(string.length() - 1);
            controllerPerfData = new ControllerPerfData(string2, string);
            this.controllerPerfTable.put(string, controllerPerfData);
        }
        return controllerPerfData;
    }

    private void calcControllerPerfStats(ControllerPerfData controllerPerfData, VolPerfData[] volPerfDataArray, boolean bl) {
        if (bl) {
            controllerPerfData.setControllerResetAfterStart();
        } else {
            controllerPerfData.setPerfData(volPerfDataArray);
        }
    }

    private void displayControllerPerfStats() {
        if (this.controllerPerfTable.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.controllerPerfTable.elements();
        while (enumeration.hasMoreElements()) {
            PerfData perfData = (PerfData)enumeration.nextElement();
            String string = perfData.getErrorCodeStr();
            if (string != null && string.length() > 0) {
                System.out.println(string);
            }
            System.out.println(perfData.getStatsStr("\n", false));
        }
    }

    private void calcSystemPerfStats() {
        ControllerPerfData[] controllerPerfDataArray = this.controllerPerfTable.values().toArray(new ControllerPerfData[this.controllerPerfTable.size()]);
        if (this.systemPerfData == null) {
            this.systemPerfData = new StorageArrayPerfData(this.arrayReg.getNodeName(), this.arrayReg.getWWN());
        }
        this.systemPerfData.setPerfData(controllerPerfDataArray);
    }

    void displayPerfStats() {
        System.out.println("                                                Cache   Total                          Aver      Aver");
        System.out.println("                                 Read   Write   Read    Data      KB/sec    KB/sec     Read      Write");
        System.out.println("Type  Name              IOPs       %      %     Hit %   Trans     Read      Write      Size       Size");
        System.out.println("====  ==============  ========  ======  ======  ======  ========  ========  ========  ========  ========");
        if (this.systemPerfData == null) {
            System.out.println("sys  [Not currently available]");
        } else {
            String string = this.systemPerfData.getErrorCodeStr();
            if (string != null && string.length() > 0) {
                System.out.println(string);
            }
            System.out.println(this.systemPerfData.getStatsStr("\n", false));
        }
        this.displayControllerPerfStats();
        this.displayVolumePerfStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void writePerfStats() {
        block28: {
            Object object;
            PersistenceManager persistenceManager;
            Vector<PerformanceArray6130DataBean> vector = new Vector<PerformanceArray6130DataBean>();
            List list = null;
            if (this.controllerPerfTable == null) {
                this.logp(Level.FINE, CLASSNAME, "writePerfStats", "controllerPerfTable is null!!!");
            }
            if (!this.controllerPerfTable.isEmpty()) {
                if (this.systemPerfData != null && ((list = this.systemPerfData.getErrorCodes()) == null || list.size() == 0) && this.systemPerfData.getPollTime() != 0L) {
                    vector.add(this.getDataBean(this.systemPerfData, ComponentType.SYSTEM));
                }
                persistenceManager = this.controllerPerfTable.elements();
                while (persistenceManager.hasMoreElements()) {
                    object = (PerformanceArray6130DataBean[])persistenceManager.nextElement();
                    list = ((PerfData)object).getErrorCodes();
                    if (list != null && list.size() != 0 || ((PerfData)object).getPollTime() == 0L) continue;
                    vector.add(this.getDataBean((PerfData)object, ComponentType.CONTROLLER));
                }
            }
            if (!this.volPerfTable.isEmpty()) {
                persistenceManager = this.volPerfTable.elements();
                while (persistenceManager.hasMoreElements()) {
                    object = (PerfData)persistenceManager.nextElement();
                    list = ((PerfData)object).getErrorCodes();
                    if (list != null && list.size() != 0 || ((PerfData)object).getPollTime() == 0L) continue;
                    vector.add(this.getDataBean((PerfData)object, ComponentType.VOLUME));
                }
            }
            if (vector.size() == 0 && this.volsToAdd.size() == 0 && this.volsToRemove.size() == 0) {
                return;
            }
            object = vector.toArray(new PerformanceArray6130DataBean[vector.size()]);
            persistenceManager = null;
            Transaction transaction = null;
            try {
                persistenceManager = PersistenceManager.getInstance();
                transaction = persistenceManager.getTransaction();
                transaction.begin();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    try {
                        transaction.put((PersistentObject)object[i]);
                        continue;
                    }
                    catch (PersistenceException persistenceException) {
                        StringBuffer stringBuffer = new StringBuffer("Failure on writing performance stats: \n");
                        stringBuffer.append(object[i]);
                        this.logp(Level.WARNING, CLASSNAME, "writePerfStats", stringBuffer.toString(), persistenceException);
                        throw persistenceException;
                    }
                }
                if (this.samplesTaken == 1L) {
                    transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$PerfVolInfoBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$PerfVolInfoBean = PerfDataCollector.class$("com.sun.netstorage.mgmt.esm.logic.data.api.performance.PerfVolInfoBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$performance$PerfVolInfoBean, (Filter)new EqualsFilter("collector_key", this.getKey()));
                }
                PerfVolInfoBean.update((Transaction)transaction, (List)this.volsToAdd, (List)this.volsToRemove);
                transaction.commit();
            }
            catch (PersistenceException persistenceException) {
                this.logp(Level.FINE, CLASSNAME, "writePerfStats", null, persistenceException);
                throw new PerfPersistenceException((Exception)((Object)persistenceException));
            }
            catch (TransactionException transactionException) {
                this.logp(Level.FINE, CLASSNAME, "writePerfStats", null, transactionException);
                throw new PerfTransactionException((Exception)((Object)transactionException));
            }
            Object var11_14 = null;
            try {
                if (transaction != null) {
                    persistenceManager.releaseTransaction(transaction);
                }
                break block28;
            }
            catch (Exception exception) {
                this.logp(Level.FINEST, CLASSNAME, "writePerfStats", null, exception);
            }
            break block28;
            {
                catch (LocalizableException localizableException) {
                    this.logp(Level.WARNING, CLASSNAME, "writePerfStats", "Failed to update data records for collector.  Cause: " + localizableException.getLocalizedMessage(Locale.ENGLISH));
                    Object var11_15 = null;
                    try {
                        if (transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                        }
                        break block28;
                    }
                    catch (Exception exception) {
                        this.logp(Level.FINEST, CLASSNAME, "writePerfStats", null, exception);
                    }
                    break block28;
                }
                catch (Exception exception) {
                    VendorException vendorException = new VendorException(exception);
                    this.logp(Level.FINE, CLASSNAME, "writePerfStats", vendorException.getLocalizedMessage(Locale.ENGLISH));
                    Object var11_16 = null;
                    try {
                        if (transaction != null) {
                            persistenceManager.releaseTransaction(transaction);
                        }
                        break block28;
                    }
                    catch (Exception exception2) {
                        this.logp(Level.FINEST, CLASSNAME, "writePerfStats", null, exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    if (transaction != null) {
                        persistenceManager.releaseTransaction(transaction);
                    }
                }
                catch (Exception exception) {
                    this.logp(Level.FINEST, CLASSNAME, "writePerfStats", null, exception);
                }
                throw throwable;
            }
        }
    }

    private PerformanceArray6130DataBean getDataBean(PerfData perfData, ComponentType componentType) {
        PerformanceArray6130DataBean performanceArray6130DataBean = new PerformanceArray6130DataBean();
        performanceArray6130DataBean.setCollectorKey(this.getKey());
        performanceArray6130DataBean.setComponentType(componentType.toString());
        performanceArray6130DataBean.setComponentName(perfData.getName());
        performanceArray6130DataBean.setComponentWwn(perfData.getWWN());
        performanceArray6130DataBean.setIops(perfData.getTotalIOPs());
        performanceArray6130DataBean.setReadPercentage((double)perfData.getReadPercentage());
        performanceArray6130DataBean.setWritePercentage((double)perfData.getWritePercentage());
        performanceArray6130DataBean.setCacheReadHits((double)perfData.getCacheReadHitPercentage());
        performanceArray6130DataBean.setDataTransfer(perfData.getTotalDataTransPerSec());
        performanceArray6130DataBean.setBytesRead(perfData.getReadsPerSec());
        performanceArray6130DataBean.setBytesWritten(perfData.getWritesPerSec());
        performanceArray6130DataBean.setAverageReadSize(perfData.getAverageReadSize());
        performanceArray6130DataBean.setAverageWriteSize(perfData.getAverageWriteSize());
        performanceArray6130DataBean.setPollTime(perfData.getPollTime());
        return performanceArray6130DataBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fetchAndProcessPerfSample() {
        block53: {
            block51: {
                this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", "Starting fetch.");
                this.volsToAdd = new ArrayList<E>();
                this.volsToRemove = new ArrayList<E>();
                try {
                    if (this.arrayReg == null) {
                        this.getArrayReg();
                    }
                }
                catch (UnableToCommunicateException var2_1) {
                    if (this.getOperationalStatus().equals(OperationalStatus.NO_CONTACT.toString()) != false) return;
                    this.setOperationalStatus(OperationalStatus.LOST_COMMUNICATION);
                    return;
                }
                catch (LocalizableException var2_2) {
                    if (!this.getOperationalStatus().equals(OperationalStatus.UNKNOWN.toString())) {
                        this.logp(Level.SEVERE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", "Unable to fetch performance statistics. Cause: " + var2_2.getLocalizedMessage(Locale.ENGLISH));
                        this.setOperationalStatus(OperationalStatus.UNKNOWN);
                        return;
                    }
                    this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var2_2.getLocalizedMessage(Locale.ENGLISH));
                    return;
                }
                catch (Throwable var2_3) {
                    if (!this.getOperationalStatus().equals(OperationalStatus.UNKNOWN.toString())) {
                        if (var2_3 instanceof Exception) {
                            var3_7 = new VendorException((Exception)var2_3);
                            this.logp(Level.SEVERE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var3_7.getLocalizedMessage(Locale.ENGLISH));
                        } else {
                            this.logp(Level.SEVERE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", null, var2_3);
                        }
                        this.setOperationalStatus(OperationalStatus.UNKNOWN);
                    } else {
                        this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", null, var2_3);
                    }
                    if (var2_3 instanceof ThreadDeath == false) return;
                    throw (ThreadDeath)var2_3;
                }
                for (var2_4 = 0; var2_4 < this.controllerFetchFailures.length; ++var2_4) {
                    if (this.controllerFetchFailures[var2_4] <= 4) continue;
                    var3_8 = null;
                    try {
                        var3_8 = ArrayUtil.getArrayReg(this.controlBean);
                        if (!this.arrayReg.getWWN().equals(var3_8.getWWN())) continue;
                        this.setArrayReg((ArrayReg)var3_8);
                        for (var4_10 = 0; var4_10 < this.controllerFetchFailures.length; ++var4_10) {
                            this.controllerFetchFailures[var4_10] = 0;
                        }
                        break;
                    }
                    catch (WWNChangeException var4_11) {
                        this.setOperationalStatus(OperationalStatus.NON_RECOVERABLE_ERROR);
                        this.logp(Level.SEVERE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", "WWN of controller changed.");
                        this.stop();
                        return;
                    }
                    catch (VendorException var4_12) {
                        this.logp(Level.SEVERE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var4_12.getLocalizedMessage(Locale.ENGLISH));
                        continue;
                    }
                    catch (Throwable var4_13) {
                        this.logp(Level.WARNING, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", null, var4_13);
                        if (!(var4_13 instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)var4_13;
                    }
                }
                try {
                    try {
                        var2_5 = new ObjectBundleManager();
                        var3_8 = var2_5.getObjectBundle(this.arrayReg);
                        if (var3_8 == null) {
                            this.setOperationalStatus(OperationalStatus.LOST_COMMUNICATION);
                            var30_15 = null;
                            if (this.isLoggable(Level.FINE) == false) return;
                            break block51;
                        }
                        if (!this.getOperationalStatus().equals(OperationalStatus.DEGRADDED.toString())) {
                            this.setOperationalStatus(OperationalStatus.OK);
                        }
                        var4_14 = new HashMap<String, ControllerData>();
                        var6_31 = var3_8.getController();
                        for (var7_32 = 0; var7_32 < var6_31.length; ++var7_32) {
                            var5_34 = var6_31[var7_32].getControllerRef();
                            var4_14.put(this.getControllerRefKey(var5_34.getRefToken()), new ControllerData(var5_34));
                        }
                        var7_33 = new HashMap<String, Volume>();
                        var8_35 = var3_8.getVolume();
                        var9_36 = new ArrayList<String>();
                        for (var11_37 = 0; var11_37 < var8_35.length; ++var11_37) {
                            var10_39 = var8_35[var11_37].getVolumeRef();
                            var12_40 = (ControllerData)var4_14.get(this.getControllerRefKey(var8_35[var11_37].getCurrentManager().getRefToken()));
                            var12_40.volumeRefs.add(var10_39);
                            var7_33.put(this.getVolumeRefKey(var8_35[var11_37].getVolumeRef().getRefToken()), var8_35[var11_37]);
                            var9_36.add(Convert.bytesToString(var8_35[var11_37].getWorldWideName()));
                        }
                        if (this.samplesTaken > 1L) {
                            this.findAndHandleDeletedVolumes(var9_36);
                        }
                        var11_38 = var4_14.values().toArray(new ControllerData[var4_14.size()]);
                        var13_41 = null;
                        var14_42 = false;
                        for (var15_43 = 0; var15_43 < var11_38.length; ++var15_43) {
                            block52: {
                                var12_40 = var11_38[var15_43].volumeRefs;
                                var16_44 = false;
                                if (var12_40.isEmpty()) continue;
                                var17_45 = new AbstractVolRefList();
                                var17_45.setAbstractVolRef(var12_40.toArray(new AbstractVolRef[var12_40.size()]));
                                var18_46 = null;
                                var19_47 = this.getControllerPerStats(var11_38[var15_43].controllerRef);
                                try {
                                    try {
                                        var13_41 = var2_5.getClient(this.arrayReg, Convert.bytesToString(var11_38[var15_43].controllerRef.getRefToken()));
                                        var20_48 = var13_41.getObjectGraph().getSa().getSaData();
                                        var21_51 = var20_48.getBootTime();
                                        var23_52 = var19_47.getBootTime();
                                        if (var23_52 == 0L) {
                                            var19_47.setBootTime(var21_51);
                                            if (var15_43 == 0) {
                                                this.arrayReg.setNodeName(var20_48);
                                            }
                                        } else if (var23_52 != var21_51) {
                                            var19_47.setBootTime(var21_51);
                                            var16_44 = true;
                                            if (var15_43 == 0) {
                                                this.arrayReg.setNodeName(var20_48);
                                            }
                                        } else if (var15_43 == 0) {
                                            this.arrayReg.setNodeName(var20_48);
                                        }
                                        var25_53 = var13_41.getVolumePerformance(var17_45);
                                        var18_46 = this.calcVolumePerfStats(var7_33, var25_53, var16_44);
                                        this.controllerFetchFailures[var15_43] = 0;
                                    }
                                    catch (RPCError var20_49) {
                                        var18_46 = this.markVolumeStatsInvalid(PerfErrorCode.ERROR_RPC, var7_33, var17_45);
                                        v0 = var15_43;
                                        this.controllerFetchFailures[v0] = this.controllerFetchFailures[v0] + 1;
                                        var14_42 = true;
                                        this.setOperationalStatus(OperationalStatus.DEGRADDED);
                                        var27_54 = null;
                                        try {
                                            if (var13_41 != null) {
                                                var13_41.close();
                                            }
                                            break block52;
                                        }
                                        catch (IOException var28_55) {}
                                        break block52;
                                    }
                                    catch (IOException var20_50) {
                                        var18_46 = this.markVolumeStatsInvalid(PerfErrorCode.ERROR_COMMUNICATING_WITH_ARRAY, var7_33, var17_45);
                                        v1 = var15_43;
                                        this.controllerFetchFailures[v1] = this.controllerFetchFailures[v1] + 1;
                                        var14_42 = true;
                                        this.setOperationalStatus(OperationalStatus.DEGRADDED);
                                        var27_54 = null;
                                        try {}
                                        catch (IOException var28_55) {}
                                        if (var13_41 != null) {
                                            var13_41.close();
                                        }
                                        break block52;
                                    }
                                    var27_54 = null;
                                }
                                catch (Throwable var26_56) {
                                    var27_54 = null;
                                    ** try [egrp 6[TRYBLOCK] [12 : 1092->1105)] { 
lbl159:
                                    // 1 sources

                                    if (var13_41 == null) throw var26_56;
                                    var13_41.close();
                                    throw var26_56;
lbl162:
                                    // 1 sources

                                    catch (IOException var28_55) {
                                        // empty catch block
                                    }
                                    throw var26_56;
                                }
                                try {}
                                catch (IOException var28_55) {}
                                if (var13_41 != null) {
                                    var13_41.close();
                                }
                            }
                            if (this.samplesTaken > 1L) {
                                this.calcControllerPerfStats(var19_47, var18_46, var16_44);
                            }
                            var18_46 = null;
                        }
                        if (!var14_42) {
                            this.setOperationalStatus(OperationalStatus.OK);
                        }
                        ++this.samplesTaken;
                        if (this.samplesTaken > 1L) {
                            this.calcSystemPerfStats();
                        }
                        this.release();
                        this.writePerfStats();
                        this.controlBean.setLastPollTime(new Date().getTime());
                        this.updateControlRecord();
                        break block53;
                    }
                    catch (Throwable var2_6) {
                        this.logp(Level.SEVERE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", null, var2_6);
                        if (var2_6 instanceof ThreadDeath) {
                            throw (ThreadDeath)var2_6;
                        }
                        var30_17 = null;
                        if (this.isLoggable(Level.FINE) == false) return;
                        var31_21 = Runtime.getRuntime();
                        var32_25 = var31_21.totalMemory() - var31_21.freeMemory();
                        var34_29 = new StringBuffer(this.getCollectorName());
                        var34_29.append(": Exited, samples taken so far ");
                        var34_29.append(this.samplesTaken).append(".");
                        var34_29.append("\n\tJVM Total Memory: ").append(var31_21.totalMemory());
                        var34_29.append(" JVM Free Memory: ").append(var31_21.freeMemory());
                        var34_29.append(" JVM Max Memory: ").append(var31_21.maxMemory());
                        this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var34_29.toString());
                        return;
                    }
                }
                catch (Throwable var29_57) {
                    var30_18 = null;
                    if (this.isLoggable(Level.FINE) == false) throw var29_57;
                    var31_22 = Runtime.getRuntime();
                    var32_26 = var31_22.totalMemory() - var31_22.freeMemory();
                    var34_30 = new StringBuffer(this.getCollectorName());
                    var34_30.append(": Exited, samples taken so far ");
                    var34_30.append(this.samplesTaken).append(".");
                    var34_30.append("\n\tJVM Total Memory: ").append(var31_22.totalMemory());
                    var34_30.append(" JVM Free Memory: ").append(var31_22.freeMemory());
                    var34_30.append(" JVM Max Memory: ").append(var31_22.maxMemory());
                    this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var34_30.toString());
                    throw var29_57;
                }
            }
            var31_19 = Runtime.getRuntime();
            var32_23 = var31_19.totalMemory() - var31_19.freeMemory();
            var34_27 = new StringBuffer(this.getCollectorName());
            var34_27.append(": Exited, samples taken so far ");
            var34_27.append(this.samplesTaken).append(".");
            var34_27.append("\n\tJVM Total Memory: ").append(var31_19.totalMemory());
            var34_27.append(" JVM Free Memory: ").append(var31_19.freeMemory());
            var34_27.append(" JVM Max Memory: ").append(var31_19.maxMemory());
            this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var34_27.toString());
            return;
        }
        var30_16 = null;
        if (this.isLoggable(Level.FINE) == false) return;
        var31_20 = Runtime.getRuntime();
        var32_24 = var31_20.totalMemory() - var31_20.freeMemory();
        var34_28 = new StringBuffer(this.getCollectorName());
        var34_28.append(": Exited, samples taken so far ");
        var34_28.append(this.samplesTaken).append(".");
        var34_28.append("\n\tJVM Total Memory: ").append(var31_20.totalMemory());
        var34_28.append(" JVM Free Memory: ").append(var31_20.freeMemory());
        var34_28.append(" JVM Max Memory: ").append(var31_20.maxMemory());
        this.logp(Level.FINE, PerfDataCollector.CLASSNAME, "fetchAndProcessPerfSample", var34_28.toString());
    }

    long getSamplesTaken() {
        return this.samplesTaken;
    }

    boolean isLoggable(Level level) {
        return logger.isLoggable(level);
    }

    void logp(Level level, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(this.getCollectorName());
        if (string3 != null) {
            stringBuffer.append(": ").append(string3);
        }
        logger.logp(level, string, string2, stringBuffer.toString());
    }

    void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer(this.getCollectorName());
        if (string3 != null) {
            stringBuffer.append(": ").append(string3);
        }
        logger.logp(level, string, string2, stringBuffer.toString(), throwable);
    }

    public String toString() {
        return this.controlBean.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ControllerData {
        ControllerRef controllerRef;
        Vector volumeRefs;

        public ControllerData(ControllerRef controllerRef) {
            this.controllerRef = controllerRef;
            this.volumeRefs = new Vector();
        }
    }
}

